/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SOFMarkerSegment
extends MarkerSegment {
    int samplePrecision;
    int numLines;
    int samplesPerLine;
    ComponentSpec[] componentSpecs;

    SOFMarkerSegment(boolean bl, boolean bl2, boolean bl3, byte[] byArray, int n) {
        super(bl ? 194 : (bl2 ? 193 : 192));
        this.samplePrecision = 8;
        this.numLines = 0;
        this.samplesPerLine = 0;
        this.componentSpecs = new ComponentSpec[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 1;
            int n4 = 0;
            if (bl3) {
                n3 = 2;
                if (n2 == 1 || n2 == 2) {
                    n3 = 1;
                    n4 = 1;
                }
            }
            this.componentSpecs[n2] = new ComponentSpec(byArray[n2], n3, n4);
            ++n2;
        }
    }

    SOFMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        this.samplePrecision = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.numLines = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.numLines |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.samplesPerLine = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.samplesPerLine |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        int n = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.componentSpecs = new ComponentSpec[n];
        int n2 = 0;
        while (n2 < n) {
            this.componentSpecs[n2] = new ComponentSpec(jPEGBuffer);
            ++n2;
        }
        jPEGBuffer.bufAvail -= this.length;
    }

    SOFMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(192);
        this.samplePrecision = 8;
        this.numLines = 0;
        this.samplesPerLine = 0;
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)super.clone();
        if (this.componentSpecs != null) {
            sOFMarkerSegment.componentSpecs = (ComponentSpec[])this.componentSpecs.clone();
            int n = 0;
            while (n < this.componentSpecs.length) {
                sOFMarkerSegment.componentSpecs[n] = (ComponentSpec)this.componentSpecs[n].clone();
                ++n;
            }
        }
        return sOFMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("sof");
        iIOMetadataNode.setAttribute("process", Integer.toString(this.tag - 192));
        iIOMetadataNode.setAttribute("samplePrecision", Integer.toString(this.samplePrecision));
        iIOMetadataNode.setAttribute("numLines", Integer.toString(this.numLines));
        iIOMetadataNode.setAttribute("samplesPerLine", Integer.toString(this.samplesPerLine));
        iIOMetadataNode.setAttribute("numFrameComponents", Integer.toString(this.componentSpecs.length));
        int n = 0;
        while (n < this.componentSpecs.length) {
            iIOMetadataNode.appendChild(this.componentSpecs[n].getNativeNode());
            ++n;
        }
        return iIOMetadataNode;
    }

    void updateFromNativeNode(Node node, boolean bl) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = MarkerSegment.getAttributeValue(node, namedNodeMap, "process", 0, 2, false);
        this.tag = n != -1 ? n + 192 : this.tag;
        n = MarkerSegment.getAttributeValue(node, namedNodeMap, "samplePrecision", 8, 8, false);
        n = MarkerSegment.getAttributeValue(node, namedNodeMap, "numLines", 0, 65535, false);
        this.numLines = n != -1 ? n : this.numLines;
        n = MarkerSegment.getAttributeValue(node, namedNodeMap, "samplesPerLine", 0, 65535, false);
        this.samplesPerLine = n != -1 ? n : this.samplesPerLine;
        int n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "numFrameComponents", 1, 4, false);
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() != n2) {
            throw new IIOInvalidTreeException("numFrameComponents must match number of children", node);
        }
        this.componentSpecs = new ComponentSpec[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.componentSpecs[n3] = new ComponentSpec(nodeList.item(n3));
            ++n3;
        }
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("SOF");
        System.out.print("Sample precision: ");
        System.out.println(this.samplePrecision);
        System.out.print("Number of lines: ");
        System.out.println(this.numLines);
        System.out.print("Samples per line: ");
        System.out.println(this.samplesPerLine);
        System.out.print("Number of components: ");
        System.out.println(this.componentSpecs.length);
        int n = 0;
        while (n < this.componentSpecs.length) {
            this.componentSpecs[n].print();
            ++n;
        }
    }

    int getIDencodedCSType() {
        int n = 0;
        while (n < this.componentSpecs.length) {
            if (this.componentSpecs[n].componentId < 65) {
                return 0;
            }
            ++n;
        }
        switch (this.componentSpecs.length) {
            case 3: {
                if (this.componentSpecs[0].componentId == 82 && this.componentSpecs[0].componentId == 71 && this.componentSpecs[0].componentId == 66) {
                    return 2;
                }
                if (this.componentSpecs[0].componentId != 89 || this.componentSpecs[0].componentId != 67 || this.componentSpecs[0].componentId != 99) break;
                return 5;
            }
            case 4: {
                if (this.componentSpecs[0].componentId == 82 && this.componentSpecs[0].componentId == 71 && this.componentSpecs[0].componentId == 66 && this.componentSpecs[0].componentId == 65) {
                    return 6;
                }
                if (this.componentSpecs[0].componentId != 89 || this.componentSpecs[0].componentId != 67 || this.componentSpecs[0].componentId != 99 || this.componentSpecs[0].componentId != 65) break;
                return 10;
            }
        }
        return 0;
    }

    ComponentSpec getComponentSpec(byte by, int n, int n2) {
        return new ComponentSpec(by, n, n2);
    }

    class ComponentSpec
    implements Cloneable {
        int componentId;
        int HsamplingFactor;
        int VsamplingFactor;
        int QtableSelector;

        ComponentSpec(byte by, int n, int n2) {
            this.componentId = by;
            this.HsamplingFactor = n;
            this.VsamplingFactor = n;
            this.QtableSelector = n2;
        }

        ComponentSpec(JPEGBuffer jPEGBuffer) {
            this.componentId = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
            this.HsamplingFactor = jPEGBuffer.buf[jPEGBuffer.bufPtr] >>> 4;
            this.VsamplingFactor = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
            this.QtableSelector = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        }

        ComponentSpec(Node node) throws IIOInvalidTreeException {
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.componentId = MarkerSegment.getAttributeValue(node, namedNodeMap, "componentId", 0, 255, true);
            this.HsamplingFactor = MarkerSegment.getAttributeValue(node, namedNodeMap, "HsamplingFactor", 1, 255, true);
            this.VsamplingFactor = MarkerSegment.getAttributeValue(node, namedNodeMap, "VsamplingFactor", 1, 255, true);
            this.QtableSelector = MarkerSegment.getAttributeValue(node, namedNodeMap, "QtableSelector", 0, 3, true);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("componentSpec");
            iIOMetadataNode.setAttribute("componentId", Integer.toString(this.componentId));
            iIOMetadataNode.setAttribute("HsamplingFactor", Integer.toString(this.HsamplingFactor));
            iIOMetadataNode.setAttribute("VsamplingFactor", Integer.toString(this.VsamplingFactor));
            iIOMetadataNode.setAttribute("QtableSelector", Integer.toString(this.QtableSelector));
            return iIOMetadataNode;
        }

        void print() {
            System.out.print("Component ID: ");
            System.out.println(this.componentId);
            System.out.print("H sampling factor: ");
            System.out.println(this.HsamplingFactor);
            System.out.print("V sampling factor: ");
            System.out.println(this.VsamplingFactor);
            System.out.print("Q table selector: ");
            System.out.println(this.QtableSelector);
        }
    }
}

