/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.PNGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class PNGImageWriterSpi
extends ImageWriterSpi {
    private static final String vendorName = "Sun Microsystems, Inc.";
    private static final String version = "1.0";
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png", "PNG"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.imageio.plugins.png.PNGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.png.PNGImageReaderSpi"};

    public PNGImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.imageio.plugins.png.PNGMetadataFormat", null, null);
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] > n) {
                n = nArray[n2];
            }
            ++n2;
        }
        if (n < 1 || n > 16) {
            return false;
        }
        int n3 = sampleModel.getNumBands();
        if (n3 < 1 || n3 > 4) {
            return false;
        }
        boolean bl = colorModel.hasAlpha();
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        if ((n3 == 1 || n3 == 3) && bl) {
            return false;
        }
        return n3 != 2 && n3 != 4 || bl;
    }

    public String getDescription(Locale locale) {
        return "Standard PNG image writer";
    }

    public ImageWriter createWriterInstance(Object object) {
        return new PNGImageWriter(this);
    }
}

