/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.DefaultSynthStyle;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKEngineParser;
import com.sun.java.swing.plaf.gtk.GTKScanner;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import com.sun.java.swing.plaf.gtk.PropertyParser;
import com.sun.java.swing.plaf.gtk.XColors;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.plaf.ColorUIResource;
import sun.security.action.GetPropertyAction;

class GTKParser {
    private ArrayList freeScanners = new ArrayList();
    private HashMap namedStyles = new HashMap();
    private ArrayList assignments = new ArrayList();
    private HashMap settings = new HashMap();
    private File[] pixmapPaths = null;
    private ArrayList dirStack = new ArrayList();
    private HashMap engineParsers = new HashMap();
    private GTKScanner scanner;
    private final String CWD;
    private static final Symbol SYMBOL_INVALID = new Symbol("invalid", 268);
    private static final Symbol SYMBOL_INCLUDE = new Symbol("include", GTKParser.SYMBOL_INVALID.val + 1);
    private static final Symbol SYMBOL_NORMAL = new Symbol("NORMAL", GTKParser.SYMBOL_INCLUDE.val + 1);
    private static final Symbol SYMBOL_ACTIVE = new Symbol("ACTIVE", GTKParser.SYMBOL_NORMAL.val + 1);
    private static final Symbol SYMBOL_PRELIGHT = new Symbol("PRELIGHT", GTKParser.SYMBOL_ACTIVE.val + 1);
    private static final Symbol SYMBOL_SELECTED = new Symbol("SELECTED", GTKParser.SYMBOL_PRELIGHT.val + 1);
    private static final Symbol SYMBOL_INSENSITIVE = new Symbol("INSENSITIVE", GTKParser.SYMBOL_SELECTED.val + 1);
    private static final Symbol SYMBOL_FG = new Symbol("fg", GTKParser.SYMBOL_INSENSITIVE.val + 1);
    private static final Symbol SYMBOL_BG = new Symbol("bg", GTKParser.SYMBOL_FG.val + 1);
    private static final Symbol SYMBOL_TEXT = new Symbol("text", GTKParser.SYMBOL_BG.val + 1);
    private static final Symbol SYMBOL_BASE = new Symbol("base", GTKParser.SYMBOL_TEXT.val + 1);
    private static final Symbol SYMBOL_XTHICKNESS = new Symbol("xthickness", GTKParser.SYMBOL_BASE.val + 1);
    private static final Symbol SYMBOL_YTHICKNESS = new Symbol("ythickness", GTKParser.SYMBOL_XTHICKNESS.val + 1);
    private static final Symbol SYMBOL_FONT = new Symbol("font", GTKParser.SYMBOL_YTHICKNESS.val + 1);
    private static final Symbol SYMBOL_FONTSET = new Symbol("fontset", GTKParser.SYMBOL_FONT.val + 1);
    private static final Symbol SYMBOL_FONT_NAME = new Symbol("font_name", GTKParser.SYMBOL_FONTSET.val + 1);
    private static final Symbol SYMBOL_BG_PIXMAP = new Symbol("bg_pixmap", GTKParser.SYMBOL_FONT_NAME.val + 1);
    private static final Symbol SYMBOL_PIXMAP_PATH = new Symbol("pixmap_path", GTKParser.SYMBOL_BG_PIXMAP.val + 1);
    private static final Symbol SYMBOL_STYLE = new Symbol("style", GTKParser.SYMBOL_PIXMAP_PATH.val + 1);
    private static final Symbol SYMBOL_BINDING = new Symbol("binding", GTKParser.SYMBOL_STYLE.val + 1);
    private static final Symbol SYMBOL_BIND = new Symbol("bind", GTKParser.SYMBOL_BINDING.val + 1);
    private static final Symbol SYMBOL_WIDGET = new Symbol("widget", GTKParser.SYMBOL_BIND.val + 1);
    private static final Symbol SYMBOL_WIDGET_CLASS = new Symbol("widget_class", GTKParser.SYMBOL_WIDGET.val + 1);
    private static final Symbol SYMBOL_CLASS = new Symbol("class", GTKParser.SYMBOL_WIDGET_CLASS.val + 1);
    private static final Symbol SYMBOL_LOWEST = new Symbol("lowest", GTKParser.SYMBOL_CLASS.val + 1);
    private static final Symbol SYMBOL_GTK = new Symbol("gtk", GTKParser.SYMBOL_LOWEST.val + 1);
    private static final Symbol SYMBOL_APPLICATION = new Symbol("application", GTKParser.SYMBOL_GTK.val + 1);
    private static final Symbol SYMBOL_THEME = new Symbol("theme", GTKParser.SYMBOL_APPLICATION.val + 1);
    private static final Symbol SYMBOL_RC = new Symbol("rc", GTKParser.SYMBOL_THEME.val + 1);
    private static final Symbol SYMBOL_HIGHEST = new Symbol("highest", GTKParser.SYMBOL_RC.val + 1);
    private static final Symbol SYMBOL_ENGINE = new Symbol("engine", GTKParser.SYMBOL_HIGHEST.val + 1);
    private static final Symbol SYMBOL_MODULE_PATH = new Symbol("module_path", GTKParser.SYMBOL_ENGINE.val + 1);
    private static final Symbol SYMBOL_IM_MODULE_PATH = new Symbol("im_module_path", GTKParser.SYMBOL_MODULE_PATH.val + 1);
    private static final Symbol SYMBOL_IM_MODULE_FILE = new Symbol("im_module_file", GTKParser.SYMBOL_IM_MODULE_PATH.val + 1);
    private static final Symbol SYMBOL_STOCK = new Symbol("stock", GTKParser.SYMBOL_IM_MODULE_FILE.val + 1);
    private static final Symbol SYMBOL_LTR = new Symbol("LTR", GTKParser.SYMBOL_STOCK.val + 1);
    private static final Symbol SYMBOL_RTL = new Symbol("RTL", GTKParser.SYMBOL_LTR.val + 1);
    private static final Symbol SYMBOL_LAST = new Symbol("last", GTKParser.SYMBOL_RTL.val + 1);
    private static final Symbol[] symbols = new Symbol[]{SYMBOL_INCLUDE, SYMBOL_NORMAL, SYMBOL_ACTIVE, SYMBOL_PRELIGHT, SYMBOL_SELECTED, SYMBOL_INSENSITIVE, SYMBOL_FG, SYMBOL_BG, SYMBOL_TEXT, SYMBOL_BASE, SYMBOL_XTHICKNESS, SYMBOL_YTHICKNESS, SYMBOL_FONT, SYMBOL_FONTSET, SYMBOL_FONT_NAME, SYMBOL_BG_PIXMAP, SYMBOL_PIXMAP_PATH, SYMBOL_STYLE, SYMBOL_BINDING, SYMBOL_BIND, SYMBOL_WIDGET, SYMBOL_WIDGET_CLASS, SYMBOL_CLASS, SYMBOL_LOWEST, SYMBOL_GTK, SYMBOL_APPLICATION, SYMBOL_THEME, SYMBOL_RC, SYMBOL_HIGHEST, SYMBOL_ENGINE, SYMBOL_MODULE_PATH, SYMBOL_IM_MODULE_FILE, SYMBOL_STOCK, SYMBOL_LTR, SYMBOL_RTL};

    private static Symbol getSymbol(int n) {
        if (n > GTKParser.SYMBOL_INVALID.val && n < GTKParser.SYMBOL_LAST.val) {
            int n2 = 0;
            while (n2 < symbols.length) {
                if (GTKParser.symbols[n2].val == n) {
                    return symbols[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public GTKParser() {
        this.engineParsers.put("pixmap", "com.sun.java.swing.plaf.gtk.PixmapEngineParser");
        this.engineParsers.put("bluecurve", "com.sun.java.swing.plaf.gtk.BluecurveEngineParser");
        this.engineParsers.put("blueprint", "com.sun.java.swing.plaf.gtk.BlueprintEngineParser");
        this.CWD = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
        this.freeScanners.add(GTKParser.createScanner());
    }

    public void parseString(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        this.parseReader(stringReader, "-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(File file, String string) throws IOException {
        if (!file.canRead() || !file.isFile()) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(this.CWD);
        }
        this.dirStack.add(file2);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            this.parseReader(bufferedReader, string);
            Object var6_5 = null;
            this.dirStack.remove(this.dirStack.size() - 1);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.dirStack.remove(this.dirStack.size() - 1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseReader(Reader reader, String string) throws IOException {
        int n = this.freeScanners.size();
        this.scanner = n == 0 ? GTKParser.createScanner() : (GTKScanner)this.freeScanners.remove(n - 1);
        this.scanner.scanReader(reader, string);
        try {
            this.parseCurrent();
            Object var5_4 = null;
            this.scanner.clearScanner();
            this.freeScanners.add(this.scanner);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.scanner.clearScanner();
            this.freeScanners.add(this.scanner);
            throw throwable;
        }
    }

    private static GTKScanner createScanner() {
        GTKScanner gTKScanner = new GTKScanner();
        gTKScanner.caseSensitive = true;
        gTKScanner.scanBinary = true;
        gTKScanner.scanHexDollar = true;
        gTKScanner.symbol2Token = true;
        int n = 0;
        while (n < symbols.length) {
            gTKScanner.addSymbol(GTKParser.symbols[n].name, GTKParser.symbols[n].val);
            ++n;
        }
        return gTKScanner;
    }

    public void loadStylesInto(GTKStyleFactory gTKStyleFactory) {
        Assignment[] assignmentArray = new Assignment[this.assignments.size()];
        assignmentArray = this.assignments.toArray(assignmentArray);
        int n = 0;
        while (n < assignmentArray.length) {
            Assignment assignment = assignmentArray[n];
            GTKStyle gTKStyle = assignment.info.toGTKStyle();
            if (gTKStyle != StyleInfo.EMPTY_STYLE) {
                try {
                    gTKStyleFactory.addStyle(gTKStyle, assignment.pattern, assignment.type);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    public HashMap getGTKSettings() {
        return this.settings;
    }

    public void clearParser() {
        this.namedStyles.clear();
        this.settings.clear();
        this.assignments.clear();
        this.dirStack.clear();
        this.pixmapPaths = null;
    }

    private void parseCurrent() throws IOException {
        while (this.scanner.peekNextToken() != -1) {
            int n = this.parseStatement();
            if (n == 256) continue;
            String string = null;
            String string2 = null;
            if (this.scanner.currScope == 0) {
                Symbol symbol = GTKParser.getSymbol(n);
                if (symbol != null) {
                    string2 = "e.g. `" + symbol.name + "'";
                }
                if ((symbol = GTKParser.getSymbol(this.scanner.currToken)) != null) {
                    string = symbol.name;
                }
            }
            this.scanner.unexpectedToken(n, string, string2, true);
            break;
        }
    }

    private int parseStatement() throws IOException {
        int n = this.scanner.peekNextToken();
        if (n == GTKParser.SYMBOL_INCLUDE.val) {
            return this.parseInclude();
        }
        if (n == GTKParser.SYMBOL_STYLE.val) {
            return this.parseStyle();
        }
        if (n == GTKParser.SYMBOL_BINDING.val) {
            return this.parseBinding();
        }
        if (n == GTKParser.SYMBOL_PIXMAP_PATH.val) {
            return this.parsePixmapPath();
        }
        if (n == GTKParser.SYMBOL_WIDGET.val || n == GTKParser.SYMBOL_WIDGET_CLASS.val || n == GTKParser.SYMBOL_CLASS.val) {
            return this.parseAssignment(n);
        }
        if (n == GTKParser.SYMBOL_MODULE_PATH.val) {
            return this.parseModulePath();
        }
        if (n == GTKParser.SYMBOL_IM_MODULE_FILE.val) {
            return this.parseIMModuleFile();
        }
        if (n == 266) {
            return this.parseIdentifier();
        }
        this.scanner.getToken();
        return GTKParser.SYMBOL_STYLE.val;
    }

    private int parseInclude() throws IOException {
        Object object;
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_INCLUDE.val) {
            return GTKParser.SYMBOL_INCLUDE.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        File file = null;
        String string = this.scanner.currValue.stringVal;
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            file = file2;
        } else {
            object = new File[this.dirStack.size()];
            object = this.dirStack.toArray((T[])object);
            int n2 = ((File[])object).length - 1;
            while (n2 >= 0) {
                file2 = new File(object[n2], string);
                if (file2.exists()) {
                    file = file2;
                    break;
                }
                --n2;
            }
        }
        if (file == null) {
            this.scanner.printMessage("Unable to find include file: \"" + string + "\"", false);
        } else {
            object = this.scanner;
            try {
                this.parseFile(file2, string);
            }
            catch (IOException iOException) {
                ((GTKScanner)object).printMessage("(" + iOException.toString() + ") while parsing include file: \"" + string + "\"", false);
            }
            this.scanner = object;
        }
        return 256;
    }

    private int parseStyle() throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_STYLE.val) {
            return GTKParser.SYMBOL_STYLE.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        StyleInfo styleInfo = (StyleInfo)this.namedStyles.get(this.scanner.currValue.stringVal);
        if (styleInfo == null) {
            styleInfo = new StyleInfo(this.scanner.currValue.stringVal);
        }
        if ((n = this.scanner.peekNextToken()) == 61) {
            n = this.scanner.getToken();
            n = this.scanner.getToken();
            if (n != 264) {
                return 264;
            }
            StyleInfo styleInfo2 = (StyleInfo)this.namedStyles.get(this.scanner.currValue.stringVal);
            if (styleInfo2 != null) {
                styleInfo.copyDataFrom(styleInfo2);
            }
        }
        if ((n = this.scanner.getToken()) != 123) {
            return 123;
        }
        n = this.scanner.peekNextToken();
        while (n != 125) {
            if (n == GTKParser.SYMBOL_FG.val || n == GTKParser.SYMBOL_BG.val || n == GTKParser.SYMBOL_TEXT.val || n == GTKParser.SYMBOL_BASE.val) {
                n = this.parseColorSetting(n, styleInfo);
            } else if (n == GTKParser.SYMBOL_XTHICKNESS.val || n == GTKParser.SYMBOL_YTHICKNESS.val) {
                n = this.parseThickness(n, styleInfo);
            } else if (n == GTKParser.SYMBOL_BG_PIXMAP.val) {
                n = this.parseBGPixmap(styleInfo);
            } else if (n == GTKParser.SYMBOL_FONT.val || n == GTKParser.SYMBOL_FONTSET.val || n == GTKParser.SYMBOL_FONT_NAME.val) {
                n = this.parseFont(n, styleInfo);
            } else if (n == GTKParser.SYMBOL_ENGINE.val) {
                n = this.parseEngine(styleInfo);
            } else if (n == GTKParser.SYMBOL_STOCK.val) {
                n = this.parseStock(styleInfo);
            } else if (n == 266) {
                n = this.parseIdentifierInStyle(styleInfo);
            } else {
                this.scanner.getToken();
                n = 125;
            }
            if (n != 256) {
                return n;
            }
            n = this.scanner.peekNextToken();
        }
        n = this.scanner.getToken();
        if (n != 125) {
            return 125;
        }
        this.namedStyles.put(styleInfo.name, styleInfo);
        return 256;
    }

    private int parseBinding() throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_BINDING.val) {
            return GTKParser.SYMBOL_BINDING.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        n = this.ignoreBlock();
        if (n != 256) {
            return n;
        }
        this.scanner.printMessage("Binding specification is unsupported, ignoring", false);
        return 256;
    }

    private int parsePixmapPath() throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_PIXMAP_PATH.val) {
            return GTKParser.SYMBOL_PIXMAP_PATH.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        this.pixmapPaths = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.scanner.currValue.stringVal, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            File file = new File(string);
            if (file.isAbsolute()) {
                arrayList.add(file);
                continue;
            }
            this.scanner.printMessage("Pixmap path element: \"" + string + "\" must be absolute", false);
        }
        if (arrayList.size() > 0) {
            this.pixmapPaths = new File[arrayList.size()];
            this.pixmapPaths = arrayList.toArray(this.pixmapPaths);
        }
        return 256;
    }

    private int parseAssignment(int n) throws IOException {
        boolean bl;
        int n2;
        int n3 = this.scanner.getToken();
        if (n3 != n) {
            return n;
        }
        if (n3 == GTKParser.SYMBOL_WIDGET.val) {
            n2 = 0;
        } else if (n3 == GTKParser.SYMBOL_WIDGET_CLASS.val) {
            n2 = 1;
        } else if (n3 == GTKParser.SYMBOL_CLASS.val) {
            n2 = 2;
        } else {
            return GTKParser.SYMBOL_WIDGET_CLASS.val;
        }
        n3 = this.scanner.getToken();
        if (n3 != 264) {
            return 264;
        }
        String string = this.scanner.currValue.stringVal;
        n3 = this.scanner.getToken();
        if (n3 == GTKParser.SYMBOL_STYLE.val) {
            bl = false;
        } else if (n3 == GTKParser.SYMBOL_BINDING.val) {
            bl = true;
        } else {
            return GTKParser.SYMBOL_STYLE.val;
        }
        n3 = this.scanner.peekNextToken();
        if (n3 == 58) {
            n3 = this.scanner.getToken();
            n3 = this.scanner.getToken();
            if (n3 != GTKParser.SYMBOL_LOWEST.val && n3 != GTKParser.SYMBOL_GTK.val && n3 != GTKParser.SYMBOL_APPLICATION.val && n3 != GTKParser.SYMBOL_THEME.val && n3 != GTKParser.SYMBOL_RC.val && n3 != GTKParser.SYMBOL_HIGHEST.val) {
                return GTKParser.SYMBOL_APPLICATION.val;
            }
            this.scanner.printMessage("Priority specification is unsupported, ignoring", false);
        }
        if ((n3 = this.scanner.getToken()) != 264) {
            return 264;
        }
        if (bl) {
            this.scanner.printMessage("Binding assignment is unsupported, ignoring", false);
        } else {
            StyleInfo styleInfo = (StyleInfo)this.namedStyles.get(this.scanner.currValue.stringVal);
            if (styleInfo == null) {
                return 264;
            }
            Assignment assignment = new Assignment(n2, string, styleInfo);
            this.assignments.add(assignment);
        }
        return 256;
    }

    private int parseModulePath() throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_MODULE_PATH.val) {
            return GTKParser.SYMBOL_MODULE_PATH.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        this.scanner.printMessage("module_path directive is now ignored", false);
        return 256;
    }

    private int parseIMModuleFile() throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_IM_MODULE_FILE.val) {
            return GTKParser.SYMBOL_IM_MODULE_FILE.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        this.scanner.printMessage("im_module_file directive is unsupported, ignoring", false);
        return 256;
    }

    private int parseIdentifier() throws IOException {
        int n = this.scanner.getToken();
        if (n != 266) {
            return 266;
        }
        Object[] objectArray = new Object[1];
        StringBuffer stringBuffer = new StringBuffer(this.scanner.currValue.stringVal);
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";
        int n2 = stringBuffer.length();
        int n3 = 0;
        while (n3 < n2) {
            if (string.indexOf(stringBuffer.charAt(n3)) == -1) {
                stringBuffer.setCharAt(n3, '-');
            }
            ++n3;
        }
        String string2 = stringBuffer.toString().intern();
        n = this.parsePropertyAssignment(objectArray);
        if (n != 256) {
            return n;
        }
        this.settings.put(string2, objectArray[0]);
        return 256;
    }

    private int parseColorSetting(int n, StyleInfo styleInfo) throws IOException {
        int n2 = this.scanner.getToken();
        if (n2 != n) {
            return n;
        }
        Color[] colorArray = null;
        if (n2 == GTKParser.SYMBOL_FG.val) {
            colorArray = styleInfo.fg;
        } else if (n2 == GTKParser.SYMBOL_BG.val) {
            colorArray = styleInfo.bg;
        } else if (n2 == GTKParser.SYMBOL_TEXT.val) {
            colorArray = styleInfo.text;
        } else if (n2 == GTKParser.SYMBOL_BASE.val) {
            colorArray = styleInfo.base;
        } else {
            return GTKParser.SYMBOL_FG.val;
        }
        int[] nArray = new int[1];
        n2 = this.parseState(nArray);
        if (n2 != 256) {
            return n2;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        return this.parseColor(colorArray, nArray[0]);
    }

    private int parseState(int[] nArray) throws IOException {
        int n = this.scanner.getToken();
        if (n != 91) {
            return 91;
        }
        n = this.scanner.getToken();
        if (n == GTKParser.SYMBOL_NORMAL.val) {
            nArray[0] = 0;
        } else if (n == GTKParser.SYMBOL_ACTIVE.val) {
            nArray[0] = 2;
        } else if (n == GTKParser.SYMBOL_PRELIGHT.val) {
            nArray[0] = 1;
        } else if (n == GTKParser.SYMBOL_SELECTED.val) {
            nArray[0] = 4;
        } else if (n == GTKParser.SYMBOL_INSENSITIVE.val) {
            nArray[0] = 3;
        } else {
            return GTKParser.SYMBOL_NORMAL.val;
        }
        n = this.scanner.getToken();
        if (n != 93) {
            return 93;
        }
        return 256;
    }

    private int parseColor(Color[] colorArray, int n) throws IOException {
        int n2 = this.scanner.getToken();
        switch (n2) {
            case 123: {
                float f;
                float f2;
                float f3;
                n2 = this.scanner.getToken();
                if (n2 == 261) {
                    f3 = GTKParser.javaColorVal(this.scanner.currValue.longVal);
                } else if (n2 == 263) {
                    f3 = GTKParser.javaColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n2 = this.scanner.getToken();
                if (n2 != 44) {
                    return 44;
                }
                n2 = this.scanner.getToken();
                if (n2 == 261) {
                    f2 = GTKParser.javaColorVal(this.scanner.currValue.longVal);
                } else if (n2 == 263) {
                    f2 = GTKParser.javaColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n2 = this.scanner.getToken();
                if (n2 != 44) {
                    return 44;
                }
                n2 = this.scanner.getToken();
                if (n2 == 261) {
                    f = GTKParser.javaColorVal(this.scanner.currValue.longVal);
                } else if (n2 == 263) {
                    f = GTKParser.javaColorVal(this.scanner.currValue.doubleVal);
                } else {
                    return 263;
                }
                n2 = this.scanner.getToken();
                if (n2 != 125) {
                    return 125;
                }
                colorArray[n] = new ColorUIResource(f3, f2, f);
                break;
            }
            case 264: {
                Color color = GTKParser.parseColorString(this.scanner.currValue.stringVal);
                if (color == null) {
                    this.scanner.printMessage("Invalid color constant '" + this.scanner.currValue.stringVal + "'", false);
                    return 264;
                }
                colorArray[n] = color;
                break;
            }
            default: {
                return 264;
            }
        }
        return 256;
    }

    private static Color parseColorString(String string) {
        if (string.charAt(0) == '#') {
            int n;
            int n2;
            int n3;
            int n4 = (string = string.substring(1)).length();
            if (n4 < 3 || n4 > 12 || n4 % 3 != 0) {
                return null;
            }
            n4 /= 3;
            try {
                n3 = Integer.parseInt(string.substring(0, n4), 16);
                n2 = Integer.parseInt(string.substring(n4, n4 * 2), 16);
                n = Integer.parseInt(string.substring(n4 * 2, n4 * 3), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n4 == 4) {
                return new ColorUIResource((float)n3 / 65535.0f, (float)n2 / 65535.0f, (float)n / 65535.0f);
            }
            if (n4 == 1) {
                return new ColorUIResource((float)n3 / 15.0f, (float)n2 / 15.0f, (float)n / 15.0f);
            }
            if (n4 == 2) {
                return new ColorUIResource(n3, n2, n);
            }
            return new ColorUIResource((float)n3 / 4095.0f, (float)n2 / 4095.0f, (float)n / 4095.0f);
        }
        return XColors.lookupColor(string);
    }

    private static float javaColorVal(long l) {
        int n = (int)Math.max(Math.min(l, 65535L), 0L);
        return (float)l / 65535.0f;
    }

    private static float javaColorVal(double d) {
        float f = (float)Math.max(Math.min(d, 1.0), 0.0);
        return f;
    }

    private int parseThickness(int n, StyleInfo styleInfo) throws IOException {
        boolean bl;
        int n2 = this.scanner.getToken();
        if (n2 != n) {
            return n;
        }
        if (n2 == GTKParser.SYMBOL_XTHICKNESS.val) {
            bl = true;
        } else if (n2 == GTKParser.SYMBOL_YTHICKNESS.val) {
            bl = false;
        } else {
            return GTKParser.SYMBOL_XTHICKNESS.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 261) {
            return 261;
        }
        int n3 = (int)this.scanner.currValue.longVal;
        if (bl) {
            styleInfo.xThickness = n3;
        } else {
            styleInfo.yThickness = n3;
        }
        return 256;
    }

    private int parseBGPixmap(StyleInfo styleInfo) throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_BG_PIXMAP.val) {
            return GTKParser.SYMBOL_BG_PIXMAP.val;
        }
        int[] nArray = new int[1];
        n = this.parseState(nArray);
        if (n != 256) {
            return n;
        }
        n = this.scanner.getToken();
        if (n != 61) {
            return 61;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        String string = null;
        String string2 = this.scanner.currValue.stringVal;
        string = string2.equals("<none>") || string2.equals("<parent>") ? string2.intern() : this.resolvePixmapPath(string2);
        if (string == null) {
            this.scanner.printMessage("Unable to locate image file in pixmap_path: \"" + string2 + "\"", false);
        } else {
            styleInfo.bgPixmapName[nArray[0]] = string;
        }
        return 256;
    }

    String resolvePixmapPath(String string) {
        if (this.pixmapPaths != null) {
            int n = 0;
            while (n < this.pixmapPaths.length) {
                File file = new File(this.pixmapPaths[n], string);
                if (file.canRead()) {
                    return file.getAbsolutePath();
                }
                ++n;
            }
        }
        File[] fileArray = new File[this.dirStack.size()];
        fileArray = this.dirStack.toArray(fileArray);
        int n = fileArray.length - 1;
        while (n >= 0) {
            File file = new File(fileArray[n], string);
            if (file.canRead()) {
                return file.getAbsolutePath();
            }
            --n;
        }
        return null;
    }

    private int parseFont(int n, StyleInfo styleInfo) throws IOException {
        boolean bl;
        int n2 = this.scanner.getToken();
        if (n2 != n) {
            return n;
        }
        if (n2 == GTKParser.SYMBOL_FONT_NAME.val) {
            bl = true;
        } else if (n2 == GTKParser.SYMBOL_FONT.val || n2 == GTKParser.SYMBOL_FONTSET.val) {
            bl = false;
        } else {
            return GTKParser.SYMBOL_FONT_NAME.val;
        }
        n2 = this.scanner.getToken();
        if (n2 != 61) {
            return 61;
        }
        n2 = this.scanner.getToken();
        if (n2 != 264) {
            return 264;
        }
        if (bl) {
            String string = this.scanner.currValue.stringVal;
            styleInfo.font = PangoFonts.lookupFont(string);
        }
        return 256;
    }

    private GTKEngineParser getParser(String string) {
        Object v = this.engineParsers.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof GTKEngineParser) {
            return (GTKEngineParser)v;
        }
        GTKEngineParser gTKEngineParser = null;
        try {
            gTKEngineParser = (GTKEngineParser)Class.forName((String)v).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (gTKEngineParser == null) {
            this.engineParsers.remove(string);
        } else {
            this.engineParsers.put(string, gTKEngineParser);
        }
        return gTKEngineParser;
    }

    private int parseEngine(StyleInfo styleInfo) throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_ENGINE.val) {
            return GTKParser.SYMBOL_ENGINE.val;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        String string = this.scanner.currValue.stringVal;
        if (string.length() == 0) {
            n = this.scanner.getToken();
            if (n != 123) {
                return 123;
            }
            n = this.scanner.getToken();
            if (n != 125) {
                return 125;
            }
            styleInfo.engineInfo = null;
            return 256;
        }
        GTKEngineParser gTKEngineParser = this.getParser(string);
        if (gTKEngineParser == null) {
            n = this.ignoreBlock();
            if (n != 256) {
                return n;
            }
            this.scanner.printMessage("Engine \"" + string + "\" is unsupported, ignoring", false);
        } else {
            n = this.scanner.getToken();
            if (n != 123) {
                return 123;
            }
            EngineInfo[] engineInfoArray = new EngineInfo[1];
            if (styleInfo.engineInfo != null && string.equals(styleInfo.engineInfo.engineName)) {
                engineInfoArray[0] = styleInfo.engineInfo;
            }
            if ((n = gTKEngineParser.parse(this.scanner, this, engineInfoArray)) != 256) {
                return n;
            }
            if (engineInfoArray[0] != null) {
                engineInfoArray[0].engineName = string;
            }
            styleInfo.engineInfo = engineInfoArray[0];
        }
        return 256;
    }

    private int parseStock(StyleInfo styleInfo) throws IOException {
        int n = this.scanner.getToken();
        if (n != GTKParser.SYMBOL_STOCK.val) {
            return GTKParser.SYMBOL_STOCK.val;
        }
        n = this.scanner.getToken();
        if (n != 91) {
            return 91;
        }
        n = this.scanner.getToken();
        if (n != 264) {
            return 264;
        }
        String string = this.scanner.currValue.stringVal;
        n = this.scanner.getToken();
        if (n != 93) {
            return 93;
        }
        n = this.scanner.getToken();
        if (n != 61) {
            return 61;
        }
        n = this.scanner.getToken();
        if (n != 123) {
            return 123;
        }
        ArrayList<GTKStyle.GTKIconSource> arrayList = new ArrayList<GTKStyle.GTKIconSource>();
        GTKStyle.GTKIconSource[] gTKIconSourceArray = new GTKStyle.GTKIconSource[1];
        n = this.scanner.peekNextToken();
        while (n != 125) {
            n = this.parseIconSource(gTKIconSourceArray);
            if (n != 256) {
                return n;
            }
            n = this.scanner.getToken();
            if (n != 44 && n != 125) {
                return 125;
            }
            if (gTKIconSourceArray[0] == null) continue;
            arrayList.add(gTKIconSourceArray[0]);
        }
        if (arrayList.size() != 0) {
            gTKIconSourceArray = new GTKStyle.GTKIconSource[arrayList.size()];
            gTKIconSourceArray = arrayList.toArray(gTKIconSourceArray);
            styleInfo.addStockItem(string, gTKIconSourceArray);
        }
        return 256;
    }

    private GTKStyle.GTKIconSource createIconSource(String string, int n, int n2, String string2) {
        String string3 = this.resolvePixmapPath(string);
        if (string3 != null) {
            return new GTKStyle.GTKIconSource(string3, n, n2, string2);
        }
        return null;
    }

    private int parseIconSource(GTKStyle.GTKIconSource[] gTKIconSourceArray) throws IOException {
        String string = null;
        int n = -100;
        int n2 = -100;
        String string2 = null;
        int n3 = this.scanner.getToken();
        if (n3 != 123) {
            return 123;
        }
        n3 = this.scanner.getToken();
        if (n3 != 264) {
            return 264;
        }
        string = this.scanner.currValue.stringVal;
        n3 = this.scanner.getToken();
        if (n3 == 125) {
            gTKIconSourceArray[0] = this.createIconSource(string, n, n2, string2);
            return 256;
        }
        if (n3 != 44) {
            return 44;
        }
        n3 = this.scanner.getToken();
        if (n3 == GTKParser.SYMBOL_RTL.val) {
            n = 1;
        } else if (n3 == GTKParser.SYMBOL_LTR.val) {
            n = 0;
        } else if (n3 != 42) {
            return GTKParser.SYMBOL_RTL.val;
        }
        n3 = this.scanner.getToken();
        if (n3 == 125) {
            gTKIconSourceArray[0] = this.createIconSource(string, n, n2, string2);
            return 256;
        }
        if (n3 != 44) {
            return 44;
        }
        n3 = this.scanner.getToken();
        if (n3 == GTKParser.SYMBOL_NORMAL.val) {
            n2 = 1;
        } else if (n3 == GTKParser.SYMBOL_ACTIVE.val) {
            n2 = 4;
        } else if (n3 == GTKParser.SYMBOL_PRELIGHT.val) {
            n2 = 2;
        } else if (n3 == GTKParser.SYMBOL_SELECTED.val) {
            n2 = 512;
        } else if (n3 == GTKParser.SYMBOL_INSENSITIVE.val) {
            n2 = 8;
        } else if (n3 != 42) {
            return GTKParser.SYMBOL_PRELIGHT.val;
        }
        n3 = this.scanner.getToken();
        if (n3 == 125) {
            gTKIconSourceArray[0] = this.createIconSource(string, n, n2, string2);
            return 256;
        }
        if (n3 != 44) {
            return 44;
        }
        n3 = this.scanner.getToken();
        if (n3 != 42) {
            if (n3 != 264) {
                return 264;
            }
            string2 = this.scanner.currValue.stringVal;
            if (GTKStyle.getIconSize(string2) == null) {
                string2 = null;
            }
        }
        if ((n3 = this.scanner.getToken()) != 125) {
            return 125;
        }
        gTKIconSourceArray[0] = this.createIconSource(string, n, n2, string2);
        return 256;
    }

    private int parseIdentifierInStyle(StyleInfo styleInfo) throws IOException {
        int n = this.scanner.getToken();
        if (n != 266 || this.scanner.currValue.stringVal.charAt(0) < 'A' || this.scanner.currValue.stringVal.charAt(0) > 'Z') {
            return 266;
        }
        Object[] objectArray = new Object[1];
        String string = this.scanner.currValue.stringVal.intern();
        if (this.scanner.getToken() != 58 || this.scanner.getToken() != 58) {
            return 58;
        }
        n = this.scanner.getToken();
        if (n != 266) {
            return 266;
        }
        StringBuffer stringBuffer = new StringBuffer(this.scanner.currValue.stringVal);
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";
        int n2 = stringBuffer.length();
        int n3 = 0;
        while (n3 < n2) {
            if (string2.indexOf(stringBuffer.charAt(n3)) == -1) {
                stringBuffer.setCharAt(n3, '-');
            }
            ++n3;
        }
        String string3 = stringBuffer.toString().intern();
        n = this.parsePropertyAssignment(objectArray);
        if (n != 256) {
            return n;
        }
        PropertyParser propertyParser = null;
        if (objectArray[0] instanceof String && (propertyParser = PropertyParser.getParserFor(string3)) != null) {
            Object object = propertyParser.parse((String)objectArray[0]);
            if (object == null) {
                this.scanner.printMessage("Failed to parse property value \"" + objectArray[0] + "\" for `" + string + "::" + string3 + "'", false);
            } else {
                styleInfo.addProperty(string, string3, object);
            }
        } else {
            styleInfo.addProperty(string, string3, objectArray[0]);
        }
        return 256;
    }

    private int parsePropertyAssignment(Object[] objectArray) throws IOException {
        int n = this.scanner.getToken();
        if (n != 61) {
            return 61;
        }
        boolean bl = this.scanner.scanIdentifier;
        boolean bl2 = this.scanner.scanSymbols;
        boolean bl3 = this.scanner.identifier2String;
        boolean bl4 = this.scanner.char2Token;
        boolean bl5 = this.scanner.scanIdentifierNULL;
        boolean bl6 = this.scanner.numbers2Int;
        this.scanner.scanIdentifier = true;
        this.scanner.scanSymbols = false;
        this.scanner.identifier2String = false;
        this.scanner.char2Token = true;
        this.scanner.scanIdentifierNULL = false;
        this.scanner.numbers2Int = true;
        boolean bl7 = false;
        if (this.scanner.peekNextToken() == 45) {
            this.scanner.getToken();
            bl7 = true;
        }
        n = this.scanner.peekNextToken();
        switch (n) {
            case 261: {
                this.scanner.getToken();
                objectArray[0] = new Long(bl7 ? -this.scanner.currValue.longVal : this.scanner.currValue.longVal);
                n = 256;
                break;
            }
            case 263: {
                this.scanner.getToken();
                objectArray[0] = new Double(bl7 ? -this.scanner.currValue.doubleVal : this.scanner.currValue.doubleVal);
                n = 256;
                break;
            }
            case 264: {
                this.scanner.getToken();
                if (bl7) {
                    n = 261;
                    break;
                }
                objectArray[0] = this.scanner.currValue.stringVal;
                n = 256;
                break;
            }
            case 40: 
            case 91: 
            case 123: 
            case 266: {
                if (bl7) {
                    n = 261;
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer();
                n = this.parseComplexPropVal(stringBuffer, -1);
                if (n != 256) break;
                stringBuffer.append(' ');
                objectArray[0] = stringBuffer.toString();
                break;
            }
            default: {
                this.scanner.getToken();
                n = 261;
            }
        }
        this.scanner.scanIdentifier = bl;
        this.scanner.scanSymbols = bl2;
        this.scanner.identifier2String = bl3;
        this.scanner.char2Token = bl4;
        this.scanner.scanIdentifierNULL = bl5;
        this.scanner.numbers2Int = bl6;
        return n;
    }

    private int parseComplexPropVal(StringBuffer stringBuffer, int n) throws IOException {
        int n2 = this.scanner.getToken();
        switch (n2) {
            case 261: {
                stringBuffer.append(" 0x");
                stringBuffer.append(Long.toHexString(this.scanner.currValue.longVal));
                break;
            }
            case 263: {
                stringBuffer.append(' ');
                stringBuffer.append(this.scanner.currValue.doubleVal);
                break;
            }
            case 264: {
                stringBuffer.append(" \"");
                stringBuffer.append(this.escapeString(this.scanner.currValue.stringVal));
                stringBuffer.append('\"');
                break;
            }
            case 266: {
                stringBuffer.append(' ');
                stringBuffer.append(this.scanner.currValue.stringVal);
                break;
            }
            case 40: {
                stringBuffer.append(' ');
                stringBuffer.append((char)n2);
                n2 = this.parseComplexPropVal(stringBuffer, 41);
                if (n2 == 256) break;
                return n2;
            }
            case 123: {
                stringBuffer.append(' ');
                stringBuffer.append((char)n2);
                n2 = this.parseComplexPropVal(stringBuffer, 125);
                if (n2 == 256) break;
                return n2;
            }
            case 91: {
                stringBuffer.append(' ');
                stringBuffer.append((char)n2);
                n2 = this.parseComplexPropVal(stringBuffer, 93);
                if (n2 == 256) break;
                return n2;
            }
            default: {
                if (n2 >= 256 || n2 <= -1) {
                    return n != -1 ? n : 264;
                }
                stringBuffer.append(' ');
                stringBuffer.append((char)n2);
                if (n2 != n) break;
                return 256;
            }
        }
        if (n == -1) {
            return 256;
        }
        return this.parseComplexPropVal(stringBuffer, n);
    }

    private String escapeString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append(Integer.toOctalString(c));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private int ignoreBlock() throws IOException {
        int n = this.scanner.getToken();
        if (n != 123) {
            return 123;
        }
        int n2 = 1;
        while (n2 > 0) {
            n = this.scanner.getToken();
            switch (n) {
                case -1: {
                    return 125;
                }
                case 123: {
                    ++n2;
                    break;
                }
                case 125: {
                    --n2;
                    break;
                }
            }
        }
        return 256;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java GTKParser <gtkrc file> <gtkrc file>....");
            System.exit(1);
        }
        GTKParser gTKParser = new GTKParser();
        try {
            int n = 0;
            while (n < stringArray.length) {
                gTKParser.parseFile(new File(stringArray[n]), stringArray[n]);
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        gTKParser.printNamedStyles();
        System.out.println();
        gTKParser.printSettings();
        System.out.println();
        gTKParser.printAssignments();
    }

    private void printNamedStyles() {
        System.out.println("===== Named Styles =====");
        StyleInfo[] styleInfoArray = new StyleInfo[this.namedStyles.size()];
        styleInfoArray = this.namedStyles.values().toArray(styleInfoArray);
        int n = 0;
        while (n < styleInfoArray.length) {
            StyleInfo styleInfo = styleInfoArray[n];
            System.out.println("NAME: " + styleInfo.name);
            GTKStyle gTKStyle = styleInfo.toGTKStyle();
            System.out.println(gTKStyle == StyleInfo.EMPTY_STYLE ? "EMPTY_STYLE" : gTKStyle.toString());
            System.out.println("---------------------------");
            ++n;
        }
    }

    private void printSettings() {
        System.out.println("===== GTK Settings =====");
        Iterator iterator = this.settings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
    }

    private void printAssignments() {
        System.out.println("===== Assignments =====");
        Assignment[] assignmentArray = new Assignment[this.assignments.size()];
        assignmentArray = this.assignments.toArray(assignmentArray);
        int n = 0;
        while (n < assignmentArray.length) {
            System.out.println(assignmentArray[n]);
            ++n;
        }
    }

    private static class Assignment {
        int type;
        String pattern;
        StyleInfo info;

        Assignment(int n, String string, StyleInfo styleInfo) {
            this.type = n;
            this.pattern = string;
            this.info = styleInfo;
        }

        public String toString() {
            String string = "";
            switch (this.type) {
                case 0: {
                    string = "widget, ";
                    break;
                }
                case 1: {
                    string = "widget_class, ";
                    break;
                }
                case 2: {
                    string = "class, ";
                }
            }
            string = string + this.pattern + ", ";
            string = string + this.info.name;
            return string;
        }
    }

    static abstract class EngineInfo {
        private String engineName;

        EngineInfo() {
        }

        abstract GTKStyle constructGTKStyle(GTKStyle.GTKStateInfo[] var1, CircularIdentityList var2, Font var3, int var4, int var5, GTKStyle.GTKStockIconInfo[] var6);
    }

    private static class StyleInfo {
        String name;
        static final int NUM_STATES = 5;
        static final int NORMAL = 0;
        static final int PRELIGHT = 1;
        static final int ACTIVE = 2;
        static final int INSENSITIVE = 3;
        static final int SELECTED = 4;
        Color[] fg = new Color[5];
        Color[] bg = new Color[5];
        Color[] text = new Color[5];
        Color[] base = new Color[5];
        String[] bgPixmapName = new String[5];
        Font font = null;
        int xThickness = -1;
        int yThickness = -1;
        ArrayList stocks = null;
        CircularIdentityList props = null;
        EngineInfo engineInfo = null;
        private GTKStyle cachedStyle = null;
        private static GTKStyle EMPTY_STYLE = new GTKStyle();

        StyleInfo(String string) {
            this.name = string;
        }

        private void initStocksIfNecessary() {
            if (this.stocks == null) {
                this.stocks = new ArrayList();
                this.stocks.add(new HashMap());
            }
        }

        void addStockItem(String string, GTKStyle.GTKIconSource[] gTKIconSourceArray) {
            this.initStocksIfNecessary();
            GTKStyle.GTKStockIconInfo gTKStockIconInfo = new GTKStyle.GTKStockIconInfo(string, gTKIconSourceArray);
            HashMap hashMap = (HashMap)this.stocks.get(0);
            hashMap.put(string, gTKStockIconInfo);
        }

        void addProperty(String string, String string2, Object object) {
            CircularIdentityList circularIdentityList;
            if (this.props == null) {
                this.props = new CircularIdentityList();
            }
            if ((circularIdentityList = (CircularIdentityList)this.props.get(string)) == null) {
                circularIdentityList = new CircularIdentityList();
                this.props.set(string, circularIdentityList);
            }
            circularIdentityList.set(string2, object);
        }

        void copyDataFrom(StyleInfo styleInfo) {
            int n = 0;
            while (n < 5) {
                this.fg[n] = styleInfo.fg[n];
                this.bg[n] = styleInfo.bg[n];
                this.text[n] = styleInfo.text[n];
                this.base[n] = styleInfo.base[n];
                this.bgPixmapName[n] = styleInfo.bgPixmapName[n];
                ++n;
            }
            this.xThickness = styleInfo.xThickness;
            this.yThickness = styleInfo.yThickness;
            this.font = styleInfo.font;
            if (styleInfo.stocks != null) {
                this.initStocksIfNecessary();
                this.stocks.addAll(styleInfo.stocks);
            }
            if (this.props == null) {
                this.props = GTKStyle.cloneClassSpecificValues(styleInfo.props);
            } else {
                GTKStyle.addClassSpecificValues(styleInfo.props, this.props);
            }
        }

        GTKStyle toGTKStyle() {
            Object object;
            Object[] objectArray;
            if (this.cachedStyle != null) {
                return this.cachedStyle;
            }
            ArrayList<GTKStyle.GTKStockIconInfo[]> arrayList = new ArrayList<GTKStyle.GTKStockIconInfo[]>();
            int n = 0;
            while (n < 5) {
                objectArray = null;
                if (this.fg[n] != null || this.bg[n] != null || this.text[n] != null || this.base[n] != null) {
                    objectArray = new Color[GTKColorType.MAX_COUNT];
                    objectArray[GTKColorType.FOREGROUND.getID()] = this.fg[n];
                    objectArray[GTKColorType.BACKGROUND.getID()] = this.bg[n];
                    objectArray[GTKColorType.TEXT_FOREGROUND.getID()] = this.text[n];
                    objectArray[GTKColorType.TEXT_BACKGROUND.getID()] = this.base[n];
                }
                if (objectArray != null || this.bgPixmapName[n] != null) {
                    object = new GTKStyle.GTKStateInfo(StyleInfo.toSynthState(n), null, null, null, (Color[])objectArray, this.bgPixmapName[n]);
                    arrayList.add((GTKStyle.GTKStockIconInfo[])object);
                }
                ++n;
            }
            objectArray = null;
            if (arrayList.size() != 0) {
                objectArray = new GTKStyle.GTKStateInfo[arrayList.size()];
                objectArray = (GTKStyle.GTKStateInfo[])arrayList.toArray(objectArray);
            }
            object = this.stocksToArray();
            this.cachedStyle = this.engineInfo != null ? this.engineInfo.constructGTKStyle((GTKStyle.GTKStateInfo[])objectArray, this.props, this.font, this.xThickness, this.yThickness, (GTKStyle.GTKStockIconInfo[])object) : (objectArray != null || object != null || this.props != null || this.font != null || this.xThickness != -1 || this.yThickness != -1 ? new GTKStyle((DefaultSynthStyle.StateInfo[])objectArray, this.props, this.font, this.xThickness, this.yThickness, (GTKStyle.GTKStockIconInfo[])object) : EMPTY_STYLE);
            return this.cachedStyle;
        }

        private GTKStyle.GTKStockIconInfo[] stocksToArray() {
            if (this.stocks == null) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            HashMap[] hashMapArray = new HashMap[this.stocks.size()];
            hashMapArray = this.stocks.toArray(hashMapArray);
            int n = 0;
            while (n < hashMapArray.length) {
                arrayList.addAll(hashMapArray[n].values());
                ++n;
            }
            GTKStyle.GTKStockIconInfo[] gTKStockIconInfoArray = new GTKStyle.GTKStockIconInfo[arrayList.size()];
            gTKStockIconInfoArray = arrayList.toArray(gTKStockIconInfoArray);
            return gTKStockIconInfoArray;
        }

        private static int toSynthState(int n) {
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
                case 4: {
                    return 512;
                }
            }
            return 1;
        }
    }

    static class Symbol {
        public String name;
        public int val;

        public Symbol(String string, int n) {
            this.name = string;
            this.val = n;
        }
    }
}

