/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.DefaultSynthStyle;
import com.sun.java.swing.plaf.gtk.GTKColorChooserPanel;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKGraphics;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import com.sun.java.swing.plaf.gtk.SynthIcon;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;

class GTKStyle
extends DefaultSynthStyle
implements GTKConstants {
    private static final Object PENDING = new StringBuffer("Pending");
    private static final Color BLACK_COLOR = new ColorUIResource(Color.BLACK);
    private static final Color WHITE_COLOR = new ColorUIResource(Color.WHITE);
    private static final Color[][] DEFAULT_COLORS;
    private static final int[] DEFAULT_COLOR_MAP;
    private static final Font DEFAULT_FONT;
    private static final HashMap DATA;
    private static final HashMap CLASS_SPECIFIC_MAP;
    private static final GTKGraphics GTK_GRAPHICS;
    private static final Object ICON_SIZE_KEY;
    private static final Dimension DIALOG_ICON_SIZE;
    private static final Dimension BUTTON_ICON_SIZE;
    private static final Dimension MENU_ICON_SIZE;
    private static final Dimension SMALL_TOOLBAR_ICON_SIZE;
    private static final Dimension LARGE_TOOLBAR_ICON_SIZE;
    private static final Dimension DND_ICON_SIZE;
    static final int UNDEFINED_THICKNESS = -1;
    private int xThickness = 2;
    private int yThickness = 2;
    private CircularIdentityList classSpecificValues;
    private Font font;
    private GTKStockIconInfo[] icons;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$GTKStyle;

    static void setIconSize(String string, int n, int n2) {
        GTKStyle.getIconSizeMap().put(string, new Dimension(n, n2));
    }

    static Dimension getIconSize(String string) {
        return (Dimension)GTKStyle.getIconSizeMap().get(string);
    }

    private static Map getIconSizeMap() {
        AppContext appContext = AppContext.getAppContext();
        HashMap<String, Dimension> hashMap = (HashMap<String, Dimension>)appContext.get(ICON_SIZE_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<String, Dimension>();
            hashMap.put("gtk-dialog", DIALOG_ICON_SIZE);
            hashMap.put("gtk-button", BUTTON_ICON_SIZE);
            hashMap.put("gtk-menu", MENU_ICON_SIZE);
            hashMap.put("gtk-small-toolbar", SMALL_TOOLBAR_ICON_SIZE);
            hashMap.put("gtk-large-toolbar", LARGE_TOOLBAR_ICON_SIZE);
            hashMap.put("gtk-dnd", DND_ICON_SIZE);
            appContext.put(ICON_SIZE_KEY, hashMap);
        }
        return hashMap;
    }

    static Color calculateLightColor(Color color) {
        return GTKColorType.adjustColor(color, 1.3f, 1.3f, 1.3f);
    }

    static Color calculateDarkColor(Color color) {
        return GTKColorType.adjustColor(color, 1.0f, 0.7f, 0.7f);
    }

    static Color calculateMidColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.min(255, (int)((double)n * 1.3));
        int n5 = Math.min(255, (int)((double)n2 * 1.3));
        int n6 = Math.min(255, (int)((double)n3 * 1.3));
        int n7 = (int)((double)n * 0.7);
        int n8 = (int)((double)n2 * 0.7);
        int n9 = (int)((double)n3 * 0.7);
        return new ColorUIResource((n4 + n7) / 2, (n5 + n8) / 2, (n6 + n9) / 2);
    }

    static Color[] getColorsFrom(Color color, Color color2) {
        Color[] colorArray = new Color[GTKColorType.MAX_COUNT];
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.min(255, (int)((double)n * 1.3));
        int n5 = Math.min(255, (int)((double)n2 * 1.3));
        int n6 = Math.min(255, (int)((double)n3 * 1.3));
        int n7 = (int)((double)n * 0.7);
        int n8 = (int)((double)n2 * 0.7);
        int n9 = (int)((double)n3 * 0.7);
        colorArray[GTKColorType.BACKGROUND.getID()] = color;
        colorArray[GTKColorType.LIGHT.getID()] = new ColorUIResource(n4, n5, n6);
        colorArray[GTKColorType.DARK.getID()] = new ColorUIResource(n7, n8, n9);
        colorArray[GTKColorType.MID.getID()] = new ColorUIResource((n4 + n7) / 2, (n5 + n8) / 2, (n6 + n9) / 2);
        colorArray[GTKColorType.BLACK.getID()] = BLACK_COLOR;
        colorArray[GTKColorType.WHITE.getID()] = WHITE_COLOR;
        colorArray[GTKColorType.FOCUS.getID()] = BLACK_COLOR;
        colorArray[GTKColorType.FOREGROUND.getID()] = color2;
        colorArray[GTKColorType.TEXT_FOREGROUND.getID()] = color2;
        colorArray[GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
        return colorArray;
    }

    public GTKStyle(DefaultSynthStyle defaultSynthStyle) {
        super(defaultSynthStyle);
        if (defaultSynthStyle instanceof GTKStyle) {
            GTKStyle gTKStyle = (GTKStyle)defaultSynthStyle;
            this.font = gTKStyle.font;
            this.xThickness = gTKStyle.xThickness;
            this.yThickness = gTKStyle.yThickness;
            this.icons = gTKStyle.icons;
            this.classSpecificValues = GTKStyle.cloneClassSpecificValues(gTKStyle.classSpecificValues);
        }
    }

    public GTKStyle() {
        super(new Insets(-1, -1, -1, -1), true, null, null);
    }

    public GTKStyle(Font font) {
        this();
        this.font = font;
    }

    public GTKStyle(DefaultSynthStyle.StateInfo[] stateInfoArray, CircularIdentityList circularIdentityList, Font font, int n, int n2, GTKStockIconInfo[] gTKStockIconInfoArray) {
        super(new Insets(-1, -1, -1, -1), true, stateInfoArray, null);
        this.font = font;
        this.xThickness = n;
        this.yThickness = n2;
        this.icons = gTKStockIconInfoArray;
        this.classSpecificValues = circularIdentityList;
    }

    public SynthGraphics getSynthGraphics(SynthContext synthContext) {
        return GTK_GRAPHICS;
    }

    public GTKEngine getEngine(SynthContext synthContext) {
        GTKEngine gTKEngine = (GTKEngine)this.get(synthContext, "engine");
        if (gTKEngine == null) {
            return GTKEngine.INSTANCE;
        }
        return gTKEngine;
    }

    public SynthPainter getBorderPainter(SynthContext synthContext) {
        SynthPainter synthPainter = super.getBorderPainter(synthContext);
        if (synthPainter == null) {
            return GTKPainter.INSTANCE;
        }
        return synthPainter;
    }

    public SynthPainter getBackgroundPainter(SynthContext synthContext) {
        SynthPainter synthPainter = super.getBackgroundPainter(synthContext);
        if (synthPainter == null) {
            return GTKPainter.INSTANCE;
        }
        return synthPainter;
    }

    public Insets getInsets(SynthContext synthContext, Insets insets) {
        insets = super.getInsets(synthContext, insets);
        if (insets.top == -1) {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets = GTKPainter.INSTANCE.getInsets(synthContext, insets);
        }
        return insets;
    }

    public Object getClassSpecificValue(SynthContext synthContext, String string) {
        if (this.classSpecificValues != null) {
            String string2 = GTKStyleFactory.gtkClassFor(synthContext.getRegion());
            while (string2 != null) {
                Object object;
                CircularIdentityList circularIdentityList = (CircularIdentityList)this.classSpecificValues.get(string2);
                if (circularIdentityList != null && (object = circularIdentityList.get(string)) != null) {
                    return object;
                }
                string2 = GTKStyleFactory.gtkSuperclass(string2);
            }
        }
        return null;
    }

    public int getClassSpecificIntValue(SynthContext synthContext, String string, int n) {
        Object object = this.getClassSpecificValue(synthContext, string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return n;
    }

    public Insets getClassSpecificInsetsValue(SynthContext synthContext, String string, Insets insets) {
        Object object = this.getClassSpecificValue(synthContext, string);
        if (object instanceof Insets) {
            return (Insets)object;
        }
        return insets;
    }

    public boolean getClassSpecificBoolValue(SynthContext synthContext, String string, boolean bl) {
        Object object = this.getClassSpecificValue(synthContext, string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(SynthContext synthContext, Object object) {
        Object object2 = super.get(synthContext, object);
        if (object2 == null) {
            Object v = CLASS_SPECIFIC_MAP.get(object);
            if (v != null && (object2 = this.getClassSpecificValue(synthContext, (String)v)) != null) {
                return object2;
            }
            if (object == "foreground" || object == "focus" || object == "SplitPane.dragPainter" || object == "ScrollPane.viewportBorderPainter") {
                return GTKPainter.INSTANCE;
            }
            if (object == "ScrollPane.viewportBorderInsets") {
                return GTKPainter.INSTANCE.getScrollPaneInsets(synthContext, new Insets(0, 0, 0, 0));
            }
            HashMap hashMap = DATA;
            synchronized (hashMap) {
                object2 = DATA.get(object);
                try {
                    while (object2 == PENDING) {
                        DATA.wait();
                        object2 = DATA.get(object);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (object2 instanceof UIDefaults.LazyValue) {
                    DATA.put(object, PENDING);
                }
            }
            if (object2 instanceof StyleSpecificValue) {
                this.put(object, ((StyleSpecificValue)object2).getValue(synthContext));
            } else if (object2 instanceof UIDefaults.ActiveValue) {
                object2 = ((UIDefaults.ActiveValue)object2).createValue(null);
            } else if (object2 instanceof UIDefaults.LazyValue) {
                object2 = ((UIDefaults.LazyValue)object2).createValue(null);
                HashMap hashMap2 = DATA;
                synchronized (hashMap2) {
                    DATA.put(object, object2);
                    DATA.notifyAll();
                }
            }
        }
        return object2;
    }

    protected Font _getFont(JComponent jComponent, Region region, int n) {
        if (this.font != null) {
            return this.font;
        }
        Font font = super._getFont(jComponent, region, n = GTKLookAndFeel.synthStateToGTKState(region, n));
        if (font == null) {
            return DEFAULT_FONT;
        }
        return font;
    }

    Color getGTKColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        Color color = super._getColor(jComponent, region, n, colorType);
        if (color != null) {
            return color;
        }
        return this.getDefaultColor(jComponent, region, n, colorType);
    }

    public Color getColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        if (region == Region.LABEL && colorType == ColorType.TEXT_FOREGROUND) {
            colorType = ColorType.FOREGROUND;
        }
        n = GTKLookAndFeel.synthStateToGTKState(region, n);
        if (!region.isSubregion() && (n & 1) == 1) {
            Color color;
            if (colorType == ColorType.BACKGROUND) {
                return jComponent.getBackground();
            }
            if (colorType == ColorType.FOREGROUND) {
                return jComponent.getForeground();
            }
            if (colorType == ColorType.TEXT_FOREGROUND && (color = jComponent.getForeground()) != null && !(color instanceof UIResource)) {
                return color;
            }
        }
        return this._getColor(jComponent, region, n, colorType);
    }

    protected Color _getColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        Color color = super._getColor(jComponent, region, n, colorType);
        if (color != null) {
            return color;
        }
        if (colorType == ColorType.FOCUS) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.BLACK) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.WHITE) {
            return WHITE_COLOR;
        }
        if (colorType == ColorType.TEXT_FOREGROUND && (GTKStyleFactory.isLabelBearing(region) || region == Region.MENU_ITEM_ACCELERATOR || region == Region.TABBED_PANE_TAB)) {
            colorType = ColorType.FOREGROUND;
        } else if (region == Region.TABLE || region == Region.LIST || region == Region.TREE || region == Region.TREE_CELL) {
            if (colorType == ColorType.FOREGROUND) {
                colorType = ColorType.TEXT_FOREGROUND;
                if (n == 4) {
                    n = 512;
                }
            } else if (colorType == ColorType.BACKGROUND) {
                colorType = ColorType.TEXT_BACKGROUND;
                if (n == 4) {
                    n = 512;
                }
            }
        }
        return this.getDefaultColor(jComponent, region, n, colorType);
    }

    Color getDefaultColor(JComponent jComponent, Region region, int n, ColorType colorType) {
        if (colorType == ColorType.FOCUS) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.BLACK) {
            return BLACK_COLOR;
        }
        if (colorType == GTKColorType.WHITE) {
            return WHITE_COLOR;
        }
        int n2 = DEFAULT_COLOR_MAP.length - 1;
        while (n2 >= 0) {
            if ((DEFAULT_COLOR_MAP[n2] & n) != 0 && colorType.getID() < DEFAULT_COLORS[n2].length) {
                return DEFAULT_COLORS[n2][colorType.getID()];
            }
            --n2;
        }
        if (colorType.getID() < DEFAULT_COLORS[2].length) {
            return DEFAULT_COLORS[2][colorType.getID()];
        }
        return null;
    }

    public boolean isOpaque(SynthContext synthContext) {
        Region region = synthContext.getRegion();
        return region == Region.COMBO_BOX || region == Region.DESKTOP_PANE || region == Region.DESKTOP_ICON || region == Region.EDITOR_PANE || region == Region.FORMATTED_TEXT_FIELD || region == Region.INTERNAL_FRAME || region == Region.LIST || region == Region.MENU_BAR || region == Region.PASSWORD_FIELD || region == Region.POPUP_MENU || region == Region.PROGRESS_BAR || region == Region.ROOT_PANE || region == Region.SCROLL_PANE || region == Region.SPINNER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE || region == Region.TOOL_BAR_DRAG_WINDOW || region == Region.TOOL_TIP || region == Region.TREE || region == Region.VIEWPORT;
    }

    public int getXThickness() {
        return this.xThickness;
    }

    public int getYThickness() {
        return this.yThickness;
    }

    private Icon getStockIcon(SynthContext synthContext, String string, String string2) {
        Serializable serializable;
        Icon icon = null;
        GTKStockIconInfo gTKStockIconInfo = null;
        GTKIconSource gTKIconSource = null;
        int n = 0;
        if (synthContext != null) {
            serializable = synthContext.getComponent().getComponentOrientation();
            n = serializable == null || serializable.isLeftToRight() ? 0 : 1;
        }
        if (this.icons != null) {
            int n2 = 0;
            while (n2 < this.icons.length) {
                if (this.icons[n2].getKey() == string) {
                    gTKStockIconInfo = this.icons[n2];
                    break;
                }
                ++n2;
            }
            if (gTKStockIconInfo != null) {
                gTKIconSource = gTKStockIconInfo.getBestIconSource(n, 1, string2);
            }
            if (gTKIconSource != null) {
                icon = gTKIconSource.toIcon();
            }
        }
        if (icon == null) {
            icon = (Icon)((UIDefaults.LazyValue)LookAndFeel.makeIcon(class$com$sun$java$swing$plaf$gtk$GTKStyle == null ? (class$com$sun$java$swing$plaf$gtk$GTKStyle = GTKStyle.class$("com.sun.java.swing.plaf.gtk.GTKStyle")) : class$com$sun$java$swing$plaf$gtk$GTKStyle, "resources/" + string + "-" + string2 + ".png")).createValue(null);
        }
        if (!(icon == null || gTKIconSource != null && gTKIconSource.getSize() != null || (serializable = GTKStyle.getIconSize(string2)) == null || icon.getIconWidth() == ((Dimension)serializable).width && icon.getIconHeight() == ((Dimension)serializable).height)) {
            BufferedImage bufferedImage = new BufferedImage(((Dimension)serializable).width, ((Dimension)serializable).height, 2);
            Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Image image = null;
            if (icon instanceof ImageIcon) {
                image = ((ImageIcon)icon).getImage();
            } else {
                image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics graphics = image.getGraphics();
                icon.paintIcon(null, graphics, 0, 0);
                graphics.dispose();
            }
            graphics2D.drawImage(image, 0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height, null);
            graphics2D.dispose();
            icon = new ImageIcon(bufferedImage);
        }
        return icon;
    }

    void addLabelProperties(GTKStyle gTKStyle) {
        block8: {
            block7: {
                this.font = gTKStyle.font;
                if (this.states != null) break block7;
                if (gTKStyle.states == null) {
                    return;
                }
                this.states = new DefaultSynthStyle.StateInfo[gTKStyle.states.length];
                int n = 0;
                while (n < gTKStyle.states.length) {
                    Color color = gTKStyle.states[n].getColor(GTKColorType.FOREGROUND);
                    this.states[n] = this.createStateInfo(gTKStyle.states[n].getComponentState(), GTKColorType.TEXT_FOREGROUND, color);
                    ++n;
                }
                break block8;
            }
            int n = this.states.length - 1;
            while (n >= 0) {
                ((GTKStateInfo)this.states[n]).setColor(GTKColorType.TEXT_FOREGROUND, null);
                --n;
            }
            if (gTKStyle.states == null) break block8;
            int n2 = gTKStyle.states.length - 1;
            while (n2 >= 0) {
                boolean bl = false;
                DefaultSynthStyle.StateInfo stateInfo = gTKStyle.states[n2];
                int n3 = stateInfo.getComponentState();
                Color color = stateInfo.getColor(GTKColorType.FOREGROUND);
                int n4 = this.states.length - 1;
                while (n4 >= 0) {
                    if (n3 == this.states[n4].getComponentState()) {
                        ((GTKStateInfo)this.states[n4]).setColor(GTKColorType.TEXT_FOREGROUND, color);
                        bl = true;
                        break;
                    }
                    --n4;
                }
                if (!bl) {
                    DefaultSynthStyle.StateInfo[] stateInfoArray = new DefaultSynthStyle.StateInfo[this.states.length + 1];
                    System.arraycopy(this.states, 0, stateInfoArray, 0, this.states.length);
                    stateInfoArray[this.states.length] = this.createStateInfo(n3, GTKColorType.TEXT_FOREGROUND, color);
                    this.states = stateInfoArray;
                }
                --n2;
            }
        }
    }

    GTKStateInfo createStateInfo(int n, ColorType colorType, Color color) {
        Color[] colorArray = new Color[GTKColorType.MAX_COUNT];
        colorArray[colorType.getID()] = color;
        return new GTKStateInfo(n, null, null, null, colorArray, null);
    }

    void put(Object object, Object object2) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(object, object2);
    }

    boolean fillBackground(SynthContext synthContext, int n) {
        GTKStateInfo gTKStateInfo = (GTKStateInfo)this.getStateInfo(n);
        if (gTKStateInfo != null) {
            Object object = gTKStateInfo.getBackgroundImage();
            return object == "<none>" || object == null;
        }
        return true;
    }

    Image getBackgroundImage(SynthContext synthContext, int n) {
        Object object;
        GTKStateInfo gTKStateInfo = (GTKStateInfo)this.getStateInfo(n);
        if (gTKStateInfo != null && (object = gTKStateInfo.getBackgroundImage()) instanceof Image) {
            return (Image)object;
        }
        return null;
    }

    public Object clone() {
        GTKStyle gTKStyle = (GTKStyle)super.clone();
        gTKStyle.classSpecificValues = GTKStyle.cloneClassSpecificValues(gTKStyle.classSpecificValues);
        return gTKStyle;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (!(defaultSynthStyle instanceof GTKStyle)) {
            defaultSynthStyle = new GTKStyle(defaultSynthStyle);
        }
        GTKStyle gTKStyle = (GTKStyle)super.addTo(defaultSynthStyle);
        if (this.xThickness != -1) {
            gTKStyle.xThickness = this.xThickness;
        }
        if (this.yThickness != -1) {
            gTKStyle.yThickness = this.yThickness;
        }
        if (this.font != null) {
            gTKStyle.font = this.font;
        }
        if (gTKStyle.icons == null) {
            gTKStyle.icons = this.icons;
        } else if (this.icons != null) {
            GTKStockIconInfo[] gTKStockIconInfoArray = new GTKStockIconInfo[gTKStyle.icons.length + this.icons.length];
            System.arraycopy(this.icons, 0, gTKStockIconInfoArray, 0, this.icons.length);
            System.arraycopy(gTKStyle.icons, 0, gTKStockIconInfoArray, this.icons.length, gTKStyle.icons.length);
            gTKStyle.icons = gTKStockIconInfoArray;
        }
        if (gTKStyle.classSpecificValues == null) {
            gTKStyle.classSpecificValues = GTKStyle.cloneClassSpecificValues(this.classSpecificValues);
        } else {
            GTKStyle.addClassSpecificValues(this.classSpecificValues, gTKStyle.classSpecificValues);
        }
        return gTKStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addClassSpecificValues(CircularIdentityList circularIdentityList, CircularIdentityList circularIdentityList2) {
        if (circularIdentityList2 == null) {
            throw new IllegalArgumentException("to may not be null");
        }
        if (circularIdentityList == null) {
            return;
        }
        CircularIdentityList circularIdentityList3 = circularIdentityList;
        synchronized (circularIdentityList3) {
            Object object = circularIdentityList.next();
            if (object != null) {
                Object object2 = object;
                do {
                    CircularIdentityList circularIdentityList4 = (CircularIdentityList)circularIdentityList.get();
                    CircularIdentityList circularIdentityList5 = (CircularIdentityList)circularIdentityList2.get(object2);
                    if (circularIdentityList5 == null) {
                        circularIdentityList2.set(object2, circularIdentityList4.clone());
                        continue;
                    }
                    Object object3 = circularIdentityList4.next();
                    if (object3 == null) continue;
                    Object object4 = object3;
                    do {
                        circularIdentityList5.set(object4, circularIdentityList4.get());
                    } while ((object4 = circularIdentityList4.next()) != object3);
                } while ((object2 = circularIdentityList.next()) != object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CircularIdentityList cloneClassSpecificValues(CircularIdentityList circularIdentityList) {
        CircularIdentityList circularIdentityList2;
        if (circularIdentityList == null) {
            return null;
        }
        CircularIdentityList circularIdentityList3 = circularIdentityList;
        synchronized (circularIdentityList3) {
            Object object = circularIdentityList.next();
            if (object == null) {
                return null;
            }
            circularIdentityList2 = new CircularIdentityList();
            Object object2 = object;
            do {
                circularIdentityList2.set(object2, ((CircularIdentityList)circularIdentityList.get()).clone());
            } while ((object2 = circularIdentityList.next()) != object);
        }
        return circularIdentityList2;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class=");
        stringBuffer.append(this.getClass().getName()).append('\n');
        if (this.font != null) {
            stringBuffer.append("font=").append(this.font.toString()).append('\n');
        }
        if (this.xThickness != -1) {
            stringBuffer.append("xt=").append(String.valueOf(this.xThickness)).append('\n');
        }
        if (this.yThickness != -1) {
            stringBuffer.append("yt=").append(String.valueOf(this.yThickness)).append('\n');
        }
        if (this.states != null) {
            stringBuffer.append("*** Colors and Pixmaps ***\n");
            n = 0;
            while (n < this.states.length) {
                stringBuffer.append(this.states[n].toString()).append('\n');
                ++n;
            }
        }
        if (this.classSpecificValues != null) {
            stringBuffer.append("*** Properties ***\n");
            stringBuffer.append(GTKStyle.classSpecValsToString(this.classSpecificValues)).append('\n');
        }
        if (this.icons != null) {
            stringBuffer.append("*** Stock Icons ***\n");
            n = 0;
            while (n < this.icons.length) {
                stringBuffer.append(this.icons[n].toString()).append('\n');
                ++n;
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static String classSpecValsToString(CircularIdentityList circularIdentityList) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = circularIdentityList.next();
        if (object == null) {
            return "";
        }
        Object object2 = object;
        do {
            stringBuffer.append(object2).append('\n');
            CircularIdentityList circularIdentityList2 = (CircularIdentityList)circularIdentityList.get();
            Object object3 = circularIdentityList2.next();
            if (object3 == null) break;
            Object object4 = object3;
            do {
                stringBuffer.append("    ").append(object4).append('=').append(circularIdentityList2.get()).append('\n');
            } while ((object4 = circularIdentityList2.next()) != object3);
        } while ((object2 = circularIdentityList.next()) != object);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static String getStateName(int n, String string) {
        switch (n) {
            case 1: {
                return "NORMAL";
            }
            case 4: {
                return "ACTIVE";
            }
            case 512: {
                return "SELECTED";
            }
            case 2: {
                return "PRELIGHT";
            }
            case 8: {
                return "INSENSITIVE";
            }
            case -100: {
                return string;
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_FONT = new FontUIResource("sansserif", 0, 10);
        DATA = new HashMap();
        GTK_GRAPHICS = new GTKGraphics();
        ICON_SIZE_KEY = new StringBuffer("IconSize");
        DIALOG_ICON_SIZE = new Dimension(48, 48);
        BUTTON_ICON_SIZE = new Dimension(20, 20);
        MENU_ICON_SIZE = new Dimension(16, 16);
        SMALL_TOOLBAR_ICON_SIZE = new Dimension(18, 18);
        LARGE_TOOLBAR_ICON_SIZE = new Dimension(24, 24);
        DND_ICON_SIZE = new Dimension(32, 32);
        DEFAULT_COLOR_MAP = new int[]{4, 512, 1, 2, 8};
        DEFAULT_COLORS = new Color[5][];
        GTKStyle.DEFAULT_COLORS[0] = GTKStyle.getColorsFrom(new ColorUIResource(195, 195, 195), BLACK_COLOR);
        GTKStyle.DEFAULT_COLORS[1] = GTKStyle.getColorsFrom(new ColorUIResource(0, 0, 156), WHITE_COLOR);
        GTKStyle.DEFAULT_COLORS[2] = GTKStyle.getColorsFrom(new ColorUIResource(214, 214, 214), BLACK_COLOR);
        GTKStyle.DEFAULT_COLORS[3] = GTKStyle.getColorsFrom(new ColorUIResource(233, 233, 233), BLACK_COLOR);
        GTKStyle.DEFAULT_COLORS[4] = GTKStyle.getColorsFrom(new ColorUIResource(214, 214, 214), new ColorUIResource(117, 117, 117));
        GTKStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(188, 210, 238);
        GTKStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(164, 223, 255);
        GTKStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
        GTKStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
        GTKStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_FOREGROUND.getID()] = DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()];
        CLASS_SPECIFIC_MAP = new HashMap();
        CLASS_SPECIFIC_MAP.put("CheckBox.iconTextGap", "indicator_spacing");
        CLASS_SPECIFIC_MAP.put("Slider.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("Slider.trackBorder", "trough-border");
        CLASS_SPECIFIC_MAP.put("SplitPaneDivider.size", "handle-size");
        CLASS_SPECIFIC_MAP.put("Tree.expanderSize", "expander_size");
        CLASS_SPECIFIC_MAP.put("ScrollBar.thumbHeight", "slider_width");
        Integer n = new Integer(500);
        InsetsUIResource insetsUIResource = new InsetsUIResource(0, 0, 0, 0);
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(3, 3, 3, 3);
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object[] objectArray = new Object[]{"Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}), "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.icon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxIcon"), "CheckBoxMenuItem.arrowIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxMenuItemArrowIcon"), "CheckBoxMenuItem.checkIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxMenuItemCheckIcon"), "ColorChooser.panels", new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return new AbstractColorChooserPanel[]{new GTKColorChooserPanel()};
            }
        }, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "shift RIGHT", "shrinkRight", "shift KP_RIGHT", "shrinkRight", "LEFT", "left", "KP_LEFT", "left", "shift LEFT", "shrinkLeft", "shift KP_LEFT", "shrinkLeft", "UP", "up", "KP_UP", "up", "shift UP", "shrinkUp", "shift KP_UP", "shrinkUp", "DOWN", "down", "KP_DOWN", "down", "shift DOWN", "shrinkDown", "shift KP_DOWN", "shrinkDown", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious", "alt  F7", "move", "alt  F8", "resize", "alt  F9", "minimize"}), "EditorPane.caretBlinkRate", n, "EditorPane.margin", insetsUIResource2, "EditorPane.focusInputMap", lazyInputMap2, "EditorPane.caretForeground", BLACK_COLOR, "EditorPane.caretBlinkRate", n, "EditorPane.margin", insetsUIResource2, "EditorPane.focusInputMap", lazyInputMap2, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "SPACE", "changeDirectory"}), "FileChooser.cancelIcon", new GTKStockIcon("gtk-cancel", "gtk-button"), "FileChooser.okIcon", new GTKStockIcon("gtk-ok", "gtk-button"), "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "InternalFrameTitlePane.titlePaneLayout", new GTKLazyValue("com.sun.java.swing.plaf.gtk.Metacity", "getTitlePaneLayout"), "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl SPACE", "selectNextRowExtendSelection", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "selectCurrent"}), "List.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection"}), "Menu.shortcutKeys", new int[]{8}, "Menu.arrowIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getMenuArrowIcon"), "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuItem.arrowIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getMenuItemArrowIcon"), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.buttonClickThreshhold", new Integer(500), "OptionPane.errorIcon", new GTKStockIcon("gtk-dialog-error", "gtk-dialog"), "OptionPane.informationIcon", new GTKStockIcon("gtk-dialog-info", "gtk-dialog"), "OptionPane.warningIcon", new GTKStockIcon("gtk-dialog-warning", "gtk-dialog"), "OptionPane.questionIcon", new GTKStockIcon("gtk-dialog-question", "gtk-dialog"), "OptionPane.yesIcon", new GTKStockIcon("gtk-yes", "gtk-button"), "OptionPane.noIcon", new GTKStockIcon("gtk-no", "gtk-button"), "OptionPane.cancelIcon", new GTKStockIcon("gtk-cancel", "gtk-button"), "OptionPane.okIcon", new GTKStockIcon("gtk-ok", "gtk-button"), "PasswordField.caretForeground", BLACK_COLOR, "PasswordField.caretBlinkRate", n, "PasswordField.margin", insetsUIResource, "PasswordField.focusInputMap", lazyInputMap, "PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "PopupMenu.selectedWindowInputMapBindings.RightToLeft", new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"}, "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"}), "RadioButton.icon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonIcon"), "RadioButtonMenuItem.arrowIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonMenuItemArrowIcon"), "RadioButtonMenuItem.checkIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonMenuItemCheckIcon"), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "ScrollBar.thumbHeight", new Integer(14), "ScrollBar.width", new Integer(16), "ScrollBar.minimumThumbSize", new Dimension(8, 8), "ScrollBar.maximumThumbSize", new Dimension(4096, 4096), "ScrollBar.allowsAbsolutePositioning", Boolean.TRUE, "ScrollBar.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollBar.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}), "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_UP", "scrollRight", "ctrl PAGE_DOWN", "scrollLeft"}), "Separator.insets", insetsUIResource, "Separator.thickness", new Integer(2), "Slider.paintValue", Boolean.TRUE, "Slider.thumbWidth", new Integer(30), "Slider.thumbHeight", new Integer(14), "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Slider.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}), "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "SplitPaneDivider.size", new Integer(7), "SplitPaneDivider.oneTouchOffset", new Integer(2), "SplitPaneDivider.oneTouchButtonSize", new Integer(5), "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent", "SPACE", "selectTabWithFocus"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl TAB", "navigateNext", "ctrl shift TAB", "navigatePrevious", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "TabbedPane.selectionFollowsFocus", Boolean.FALSE, "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}), "Table.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl PAGE_UP", "scrollRightChangeSelection", "ctrl PAGE_DOWN", "scrollLeftChangeSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection"}), "TextArea.caretForeground", BLACK_COLOR, "TextArea.caretBlinkRate", n, "TextArea.margin", insetsUIResource, "TextArea.focusInputMap", lazyInputMap2, "TextField.caretForeground", BLACK_COLOR, "TextField.caretBlinkRate", n, "TextField.margin", insetsUIResource, "TextField.focusInputMap", lazyInputMap, "TextPane.caretForeground", BLACK_COLOR, "TextPane.caretBlinkRate", n, "TextPane.margin", insetsUIResource2, "TextPane.focusInputMap", lazyInputMap2, "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToolBar.separatorSize", new DimensionUIResource(10, 10), "ToolBar.handleIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getToolBarHandleIcon"), "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "Tree.drawHorizontalLegs", Boolean.TRUE, "Tree.drawVerticalLegs", Boolean.TRUE, "Tree.rowHeight", new Integer(-1), "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.expanderSize", new Integer(10), "Tree.expandedIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getTreeExpandedIcon"), "Tree.collapsedIcon", new GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getTreeCollapsedIcon"), "Tree.trailingLegBufferOffset", new Integer(14), "Tree.trailingControlOffset", new Integer(12), "Tree.controlSize", new Integer(18), "Tree.indent", new Integer(14), "Tree.scrollsHorizontallyAndVertically", Boolean.FALSE, "Tree.drawsFocusBorder", Boolean.TRUE, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"}), "Tree.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectParent", "KP_RIGHT", "selectParent", "LEFT", "selectChild", "KP_LEFT", "selectChild"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            DATA.put(objectArray[n2], objectArray[++n2]);
            ++n2;
        }
    }

    static class GTKLazyValue
    implements UIDefaults.LazyValue {
        private String className;
        private String methodName;

        GTKLazyValue(String string) {
            this(string, null);
        }

        GTKLazyValue(String string, String string2) {
            this.className = string;
            this.methodName = string2;
        }

        public Object createValue(UIDefaults uIDefaults) {
            try {
                Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                if (this.methodName == null) {
                    return clazz.newInstance();
                }
                Method method = clazz.getMethod(this.methodName, null);
                return method.invoke(clazz, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            return null;
        }
    }

    private static class GTKStockIcon
    extends SynthIcon
    implements Cloneable,
    StyleSpecificValue {
        private String key;
        private String size;
        private boolean loadedLTR;
        private boolean loadedRTL;
        private Icon ltrIcon;
        private Icon rtlIcon;
        private SynthStyle style;

        GTKStockIcon(String string, String string2) {
            this.key = string;
            this.size = string2;
        }

        public void paintIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                if (synthContext == null) {
                    icon.paintIcon(null, graphics, n, n2);
                } else {
                    icon.paintIcon(synthContext.getComponent(), graphics, n, n2);
                }
            }
        }

        public int getIconWidth(SynthContext synthContext) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 0;
        }

        public int getIconHeight(SynthContext synthContext) {
            Icon icon = this.getIcon(synthContext);
            if (icon != null) {
                return icon.getIconHeight();
            }
            return 0;
        }

        private Icon getIcon(SynthContext synthContext) {
            if (synthContext != null) {
                ComponentOrientation componentOrientation = synthContext.getComponent().getComponentOrientation();
                SynthStyle synthStyle = synthContext.getStyle();
                if (synthStyle != this.style) {
                    this.style = synthStyle;
                    this.loadedRTL = false;
                    this.loadedLTR = false;
                }
                if (componentOrientation == null || componentOrientation.isLeftToRight()) {
                    if (!this.loadedLTR) {
                        this.loadedLTR = true;
                        this.ltrIcon = ((GTKStyle)synthContext.getStyle()).getStockIcon(synthContext, this.key, this.size);
                    }
                    return this.ltrIcon;
                }
                if (!this.loadedRTL) {
                    this.loadedRTL = true;
                    this.rtlIcon = ((GTKStyle)synthContext.getStyle()).getStockIcon(synthContext, this.key, this.size);
                }
                return this.rtlIcon;
            }
            return this.ltrIcon;
        }

        public Object getValue(SynthContext synthContext) {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    static interface StyleSpecificValue {
        public Object getValue(SynthContext var1);
    }

    public static class GTKStateInfo
    extends DefaultSynthStyle.StateInfo {
        private Object backgroundImage;

        public GTKStateInfo(int n, SynthPainter synthPainter, SynthPainter synthPainter2, Font font, Color[] colorArray, Object object) {
            super(n, synthPainter, synthPainter2, font, colorArray);
            this.backgroundImage = object;
        }

        public GTKStateInfo(DefaultSynthStyle.StateInfo stateInfo) {
            super(stateInfo);
            if (stateInfo instanceof GTKStateInfo) {
                this.backgroundImage = ((GTKStateInfo)stateInfo).backgroundImage;
            }
        }

        void setColor(ColorType colorType, Color color) {
            if (this.colors == null) {
                if (color == null) {
                    return;
                }
                this.colors = new Color[GTKColorType.MAX_COUNT];
            }
            this.colors[colorType.getID()] = color;
        }

        public Color getColor(ColorType colorType) {
            Color color;
            Color[] colorArray;
            Color color2 = super.getColor(colorType);
            if (color2 == null && (colorArray = this.getColors()) != null && (color = super.getColor(GTKColorType.BACKGROUND)) != null) {
                if (colorType == GTKColorType.LIGHT) {
                    Color color3 = GTKStyle.calculateLightColor(color);
                    colorArray[GTKColorType.LIGHT.getID()] = color3;
                    color2 = color3;
                } else if (colorType == GTKColorType.MID) {
                    Color color4 = GTKStyle.calculateMidColor(color);
                    colorArray[GTKColorType.MID.getID()] = color4;
                    color2 = color4;
                } else if (colorType == GTKColorType.DARK) {
                    Color color5 = GTKStyle.calculateDarkColor(color);
                    colorArray[GTKColorType.DARK.getID()] = color5;
                    color2 = color5;
                }
            }
            return color2;
        }

        Object getBackgroundImage() {
            if (this.backgroundImage == null || this.backgroundImage instanceof Image || this.backgroundImage == "<none>" || this.backgroundImage == "<parent>") {
                return this.backgroundImage;
            }
            ImageIcon imageIcon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ GTKStateInfo this$0;
                {
                    this.this$0 = gTKStateInfo;
                }

                public Object run() {
                    return new ImageIcon((String)GTKStateInfo.access$400(this.this$0));
                }
            });
            this.backgroundImage = imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0 ? imageIcon.getImage() : null;
            return this.backgroundImage;
        }

        public Object clone() {
            return new GTKStateInfo(this);
        }

        public DefaultSynthStyle.StateInfo addTo(DefaultSynthStyle.StateInfo stateInfo) {
            if (!(stateInfo instanceof GTKStateInfo)) {
                stateInfo = new GTKStateInfo(stateInfo);
            } else {
                super.addTo(stateInfo);
            }
            GTKStateInfo gTKStateInfo = (GTKStateInfo)stateInfo;
            if (this.backgroundImage != null) {
                gTKStateInfo.backgroundImage = this.backgroundImage;
            }
            return gTKStateInfo;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(GTKStyle.getStateName(this.getComponentState(), "UNDEFINED")).append(":\n");
            if (this.getColor(GTKColorType.FOREGROUND) != null) {
                stringBuffer.append("    fg=").append(this.getColor(GTKColorType.FOREGROUND)).append('\n');
            }
            if (this.getColor(GTKColorType.BACKGROUND) != null) {
                stringBuffer.append("    bg=").append(this.getColor(GTKColorType.BACKGROUND)).append('\n');
            }
            if (this.getColor(GTKColorType.TEXT_FOREGROUND) != null) {
                stringBuffer.append("    text=").append(this.getColor(GTKColorType.TEXT_FOREGROUND)).append('\n');
            }
            if (this.getColor(GTKColorType.TEXT_BACKGROUND) != null) {
                stringBuffer.append("    base=").append(this.getColor(GTKColorType.TEXT_BACKGROUND)).append('\n');
            }
            if (this.backgroundImage != null) {
                stringBuffer.append("    pmn=").append(this.backgroundImage).append('\n');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }

        static /* synthetic */ Object access$400(GTKStateInfo gTKStateInfo) {
            return gTKStateInfo.backgroundImage;
        }
    }

    static class GTKIconSource
    implements Comparable {
        private Object image;
        private int direction;
        private int state;
        private String size;

        GTKIconSource(String string, int n, int n2, String string2) {
            this.image = string;
            this.direction = n;
            this.state = n2;
            if (string2 != null) {
                this.size = string2.intern();
            }
        }

        public int getDirection() {
            return this.direction;
        }

        public int getState() {
            return this.state;
        }

        public String getSize() {
            return this.size;
        }

        public int compareTo(Object object) {
            GTKIconSource gTKIconSource = (GTKIconSource)object;
            if (this.direction != -100 && gTKIconSource.direction == -100) {
                return -1;
            }
            if (this.direction == -100 && gTKIconSource.direction != -100) {
                return 1;
            }
            if (this.state != -100 && gTKIconSource.state == -100) {
                return -1;
            }
            if (this.state == -100 && gTKIconSource.state != -100) {
                return 1;
            }
            if (this.size != null && gTKIconSource.size == null) {
                return -1;
            }
            if (this.size == null && gTKIconSource.size != null) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "image=" + this.image + ", dir=" + GTKIconSource.getDirectionName(this.direction) + ", state=" + GTKStyle.getStateName(this.state, "*") + ", size=" + (this.size == null ? "*" : this.size);
        }

        private static String getDirectionName(int n) {
            switch (n) {
                case 0: {
                    return "LTR";
                }
                case 1: {
                    return "RTL";
                }
                case -100: {
                    return "*";
                }
            }
            return "UNKNOWN";
        }

        public Icon toIcon() {
            if (this.image == null || this.image instanceof Icon) {
                return (Icon)this.image;
            }
            ImageIcon imageIcon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ GTKIconSource this$0;
                {
                    this.this$0 = gTKIconSource;
                }

                public Object run() {
                    return new ImageIcon((String)GTKIconSource.access$300(this.this$0));
                }
            });
            this.image = imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0 ? imageIcon : null;
            return (Icon)this.image;
        }

        static /* synthetic */ Object access$300(GTKIconSource gTKIconSource) {
            return gTKIconSource.image;
        }
    }

    static class GTKStockIconInfo {
        private String key;
        private GTKIconSource[] sources;

        GTKStockIconInfo(String string, GTKIconSource[] gTKIconSourceArray) {
            this.key = string.intern();
            this.sources = gTKIconSourceArray;
            Arrays.sort(this.sources);
        }

        public String getKey() {
            return this.key;
        }

        public GTKIconSource getBestIconSource(int n, int n2, String string) {
            int n3 = 0;
            while (n3 < this.sources.length) {
                GTKIconSource gTKIconSource = this.sources[n3];
                if (!(gTKIconSource.direction != -100 && gTKIconSource.direction != n || gTKIconSource.state != -100 && gTKIconSource.state != n2 || gTKIconSource.size != null && !GTKStockIconInfo.sizesMatch(gTKIconSource.size, string))) {
                    return gTKIconSource;
                }
                ++n3;
            }
            return null;
        }

        private static boolean sizesMatch(String string, String string2) {
            return string == string2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("STOCK ICON " + this.key + ":\n");
            int n = 0;
            while (n < this.sources.length) {
                stringBuffer.append("    ").append(this.sources[n].toString()).append('\n');
                ++n;
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }
    }
}

