/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthDragGestureRecognizer;
import com.sun.java.swing.plaf.gtk.SynthDropTargetListener;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthTransferable;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Position;

class SynthListUI
extends ListUI
implements SynthUI {
    protected JList list = null;
    private SynthStyle style;
    protected CellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    private KeyListener keyListener;
    protected int[] cellHeights = null;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    private int listHeight;
    private int listWidth;
    private int layoutOrientation;
    private int columnCount;
    private int preferredHeight;
    private int rowsPerColumn;
    private static IncrementLeadSelectionAction selectCurrentAction = new IncrementLeadSelectionAction("selectCurrent", 1, 0);
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    private static final int layoutOrientationChanged = 128;
    private static final int heightChanged = 256;
    private static final int widthChanged = 512;
    private static final int componentOrientationChanged = 1024;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;
    private static final ListDragGestureRecognizer defaultDragRecognizer = new ListDragGestureRecognizer();
    private static final TransferHandler defaultTransferHandler = new ListTransferHandler();
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthListUI;
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthListUI() {
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("selectPreviousColumn", new IncrementLeadByColumnAction("selectPreviousColumn", 1, -1));
        actionMap.put("selectPreviousColumnExtendSelection", new IncrementLeadByColumnAction("selectPreviousColumnExtendSelection", 2, -1));
        actionMap.put("selectNextColumn", new IncrementLeadByColumnAction("selectNextColumn", 1, 1));
        actionMap.put("selectNextColumnExtendSelection", new IncrementLeadByColumnAction("selectNextColumnExtendSelection", 2, 1));
        actionMap.put("selectPreviousRow", new IncrementLeadSelectionAction("selectPreviousRow", 1, -1));
        actionMap.put("selectPreviousRowExtendSelection", new IncrementLeadSelectionAction("selectPreviousRowExtendSelection", 2, -1));
        actionMap.put("selectNextRow", new IncrementLeadSelectionAction("selectNextRow", 1, 1));
        actionMap.put("selectNextRowExtendSelection", new IncrementLeadSelectionAction("selectNextRowExtendSelection", 2, 1));
        actionMap.put("selectFirstRow", new HomeAction("selectFirstRow", 1));
        actionMap.put("selectFirstRowExtendSelection", new HomeAction("selectFirstRowExtendSelection", 2));
        actionMap.put("selectLastRow", new EndAction("selctLastRow", 1));
        actionMap.put("selectLastRowExtendSelection", new EndAction("selectLastRowExtendSelection", 2));
        actionMap.put("scrollUp", new PageUpAction("scrollUp", 1));
        actionMap.put("scrollUpExtendSelection", new PageUpAction("scrollUpExtendSelection", 2));
        actionMap.put("scrollDown", new PageDownAction("scrollDown", 1));
        actionMap.put("scrollDownExtendSelection", new PageDownAction("scrollDownExtendSelection", 2));
        actionMap.put("selectAll", new SelectAllAction("selectAll"));
        actionMap.put("clearSelection", new ClearSelectionAction("clearSelection"));
        actionMap.put("selectCurrent", selectCurrentAction);
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    /*
     * Unable to fully structure code
     */
    protected void paint(SynthContext var1_1, Graphics var2_2) {
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 256;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 512;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        var3_3 = this.list.getCellRenderer();
        var4_4 = this.list.getModel();
        var5_5 = this.list.getSelectionModel();
        if (var3_3 == null || (var6_6 = var4_4.getSize()) == 0) {
            return;
        }
        var7_7 = var2_2.getClipBounds();
        if (SynthLookAndFeel.isLeftToRight(this.list)) {
            var8_8 = this.convertLocationToColumn(var7_7.x, var7_7.y);
            var9_9 = this.convertLocationToColumn(var7_7.x + var7_7.width, var7_7.y);
        } else {
            var8_8 = this.convertLocationToColumn(var7_7.x + var7_7.width, var7_7.y);
            var9_9 = this.convertLocationToColumn(var7_7.x, var7_7.y);
        }
        var10_10 = var7_7.y + var7_7.height;
        var11_11 = this.list.getLeadSelectionIndex();
        var12_12 = this.layoutOrientation == 2 ? this.columnCount : 1;
        var13_13 = var8_8;
        while (var13_13 <= var9_9) {
            var14_14 = this.convertLocationToRowInColumn(var7_7.y, var13_13);
            var15_15 = this.getRowCount(var13_13);
            var16_16 = this.getModelIndex(var13_13, var14_14);
            var17_17 = this.getCellBounds(this.list, var16_16, var16_16);
            if (var17_17 != null) ** GOTO lbl43
            return;
lbl-1000:
            // 1 sources

            {
                var17_17.height = this.getHeight(var13_13, var14_14);
                var2_2.setClip(var17_17.x, var17_17.y, var17_17.width, var17_17.height);
                var2_2.clipRect(var7_7.x, var7_7.y, var7_7.width, var7_7.height);
                this.paintCell(var2_2, var16_16, var17_17, var3_3, var4_4, var5_5, var11_11);
                var17_17.y += var17_17.height;
                var16_16 += var12_12;
                ++var14_14;
lbl43:
                // 2 sources

                ** while (var14_14 < var15_15 && var17_17.y < var10_10 && var16_16 < var6_6)
            }
lbl44:
            // 1 sources

            ++var13_13;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        int n2 = this.cellWidth * this.columnCount + insets.left + insets.right;
        int n3 = this.layoutOrientation != 0 ? this.preferredHeight : ((rectangle = this.getCellBounds(this.list, n)) != null ? rectangle.y + rectangle.height + insets.bottom : 0);
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectedIndex();
        if (n + 1 < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(++n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.list, class$com$sun$java$swing$plaf$gtk$SynthListUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthListUI = SynthListUI.class$("com.sun.java.swing.plaf.gtk.SynthListUI")) : class$com$sun$java$swing$plaf$gtk$SynthListUI, "List.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 0) {
            InputMap inputMap;
            SynthContext synthContext = this.getContext(this.list, 1);
            InputMap inputMap2 = (InputMap)synthContext.getStyle().get(synthContext, "List.focusInputMap");
            if (!SynthLookAndFeel.isLeftToRight(this.list) && (inputMap = (InputMap)synthContext.getStyle().get(synthContext, "List.focusInputMap.RightToLeft")) != null) {
                inputMap.setParent(inputMap2);
                inputMap2 = inputMap;
            }
            synthContext.dispose();
            return inputMap2;
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.list, null);
        SwingUtilities.replaceUIInputMap(this.list, 0, null);
    }

    protected void installListeners() {
        ListSelectionModel listSelectionModel;
        this.focusListener = this.createFocusListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.listSelectionListener = this.createListSelectionListener();
        this.listDataListener = this.createListDataListener();
        this.keyListener = this.createKeyListener();
        this.list.addFocusListener(this.focusListener);
        this.list.addMouseListener(defaultDragRecognizer);
        this.list.addMouseMotionListener(defaultDragRecognizer);
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.list.addKeyListener(this.keyListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionListener);
        }
    }

    protected void uninstallListeners() {
        ListSelectionModel listSelectionModel;
        this.list.removeFocusListener(this.focusListener);
        this.list.removeMouseListener(defaultDragRecognizer);
        this.list.removeMouseMotionListener(defaultDragRecognizer);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        this.list.removeKeyListener(this.keyListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.removeListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        }
        this.focusListener = null;
        this.mouseInputListener = null;
        this.listSelectionListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
    }

    protected void installDefaults() {
        block4: {
            DropTarget dropTarget;
            TransferHandler transferHandler;
            this.columnCount = 1;
            this.list.setLayout(null);
            this.fetchStyle(this.list);
            if (this.list.getCellRenderer() == null) {
                this.list.setCellRenderer(new DefaultListCellRenderer.UIResource());
            }
            if ((transferHandler = this.list.getTransferHandler()) == null || transferHandler instanceof UIResource) {
                this.list.setTransferHandler(defaultTransferHandler);
            }
            if (!((dropTarget = this.list.getDropTarget()) instanceof UIResource)) break block4;
            try {
                dropTarget.addDropTargetListener(new ListDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {}
        }
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this.list, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Color color;
            synthContext.setComponentState(512);
            Color color2 = this.list.getSelectionBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.list.setSelectionBackground(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
                this.list.setSelectionForeground(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        if (this.list.getSelectionBackground() instanceof UIResource) {
            this.list.setSelectionBackground(null);
        }
        if (this.list.getSelectionForeground() instanceof UIResource) {
            this.list.setSelectionForeground(null);
        }
        if (this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(null);
        }
        if (this.list.getTransferHandler() instanceof UIResource) {
            this.list.setTransferHandler(null);
        }
        SynthContext synthContext = this.getContext(this.list, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public void installUI(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.layoutOrientation = this.list.getLayoutOrientation();
        this.rendererPane = new CellRendererPane();
        this.list.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.cellHeight = -1;
        this.cellWidth = -1;
        this.cellHeights = null;
        this.listHeight = -1;
        this.listWidth = -1;
        this.list.remove(this.rendererPane);
        this.rendererPane = null;
        this.list = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthListUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthListUI();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertLocationToModel(point.x, point.y);
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        Rectangle rectangle = this.getCellBounds(jList, n, n);
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return null;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (n3 >= jList.getModel().getSize()) {
            return null;
        }
        Rectangle rectangle = this.getCellBounds(jList, n3);
        if (rectangle == null) {
            return null;
        }
        if (n3 == n4) {
            return rectangle;
        }
        Rectangle rectangle2 = this.getCellBounds(jList, n4);
        if (rectangle2 != null) {
            if (this.layoutOrientation == 2) {
                int n5;
                int n6 = this.convertModelToRow(n3);
                if (n6 != (n5 = this.convertModelToRow(n4))) {
                    rectangle.x = 0;
                    rectangle.width = jList.getWidth();
                }
            } else if (rectangle.x != rectangle2.x) {
                rectangle.y = 0;
                rectangle.height = jList.getHeight();
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    private Rectangle getCellBounds(JList jList, int n) {
        int n2;
        int n3;
        this.maybeUpdateLayoutState();
        int n4 = this.convertModelToRow(n);
        int n5 = this.convertModelToColumn(n);
        if (n4 == -1 || n5 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n6 = this.cellWidth;
        int n7 = insets.top;
        switch (this.layoutOrientation) {
            case 1: 
            case 2: {
                n3 = jList.getComponentOrientation().isLeftToRight() ? insets.left + n5 * this.cellWidth : jList.getWidth() - insets.right - (n5 + 1) * this.cellWidth;
                n7 += this.cellHeight * n4;
                n2 = this.cellHeight;
                break;
            }
            default: {
                n3 = insets.left;
                if (this.cellHeights == null) {
                    n7 += this.cellHeight * n4;
                } else if (n4 >= this.cellHeights.length) {
                    n7 = 0;
                } else {
                    int n8 = 0;
                    while (n8 < n4) {
                        n7 += this.cellHeights[n8];
                        ++n8;
                    }
                }
                n6 = jList.getWidth() - (insets.left + insets.right);
                n2 = this.getRowHeight(n);
            }
        }
        return new Rectangle(n3, n7, n6, n2);
    }

    protected int getRowHeight(int n) {
        return this.getHeight(0, n);
    }

    protected int convertYToRow(int n) {
        return this.convertLocationToRow(0, n, false);
    }

    protected int convertRowToY(int n) {
        if (this.getRowCount(0) >= n || n < 0) {
            return -1;
        }
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        return rectangle.y;
    }

    private int getHeight(int n, int n2) {
        if (n < 0 || n > this.columnCount || n2 < 0) {
            return -1;
        }
        if (this.layoutOrientation != 0) {
            return this.cellHeight;
        }
        if (n2 >= this.list.getModel().getSize()) {
            return -1;
        }
        return this.cellHeights == null ? this.cellHeight : (n2 < this.cellHeights.length ? this.cellHeights[n2] : -1);
    }

    private int convertLocationToRow(int n, int n2, boolean bl) {
        int n3 = this.list.getModel().getSize();
        if (n3 <= 0) {
            return -1;
        }
        Insets insets = this.list.getInsets();
        if (this.cellHeights == null) {
            int n4;
            int n5 = n4 = this.cellHeight == 0 ? 0 : (n2 - insets.top) / this.cellHeight;
            if (bl) {
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 >= n3) {
                    n4 = n3 - 1;
                }
            }
            return n4;
        }
        if (n3 > this.cellHeights.length) {
            return -1;
        }
        int n6 = insets.top;
        int n7 = 0;
        if (bl && n2 < n6) {
            return 0;
        }
        int n8 = 0;
        while (n8 < n3) {
            if (n2 >= n6 && n2 < n6 + this.cellHeights[n8]) {
                return n7;
            }
            n6 += this.cellHeights[n8];
            ++n7;
            ++n8;
        }
        return n8 - 1;
    }

    private int convertLocationToRowInColumn(int n, int n2) {
        int n3 = 0;
        if (this.layoutOrientation != 0) {
            n3 = this.list.getComponentOrientation().isLeftToRight() ? n2 * this.cellWidth : this.list.getWidth() - (n2 + 1) * this.cellWidth - this.list.getInsets().right;
        }
        return this.convertLocationToRow(n3, n, true);
    }

    private int convertLocationToModel(int n, int n2) {
        int n3 = this.convertLocationToRow(n, n2, true);
        int n4 = this.convertLocationToColumn(n, n2);
        if (n3 >= 0 && n4 >= 0) {
            return this.getModelIndex(n4, n3);
        }
        return -1;
    }

    private int getRowCount(int n) {
        if (n < 0 || n >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 0 || n == 0 && this.columnCount == 1) {
            return this.list.getModel().getSize();
        }
        if (n >= this.columnCount) {
            return -1;
        }
        if (this.layoutOrientation == 1) {
            if (n < this.columnCount - 1) {
                return this.rowsPerColumn;
            }
            return this.list.getModel().getSize() - (this.columnCount - 1) * this.rowsPerColumn;
        }
        int n2 = this.columnCount - (this.columnCount * this.rowsPerColumn - this.list.getModel().getSize());
        if (n >= n2) {
            return Math.max(0, this.rowsPerColumn - 1);
        }
        return this.rowsPerColumn;
    }

    private int getModelIndex(int n, int n2) {
        switch (this.layoutOrientation) {
            case 1: {
                return Math.min(this.list.getModel().getSize() - 1, this.rowsPerColumn * n + Math.min(n2, this.rowsPerColumn - 1));
            }
            case 2: {
                return Math.min(this.list.getModel().getSize() - 1, n2 * this.columnCount + n);
            }
        }
        return n2;
    }

    private int convertLocationToColumn(int n, int n2) {
        if (this.cellWidth > 0) {
            if (this.layoutOrientation == 0) {
                return 0;
            }
            Insets insets = this.list.getInsets();
            int n3 = this.list.getComponentOrientation().isLeftToRight() ? (n - insets.left) / this.cellWidth : (this.list.getWidth() - n - insets.right) / this.cellWidth;
            if (n3 < 0) {
                return 0;
            }
            if (n3 >= this.columnCount) {
                return this.columnCount - 1;
            }
            return n3;
        }
        return 0;
    }

    private int convertModelToRow(int n) {
        int n2 = this.list.getModel().getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation != 0 && this.columnCount > 1 && this.rowsPerColumn > 0) {
            if (this.layoutOrientation == 1) {
                return n % this.rowsPerColumn;
            }
            return n / this.columnCount;
        }
        return n;
    }

    private int convertModelToColumn(int n) {
        int n2 = this.list.getModel().getSize();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.layoutOrientation != 0 && this.rowsPerColumn > 0 && this.columnCount > 1) {
            if (this.layoutOrientation == 1) {
                return n / this.rowsPerColumn;
            }
            return n % this.columnCount;
        }
        return 0;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n4 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                int n5 = 0;
                while (n5 < n4) {
                    Object object = listModel.getElementAt(n5);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n5, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n == -1 && this.cellHeights != null) {
                        this.cellHeights[n5] = dimension.height;
                    }
                    ++n5;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeights == null) {
                    this.cellHeights = new int[n4];
                }
                int n6 = 0;
                while (n6 < n4) {
                    this.cellHeights[n6] = 0;
                    ++n6;
                }
            }
        }
        this.columnCount = 1;
        if (this.layoutOrientation != 0) {
            this.updateHorizontalLayoutState(n2, n);
        }
    }

    private void updateHorizontalLayoutState(int n, int n2) {
        int n3;
        int n4 = this.list.getVisibleRowCount();
        int n5 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        this.listHeight = this.list.getHeight();
        this.listWidth = this.list.getWidth();
        if (n5 == 0) {
            this.columnCount = 0;
            this.rowsPerColumn = 0;
            this.preferredHeight = insets.top + insets.bottom;
            return;
        }
        if (n2 != -1) {
            n3 = n2;
        } else {
            int n6 = 0;
            if (this.cellHeights != null && this.cellHeights.length > 0) {
                n6 = this.cellHeights[this.cellHeights.length - 1];
                int n7 = this.cellHeights.length - 2;
                while (n7 >= 0) {
                    n6 = Math.max(n6, this.cellHeights[n7]);
                    --n7;
                }
            }
            n3 = this.cellHeight = n6;
            this.cellHeights = null;
        }
        this.rowsPerColumn = n5;
        if (n4 > 0) {
            this.rowsPerColumn = n4;
            this.columnCount = Math.max(1, n5 / this.rowsPerColumn);
            if (n5 > 0 && n5 > this.rowsPerColumn && n5 % this.rowsPerColumn != 0) {
                ++this.columnCount;
            }
            if (this.layoutOrientation == 2) {
                this.rowsPerColumn = n5 / this.columnCount;
                if (n5 % this.columnCount > 0) {
                    ++this.rowsPerColumn;
                }
            }
        } else if (this.layoutOrientation == 1 && n3 != 0) {
            this.rowsPerColumn = Math.max(1, (this.listHeight - insets.top - insets.bottom) / n3);
            this.columnCount = Math.max(1, n5 / this.rowsPerColumn);
            if (n5 > 0 && n5 > this.rowsPerColumn && n5 % this.rowsPerColumn != 0) {
                ++this.columnCount;
            }
        } else if (this.layoutOrientation == 2 && this.cellWidth > 0 && this.listWidth > 0) {
            this.columnCount = Math.max(1, (this.listWidth - insets.left - insets.right) / this.cellWidth);
            this.rowsPerColumn = n5 / this.columnCount;
            if (n5 % this.columnCount > 0) {
                ++this.rowsPerColumn;
            }
        }
        this.preferredHeight = this.rowsPerColumn * this.cellHeight + insets.top + insets.bottom;
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private void checkSelectCurrentAction() {
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.list);
        if (this.list.isSelectionEmpty() == (actionMap.get("selectCurrent") == null)) {
            if (this.list.isSelectionEmpty()) {
                actionMap.put("selectCurrent", selectCurrentAction);
            } else {
                actionMap.remove("selectCurrent");
            }
        }
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private KeyListener createKeyListener() {
        return new KeyHandler();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ListTransferHandler
    extends TransferHandler
    implements UIResource {
        ListTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JList) {
                JList jList = (JList)jComponent;
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray == null || objectArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    String string = object == null ? "" : object.toString();
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                    ++n;
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                return new SynthTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    class ListDropTargetListener
    extends SynthDropTargetListener {
        private int[] selectedIndices;

        ListDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JList jList = (JList)jComponent;
            this.selectedIndices = jList.getSelectedIndices();
        }

        protected void restoreComponentState(JComponent jComponent) {
            JList jList = (JList)jComponent;
            jList.setSelectedIndices(this.selectedIndices);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JList jList = (JList)jComponent;
            int n = SynthListUI.this.convertLocationToModel(point.x, point.y);
            if (n != -1) {
                jList.setSelectionInterval(n, n);
            }
        }
    }

    static class ListDragGestureRecognizer
    extends SynthDragGestureRecognizer {
        ListDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            ListUI listUI;
            int n;
            JList jList;
            return super.isDragPossible(mouseEvent) && (jList = (JList)this.getComponent(mouseEvent)).getDragEnabled() && (n = (listUI = jList.getUI()).locationToIndex(jList, new Point(mouseEvent.getX(), mouseEvent.getY()))) != -1 && jList.isSelectedIndex(n);
        }
    }

    private static class ClearSelectionAction
    extends AbstractAction {
        private ClearSelectionAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            jList.clearSelection();
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        private SelectAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            int n = jList.getModel().getSize();
            if (n > 0) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (listSelectionModel.getSelectionMode() == 0) {
                    if (jList.getMinSelectionIndex() == -1) {
                        jList.setSelectionInterval(0, 0);
                    }
                } else {
                    jList.setSelectionInterval(0, n - 1);
                    jList.ensureIndexIsVisible(jList.getLeadSelectionIndex());
                }
            }
        }
    }

    private static class PageDownAction
    extends IncrementLeadSelectionAction {
        protected PageDownAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            if (n == -1) {
                n = jList.getModel().getSize() - 1;
            }
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = jList.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                n = jList.locationToIndex(rectangle.getLocation());
                if (n == -1) {
                    n = jList.getModel().getSize() - 1;
                }
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            Rectangle rectangle = jList.getVisibleRect();
            Rectangle rectangle2 = jList.getCellBounds(n, n);
            rectangle2.y = Math.max(0, rectangle2.y + rectangle2.height - rectangle.height);
            rectangle2.height = rectangle.height;
            jList.scrollRectToVisible(rectangle2);
        }
    }

    private static class PageUpAction
    extends IncrementLeadSelectionAction {
        protected PageUpAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getFirstVisibleIndex();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = jList.getVisibleRect();
                rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                n = jList.locationToIndex(rectangle.getLocation());
            }
            return n;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            Rectangle rectangle = jList.getVisibleRect();
            Rectangle rectangle2 = jList.getCellBounds(n, n);
            rectangle2.height = rectangle.height;
            jList.scrollRectToVisible(rectangle2);
        }
    }

    private static class EndAction
    extends IncrementLeadSelectionAction {
        protected EndAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            return jList.getModel().getSize() - 1;
        }
    }

    private static class HomeAction
    extends IncrementLeadSelectionAction {
        protected HomeAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex(JList jList) {
            return 0;
        }
    }

    private static class IncrementLeadByColumnAction
    extends IncrementLeadSelectionAction {
        IncrementLeadByColumnAction(String string, int n, int n2) {
            super(string, n, n2);
        }

        protected int getNextIndex(JList jList) {
            SynthListUI synthListUI;
            ListUI listUI;
            if (jList.getLayoutOrientation() != 0 && (listUI = jList.getUI()) instanceof SynthListUI && (synthListUI = (SynthListUI)listUI).columnCount > 1) {
                int n = jList.getLeadSelectionIndex();
                if (n == -1) {
                    return 0;
                }
                int n2 = jList.getModel().getSize();
                int n3 = synthListUI.convertModelToColumn(n);
                int n4 = synthListUI.convertModelToRow(n);
                if ((n3 += this.amount) >= synthListUI.columnCount || n3 < 0) {
                    return -1;
                }
                int n5 = synthListUI.getRowCount(n3);
                if (n4 >= n5) {
                    n4 = n5 - 1;
                }
                return synthListUI.getModelIndex(n3, n4);
            }
            return -1;
        }
    }

    private static class IncrementLeadSelectionAction
    extends AbstractAction {
        protected int amount;
        protected int selectionType;

        protected IncrementLeadSelectionAction(String string, int n) {
            this(string, n, -1);
        }

        protected IncrementLeadSelectionAction(String string, int n, int n2) {
            super(string);
            this.amount = n2;
            this.selectionType = n;
        }

        protected int getNextIndex(JList jList) {
            int n = jList.getLeadSelectionIndex();
            int n2 = jList.getModel().getSize();
            if (n == -1 || n >= n2) {
                if (n2 > 0) {
                    n = this.amount >= 0 ? 0 : n2 - 1;
                }
            } else {
                n += this.getAmount(jList);
            }
            return n;
        }

        protected int getAmount(JList jList) {
            ListUI listUI;
            if (jList.getLayoutOrientation() == 2 && (listUI = jList.getUI()) instanceof SynthListUI) {
                return ((SynthListUI)listUI).columnCount * this.amount;
            }
            return this.amount;
        }

        protected void ensureIndexIsVisible(JList jList, int n) {
            jList.ensureIndexIsVisible(n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            int n = this.getNextIndex(jList);
            if (jList.getModel().getSize() == 1) {
                n = 0;
            }
            if (n >= 0 && n < jList.getModel().getSize()) {
                ListSelectionModel listSelectionModel = jList.getSelectionModel();
                if (this.selectionType == 2) {
                    listSelectionModel.setLeadSelectionIndex(n);
                } else if (this.selectionType == 1) {
                    jList.setSelectedIndex(n);
                } else {
                    listSelectionModel.setLeadSelectionIndex(n);
                }
                this.ensureIndexIsVisible(jList, n);
            }
        }
    }

    private static class KeyHandler
    implements KeyListener {
        private String prefix = "";
        private transient String typedString = "";
        private long lastTime = 0L;

        private KeyHandler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            int n;
            JList jList = (JList)keyEvent.getSource();
            ListModel listModel = jList.getModel();
            if (listModel.getSize() == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                return;
            }
            boolean bl = true;
            char c = keyEvent.getKeyChar();
            long l = keyEvent.getWhen();
            int n2 = jList.getSelectedIndex();
            if (l - this.lastTime < 1000L) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++n2;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++n2;
                this.prefix = this.typedString = "" + c;
            }
            this.lastTime = l;
            if (n2 < 0 || n2 >= listModel.getSize()) {
                bl = false;
                n2 = 0;
            }
            if ((n = jList.getNextMatch(this.prefix, n2, Position.Bias.Forward)) >= 0) {
                jList.setSelectedIndex(n);
                jList.ensureIndexIsVisible(n);
            } else if (bl && (n = jList.getNextMatch(this.prefix, 0, Position.Bias.Forward)) >= 0) {
                jList.setSelectedIndex(n);
                jList.ensureIndexIsVisible(n);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block8: {
                DropTarget dropTarget;
                String string;
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block12: {
                                                    block11: {
                                                        block10: {
                                                            block9: {
                                                                block7: {
                                                                    string = propertyChangeEvent.getPropertyName();
                                                                    if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                                                                        SynthListUI.this.fetchStyle((JList)propertyChangeEvent.getSource());
                                                                    }
                                                                    if (!string.equals("model")) break block7;
                                                                    ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                                                                    ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                                                                    if (listModel != null) {
                                                                        listModel.removeListDataListener(SynthListUI.this.listDataListener);
                                                                    }
                                                                    if (listModel2 != null) {
                                                                        listModel2.addListDataListener(SynthListUI.this.listDataListener);
                                                                    }
                                                                    SynthListUI.this.updateLayoutStateNeeded |= 1;
                                                                    SynthListUI.this.redrawList();
                                                                    break block8;
                                                                }
                                                                if (!string.equals("selectionModel")) break block9;
                                                                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                                                                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                                                                if (listSelectionModel != null) {
                                                                    listSelectionModel.removeListSelectionListener(SynthListUI.this.listSelectionListener);
                                                                }
                                                                if (listSelectionModel2 != null) {
                                                                    listSelectionModel2.addListSelectionListener(SynthListUI.this.listSelectionListener);
                                                                }
                                                                SynthListUI.this.updateLayoutStateNeeded |= 1;
                                                                SynthListUI.this.redrawList();
                                                                break block8;
                                                            }
                                                            if (!string.equals("cellRenderer")) break block10;
                                                            SynthListUI.this.updateLayoutStateNeeded |= 0x40;
                                                            SynthListUI.this.redrawList();
                                                            break block8;
                                                        }
                                                        if (!string.equals("font")) break block11;
                                                        SynthListUI.this.updateLayoutStateNeeded |= 4;
                                                        SynthListUI.this.redrawList();
                                                        break block8;
                                                    }
                                                    if (!string.equals("prototypeCellValue")) break block12;
                                                    SynthListUI.this.updateLayoutStateNeeded |= 0x20;
                                                    SynthListUI.this.redrawList();
                                                    break block8;
                                                }
                                                if (!string.equals("fixedCellHeight")) break block13;
                                                SynthListUI.this.updateLayoutStateNeeded |= 0x10;
                                                SynthListUI.this.redrawList();
                                                break block8;
                                            }
                                            if (!string.equals("fixedCellWidth")) break block14;
                                            SynthListUI.this.updateLayoutStateNeeded |= 8;
                                            SynthListUI.this.redrawList();
                                            break block8;
                                        }
                                        if (!string.equals("cellRenderer")) break block15;
                                        SynthListUI.this.updateLayoutStateNeeded |= 0x40;
                                        SynthListUI.this.redrawList();
                                        break block8;
                                    }
                                    if (!string.equals("selectionForeground")) break block16;
                                    SynthListUI.this.list.repaint();
                                    break block8;
                                }
                                if (!string.equals("selectionBackground")) break block17;
                                SynthListUI.this.list.repaint();
                                break block8;
                            }
                            if (!"layoutOrientation".equals(string)) break block18;
                            SynthListUI.this.updateLayoutStateNeeded |= 0x80;
                            SynthListUI.this.layoutOrientation = SynthListUI.this.list.getLayoutOrientation();
                            SynthListUI.this.redrawList();
                            break block8;
                        }
                        if (!"visibleRowCount".equals(string)) break block19;
                        if (SynthListUI.this.layoutOrientation == 0) break block8;
                        SynthListUI.this.updateLayoutStateNeeded |= 0x80;
                        SynthListUI.this.redrawList();
                        break block8;
                    }
                    if (!"componentOrientation".equals(string)) break block20;
                    SynthListUI.this.updateLayoutStateNeeded |= 0x400;
                    SynthListUI.this.redrawList();
                    InputMap inputMap = SynthListUI.this.getInputMap(0);
                    SwingUtilities.replaceUIInputMap(SynthListUI.this.list, 0, inputMap);
                    break block8;
                }
                if (!"transferHandler".equals(string) || !((dropTarget = SynthListUI.this.list.getDropTarget()) instanceof UIResource)) break block8;
                try {
                    dropTarget.addDropTargetListener(new ListDropTargetListener());
                }
                catch (TooManyListenersException tooManyListenersException) {}
            }
        }
    }

    class ListDataHandler
    implements ListDataListener {
        ListDataHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            SynthListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = SynthListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n + 1, true);
            }
            SynthListUI.this.redrawList();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            SynthListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = SynthListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
                listSelectionModel.setAnchorSelectionIndex(-1);
            }
            SynthListUI.this.redrawList();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            SynthListUI.this.updateLayoutStateNeeded = 1;
            SynthListUI.this.redrawList();
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SynthListUI.this.maybeUpdateLayoutState();
            Rectangle rectangle = SynthListUI.this.getCellBounds(SynthListUI.this.list, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
            if (rectangle != null) {
                SynthListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (SynthListUI.this.list.isFocusOwner()) {
                SynthListUI.this.checkSelectCurrentAction();
            }
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = SynthListUI.this.list.getLeadSelectionIndex();
            if (n != -1 && (rectangle = SynthListUI.this.getCellBounds(SynthListUI.this.list, n, n)) != null) {
                SynthListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            ListSelectionModel listSelectionModel = SynthListUI.this.list.getSelectionModel();
            if (SynthListUI.this.list.getModel().getSize() > 0 && (listSelectionModel.getLeadSelectionIndex() < 0 || listSelectionModel.getLeadSelectionIndex() >= SynthListUI.this.list.getModel().getSize())) {
                listSelectionModel.setAnchorSelectionIndex(0);
                listSelectionModel.setLeadSelectionIndex(0);
                listSelectionModel.clearSelection();
            }
            this.repaintCellFocus();
            SynthListUI.this.checkSelectCurrentAction();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }
    }

    class MouseInputHandler
    implements MouseInputListener {
        private boolean selectedOnPress;

        MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!SynthListUI.this.list.isEnabled()) {
                return;
            }
            if (!SynthListUI.this.list.hasFocus() && SynthListUI.this.list.isRequestFocusEnabled()) {
                SynthListUI.this.list.requestFocus();
            }
            if ((n = SynthListUI.this.convertLocationToModel(mouseEvent.getX(), mouseEvent.getY())) != -1) {
                boolean bl = mouseEvent.getID() == 501;
                SynthListUI.this.list.setValueIsAdjusting(bl);
                int n2 = SynthListUI.this.list.getAnchorSelectionIndex();
                if (mouseEvent.isControlDown()) {
                    if (SynthListUI.this.list.isSelectedIndex(n)) {
                        SynthListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        SynthListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown() && n2 != -1) {
                    SynthListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    SynthListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!SynthListUI.this.list.isEnabled()) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = SynthListUI.this.convertLocationToModel(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && (rectangle = SynthListUI.this.getCellBounds(SynthListUI.this.list, n, n)) != null) {
                SynthListUI.this.list.scrollRectToVisible(rectangle);
                SynthListUI.this.list.setSelectionInterval(n, n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                SynthListUI.this.list.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }
    }
}

