/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthDragGestureRecognizer;
import com.sun.java.swing.plaf.gtk.SynthDropTargetListener;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthTransferable;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

abstract class SynthTextUI
extends TextUI
implements SynthUI,
ViewFactory {
    private SynthStyle style;
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();
    private static final TransferHandler defaultTransferHandler = new TextTransferHandler();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TextDragGestureRecognizer defaultDragRecognizer = new TextDragGestureRecognizer();
    private static final Position.Bias[] discardBias = new Position.Bias[1];
    static /* synthetic */ Class class$com$sun$java$swing$plaf$gtk$SynthContext;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;

    void forceFetchStyle(JTextComponent jTextComponent) {
        this.style = null;
        this.fetchStyle(jTextComponent);
    }

    private void fetchStyle(JTextComponent jTextComponent) {
        SynthContext synthContext = this.getContext(jTextComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Object object;
            Caret caret;
            Insets insets;
            Color color;
            Color color2;
            String string = this.getPropertyPrefix();
            Color color3 = this.editor.getCaretColor();
            if (color3 == null || color3 instanceof UIResource) {
                this.editor.setCaretColor((Color)this.style.get(synthContext, string + ".caretForeground"));
            }
            if ((color2 = this.editor.getForeground()) == null || color2 instanceof UIResource) {
                this.editor.setSelectionColor(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(768);
            Color color4 = this.editor.getSelectionColor();
            if (color4 == null || color4 instanceof UIResource) {
                this.editor.setSelectionColor(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.editor.getSelectedTextColor()) == null || color instanceof UIResource) {
                this.editor.setSelectedTextColor(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(8);
            Color color5 = this.editor.getDisabledTextColor();
            if (color5 == null || color5 instanceof UIResource) {
                this.editor.setDisabledTextColor((Color)this.style.get(synthContext, ColorType.FOREGROUND));
            }
            if ((insets = this.editor.getMargin()) == null || insets instanceof UIResource) {
                insets = (Insets)this.style.get(synthContext, string + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.editor.setMargin(insets);
            }
            if ((caret = this.editor.getCaret()) instanceof UIResource && (object = this.style.get(synthContext, string + ".caretBlinkRate")) != null && object instanceof Integer) {
                Integer n = (Integer)object;
                caret.setBlinkRate(n);
            }
        }
        synthContext.dispose();
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthTextUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.paintSafely(graphics);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    protected Caret createCaret() {
        return new SynthCaret();
    }

    protected Highlighter createHighlighter() {
        return new SynthHighlighter();
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
        block6: {
            DropTarget dropTarget;
            Highlighter highlighter;
            this.editor.addMouseListener(defaultDragRecognizer);
            this.editor.addMouseMotionListener(defaultDragRecognizer);
            String string = this.getPropertyPrefix();
            Caret caret = this.editor.getCaret();
            if (caret == null || caret instanceof UIResource) {
                this.editor.setCaret(this.createCaret());
            }
            if ((highlighter = this.editor.getHighlighter()) == null || highlighter instanceof UIResource) {
                this.editor.setHighlighter(this.createHighlighter());
            }
            this.fetchStyle(this.editor);
            TransferHandler transferHandler = this.editor.getTransferHandler();
            if (transferHandler == null || transferHandler instanceof UIResource) {
                this.editor.setTransferHandler(this.getTransferHandler());
            }
            if (!((dropTarget = this.editor.getDropTarget()) instanceof UIResource)) break block6;
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TextDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {}
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.editor, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.editor.removeMouseListener(defaultDragRecognizer);
        this.editor.removeMouseMotionListener(defaultDragRecognizer);
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
        if (this.editor.getTransferHandler() instanceof UIResource) {
            this.editor.setTransferHandler(null);
        }
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        this.editor.setKeymap(JTextComponent.getKeymap("default"));
        InputMap inputMap = this.getInputMap();
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    InputMap getInputMap() {
        SynthContext synthContext = this.getContext(this.editor, 1);
        SynthStyle synthStyle = synthContext.getStyle();
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)synthStyle.get(synthContext, this.getPropertyPrefix() + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        synthContext.dispose();
        return inputMapUIResource;
    }

    void updateFocusAcceleratorBinding(boolean bl) {
        char c = this.editor.getFocusAccelerator();
        if (bl || c != '\u0000') {
            InputMap inputMap = SwingUtilities.getUIInputMap(this.editor, 2);
            if (inputMap == null && c != '\u0000') {
                inputMap = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, inputMap);
                ActionMap actionMap = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, actionMap);
            }
            if (inputMap != null) {
                inputMap.clear();
                if (c != '\u0000') {
                    inputMap.put(KeyStroke.getKeyStroke((int)c, 8), "requestFocus");
                }
            }
        }
    }

    void updateFocusTraversalKeys() {
        EditorKit editorKit = this.getEditorKit(this.editor);
        if (editorKit != null && editorKit instanceof DefaultEditorKit) {
            Set set = this.editor.getFocusTraversalKeys(0);
            Set set2 = this.editor.getFocusTraversalKeys(1);
            HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>(set);
            HashSet<KeyStroke> hashSet2 = new HashSet<KeyStroke>(set2);
            if (this.editor.isEditable()) {
                hashSet.remove(KeyStroke.getKeyStroke(9, 0));
                hashSet2.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                hashSet.add(KeyStroke.getKeyStroke(9, 0));
                hashSet2.add(KeyStroke.getKeyStroke(9, 1));
            }
            this.editor.setFocusTraversalKeys(0, hashSet);
            this.editor.setFocusTraversalKeys(1, hashSet2);
        }
    }

    TransferHandler getTransferHandler() {
        return defaultTransferHandler;
    }

    ActionMap getActionMap() {
        Action action;
        String string = this.getPropertyPrefix() + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        if (this.getEditorKit(this.editor) instanceof DefaultEditorKit && actionMap != null && (action = actionMap.get("insert-break")) != null && action instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper textActionWrapper = new TextActionWrapper((TextAction)action);
            actionMapUIResource.put(textActionWrapper.getValue("Name"), textActionWrapper);
        }
        if (actionMap != null) {
            actionMapUIResource.setParent(actionMap);
        }
        return actionMapUIResource;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        Action[] actionArray = this.editor.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            actionMapUIResource.put(action.getValue("Name"), action);
            ++n2;
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    protected final void setView(View view) {
        this.editor.removeAll();
        this.rootView.setView(view);
        this.painted = false;
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected void paintSafely(Graphics graphics) {
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        this.rootView.paint(graphics, rectangle);
        if (caret != null) {
            caret.paint(graphics);
        }
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            this.installDefaults();
            this.editor.setAutoscrolls(true);
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners();
            this.installKeyboardActions();
            LayoutManager layoutManager = this.editor.getLayout();
            if (layoutManager == null || layoutManager instanceof UIResource) {
                this.editor.setLayout(this.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        jComponent.removeAll();
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager instanceof UIResource) {
            jComponent.setLayout(null);
        }
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.editor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            } else if (dimension.width == 0 && dimension.height == 0) {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            dimension.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return dimension;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = this.editor.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n) throws BadLocationException {
        return this.modelToView(jTextComponent, n, Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle modelToView(JTextComponent jTextComponent, int n, Position.Bias bias) throws BadLocationException {
        Document document;
        block7: {
            Rectangle rectangle;
            document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                Rectangle rectangle2 = this.getVisibleEditorRect();
                if (rectangle2 == null) break block7;
                this.rootView.setSize(rectangle2.width, rectangle2.height);
                Shape shape = this.rootView.modelToView(n, rectangle2, bias);
                if (shape == null) break block7;
                rectangle = shape.getBounds();
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            return rectangle;
        }
        Object var9_9 = null;
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return null;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, discardBias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        int n = -1;
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n = this.rootView.viewToModel(point.x, point.y, rectangle, biasArray);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Document document;
        block7: {
            int n3;
            document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                if (!this.painted) break block7;
                Rectangle rectangle = this.getVisibleEditorRect();
                this.rootView.setSize(rectangle.width, rectangle.height);
                n3 = this.rootView.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
                throw throwable;
            }
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            return n3;
        }
        Object var10_10 = null;
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return -1;
    }

    public void damageRange(JTextComponent jTextComponent, int n, int n2) {
        this.damageRange(jTextComponent, n, n2, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        if (!this.painted) return;
        Rectangle rectangle = this.getVisibleEditorRect();
        Document document = jTextComponent.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            try {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n, bias, n2, bias2, rectangle);
                Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.editor.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
                Object var11_12 = null;
                if (!(document instanceof AbstractDocument)) return;
                ((AbstractDocument)document).readUnlock();
                return;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!(document instanceof AbstractDocument)) throw throwable;
            ((AbstractDocument)document).readUnlock();
            throw throwable;
        }
        if (!(document instanceof AbstractDocument)) return;
        ((AbstractDocument)document).readUnlock();
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(JTextComponent jTextComponent, Point point) {
        if (!this.painted) {
            return null;
        }
        Document document = this.editor.getDocument();
        String string = null;
        Rectangle rectangle = this.getVisibleEditorRect();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            string = this.rootView.getToolTipText(point.x, point.y, rectangle);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
            throw throwable;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readUnlock();
        }
        return string;
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TextTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        TextTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                int n = 0;
                while (n < dataFlavorArray.length) {
                    String string = dataFlavorArray[n].getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                        return dataFlavorArray[n];
                    }
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavorArray[n];
                    } else if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[n].getRepresentationClass() == (class$java$lang$String == null ? SynthTextUI.class$("java.lang.String") : class$java$lang$String)) {
                        dataFlavor2 = dataFlavorArray[n];
                    } else if (dataFlavor3 == null && dataFlavorArray[n].equals(DataFlavor.stringFlavor)) {
                        dataFlavor3 = dataFlavorArray[n];
                    }
                    ++n;
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            int n = 0;
            while (n < dataFlavorArray.length) {
                String string = dataFlavorArray[n].getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavorArray[n];
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[n].getRepresentationClass() == (class$java$lang$String == null ? SynthTextUI.class$("java.lang.String") : class$java$lang$String)) {
                    dataFlavor2 = dataFlavorArray[n];
                } else if (dataFlavor3 == null && dataFlavorArray[n].equals(DataFlavor.stringFlavor)) {
                    dataFlavor3 = dataFlavorArray[n];
                }
                ++n;
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
            if (bl) {
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                int n3 = n2 - n;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n3 > 0) {
                    document.remove(n, n3);
                }
                editorKit.read(reader, document, n);
            } else {
                int n;
                char[] cArray = new char[1024];
                boolean bl2 = false;
                StringBuffer stringBuffer = null;
                while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n);
                    }
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n) {
                        switch (cArray[n5]) {
                            case '\r': {
                                if (bl2) {
                                    if (n5 == 0) {
                                        stringBuffer.append('\n');
                                        break;
                                    }
                                    cArray[n5 - 1] = 10;
                                    break;
                                }
                                bl2 = true;
                                break;
                            }
                            case '\n': {
                                if (!bl2) break;
                                if (n5 > n4 + 1) {
                                    stringBuffer.append(cArray, n4, n5 - n4 - 1);
                                }
                                bl2 = false;
                                n4 = n5;
                                break;
                            }
                            default: {
                                if (!bl2) break;
                                if (n5 == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[n5 - 1] = 10;
                                }
                                bl2 = false;
                            }
                        }
                        ++n5;
                    }
                    if (n4 >= n) continue;
                    if (bl2) {
                        if (n4 >= n - 1) continue;
                        stringBuffer.append(cArray, n4, n - n4 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n4, n - n4);
                }
                if (bl2) {
                    stringBuffer.append('\n');
                }
                jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
            }
        }

        public int getSourceActions(JComponent jComponent) {
            int n = 0;
            if (!(jComponent instanceof JPasswordField)) {
                n = ((JTextComponent)jComponent).isEditable() ? 3 : 1;
            }
            return n;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.exportComp = (JTextComponent)jComponent;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (this.shouldRemove && n == 2) {
                TextTransferable textTransferable = (TextTransferable)transferable;
                textTransferable.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            boolean bl;
            block6: {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
                    this.shouldRemove = false;
                    return true;
                }
                bl = false;
                DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
                if (dataFlavor == null) break block6;
                try {
                    Object object;
                    boolean bl2 = false;
                    if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl2 = true;
                    }
                    object = dataFlavor.getReaderForText(transferable);
                    this.handleReaderImport((Reader)object, jTextComponent, bl2);
                    bl = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {}
            }
            return bl;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
        }

        static class TextTransferable
        extends SynthTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            TextTransferable(JTextComponent jTextComponent, int n, int n2) {
                block5: {
                    super(null, null);
                    this.c = jTextComponent;
                    Document document = jTextComponent.getDocument();
                    try {
                        this.p0 = document.createPosition(n);
                        this.p1 = document.createPosition(n2);
                        this.plainData = jTextComponent.getSelectedText();
                        if (!(jTextComponent instanceof JEditorPane)) break block5;
                        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                        this.mimeType = jEditorPane.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith("text/html")) {
                            this.htmlData = stringWriter.toString();
                            break block5;
                        }
                        this.richText = stringWriter.toString();
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    catch (IOException iOException) {}
                }
            }

            void removeText() {
                block2: {
                    if (this.p0 == null || this.p1 == null || this.p0.getOffset() == this.p1.getOffset()) break block2;
                    try {
                        Document document = this.c.getDocument();
                        document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return dataFlavorArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if ((class$java$lang$String == null ? (class$java$lang$String = SynthTextUI.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return this.richText;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = SynthTextUI.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = SynthTextUI.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
    }

    static class TextDropTargetListener
    extends SynthDropTargetListener {
        int dot;
        int mark;
        boolean visible;

        TextDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            this.dot = caret.getDot();
            this.mark = caret.getMark();
            this.visible = caret.isVisible();
            caret.setVisible(true);
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            caret.setDot(this.mark);
            caret.moveDot(this.dot);
            caret.setVisible(this.visible);
        }

        protected void restoreComponentStateForDrop(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            caret.setVisible(this.visible);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
        }
    }

    static class TextDragGestureRecognizer
    extends SynthDragGestureRecognizer {
        TextDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            int n;
            Caret caret;
            int n2;
            JTextComponent jTextComponent;
            if (super.isDragPossible(mouseEvent) && (jTextComponent = (JTextComponent)this.getComponent(mouseEvent)).getDragEnabled() && (n2 = (caret = jTextComponent.getCaret()).getDot()) != (n = caret.getMark())) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n3 = jTextComponent.viewToModel(point);
                int n4 = Math.min(n2, n);
                int n5 = Math.max(n2, n);
                if (n3 >= n4 && n3 < n5) {
                    return true;
                }
            }
            return false;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SynthTextUI.this.editor.requestFocus();
        }

        public boolean isEnabled() {
            return SynthTextUI.this.editor.isEditable();
        }
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public TextActionWrapper(TextAction textAction) {
            super((String)textAction.getValue("Name"));
            this.action = null;
            this.action = textAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }

        public boolean isEnabled() {
            return SynthTextUI.this.editor == null || SynthTextUI.this.editor.isEditable() ? this.action.isEnabled() : false;
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DropTarget dropTarget;
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthTextUI.this.fetchStyle((JTextComponent)propertyChangeEvent.getSource());
            }
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                    if ("document".equals(string)) {
                        SynthTextUI.this.propertyChange(propertyChangeEvent);
                        SynthTextUI.this.modelChanged();
                        return;
                    }
                }
                SynthTextUI.this.modelChanged();
            }
            if ("focusAcceleratorKey".equals(string)) {
                SynthTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation".equals(string)) {
                SynthTextUI.this.modelChanged();
            } else if ("font".equals(string)) {
                SynthTextUI.this.modelChanged();
            } else if ("transferHandler".equals(string) && (dropTarget = SynthTextUI.this.editor.getDropTarget()) instanceof UIResource) {
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TextDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
            SynthTextUI.this.propertyChange(propertyChangeEvent);
        }

        public final void insertUpdate(DocumentEvent documentEvent) {
            Boolean bl;
            Document document = documentEvent.getDocument();
            Object object = document.getProperty("i18n");
            if (object instanceof Boolean && (bl = (Boolean)object) != this.i18nView) {
                this.i18nView = bl;
                SynthTextUI.this.modelChanged();
                return;
            }
            bl = SynthTextUI.this.painted ? SynthTextUI.this.getVisibleEditorRect() : null;
            SynthTextUI.this.rootView.insertUpdate(documentEvent, (Shape)((Object)bl), SynthTextUI.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = SynthTextUI.this.painted ? SynthTextUI.this.getVisibleEditorRect() : null;
            SynthTextUI.this.rootView.removeUpdate(documentEvent, rectangle, SynthTextUI.this.rootView.getViewFactory());
        }

        public final void changedUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = SynthTextUI.this.painted ? SynthTextUI.this.getVisibleEditorRect() : null;
            SynthTextUI.this.rootView.changedUpdate(documentEvent, rectangle, SynthTextUI.this.rootView.getViewFactory());
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
            if (this.constraints != null) {
                this.constraints.remove(component);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Rectangle rectangle;
            if (this.constraints != null && !this.constraints.isEmpty() && (rectangle = SynthTextUI.this.getVisibleEditorRect()) != null) {
                Document document = SynthTextUI.this.editor.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                try {
                    SynthTextUI.this.rootView.setSize(rectangle.width, rectangle.height);
                    Enumeration enumeration = this.constraints.keys();
                    while (enumeration.hasMoreElements()) {
                        Component component = (Component)enumeration.nextElement();
                        View view = (View)this.constraints.get(component);
                        Shape shape = this.calculateViewPosition(rectangle, view);
                        if (shape == null) continue;
                        Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                        component.setBounds(rectangle2);
                    }
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                    throw throwable;
                }
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }

        Shape calculateViewPosition(Shape shape, View view) {
            int n = view.getStartOffset();
            View view2 = null;
            View view3 = SynthTextUI.this.rootView;
            while (view3 != null && view3 != view) {
                int n2 = ((View)view3).getViewIndex(n, Position.Bias.Forward);
                shape = ((View)view3).getChildAllocation(n2, shape);
                view2 = ((View)view3).getView(n2);
                view3 = view2;
            }
            return view2 != null ? shape : null;
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(component, object);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int n) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            SynthTextUI.this.editor.revalidate();
        }

        public float getAlignment(int n) {
            if (this.view != null) {
                return this.view.getAlignment(n);
            }
            return 0.0f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewIndex(int n, Position.Bias bias) {
            return 0;
        }

        public Shape getChildAllocation(int n, Shape shape) {
            return shape;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n, bias, n2, bias2, shape);
            }
            return null;
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n = this.view.viewToModel(f, f2, shape, biasArray);
                return n;
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n3 = this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
                if (n3 != -1) {
                    n = n3;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Document getDocument() {
            return SynthTextUI.this.editor.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return SynthTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int n, float f, Shape shape) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int n) {
            if (this.view != null) {
                return this.view.getResizeWeight(n);
            }
            return 0;
        }

        public void setSize(float f, float f2) {
            if (this.view != null) {
                this.view.setSize(f, f2);
            }
        }

        public Container getContainer() {
            return SynthTextUI.this.editor;
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = SynthTextUI.this.getEditorKit(SynthTextUI.this.editor);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return SynthTextUI.this;
        }
    }

    public static class SynthHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class SynthCaret
    extends DefaultCaret
    implements UIResource {
    }
}

