/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class WindowsInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Color selectedTitleGradientColor;
    private Color notSelectedTitleGradientColor;
    private JPopupMenu systemPopupMenu;
    private JLabel systemLabel;
    private Font titleFont;
    private int shadowOffset;
    private Color shadowColor;

    public WindowsInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void addSubComponents() {
        this.add(this.systemLabel);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() == null) {
            this.selectedTitleGradientColor = UIManager.getColor("InternalFrame.activeTitleGradient");
            this.notSelectedTitleGradientColor = UIManager.getColor("InternalFrame.inactiveTitleGradient");
            Color color = UIManager.getColor("InternalFrame.activeBorderColor");
            this.setBorder(BorderFactory.createLineBorder(color, 1));
        }
    }

    protected void createButtons() {
        super.createButtons();
        if (XPStyle.getXP() != null) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
        String string = this.frame.getTitle();
        if (string != null) {
            int n;
            boolean bl = this.frame.isSelected();
            Font font = graphics.getFont();
            Font font2 = this.titleFont != null ? this.titleFont : this.getFont();
            graphics.setFont(font2);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (WindowsGraphicsUtils.isLeftToRight(this.frame)) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                n = this.systemLabel.getX() + this.systemLabel.getWidth() + 2;
                int n3 = rectangle.x - n - 3;
                string = this.getTitle(this.frame.getTitle(), fontMetrics, n3);
            } else {
                n = this.systemLabel.getX() - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            if (this.shadowOffset != 0 && this.shadowColor != null) {
                graphics.setColor(this.shadowColor);
                graphics.drawString(string, n + this.shadowOffset, n2 + this.shadowOffset);
            }
            graphics.setColor(bl ? this.selectedTextColor : this.notSelectedTextColor);
            graphics.drawString(string, n, n2);
            graphics.setFont(font);
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            dimension.height = xPStyle.getInt("sysmetrics.captionbarheight", dimension.height);
            dimension.height = this.frame.isMaximum() ? ++dimension.height : (dimension.height += 5);
        }
        return dimension;
    }

    protected void paintTitleBackground(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(this.frame.isIcon() ? "window.mincaption" : (this.frame.isMaximum() ? "window.maxcaption" : "window.caption"));
            skin.paintSkin(graphics, 0, 0, this.getSize().width, this.getSize().height, this.frame.isSelected() ? 0 : 1);
        } else {
            Boolean bl = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", false);
            if (bl.booleanValue() && graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                boolean bl2 = this.frame.isSelected();
                int n = this.getWidth();
                if (bl2) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.selectedTitleColor, (int)((double)n * 0.75), 0.0f, this.selectedTitleGradientColor);
                    graphics2D.setPaint(gradientPaint);
                } else {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.notSelectedTitleColor, (int)((double)n * 0.75), 0.0f, this.notSelectedTitleGradientColor);
                    graphics2D.setPaint(gradientPaint);
                }
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setPaint(paint);
            } else {
                super.paintTitleBackground(graphics);
            }
        }
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.systemLabel = new JLabel(this.frame.getFrameIcon());
        this.systemLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                WindowsInternalFrameTitlePane.this.showSystemPopupMenu(mouseEvent.getComponent());
            }
        });
    }

    protected void showSystemMenu() {
        Dimension dimension = new Dimension();
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.width += border.getBorderInsets((Component)this.frame).left + border.getBorderInsets((Component)this.frame).right;
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(this.systemLabel, this.getX() - dimension.width, this.getY() + this.getHeight() - dimension.height);
        } else {
            this.systemPopupMenu.show(this.frame.getDesktopIcon(), this.getX(), this.getY() - this.systemPopupMenu.getPreferredSize().height);
        }
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        this.systemPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    private void showSystemPopupMenu(Component component) {
        Dimension dimension = new Dimension();
        Border border = this.frame.getBorder();
        if (border != null) {
            dimension.width += border.getBorderInsets((Component)this.frame).left + border.getBorderInsets((Component)this.frame).right;
            dimension.height += border.getBorderInsets((Component)this.frame).bottom + border.getBorderInsets((Component)this.frame).top;
        }
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(component, this.getX() - dimension.width, this.getY() + this.getHeight() - dimension.height);
        } else {
            this.systemPopupMenu.show(component, this.getX() - dimension.width, this.getY() - this.systemPopupMenu.getPreferredSize().height - dimension.height);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new WindowsPropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new WindowsTitlePaneLayout();
    }

    public class WindowsPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        public WindowsPropertyChangeHandler() {
            super(WindowsInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("frameIcon".equals(string) && WindowsInternalFrameTitlePane.this.systemLabel != null) {
                WindowsInternalFrameTitlePane.this.systemLabel.setIcon(WindowsInternalFrameTitlePane.this.frame.getFrameIcon());
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public class WindowsTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        private Insets captionMargin;
        private Insets contentMargin;
        private XPStyle xp;

        WindowsTitlePaneLayout() {
            super(WindowsInternalFrameTitlePane.this);
            this.captionMargin = null;
            this.contentMargin = null;
            this.xp = XPStyle.getXP();
            if (this.xp != null) {
                this.captionMargin = this.xp.getMargin("window.caption.captionmargins");
                this.contentMargin = this.xp.getMargin("window.caption.contentmargins");
            }
            if (this.captionMargin == null) {
                this.captionMargin = new Insets(0, 2, 0, 2);
            }
            if (this.contentMargin == null) {
                this.contentMargin = new Insets(0, 0, 0, 0);
            }
        }

        private int layoutButton(JComponent jComponent, String string, int n, int n2, int n3, int n4, boolean bl) {
            XPStyle.Skin skin;
            if (this.xp != null && (skin = this.xp.getSkin(string)).getImage() != null) {
                n3 = skin.getWidth();
                n4 = skin.getHeight();
            }
            if (!bl) {
                n -= n3;
            }
            jComponent.setBounds(n, n2, n3, n4);
            n = bl ? (n += n3 + 2) : (n -= 2);
            return n;
        }

        public void layoutContainer(Container container) {
            boolean bl = WindowsGraphicsUtils.isLeftToRight(WindowsInternalFrameTitlePane.this.frame);
            int n = WindowsInternalFrameTitlePane.this.getWidth();
            int n2 = WindowsInternalFrameTitlePane.this.getHeight();
            Icon icon = WindowsInternalFrameTitlePane.this.frame.getFrameIcon();
            int n3 = icon != null ? icon.getIconHeight() : 0;
            int n4 = bl ? this.captionMargin.left : n - this.captionMargin.right;
            int n5 = (n2 - n3) / 2 + 1;
            this.layoutButton(WindowsInternalFrameTitlePane.this.systemLabel, "window.sysbutton", n4, n5, 16, 16, bl);
            if (this.xp != null) {
                n4 = bl ? n - this.captionMargin.right - 2 : this.captionMargin.left + 2;
                n5 = this.contentMargin.top + this.captionMargin.top;
                n5 = WindowsInternalFrameTitlePane.this.frame.isMaximum() ? ++n5 : (n5 += 5);
            } else {
                n4 = bl ? n - this.captionMargin.right : this.captionMargin.left;
                n5 = (n2 - 16) / 2 + 1;
            }
            if (WindowsInternalFrameTitlePane.this.frame.isClosable()) {
                n4 = this.layoutButton(WindowsInternalFrameTitlePane.this.closeButton, "window.closebutton", n4, n5, 16, 14, !bl);
            }
            if (WindowsInternalFrameTitlePane.this.frame.isMaximizable()) {
                n4 = this.layoutButton(WindowsInternalFrameTitlePane.this.maxButton, "window.maxbutton", n4, n5, 16, 14, !bl);
            }
            if (WindowsInternalFrameTitlePane.this.frame.isIconifiable()) {
                this.layoutButton(WindowsInternalFrameTitlePane.this.iconButton, "window.minbutton", n4, n5, 16, 14, !bl);
            }
        }
    }
}

