/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsPopupMenuUI
extends BasicPopupMenuUI {
    static MnemonicListener mnemonicListener = null;
    private static AbstractAction cancelAction = new CancelAction();
    private static AbstractAction selectParentAction = new SelectParentChildAction(SelectParentChildAction.PARENT);
    private static AbstractAction selectChildAction = new SelectParentChildAction(SelectParentChildAction.CHILD);
    private static AbstractAction oldCancelAction = null;
    private static AbstractAction oldSelectParentAction = null;
    private static AbstractAction oldSelectChildAction = null;
    private static boolean installWindowsActions = false;
    private static boolean uninstallWindowsActions = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsPopupMenuUI();
    }

    public void installListeners() {
        super.installListeners();
        boolean bl = false;
        ChangeListener[] changeListenerArray = MenuSelectionManager.defaultManager().getChangeListeners();
        if (changeListenerArray != null) {
            int n = 1;
            while (n < changeListenerArray.length) {
                if (changeListenerArray[n] == mnemonicListener) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!(UIManager.getBoolean("Button.showMnemonics") || mnemonicListener != null && bl)) {
            if (mnemonicListener == null) {
                mnemonicListener = new MnemonicListener();
            }
            MenuSelectionManager.defaultManager().addChangeListener(mnemonicListener);
        }
    }

    public void installUI(JComponent jComponent) {
        if (UIManager.get("PopupMenu.actionMap") == null) {
            installWindowsActions = true;
        }
        super.installUI(jComponent);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        super.installKeyboardActions();
        if (installWindowsActions && (actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap")) != null) {
            oldCancelAction = (AbstractAction)actionMap.get("cancel");
            oldSelectParentAction = (AbstractAction)actionMap.get("selectParent");
            oldSelectChildAction = (AbstractAction)actionMap.get("selectChild");
            actionMap.put("cancel", cancelAction);
            actionMap.put("selectParent", selectParentAction);
            actionMap.put("selectChild", selectChildAction);
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", actionMap);
            installWindowsActions = false;
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (UIManager.get("PopupMenu.actionMap") == null) {
            uninstallWindowsActions = true;
        }
        super.uninstallUI(jComponent);
    }

    protected void uninstallKeyboardActions() {
        ActionMap actionMap;
        super.uninstallKeyboardActions();
        if (uninstallWindowsActions && (actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap")) != null) {
            actionMap.put("cancel", oldCancelAction);
            actionMap.put("selectParent", oldSelectParentAction);
            actionMap.put("selectChild", oldSelectChildAction);
            oldCancelAction = null;
            oldSelectParentAction = null;
            oldSelectChildAction = null;
            uninstallWindowsActions = false;
        }
    }

    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        return popupFactory.getPopup(jPopupMenu.getInvoker(), jPopupMenu, n, n2);
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            Component component;
            if (menuElementArray[n3] != null && (component = menuElementArray[n3].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
        int n3 = n;
        while (n3 >= n2) {
            Component component;
            if (menuElementArray[n3] != null && (component = menuElementArray[n3].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n3];
            }
            --n3;
        }
        return null;
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, int n, boolean bl) {
        MenuElement menuElement = null;
        if (bl) {
            menuElement = WindowsPopupMenuUI.nextEnabledChild(menuElementArray, n + 1, menuElementArray.length - 1);
            if (menuElement == null) {
                menuElement = WindowsPopupMenuUI.nextEnabledChild(menuElementArray, 0, n - 1);
            }
        } else {
            menuElement = WindowsPopupMenuUI.previousEnabledChild(menuElementArray, n - 1, 0);
            if (menuElement == null) {
                menuElement = WindowsPopupMenuUI.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n + 1);
            }
        }
        return menuElement;
    }

    private static MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl) {
        int n = 0;
        while (n < menuElementArray.length) {
            if (menuElementArray[n] == menuElement) {
                return WindowsPopupMenuUI.findEnabledChild(menuElementArray, n, bl);
            }
            ++n;
        }
        return null;
    }

    private static class SelectParentChildAction
    extends AbstractAction {
        static boolean PARENT = false;
        static boolean CHILD = true;
        boolean direction;

        SelectParentChildAction(boolean bl) {
            this.direction = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (this.direction == PARENT) {
                int n2 = n - 1;
                if (n > 2 && (menuElementArray[n2] instanceof JPopupMenu || menuElementArray[--n2] instanceof JPopupMenu) && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n2);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n > 0 && menuElementArray[n - 1] instanceof JMenu && !((JMenu)menuElementArray[n - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = WindowsPopupMenuUI.findEnabledChild(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n + 1];
                } else {
                    menuElementArray3 = new MenuElement[n + 2];
                    menuElementArray3[n + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n);
                menuElementArray3[n] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = WindowsPopupMenuUI.findEnabledChild(menuElementArray[0].getSubElements(), menuElement, this.direction);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5;
                    if (n == 2) {
                        menuElementArray5 = new MenuElement[]{menuElementArray[0], menuElement2};
                    } else {
                        JPopupMenu jPopupMenu = null;
                        MenuElement menuElement3 = null;
                        jPopupMenu = ((JMenu)menuElement2).getPopupMenu();
                        MenuElement[] menuElementArray6 = jPopupMenu.getSubElements();
                        if (menuElementArray6.length > 0) {
                            menuElement3 = WindowsPopupMenuUI.nextEnabledChild(menuElementArray6, 0, menuElementArray6.length - 1);
                        }
                        menuElementArray5 = menuElement3 != null ? new MenuElement[]{menuElementArray[0], menuElement2, jPopupMenu, menuElement3} : new MenuElement[]{menuElementArray[0], menuElement2, jPopupMenu};
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else if (menuElementArray.length > 2) {
                MenuElement[] menuElementArray3 = new MenuElement[2];
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    static class MnemonicListener
    implements ChangeListener {
        JRootPane repaintRoot = null;
        MenuElement lastTopMenuElement = null;

        MnemonicListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length == 0) {
                if (!(this.lastTopMenuElement instanceof ComboPopup)) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    if (this.repaintRoot != null) {
                        this.repaintRoot.repaint();
                    }
                }
            } else {
                Component component = (Component)((Object)menuElementArray[0]);
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.repaintRoot = SwingUtilities.getRootPane(component);
            }
            this.lastTopMenuElement = menuElementArray.length != 0 ? menuElementArray[0] : null;
        }
    }
}

