/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WindowsTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (XPStyle.getXP() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new XPDefaultRenderer());
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    private class XPDefaultRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        XPStyle.Skin skin = XPStyle.getXP().getSkin("header.headeritem");
        boolean isSelected;
        boolean hasFocus;
        int column;

        private XPDefaultRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setFont(jTableHeader.getFont());
            }
            this.isSelected = bl;
            this.hasFocus = bl2;
            this.column = n2;
            this.setText(object == null ? "" : object.toString());
            this.setBorder(new EmptyBorder(this.skin.getContentMargin()));
            return this;
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel tableColumnModel = WindowsTableHeaderUI.this.header.getColumnModel();
            int n = 0;
            while (n < tableColumnModel.getColumnCount()) {
                if (tableColumnModel.getColumn(n) == tableColumn) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = 0;
            if (this.column == this.viewIndexForColumn(WindowsTableHeaderUI.this.header.getDraggedColumn())) {
                n = 2;
            } else if (this.isSelected || this.hasFocus) {
                n = 1;
            }
            this.skin.paintSkin(graphics, 0, 0, dimension.width - 1, dimension.height - 1, n);
            super.paint(graphics);
        }
    }
}

