/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.EventDispatcher;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractLine
implements Line {
    protected Line.Info info;
    protected Control[] controls;
    protected AbstractMixer mixer;
    private boolean open = false;
    private Vector listeners = new Vector();
    private static final EventDispatcher eventDispatcher = new EventDispatcher();

    protected AbstractLine(Line.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.info = info;
        this.mixer = abstractMixer;
        this.controls = controlArray;
    }

    public Line.Info getLineInfo() {
        return this.info;
    }

    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineListener(LineListener lineListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(lineListener)) {
                this.listeners.addElement(lineListener);
            }
        }
    }

    public void removeLineListener(LineListener lineListener) {
        this.listeners.removeElement(lineListener);
    }

    public Control[] getControls() {
        Control[] controlArray = new Control[this.controls.length];
        int n = 0;
        while (n < this.controls.length) {
            controlArray[n] = this.controls[n];
            ++n;
        }
        return controlArray;
    }

    public boolean isControlSupported(Control.Type type) {
        if (type == null) {
            return false;
        }
        int n = 0;
        while (n < this.controls.length) {
            if (type == this.controls[n].getType()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Control getControl(Control.Type type) {
        if (type != null) {
            int n = 0;
            while (n < this.controls.length) {
                if (type == this.controls[n].getType()) {
                    return this.controls[n];
                }
                ++n;
            }
        }
        throw new IllegalArgumentException("Unsupported control type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpen(boolean bl) {
        boolean bl2 = false;
        int n = this.getFramePosition();
        AbstractLine abstractLine = this;
        synchronized (abstractLine) {
            if (this.open != bl) {
                this.open = bl;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.OPEN, n));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.CLOSE, n));
            }
        }
    }

    protected void sendEvents(LineEvent lineEvent) {
        eventDispatcher.sendAudioEvents(lineEvent, this.listeners);
    }

    public int getFramePosition() {
        return -1;
    }

    protected AbstractMixer getMixer() {
        return this.mixer;
    }

    protected EventDispatcher getEventDispatcher() {
        return eventDispatcher;
    }

    public abstract void open() throws LineUnavailableException;

    public abstract void close();

    static {
        eventDispatcher.start();
    }
}

