/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AlawCodec
extends SunCodec {
    static final byte[] ALAW_TABH = new byte[256];
    static final byte[] ALAW_TABL = new byte[256];
    private static final AudioFormat.Encoding[] alawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public AlawCodec() {
        super(alawEncodings, alawEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW) || encoding.equals(AudioFormat.Encoding.ALAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ALAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 2 * audioFormat.getChannels(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ALAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new AlawCodecStream(audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ALAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        int n = 0;
        while (n < audioFormatArray.length) {
            audioFormatArray[n] = (AudioFormat)vector.elementAt(n);
            ++n;
        }
        return audioFormatArray;
    }

    static {
        int n = 0;
        while (n < 256) {
            int n2 = n ^ 0x55;
            int n3 = (n2 & 0xF) << 4;
            int n4 = (n2 & 0x70) >> 4;
            int n5 = n3 + 8;
            if (n4 >= 1) {
                n5 += 256;
            }
            if (n4 > 1) {
                n5 <<= n4 - 1;
            }
            if ((n2 & 0x80) == 0) {
                n5 = -n5;
            }
            AlawCodec.ALAW_TABL[n] = (byte)n5;
            AlawCodec.ALAW_TABH[n] = (byte)(n5 >> 8);
            ++n;
        }
    }

    class AlawCodecStream
    extends AudioInputStream {
        boolean encode;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1;
        byte[] tabByte2;
        int highByte;
        int lowByte;

        AlawCodecStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            boolean bl;
            super(audioInputStream, audioFormat, -1L);
            this.encode = false;
            this.tabByte1 = null;
            this.tabByte2 = null;
            this.highByte = 0;
            this.lowByte = 1;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!AlawCodec.this.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (audioFormat2.getEncoding() == AudioFormat.Encoding.ALAW) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
                bl = audioFormat.isBigEndian();
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
                bl = audioFormat2.isBigEndian();
            }
            if (bl) {
                this.tabByte1 = ALAW_TABH;
                this.tabByte2 = ALAW_TABL;
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.tabByte1 = ALAW_TABL;
                this.tabByte2 = ALAW_TABH;
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                this.frameLength = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }

        private short search(short s, short[] sArray, short s2) {
            short s3 = 0;
            while (s3 < s2) {
                if (s <= sArray[s3]) {
                    return s3;
                }
                s3 = (short)(s3 + 1);
            }
            return s2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 % this.frameSize != 0) {
                n2 -= n2 % this.frameSize;
            }
            if (this.encode) {
                int n3 = 15;
                int n4 = 4;
                int n5 = 0;
                int n6 = n;
                int n7 = n2 * 2;
                int n8 = n7 > 64 ? 64 : n7;
                while ((n5 = super.read(AlawCodec.this.tempBuffer, 0, n8)) > 0) {
                    int n9 = 0;
                    while (n9 < n5) {
                        byte by;
                        int n10;
                        short s = (short)(AlawCodec.this.tempBuffer[n9 + this.highByte] << 8 & 0xFF00);
                        if ((s = (short)(s | (short)(AlawCodec.this.tempBuffer[n9 + this.lowByte] & 0xFF))) >= 0) {
                            n10 = 213;
                        } else {
                            n10 = 85;
                            s = (short)(-s - 8);
                        }
                        short s2 = this.search(s, seg_end, (short)8);
                        if (s2 >= 8) {
                            by = (byte)(0x7F ^ n10);
                        } else {
                            by = (byte)(s2 << n4);
                            by = s2 < 2 ? (byte)(by | (byte)(s >> 4 & n3)) : (byte)(by | (byte)(s >> s2 + 3 & n3));
                            by = (byte)(by ^ n10);
                        }
                        byArray[n6] = by;
                        ++n6;
                        n9 += 2;
                    }
                    int n11 = n8 = (n7 -= n5) > 64 ? 64 : n7;
                }
                if (n6 == n && n5 < 0) {
                    return n5;
                }
                return n6 - n;
            }
            int n12 = n2 / 2;
            int n13 = n + n2 / 2;
            int n14 = super.read(byArray, n13, n12);
            int n15 = n;
            while (n15 < n + n14 * 2) {
                byArray[n15] = this.tabByte1[byArray[n13] & 0xFF];
                byArray[n15 + 1] = this.tabByte2[byArray[n13] & 0xFF];
                ++n13;
                n15 += 2;
            }
            if (n14 < 0) {
                return n14;
            }
            return n15 - n;
        }
    }
}

