/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class MixerSourceLine
extends AbstractDataLine
implements SourceDataLine {
    private CircularBuffer circularBuffer = null;
    private byte[] dataBuffer = null;
    private long id;
    private int finalPosition = 0;
    private boolean implStarted = false;
    MixerSourceLineGainControl gainControl = new MixerSourceLineGainControl();

    MixerSourceLine(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[4], audioFormat, n);
        this.controls[0] = this.gainControl;
        this.controls[1] = new MixerSourceLineMuteControl();
        this.controls[2] = new MixerSourceLinePanControl();
        this.controls[3] = new MixerSourceLineSampleRateControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            if (this.circularBuffer != null) {
                this.circularBuffer.markEnd();
            }
            return 0;
        }
        int n3 = n2;
        if (n2 % this.getFormat().getFrameSize() != 0) {
            throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n2 + " bytes )");
        }
        int n4 = 0;
        int n5 = 0;
        while (this.isOpen() && this.isStartedRunning() && n4 < n3) {
            n5 = this.circularBuffer.write(byArray, n, n3 - n4);
            n += n5;
            if ((n4 += n5) >= n3) continue;
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return n4;
    }

    public int available() {
        if (this.circularBuffer != null) {
            return this.circularBuffer.bytesAvailableToWrite();
        }
        return 0;
    }

    void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (audioFormat.getSampleRate() == -1.0f) {
            float f;
            float f2 = 44100.0f;
            if (this.mixer instanceof HeadspaceMixer) {
                f2 = ((HeadspaceMixer)this.mixer).getDefaultFormat().getSampleRate();
            }
            if ((f = audioFormat.getFrameRate()) == -1.0f || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                f = f2;
            }
            audioFormat = new AudioFormat(audioFormat.getEncoding(), f2, audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), f, audioFormat.isBigEndian());
        }
        if (n == -1 || n < audioFormat.getFrameSize()) {
            n = MixerSourceLine.calculateBufferSizeInBytes(audioFormat);
        }
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        int n2 = 0x100000 * audioFormat.getFrameSize() * 2;
        while (n > n2) {
            n /= 2;
        }
        n -= n % audioFormat.getFrameSize();
        boolean bl = false;
        boolean bl2 = false;
        if (this.getFormat().getSampleSizeInBits() == 8 && this.getFormat().getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            bl = true;
        }
        if (this.getFormat().getSampleSizeInBits() > 8 && this.getFormat().isBigEndian() != Platform.isBigEndian()) {
            bl2 = true;
        }
        if (this.circularBuffer == null || this.circularBuffer.getByteLength() != n) {
            this.circularBuffer = new CircularBuffer(n, bl, bl2);
        }
        if (this.dataBuffer == null || this.dataBuffer.length != n) {
            this.dataBuffer = new byte[n];
        }
        this.id = this.nOpen(this.getFormat().getSampleSizeInBits(), this.getFormat().getChannels(), this.getFormat().getSampleRate(), n);
        this.format = audioFormat;
        this.bufferSize = n;
        if (this.id == 0L) {
            throw new LineUnavailableException("Failed to allocate native stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implClose() {
        this.nClose(this.id);
        while (this.id != 0L) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.implStarted = false;
    }

    void implStart() {
        if (!this.implStarted) {
            this.nStart(this.id);
            this.implStarted = true;
        } else {
            this.nResume(this.id);
        }
    }

    void implStop() {
        this.nPause(this.id);
    }

    public float getLevel() {
        return this.id != 0L ? this.nGetLevel(this.id) : -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        if (this.circularBuffer != null) {
            this.circularBuffer.drain();
        }
        if (!this.isActive()) {
            this.nDrain(this.id);
        }
        int n = 40;
        while (this.isActive() && n-- > 0) {
            MixerSourceLine mixerSourceLine = this;
            synchronized (mixerSourceLine) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void flush() {
        if (this.circularBuffer != null) {
            this.circularBuffer.flush();
        }
        this.nFlush(this.id);
    }

    public int getFramePosition() {
        return this.id != 0L ? (int)this.nGetPosition(this.id) : this.finalPosition;
    }

    long getId() {
        return this.id;
    }

    private static int calculateBufferSizeInBytes(AudioFormat audioFormat) {
        int n = (int)audioFormat.getFrameRate() / 2;
        int n2 = 1;
        while (n > n2) {
            n2 *= 2;
        }
        return n2 * audioFormat.getFrameSize();
    }

    private synchronized int callbackStreamGetData(byte[] byArray, int n) {
        int n2 = this.getFormat().getFrameSize();
        int n3 = n * n2;
        int n4 = this.circularBuffer.read(byArray, 0, n3 = Math.min(n3, byArray.length));
        n4 = n4 > 0 ? n4 / n2 : n4;
        this.notifyAll();
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamDestroy() {
        this.finalPosition = this.getFramePosition();
        this.id = 0L;
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.notifyAll();
        }
    }

    private void callbackStreamStart() {
        this.setActive(true);
        this.setStarted(true);
    }

    private void callbackStreamStop() {
        this.setActive(false);
        this.setStarted(false);
    }

    private void callbackStreamEOM() {
        this.setActive(false);
        this.setEOM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamActive() {
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.setActive(true);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamInactive() {
        MixerSourceLine mixerSourceLine = this;
        synchronized (mixerSourceLine) {
            this.setActive(false);
            this.notifyAll();
        }
    }

    private native void nDrain(long var1);

    private native void nFlush(long var1);

    private native long nGetPosition(long var1);

    private native float nGetLevel(long var1);

    private native long nOpen(int var1, int var2, float var3, int var4) throws LineUnavailableException;

    private native void nStart(long var1);

    private native void nResume(long var1);

    private native void nPause(long var1);

    private native void nClose(long var1);

    protected native float nSetLinearGain(long var1, float var3);

    protected native float nSetPan(long var1, float var3);

    protected native int nSetSampleRate(long var1, int var3);

    private class MixerSourceLineApplyReverbControl
    extends BooleanControl {
        private MixerSourceLineApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean bl) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (bl == this.getValue() || MixerSourceLine.this.id != 0L) {
                // empty if block
            }
            super.setValue(bl);
        }
    }

    private class MixerSourceLineMuteControl
    extends BooleanControl {
        private MixerSourceLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        public void setValue(boolean bl) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (bl && !this.getValue() && MixerSourceLine.this.id != 0L) {
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, 0.0f);
            } else if (!bl && this.getValue() && MixerSourceLine.this.id != 0L) {
                float f = Toolkit.dBToLinear(MixerSourceLine.this.gainControl.getValue());
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, f);
            }
            super.setValue(bl);
        }
    }

    private class MixerSourceLineSampleRateControl
    extends FloatControl {
        private MixerSourceLineSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerSourceLine.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float f) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            if ((f = Math.max(f, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0L) {
                f = MixerSourceLine.this.nSetSampleRate(MixerSourceLine.this.id, (int)f);
            }
            super.setValue(f);
        }

        private void update() {
            super.setValue(MixerSourceLine.this.getFormat().getFrameRate());
        }
    }

    private class MixerSourceLinePanControl
    extends FloatControl {
        private MixerSourceLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float f) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            if ((f = Math.max(f, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0L) {
                f = -1.0f * MixerSourceLine.this.nSetPan(MixerSourceLine.this.id, -1.0f * f);
            }
            super.setValue(f);
        }
    }

    private class MixerSourceLineGainControl
    extends FloatControl {
        private float linearGain;

        private MixerSourceLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Math.abs(Toolkit.linearToDB(5.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
            this.linearGain = 1.0f;
        }

        public void setValue(float f) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f = Math.min(f, this.getMaximum());
            float f2 = Toolkit.dBToLinear(f = Math.max(f, this.getMinimum()));
            if (f2 != this.linearGain && MixerSourceLine.this.id != 0L) {
                f2 = MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, f2);
            }
            this.linearGain = f2;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }
}

