/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import com.sun.media.sound.PortMixer;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class PortMixerProvider
extends MixerProvider {
    private static PortMixerInfo[] infos;
    private static PortMixer[] devices;

    public PortMixerProvider() {
        if (Platform.isPortsEnabled()) {
            PortMixerProvider.init();
        } else {
            infos = new PortMixerInfo[0];
            devices = new PortMixer[0];
        }
    }

    private static void init() {
        int n = PortMixerProvider.nGetNumDevices();
        if (infos == null || infos.length != n) {
            infos = new PortMixerInfo[n];
            devices = new PortMixer[n];
            int n2 = 0;
            while (n2 < infos.length) {
                PortMixerProvider.infos[n2] = PortMixerProvider.nNewPortMixerInfo(n2);
                ++n2;
            }
        }
    }

    public Mixer.Info[] getMixerInfo() {
        Mixer.Info[] infoArray = new Mixer.Info[infos.length];
        System.arraycopy(infos, 0, infoArray, 0, infos.length);
        return infoArray;
    }

    public Mixer getMixer(Mixer.Info info) {
        int n = 0;
        while (n < infos.length) {
            if (infos[n].equals(info)) {
                return this.getDevice(infos[n]);
            }
            ++n;
        }
        throw new IllegalArgumentException("Mixer " + info.toString() + " not supported by this provider.");
    }

    private Mixer getDevice(PortMixerInfo portMixerInfo) {
        int n = portMixerInfo.getIndex();
        if (devices[n] == null) {
            PortMixerProvider.devices[n] = new PortMixer(portMixerInfo);
        }
        return devices[n];
    }

    private static native int nGetNumDevices();

    private static native PortMixerInfo nNewPortMixerInfo(int var0);

    static {
        Platform.initialize();
    }

    static class PortMixerInfo
    extends Mixer.Info {
        private int index;

        private PortMixerInfo(int n, String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
            this.index = n;
        }

        int getIndex() {
            return this.index;
        }
    }
}

