/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ColorPaintContext;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;
import sun.awt.NativeLibLoader;

public class Color
implements Paint,
Serializable {
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    private transient long pData;
    int value;
    private float[] frgbvalue = null;
    private float[] fvalue = null;
    private float falpha = 0.0f;
    private ColorSpace cs = null;
    private static final long serialVersionUID = 118526816881161077L;
    private static final double FACTOR = 0.7;
    private transient PaintContext theContext;

    private static native void initIDs();

    private static void testColorValueRange(int n, int n2, int n3, int n4) {
        boolean bl = false;
        String string = "";
        if (n4 < 0 || n4 > 255) {
            bl = true;
            string = string + " Alpha";
        }
        if (n < 0 || n > 255) {
            bl = true;
            string = string + " Red";
        }
        if (n2 < 0 || n2 > 255) {
            bl = true;
            string = string + " Green";
        }
        if (n3 < 0 || n3 > 255) {
            bl = true;
            string = string + " Blue";
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    private static void testColorValueRange(float f, float f2, float f3, float f4) {
        boolean bl = false;
        String string = "";
        if ((double)f4 < 0.0 || (double)f4 > 1.0) {
            bl = true;
            string = string + " Alpha";
        }
        if ((double)f < 0.0 || (double)f > 1.0) {
            bl = true;
            string = string + " Red";
        }
        if ((double)f2 < 0.0 || (double)f2 > 1.0) {
            bl = true;
            string = string + " Green";
        }
        if ((double)f3 < 0.0 || (double)f3 > 1.0) {
            bl = true;
            string = string + " Blue";
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    public Color(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public Color(int n, int n2, int n3, int n4) {
        this.value = (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
        Color.testColorValueRange(n, n2, n3, n4);
    }

    public Color(int n) {
        this.value = 0xFF000000 | n;
    }

    public Color(int n, boolean bl) {
        this.value = bl ? n : 0xFF000000 | n;
    }

    public Color(float f, float f2, float f3) {
        this((int)((double)(f * 255.0f) + 0.5), (int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5));
        Color.testColorValueRange(f, f2, f3, 1.0f);
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = f;
        this.frgbvalue[1] = f2;
        this.frgbvalue[2] = f3;
        this.falpha = 1.0f;
        this.fvalue = this.frgbvalue;
    }

    public Color(float f, float f2, float f3, float f4) {
        this((int)((double)(f * 255.0f) + 0.5), (int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5), (int)((double)(f4 * 255.0f) + 0.5));
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = f;
        this.frgbvalue[1] = f2;
        this.frgbvalue[2] = f3;
        this.falpha = f4;
        this.fvalue = this.frgbvalue;
    }

    public Color(ColorSpace colorSpace, float[] fArray, float f) {
        boolean bl = false;
        String string = "";
        int n = colorSpace.getNumComponents();
        this.fvalue = new float[n];
        int n2 = 0;
        while (n2 < n) {
            if ((double)fArray[n2] < 0.0 || (double)fArray[n2] > 1.0) {
                bl = true;
                string = string + "Component " + n2 + " ";
            } else {
                this.fvalue[n2] = fArray[n2];
            }
            ++n2;
        }
        if ((double)f < 0.0 || (double)f > 1.0) {
            bl = true;
            string = string + "Alpha";
        } else {
            this.falpha = f;
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range: " + string);
        }
        this.frgbvalue = colorSpace.toRGB(this.fvalue);
        this.cs = colorSpace;
        this.value = ((int)(this.falpha * 255.0f) & 0xFF) << 24 | ((int)(this.frgbvalue[0] * 255.0f) & 0xFF) << 16 | ((int)(this.frgbvalue[1] * 255.0f) & 0xFF) << 8 | ((int)(this.frgbvalue[2] * 255.0f) & 0xFF) << 0;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int n = this.getRed();
        int n2 = this.getGreen();
        int n3 = this.getBlue();
        int n4 = 3;
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(70, 70, 70);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / 0.7), 255), Math.min((int)((double)n2 / 0.7), 255), Math.min((int)((double)n3 / 0.7), 255));
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Color && ((Color)object).value == this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public static Color decode(String string) throws NumberFormatException {
        Integer n = Integer.decode(string);
        int n2 = n;
        return new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static Color getColor(String string) {
        return Color.getColor(string, null);
    }

    public static Color getColor(String string, Color color) {
        Integer n = Integer.getInteger(string);
        if (n == null) {
            return color;
        }
        int n2 = n;
        return new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
    }

    public static Color getColor(String string, int n) {
        Integer n2 = Integer.getInteger(string);
        int n3 = n2 != null ? n2 : n;
        return new Color(n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 >> 0 & 0xFF);
    }

    public static int HSBtoRGB(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (f2 == 0.0f) {
            n2 = n3 = (int)(f3 * 255.0f + 0.5f);
            n = n3;
        } else {
            float f4 = (f - (float)Math.floor(f)) * 6.0f;
            float f5 = f4 - (float)Math.floor(f4);
            float f6 = f3 * (1.0f - f2);
            float f7 = f3 * (1.0f - f2 * f5);
            float f8 = f3 * (1.0f - f2 * (1.0f - f5));
            switch ((int)f4) {
                case 0: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f8 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n = (int)(f7 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f6 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f8 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n = (int)(f6 * 255.0f + 0.5f);
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n = (int)(f8 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f6 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | n << 16 | n2 << 8 | n3 << 0;
    }

    public static float[] RGBtoHSB(int n, int n2, int n3, float[] fArray) {
        float f;
        int n4;
        int n5;
        if (fArray == null) {
            fArray = new float[3];
        }
        int n6 = n5 = n > n2 ? n : n2;
        if (n3 > n5) {
            n5 = n3;
        }
        int n7 = n4 = n < n2 ? n : n2;
        if (n3 < n4) {
            n4 = n3;
        }
        float f2 = (float)n5 / 255.0f;
        float f3 = n5 != 0 ? (float)(n5 - n4) / (float)n5 : 0.0f;
        if (f3 == 0.0f) {
            f = 0.0f;
        } else {
            float f4 = (float)(n5 - n) / (float)(n5 - n4);
            float f5 = (float)(n5 - n2) / (float)(n5 - n4);
            float f6 = (float)(n5 - n3) / (float)(n5 - n4);
            f = n == n5 ? f6 - f5 : (n2 == n5 ? 2.0f + f4 - f6 : 4.0f + f5 - f4);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        fArray[0] = f;
        fArray[1] = f3;
        fArray[2] = f2;
        return fArray;
    }

    public static Color getHSBColor(float f, float f2, float f3) {
        return new Color(Color.HSBtoRGB(f, f2, f3));
    }

    public float[] getRGBComponents(float[] fArray) {
        float[] fArray2 = fArray == null ? new float[4] : fArray;
        if (this.frgbvalue == null) {
            fArray2[0] = (float)this.getRed() / 255.0f;
            fArray2[1] = (float)this.getGreen() / 255.0f;
            fArray2[2] = (float)this.getBlue() / 255.0f;
            fArray2[3] = (float)this.getAlpha() / 255.0f;
        } else {
            fArray2[0] = this.frgbvalue[0];
            fArray2[1] = this.frgbvalue[1];
            fArray2[2] = this.frgbvalue[2];
            fArray2[3] = this.falpha;
        }
        return fArray2;
    }

    public float[] getRGBColorComponents(float[] fArray) {
        float[] fArray2 = fArray == null ? new float[3] : fArray;
        if (this.frgbvalue == null) {
            fArray2[0] = (float)this.getRed() / 255.0f;
            fArray2[1] = (float)this.getGreen() / 255.0f;
            fArray2[2] = (float)this.getBlue() / 255.0f;
        } else {
            fArray2[0] = this.frgbvalue[0];
            fArray2[1] = this.frgbvalue[1];
            fArray2[2] = this.frgbvalue[2];
        }
        return fArray2;
    }

    public float[] getComponents(float[] fArray) {
        if (this.fvalue == null) {
            return this.getRGBComponents(fArray);
        }
        int n = this.fvalue.length;
        float[] fArray2 = fArray == null ? new float[n + 1] : fArray;
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = this.fvalue[n2];
            ++n2;
        }
        fArray2[n] = this.falpha;
        return fArray2;
    }

    public float[] getColorComponents(float[] fArray) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(fArray);
        }
        int n = this.fvalue.length;
        float[] fArray2 = fArray == null ? new float[n] : fArray;
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = this.fvalue[n2];
            ++n2;
        }
        return fArray2;
    }

    public float[] getComponents(ColorSpace colorSpace, float[] fArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] fArray2 = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] fArray3 = this.cs.toCIEXYZ(fArray2);
        float[] fArray4 = colorSpace.fromCIEXYZ(fArray3);
        if (fArray == null) {
            fArray = new float[fArray4.length + 1];
        }
        int n = 0;
        while (n < fArray4.length) {
            fArray[n] = fArray4[n];
            ++n;
        }
        fArray[fArray4.length] = this.fvalue == null ? (float)this.getAlpha() / 255.0f : this.falpha;
        return fArray;
    }

    public float[] getColorComponents(ColorSpace colorSpace, float[] fArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] fArray2 = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] fArray3 = this.cs.toCIEXYZ(fArray2);
        float[] fArray4 = colorSpace.fromCIEXYZ(fArray3);
        if (fArray == null) {
            return fArray4;
        }
        int n = 0;
        while (n < fArray4.length) {
            fArray[n] = fArray4[n];
            ++n;
        }
        return fArray;
    }

    public ColorSpace getColorSpace() {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        return this.cs;
    }

    public synchronized PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        PaintContext paintContext = this.theContext;
        if (paintContext == null) {
            this.theContext = paintContext = new ColorPaintContext(this.value, colorModel);
        }
        return paintContext;
    }

    public int getTransparency() {
        int n = this.getAlpha();
        if (n == 255) {
            return 1;
        }
        if (n == 0) {
            return 2;
        }
        return 3;
    }

    static {
        WHITE = white = new Color(255, 255, 255);
        LIGHT_GRAY = lightGray = new Color(192, 192, 192);
        GRAY = gray = new Color(128, 128, 128);
        DARK_GRAY = darkGray = new Color(64, 64, 64);
        BLACK = black = new Color(0, 0, 0);
        RED = red = new Color(255, 0, 0);
        PINK = pink = new Color(255, 175, 175);
        ORANGE = orange = new Color(255, 200, 0);
        YELLOW = yellow = new Color(255, 255, 0);
        GREEN = green = new Color(0, 255, 0);
        MAGENTA = magenta = new Color(255, 0, 255);
        CYAN = cyan = new Color(0, 255, 255);
        BLUE = blue = new Color(0, 0, 255);
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Color.initIDs();
        }
    }
}

