/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import com.ibm.jvm.Constants;
import com.ibm.jvm.io.LocalizedInputStream;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import sun.awt.datatransfer.DataTransferer;

public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static String JavaMIME;
    private static final WeakHashMap flavorMaps;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String[] UNICODE_TEXT_CLASSES;
    private static final String[] ENCODED_TEXT_CLASSES;
    private static final String TEXT_PLAIN_BASE_TYPE = "text/plain";
    private static final boolean SYNTHESIZE_IF_NOT_FOUND = true;
    private Map nativeToFlavor;
    private Map flavorToNative;
    private Map getNativesForFlavorCache;
    private Map getFlavorsForNativeCache;
    private Set disabledMappingGenerationKeys;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$awt$datatransfer$SystemFlavorMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlavorMap getDefaultFlavorMap() {
        FlavorMap flavorMap;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        WeakHashMap weakHashMap = flavorMaps;
        synchronized (weakHashMap) {
            flavorMap = (FlavorMap)flavorMaps.get(classLoader);
            if (flavorMap == null) {
                flavorMap = new SystemFlavorMap();
                flavorMaps.put(classLoader, flavorMap);
            }
        }
        return flavorMap;
    }

    private SystemFlavorMap() {
        block5: {
            this.nativeToFlavor = new HashMap();
            this.flavorToNative = new HashMap();
            this.getNativesForFlavorCache = new HashMap();
            this.getFlavorsForNativeCache = new HashMap();
            this.disabledMappingGenerationKeys = new HashSet();
            BufferedReader bufferedReader = (BufferedReader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + Constants.flavormap_properties;
                    try {
                        InputStream inputStream = new File(string).toURI().toURL().openStream();
                        inputStream = LocalizedInputStream.localize((InputStream)inputStream);
                        LocalizedInputStream.dontUnwrap((InputStream)inputStream);
                        return new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("MalformedURLException:" + malformedURLException + " while loading default flavormap.properties file:" + string);
                    }
                    catch (IOException iOException) {
                        System.err.println("IOException:" + iOException + " while loading default flavormap.properties file:" + string);
                    }
                    return null;
                }
            });
            BufferedReader bufferedReader2 = (BufferedReader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit();
                    String string = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                    if (string == null) {
                        return null;
                    }
                    try {
                        InputStream inputStream = new URL(string).openStream();
                        inputStream = LocalizedInputStream.localize((InputStream)inputStream);
                        LocalizedInputStream.dontUnwrap((InputStream)inputStream);
                        return new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("MalformedURLException:" + malformedURLException + " while reading AWT.DnD.flavorMapFileURL:" + string);
                    }
                    catch (IOException iOException) {
                        System.err.println("IOException:" + iOException + " while reading AWT.DnD.flavorMapFileURL:" + string);
                    }
                    return null;
                }
            });
            if (bufferedReader != null) {
                try {
                    this.parseAndStoreReader(bufferedReader);
                }
                catch (IOException iOException) {
                    System.err.println("IOException:" + iOException + " while parsing default flavormap.properties file");
                }
            }
            if (bufferedReader2 == null) break block5;
            try {
                this.parseAndStoreReader(bufferedReader2);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while parsing AWT.DnD.flavorMapFileURL");
            }
        }
    }

    private void parseAndStoreReader(BufferedReader bufferedReader) throws IOException {
        while (true) {
            Cloneable cloneable;
            String string;
            String string2;
            block24: {
                int n;
                int n2;
                char c;
                String string3;
                if ((string3 = bufferedReader.readLine()) == null) {
                    return;
                }
                if (string3.length() <= 0 || (c = string3.charAt(0)) == '#' || c == '!') continue;
                while (this.continueLine(string3)) {
                    String string4 = bufferedReader.readLine();
                    if (string4 == null) {
                        string4 = new String("");
                    }
                    String string5 = string3.substring(0, string3.length() - 1);
                    n2 = 0;
                    while (n2 < string4.length()) {
                        if (whiteSpaceChars.indexOf(string4.charAt(n2)) == -1) break;
                        ++n2;
                    }
                    string4 = string4.substring(n2, string4.length());
                    string3 = new String(string5 + string4);
                }
                int n3 = string3.length();
                int n4 = 0;
                while (n4 < n3) {
                    if (whiteSpaceChars.indexOf(string3.charAt(n4)) == -1) break;
                    ++n4;
                }
                if (n4 == n3) continue;
                n2 = 0;
                boolean bl = false;
                if (string3.charAt(n4) == '\"') {
                    n2 = 1;
                }
                int n5 = ++n4;
                int n6 = n4;
                while (n5 < n3) {
                    n = string3.charAt(n5);
                    if (n == 92) {
                        ++n5;
                    } else if (n2 != 0 && n == 34) {
                        bl = true;
                        n6 = n5;
                    } else if (keyValueSeparators.indexOf(n) != -1 && (n2 == 0 || n2 != 0 && bl)) break;
                    ++n5;
                }
                n = n5;
                if (n2 != 0) {
                    n5 = n6;
                }
                while (n < n3) {
                    if (whiteSpaceChars.indexOf(string3.charAt(n)) == -1) break;
                    ++n;
                }
                if (n < n3 && strictKeyValueSeparators.indexOf(string3.charAt(n)) != -1) {
                    ++n;
                }
                while (n < n3) {
                    if (whiteSpaceChars.indexOf(string3.charAt(n)) == -1) break;
                    ++n;
                }
                string2 = string3.substring(n4, n5);
                string = n5 < n3 ? string3.substring(n, n3) : "";
                string2 = this.loadConvert(string2);
                string = this.loadConvert(string);
                try {
                    DataTransferer dataTransferer;
                    cloneable = new MimeType(string);
                    if (!"text".equals(((MimeType)cloneable).getPrimaryType())) break block24;
                    String string6 = ((MimeType)cloneable).getParameter("charset");
                    if (DataTransferer.doesSubtypeSupportCharset(((MimeType)cloneable).getSubType(), string6) && (dataTransferer = DataTransferer.getInstance()) != null) {
                        dataTransferer.registerTextFlavorProperties(string2, string6, ((MimeType)cloneable).getParameter("eoln"), ((MimeType)cloneable).getParameter("terminators"));
                    }
                    ((MimeType)cloneable).removeParameter("charset");
                    ((MimeType)cloneable).removeParameter("class");
                    ((MimeType)cloneable).removeParameter("eoln");
                    ((MimeType)cloneable).removeParameter("terminators");
                    string = ((MimeType)cloneable).toString();
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    mimeTypeParseException.printStackTrace();
                    continue;
                }
            }
            try {
                cloneable = new DataFlavor(string);
            }
            catch (Exception exception) {
                try {
                    cloneable = new DataFlavor(string, (String)null);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    continue;
                }
            }
            if ("text".equals(((DataFlavor)cloneable).getPrimaryType())) {
                this.store(string, string2, this.flavorToNative);
                this.store(string2, string, this.nativeToFlavor);
                continue;
            }
            this.store(cloneable, string2, this.flavorToNative);
            this.store(string2, cloneable, this.nativeToFlavor);
        }
    }

    private boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < 4) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n5;
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private void store(Object object, Object object2, Map map) {
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(1);
            map.put(object, arrayList);
        }
        if (!arrayList.contains(object2)) {
            arrayList.add(object2);
        }
    }

    private List nativeToFlavorLookup(String string) {
        ArrayList<DataFlavor> arrayList = (ArrayList<DataFlavor>)this.nativeToFlavor.get(string);
        if (arrayList == null && SystemFlavorMap.isJavaMIMEType(string)) {
            String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
            DataFlavor dataFlavor = null;
            try {
                dataFlavor = new DataFlavor(string2);
            }
            catch (Exception exception) {
                System.err.println("Exception \"" + exception.getClass().getName() + ": " + exception.getMessage() + "\"while constructing DataFlavor for: " + string2);
            }
            if (dataFlavor != null) {
                arrayList = new ArrayList<DataFlavor>(1);
                this.nativeToFlavor.put(string, arrayList);
                arrayList.add(dataFlavor);
                this.getFlavorsForNativeCache.remove(string);
                this.getFlavorsForNativeCache.remove(null);
                ArrayList<String> arrayList2 = (ArrayList<String>)this.flavorToNative.get(dataFlavor);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>(1);
                    this.flavorToNative.put(dataFlavor, arrayList2);
                }
                arrayList2.add(string);
                this.getNativesForFlavorCache.remove(dataFlavor);
                this.getNativesForFlavorCache.remove(null);
            }
        }
        return arrayList != null ? arrayList : new ArrayList(0);
    }

    private List flavorToNativeLookup(DataFlavor dataFlavor, boolean bl) {
        ArrayList<String> arrayList = (ArrayList<String>)this.flavorToNative.get(dataFlavor);
        if (arrayList == null) {
            if (bl) {
                String string = SystemFlavorMap.encodeDataFlavor(dataFlavor);
                arrayList = new ArrayList(1);
                this.flavorToNative.put(dataFlavor, arrayList);
                arrayList.add(string);
                this.getNativesForFlavorCache.remove(dataFlavor);
                this.getNativesForFlavorCache.remove(null);
                ArrayList<DataFlavor> arrayList2 = (ArrayList<DataFlavor>)this.nativeToFlavor.get(string);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<DataFlavor>(1);
                    this.nativeToFlavor.put(string, arrayList2);
                }
                arrayList2.add(dataFlavor);
                this.getFlavorsForNativeCache.remove(string);
                this.getFlavorsForNativeCache.remove(null);
            } else {
                arrayList = new ArrayList<String>(0);
            }
        }
        return arrayList;
    }

    public synchronized List getNativesForFlavor(DataFlavor dataFlavor) {
        List<Object> list = null;
        SoftReference softReference = (SoftReference)this.getNativesForFlavorCache.get(dataFlavor);
        if (softReference != null && (list = (ArrayList)softReference.get()) != null) {
            return new ArrayList(list);
        }
        if (dataFlavor == null) {
            list = new ArrayList(this.nativeToFlavor.keySet());
        } else if (this.disabledMappingGenerationKeys.contains(dataFlavor)) {
            list = this.flavorToNativeLookup(dataFlavor, false);
        } else if (DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            ArrayList arrayList;
            if ("text".equals(dataFlavor.getPrimaryType()) && (list = (List)this.flavorToNative.get(dataFlavor.mimeType.getBaseType())) != null) {
                list = new ArrayList<Object>(list);
            }
            if ((arrayList = (ArrayList)this.flavorToNative.get(TEXT_PLAIN_BASE_TYPE)) != null && !arrayList.isEmpty()) {
                arrayList = new ArrayList(arrayList);
                if (list != null && !list.isEmpty()) {
                    arrayList.removeAll(new HashSet<Object>(list));
                    list.addAll(arrayList);
                } else {
                    list = arrayList;
                }
            }
            if (list == null || list.isEmpty()) {
                list = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                ArrayList arrayList2 = this.flavorToNativeLookup(dataFlavor, false);
                if (!arrayList2.isEmpty()) {
                    arrayList2 = new ArrayList(arrayList2);
                    arrayList2.removeAll(new HashSet<Object>(list));
                    list.addAll(arrayList2);
                }
            }
        } else if (DataTransferer.isFlavorNoncharsetTextType(dataFlavor)) {
            list = (List)this.flavorToNative.get(dataFlavor.mimeType.getBaseType());
            if (list == null || list.isEmpty()) {
                list = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                ArrayList arrayList = this.flavorToNativeLookup(dataFlavor, false);
                if (!arrayList.isEmpty()) {
                    list = new ArrayList<Object>(list);
                    arrayList = new ArrayList(arrayList);
                    arrayList.removeAll(new HashSet<Object>(list));
                    list.addAll(arrayList);
                }
            }
        } else {
            list = this.flavorToNativeLookup(dataFlavor, true);
        }
        this.getNativesForFlavorCache.put(dataFlavor, new SoftReference(list));
        return new ArrayList(list);
    }

    public synchronized List getFlavorsForNative(String string) {
        ArrayList arrayList;
        AbstractList abstractList;
        SoftReference softReference = (SoftReference)this.getFlavorsForNativeCache.get(string);
        if (softReference != null && (abstractList = (ArrayList)softReference.get()) != null) {
            return (List)((ArrayList)abstractList).clone();
        }
        abstractList = new LinkedList();
        if (string == null) {
            arrayList = this.getNativesForFlavor(null);
            HashSet hashSet = new HashSet(arrayList.size());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                List list = this.getFlavorsForNative((String)iterator.next());
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!hashSet.add(e)) continue;
                    ((LinkedList)abstractList).add(e);
                }
            }
        } else {
            arrayList = this.nativeToFlavorLookup(string);
            if (this.disabledMappingGenerationKeys.contains(string)) {
                return arrayList;
            }
            HashSet<Object> hashSet = new HashSet<Object>(arrayList.size());
            List list = this.nativeToFlavorLookup(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (e instanceof String) {
                    Object object2;
                    int n;
                    String string2;
                    block26: {
                        object = (String)e;
                        string2 = null;
                        try {
                            MimeType mimeType = new MimeType((String)object);
                            string2 = mimeType.getSubType();
                        }
                        catch (MimeTypeParseException mimeTypeParseException) {
                            if ($assertionsDisabled) break block26;
                            throw new AssertionError();
                        }
                    }
                    if (DataTransferer.doesSubtypeSupportCharset(string2, null)) {
                        if (TEXT_PLAIN_BASE_TYPE.equals(object) && hashSet.add(DataFlavor.stringFlavor)) {
                            ((LinkedList)abstractList).add(DataFlavor.stringFlavor);
                        }
                        n = 0;
                        while (n < UNICODE_TEXT_CLASSES.length) {
                            object2 = null;
                            try {
                                object2 = new DataFlavor((String)object + ";charset=Unicode;class=" + UNICODE_TEXT_CLASSES[n]);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                            if (hashSet.add(object2)) {
                                ((LinkedList)abstractList).add(object2);
                            }
                            ++n;
                        }
                        object2 = DataTransferer.standardEncodings();
                        while (object2.hasNext()) {
                            String string3 = (String)object2.next();
                            int n2 = 0;
                            while (n2 < ENCODED_TEXT_CLASSES.length) {
                                DataFlavor dataFlavor = null;
                                try {
                                    dataFlavor = new DataFlavor((String)object + ";charset=" + string3 + ";class=" + ENCODED_TEXT_CLASSES[n2]);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                                if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
                                    dataFlavor = DataFlavor.plainTextFlavor;
                                }
                                if (hashSet.add(dataFlavor)) {
                                    ((LinkedList)abstractList).add(dataFlavor);
                                }
                                ++n2;
                            }
                        }
                        if (!TEXT_PLAIN_BASE_TYPE.equals(object) || !hashSet.add(DataFlavor.plainTextFlavor)) continue;
                        ((LinkedList)abstractList).add(DataFlavor.plainTextFlavor);
                        continue;
                    }
                    n = 0;
                    while (n < ENCODED_TEXT_CLASSES.length) {
                        object2 = null;
                        try {
                            object2 = new DataFlavor((String)object + ";class=" + ENCODED_TEXT_CLASSES[n]);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (hashSet.add(object2)) {
                            ((LinkedList)abstractList).add(object2);
                        }
                        ++n;
                    }
                    continue;
                }
                object = (DataFlavor)e;
                if (!hashSet.add(object)) continue;
                ((LinkedList)abstractList).add(object);
            }
        }
        arrayList = new ArrayList(abstractList);
        this.getFlavorsForNativeCache.put(string, new SoftReference(arrayList));
        return (List)arrayList.clone();
    }

    public synchronized Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        Object object;
        if (dataFlavorArray == null) {
            object = this.getFlavorsForNative(null);
            dataFlavorArray = new DataFlavor[object.size()];
            object.toArray(dataFlavorArray);
        }
        object = new HashMap(dataFlavorArray.length, 1.0f);
        int n = 0;
        while (n < dataFlavorArray.length) {
            List list = this.getNativesForFlavor(dataFlavorArray[n]);
            String string = list.isEmpty() ? null : (String)list.get(0);
            ((HashMap)object).put(dataFlavorArray[n], string);
            ++n;
        }
        return object;
    }

    public synchronized Map getFlavorsForNatives(String[] stringArray) {
        Object object;
        if (stringArray == null) {
            object = this.getNativesForFlavor(null);
            stringArray = new String[object.size()];
            object.toArray(stringArray);
        }
        object = new HashMap(stringArray.length, 1.0f);
        int n = 0;
        while (n < stringArray.length) {
            List list = this.getFlavorsForNative(stringArray[n]);
            DataFlavor dataFlavor = list.isEmpty() ? null : (DataFlavor)list.get(0);
            ((HashMap)object).put(stringArray[n], dataFlavor);
            ++n;
        }
        return object;
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        if (dataFlavor == null || string == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.flavorToNative.get(dataFlavor);
        if (arrayList == null) {
            arrayList = new ArrayList<String>(1);
            this.flavorToNative.put(dataFlavor, arrayList);
        } else if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        this.getNativesForFlavorCache.remove(dataFlavor);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        if (dataFlavor == null || stringArray == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.flavorToNative.remove(dataFlavor);
        int n = 0;
        while (n < stringArray.length) {
            this.addUnencodedNativeForFlavor(dataFlavor, stringArray[n]);
            ++n;
        }
        this.disabledMappingGenerationKeys.add(dataFlavor);
        this.getNativesForFlavorCache.remove(dataFlavor);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        ArrayList<DataFlavor> arrayList = (ArrayList<DataFlavor>)this.nativeToFlavor.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<DataFlavor>(1);
            this.nativeToFlavor.put(string, arrayList);
        } else if (arrayList.contains(dataFlavor)) {
            return;
        }
        arrayList.add(dataFlavor);
        this.getFlavorsForNativeCache.remove(string);
        this.getFlavorsForNativeCache.remove(null);
    }

    public synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        if (string == null || dataFlavorArray == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.nativeToFlavor.remove(string);
        int n = 0;
        while (n < dataFlavorArray.length) {
            this.addFlavorForUnencodedNative(string, dataFlavorArray[n]);
            ++n;
        }
        this.disabledMappingGenerationKeys.add(string);
        this.getFlavorsForNativeCache.remove(string);
        this.getFlavorsForNativeCache.remove(null);
    }

    public static String encodeJavaMIMEType(String string) {
        return string != null ? JavaMIME + string : null;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        return dataFlavor != null ? SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType()) : null;
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(JavaMIME, 0);
    }

    public static String decodeJavaMIMEType(String string) {
        return SystemFlavorMap.isJavaMIMEType(string) ? string.substring(JavaMIME.length(), string.length()).trim() : null;
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        return string2 != null ? new DataFlavor(string2) : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$awt$datatransfer$SystemFlavorMap == null ? (class$java$awt$datatransfer$SystemFlavorMap = SystemFlavorMap.class$("java.awt.datatransfer.SystemFlavorMap")) : class$java$awt$datatransfer$SystemFlavorMap).desiredAssertionStatus();
        JavaMIME = "JAVA_DATAFLAVOR:";
        flavorMaps = new WeakHashMap();
        UNICODE_TEXT_CLASSES = new String[]{"java.io.Reader", "java.lang.String", "java.nio.CharBuffer", "\"[C\""};
        ENCODED_TEXT_CLASSES = new String[]{"java.io.InputStream", "java.nio.ByteBuffer", "\"[B\""};
    }
}

