/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.color.ICC_Transform;
import sun.awt.color.ProfileDeferralMgr;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    ICC_Profile[] profileList;
    ColorSpace[] CSList;
    ICC_Transform thisTransform;
    ICC_Transform thisRasterTransform;
    ICC_Profile thisSrcProfile;
    ICC_Profile thisDestProfile;
    RenderingHints hints;
    boolean gotProfiles;
    float[] srcMinVals;
    float[] srcMaxVals;
    float[] dstMinVals;
    float[] dstMaxVals;

    public ColorConvertOp(RenderingHints renderingHints) {
        this.profileList = new ICC_Profile[0];
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace == null) {
            throw new NullPointerException("ColorSpace cannot be null");
        }
        if (colorSpace instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[1];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
        } else {
            this.CSList = new ColorSpace[1];
            this.CSList[0] = colorSpace;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace == null || colorSpace2 == null) {
            throw new NullPointerException("ColorSpaces cannot be null");
        }
        if (colorSpace instanceof ICC_ColorSpace && colorSpace2 instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[2];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
            this.profileList[1] = ((ICC_ColorSpace)colorSpace2).getProfile();
            this.getMinMaxValsFromColorSpaces(colorSpace, colorSpace2);
        } else {
            this.CSList = new ColorSpace[2];
            this.CSList[0] = colorSpace;
            this.CSList[1] = colorSpace2;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        if (iCC_ProfileArray == null) {
            throw new NullPointerException("Profiles cannot be null");
        }
        this.gotProfiles = true;
        this.profileList = new ICC_Profile[iCC_ProfileArray.length];
        int n = 0;
        while (n < iCC_ProfileArray.length) {
            this.profileList[n] = iCC_ProfileArray[n];
            ++n;
        }
        this.hints = renderingHints;
    }

    public final ICC_Profile[] getICC_Profiles() {
        if (this.gotProfiles) {
            ICC_Profile[] iCC_ProfileArray = new ICC_Profile[this.profileList.length];
            int n = 0;
            while (n < this.profileList.length) {
                iCC_ProfileArray[n] = this.profileList[n];
                ++n;
            }
            return iCC_ProfileArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorSpace colorSpace;
        Object object;
        BufferedImage bufferedImage3 = null;
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)bufferedImage.getColorModel();
            bufferedImage = ((IndexColorModel)object).convertToIntDiscrete(bufferedImage.getRaster(), true);
        }
        ColorSpace colorSpace2 = bufferedImage.getColorModel().getColorSpace();
        if (bufferedImage2 != null) {
            if (bufferedImage2.getColorModel() instanceof IndexColorModel) {
                bufferedImage3 = bufferedImage2;
                bufferedImage2 = null;
                colorSpace = null;
            } else {
                colorSpace = bufferedImage2.getColorModel().getColorSpace();
            }
        } else {
            colorSpace = null;
        }
        bufferedImage2 = this.CSList != null || !(colorSpace2 instanceof ICC_ColorSpace) || bufferedImage2 != null && !(colorSpace instanceof ICC_ColorSpace) ? this.nonICCBIFilter(bufferedImage, colorSpace2, bufferedImage2, colorSpace) : this.ICCBIFilter(bufferedImage, colorSpace2, bufferedImage2, colorSpace);
        if (bufferedImage3 != null) {
            object = bufferedImage3.createGraphics();
            try {
                ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((Graphics)object).dispose();
                throw throwable;
            }
            ((Graphics)object).dispose();
            return bufferedImage3;
        }
        return bufferedImage2;
    }

    private final BufferedImage ICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        int n = this.profileList.length;
        ICC_Profile iCC_Profile = null;
        ICC_Profile iCC_Profile2 = null;
        iCC_Profile = ((ICC_ColorSpace)colorSpace).getProfile();
        if (bufferedImage2 == null) {
            if (n == 0) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            iCC_Profile2 = this.profileList[n - 1];
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else {
            if (bufferedImage.getHeight() != bufferedImage2.getHeight() || bufferedImage.getWidth() != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Width or height of BufferedImages do not match");
            }
            iCC_Profile2 = ((ICC_ColorSpace)colorSpace2).getProfile();
        }
        if (this.thisTransform == null || this.thisSrcProfile != iCC_Profile || this.thisDestProfile != iCC_Profile2) {
            this.updateBITransform(iCC_Profile, iCC_Profile2);
        }
        this.thisTransform.colorConvert(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private void updateBITransform(ICC_Profile iCC_Profile, ICC_Profile iCC_Profile2) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = n = this.profileList.length;
        if (n == 0 || iCC_Profile != this.profileList[0]) {
            ++n2;
            bl = true;
        }
        if (n == 0 || iCC_Profile2 != this.profileList[n - 1] || n2 < 2) {
            ++n2;
            bl2 = true;
        }
        ICC_Profile[] iCC_ProfileArray = new ICC_Profile[n2];
        int n3 = 0;
        if (bl) {
            iCC_ProfileArray[n3++] = iCC_Profile;
        }
        int n4 = 0;
        while (n4 < n) {
            iCC_ProfileArray[n3++] = this.profileList[n4];
            ++n4;
        }
        if (bl2) {
            iCC_ProfileArray[n3] = iCC_Profile2;
        }
        ICC_Transform[] iCC_TransformArray = new ICC_Transform[n2];
        int n5 = iCC_ProfileArray[0].getProfileClass() == 2 ? 1 : 0;
        int n6 = 1;
        n4 = 0;
        while (n4 < n2) {
            if (n4 == n2 - 1) {
                n6 = 2;
            } else if (n6 == 4 && iCC_ProfileArray[n4].getProfileClass() == 5) {
                n5 = 0;
                n6 = 1;
            }
            iCC_TransformArray[n4] = new ICC_Transform(iCC_ProfileArray[n4], n5, n6);
            n5 = this.getRenderingIntent(iCC_ProfileArray[n4]);
            n6 = 4;
            ++n4;
        }
        this.thisTransform = new ICC_Transform(iCC_TransformArray);
        this.thisSrcProfile = iCC_Profile;
        this.thisDestProfile = iCC_Profile2;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        if (this.CSList != null) {
            return this.nonICCRasterFilter(raster, writableRaster);
        }
        int n3 = this.profileList.length;
        if (n3 < 2) {
            throw new IllegalArgumentException("Source or Destination ColorSpace is undefined");
        }
        if (raster.getNumBands() != this.profileList[0].getNumComponents()) {
            throw new IllegalArgumentException("Numbers of source Raster bands and source color space components do not match");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (writableRaster.getNumBands() != this.profileList[n3 - 1].getNumComponents()) {
                throw new IllegalArgumentException("Numbers of destination Raster bands and destination color space components do not match");
            }
        }
        if (this.thisRasterTransform == null) {
            ICC_Transform[] iCC_TransformArray = new ICC_Transform[n3];
            int n4 = this.profileList[0].getProfileClass() == 2 ? 1 : 0;
            n2 = 1;
            n = 0;
            while (n < n3) {
                if (n == n3 - 1) {
                    n2 = 2;
                } else if (n2 == 4 && this.profileList[n].getProfileClass() == 5) {
                    n4 = 0;
                    n2 = 1;
                }
                iCC_TransformArray[n] = new ICC_Transform(this.profileList[n], n4, n2);
                n4 = this.getRenderingIntent(this.profileList[n]);
                n2 = 4;
                ++n;
            }
            this.thisRasterTransform = new ICC_Transform(iCC_TransformArray);
        }
        n = raster.getTransferType();
        n2 = writableRaster.getTransferType();
        if (n == 4 || n == 5 || n2 == 4 || n2 == 5) {
            if (this.srcMinVals == null) {
                this.getMinMaxValsFromProfiles(this.profileList[0], this.profileList[n3 - 1]);
            }
            this.thisRasterTransform.colorConvert(raster, writableRaster, this.srcMinVals, this.srcMaxVals, this.dstMinVals, this.dstMaxVals);
        } else {
            this.thisRasterTransform.colorConvert(raster, writableRaster);
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        ColorSpace colorSpace = null;
        if (colorModel == null) {
            if (this.CSList == null) {
                int n = this.profileList.length;
                if (n == 0) {
                    throw new IllegalArgumentException("Destination ColorSpace is undefined");
                }
                ICC_Profile iCC_Profile = this.profileList[n - 1];
                colorSpace = new ICC_ColorSpace(iCC_Profile);
            } else {
                int n = this.CSList.length;
                colorSpace = this.CSList[n - 1];
            }
        }
        return this.createCompatibleDestImage(bufferedImage, colorModel, colorSpace);
    }

    private BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel, ColorSpace colorSpace) {
        int n;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            n = colorSpace.getNumComponents();
            boolean bl = colorModel2.hasAlpha();
            if (bl) {
                ++n;
            }
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = 8;
                ++n2;
            }
            colorModel = new ComponentColorModel(colorSpace, nArray, bl, colorModel2.isAlphaPremultiplied(), colorModel2.getTransparency(), 0);
        }
        int n3 = bufferedImage.getWidth();
        n = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        int n;
        if (this.CSList != null) {
            if (this.CSList.length != 2) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n = this.CSList[1].getNumComponents();
        } else {
            int n2 = this.profileList.length;
            if (n2 < 2) {
                throw new IllegalArgumentException("Destination ColorSpace is undefined");
            }
            n = this.profileList[n2 - 1].getNumComponents();
        }
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, raster.getWidth(), raster.getHeight(), n, new Point(raster.getMinX(), raster.getMinY()));
        return writableRaster;
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    private int getRenderingIntent(ICC_Profile iCC_Profile) {
        byte[] byArray = iCC_Profile.getData(1751474532);
        int n = 64;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    private final BufferedImage nonICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        boolean bl;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)ColorSpace.getInstance(1001);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        } else if (n2 != bufferedImage2.getHeight() || n != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Width or height of BufferedImages do not match");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n3 = colorModel.getNumColorComponents();
        int n4 = colorModel2.getNumColorComponents();
        boolean bl2 = colorModel2.hasAlpha();
        boolean bl3 = bl = colorModel.hasAlpha() && bl2;
        if (this.CSList == null && this.profileList.length != 0) {
            float[] fArray;
            int n5;
            int n6;
            int n7;
            ColorSpace colorSpace3;
            ICC_Profile iCC_Profile;
            boolean bl4;
            ICC_Profile iCC_Profile2;
            boolean bl5;
            if (!(colorSpace instanceof ICC_ColorSpace)) {
                bl5 = true;
                iCC_Profile2 = iCC_ColorSpace.getProfile();
            } else {
                bl5 = false;
                iCC_Profile2 = ((ICC_ColorSpace)colorSpace).getProfile();
            }
            if (!(colorSpace2 instanceof ICC_ColorSpace)) {
                bl4 = true;
                iCC_Profile = iCC_ColorSpace.getProfile();
            } else {
                bl4 = false;
                iCC_Profile = ((ICC_ColorSpace)colorSpace2).getProfile();
            }
            if (this.thisTransform == null || this.thisSrcProfile != iCC_Profile2 || this.thisDestProfile != iCC_Profile) {
                this.updateBITransform(iCC_Profile2, iCC_Profile);
            }
            float f = 65535.0f;
            if (bl5) {
                colorSpace3 = iCC_ColorSpace;
                n7 = 3;
            } else {
                colorSpace3 = colorSpace;
                n7 = n3;
            }
            float[] fArray2 = new float[n7];
            float[] fArray3 = new float[n7];
            int n8 = 0;
            while (n8 < n3) {
                fArray2[n8] = colorSpace3.getMinValue(n8);
                fArray3[n8] = f / (colorSpace3.getMaxValue(n8) - fArray2[n8]);
                ++n8;
            }
            if (bl4) {
                colorSpace3 = iCC_ColorSpace;
                n6 = 3;
            } else {
                colorSpace3 = colorSpace2;
                n6 = n4;
            }
            float[] fArray4 = new float[n6];
            float[] fArray5 = new float[n6];
            int n9 = 0;
            while (n9 < n4) {
                fArray4[n9] = colorSpace3.getMinValue(n9);
                fArray5[n9] = (colorSpace3.getMaxValue(n9) - fArray4[n9]) / f;
                ++n9;
            }
            if (bl2) {
                n5 = n4 + 1 > 3 ? n4 + 1 : 3;
                fArray = new float[n5];
            } else {
                n5 = n4 > 3 ? n4 : 3;
                fArray = new float[n5];
            }
            short[] sArray = new short[n * n7];
            short[] sArray2 = new short[n * n6];
            float[] fArray6 = null;
            if (bl) {
                fArray6 = new float[n];
            }
            int n10 = 0;
            while (n10 < n2) {
                int n11;
                Object object = null;
                float[] fArray7 = null;
                int n12 = 0;
                int n13 = 0;
                while (n13 < n) {
                    object = writableRaster.getDataElements(n13, n10, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    if (bl) {
                        fArray6[n13] = fArray7[n3];
                    }
                    if (bl5) {
                        fArray7 = colorSpace.toCIEXYZ(fArray7);
                    }
                    n11 = 0;
                    while (n11 < n7) {
                        sArray[n12++] = (short)((fArray7[n11] - fArray2[n11]) * fArray3[n11] + 0.5f);
                        ++n11;
                    }
                    ++n13;
                }
                this.thisTransform.colorConvert(sArray, sArray2);
                object = null;
                n12 = 0;
                n11 = 0;
                while (n11 < n) {
                    int n14 = 0;
                    while (n14 < n6) {
                        fArray[n14] = (float)(sArray2[n12++] & 0xFFFF) * fArray5[n14] + fArray4[n14];
                        ++n14;
                    }
                    if (bl4) {
                        fArray7 = colorSpace.fromCIEXYZ(fArray);
                        int n15 = 0;
                        while (n15 < n4) {
                            fArray[n15] = fArray7[n15];
                            ++n15;
                        }
                    }
                    if (bl) {
                        fArray[n4] = fArray6[n11];
                    } else if (bl2) {
                        fArray[n4] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray, 0, object);
                    writableRaster2.setDataElements(n11, n10, object);
                    ++n11;
                }
                ++n10;
            }
        } else {
            int n16 = this.CSList == null ? 0 : this.CSList.length;
            float[] fArray = bl2 ? new float[n4 + 1] : new float[n4];
            Object object = null;
            Object object2 = null;
            float[] fArray8 = null;
            int n17 = 0;
            while (n17 < n2) {
                int n18 = 0;
                while (n18 < n) {
                    object = writableRaster.getDataElements(n18, n17, object);
                    fArray8 = colorModel.getNormalizedComponents(object, fArray8, 0);
                    float[] fArray9 = colorSpace.toCIEXYZ(fArray8);
                    int n19 = 0;
                    while (n19 < n16) {
                        fArray9 = this.CSList[n19].fromCIEXYZ(fArray9);
                        fArray9 = this.CSList[n19].toCIEXYZ(fArray9);
                        ++n19;
                    }
                    fArray9 = colorSpace2.fromCIEXYZ(fArray9);
                    int n20 = 0;
                    while (n20 < n4) {
                        fArray[n20] = fArray9[n20];
                        ++n20;
                    }
                    if (bl) {
                        fArray[n4] = fArray8[n3];
                    } else if (bl2) {
                        fArray[n4] = 1.0f;
                    }
                    object2 = colorModel2.getDataElements(fArray, 0, object2);
                    writableRaster2.setDataElements(n18, n17, object2);
                    ++n18;
                }
                ++n17;
            }
        }
        return bufferedImage2;
    }

    private final WritableRaster nonICCRasterFilter(Raster raster, WritableRaster writableRaster) {
        int n;
        if (this.CSList.length != 2) {
            throw new IllegalArgumentException("Destination ColorSpace is undefined");
        }
        if (raster.getNumBands() != this.CSList[0].getNumComponents()) {
            throw new IllegalArgumentException("Numbers of source Raster bands and source color space components do not match");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (writableRaster.getNumBands() != this.CSList[1].getNumComponents()) {
                throw new IllegalArgumentException("Numbers of destination Raster bands and destination color space components do not match");
            }
        }
        if (this.srcMinVals == null) {
            this.getMinMaxValsFromColorSpaces(this.CSList[0], this.CSList[1]);
        }
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n2 = raster.getTransferType();
        int n3 = writableRaster.getTransferType();
        boolean bl = n2 == 4 || n2 == 5;
        boolean bl2 = n3 == 4 || n3 == 5;
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getNumBands();
        int n7 = writableRaster.getNumBands();
        float[] fArray = null;
        float[] fArray2 = null;
        if (!bl) {
            fArray = new float[n6];
            n = 0;
            while (n < n6) {
                fArray[n] = n2 == 2 ? (this.srcMaxVals[n] - this.srcMinVals[n]) / 32767.0f : (this.srcMaxVals[n] - this.srcMinVals[n]) / (float)((1 << sampleModel.getSampleSize(n)) - 1);
                ++n;
            }
        }
        if (!bl2) {
            fArray2 = new float[n7];
            n = 0;
            while (n < n7) {
                fArray2[n] = n3 == 2 ? 32767.0f / (this.dstMaxVals[n] - this.dstMinVals[n]) : (float)((1 << sampleModel2.getSampleSize(n)) - 1) / (this.dstMaxVals[n] - this.dstMinVals[n]);
                ++n;
            }
        }
        n = raster.getMinY();
        int n8 = writableRaster.getMinY();
        float[] fArray3 = new float[n6];
        ColorSpace colorSpace = this.CSList[0];
        ColorSpace colorSpace2 = this.CSList[1];
        int n9 = 0;
        while (n9 < n5) {
            int n10 = raster.getMinX();
            int n11 = writableRaster.getMinX();
            int n12 = 0;
            while (n12 < n4) {
                float f;
                int n13 = 0;
                while (n13 < n6) {
                    f = raster.getSampleFloat(n10, n, n13);
                    if (!bl) {
                        f = f * fArray[n13] + this.srcMinVals[n13];
                    }
                    fArray3[n13] = f;
                    ++n13;
                }
                float[] fArray4 = colorSpace.toCIEXYZ(fArray3);
                fArray4 = colorSpace2.fromCIEXYZ(fArray4);
                int n14 = 0;
                while (n14 < n7) {
                    f = fArray4[n14];
                    if (!bl2) {
                        f = (f - this.dstMinVals[n14]) * fArray2[n14];
                    }
                    writableRaster.setSample(n11, n8, n14, f);
                    ++n14;
                }
                ++n12;
                ++n10;
                ++n11;
            }
            ++n9;
            ++n;
            ++n8;
        }
        return writableRaster;
    }

    private void getMinMaxValsFromProfiles(ICC_Profile iCC_Profile, ICC_Profile iCC_Profile2) {
        int n = iCC_Profile.getColorSpaceType();
        int n2 = iCC_Profile.getNumComponents();
        this.srcMinVals = new float[n2];
        this.srcMaxVals = new float[n2];
        this.setMinMax(n, n2, this.srcMinVals, this.srcMaxVals);
        n = iCC_Profile2.getColorSpaceType();
        n2 = iCC_Profile2.getNumComponents();
        this.dstMinVals = new float[n2];
        this.dstMaxVals = new float[n2];
        this.setMinMax(n, n2, this.dstMinVals, this.dstMaxVals);
    }

    private void setMinMax(int n, int n2, float[] fArray, float[] fArray2) {
        if (n == 1) {
            fArray[0] = 0.0f;
            fArray2[0] = 100.0f;
            fArray[1] = -128.0f;
            fArray2[1] = 127.0f;
            fArray[2] = -128.0f;
            fArray2[2] = 127.0f;
        } else if (n == 0) {
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
            fArray2[2] = 1.9999695f;
            fArray2[1] = 1.9999695f;
            fArray2[0] = 1.9999695f;
        } else {
            int n3 = 0;
            while (n3 < n2) {
                fArray[n3] = 0.0f;
                fArray2[n3] = 1.0f;
                ++n3;
            }
        }
    }

    private void getMinMaxValsFromColorSpaces(ColorSpace colorSpace, ColorSpace colorSpace2) {
        int n = colorSpace.getNumComponents();
        this.srcMinVals = new float[n];
        this.srcMaxVals = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.srcMinVals[n2] = colorSpace.getMinValue(n2);
            this.srcMaxVals[n2] = colorSpace.getMaxValue(n2);
            ++n2;
        }
        n = colorSpace2.getNumComponents();
        this.dstMinVals = new float[n];
        this.dstMaxVals = new float[n];
        int n3 = 0;
        while (n3 < n) {
            this.dstMinVals[n3] = colorSpace2.getMinValue(n3);
            this.dstMaxVals[n3] = colorSpace2.getMaxValue(n3);
            ++n3;
        }
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }
}

