/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import sun.awt.NativeLibLoader;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    private static native void initIDs();

    public SampleModel(int n, int n2, int n3, int n4) {
        float f = (float)n2 * (float)n3;
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Width (" + n2 + ") and height (" + n3 + ") must be > 0");
        }
        if (f >= 2.1474836E9f) {
            throw new IllegalArgumentException("Dimensions (width=" + n2 + " height=" + n3 + ") are too large");
        }
        if (n < 0 || n > 5 && n != 32) {
            throw new IllegalArgumentException("Unsupported dataType: " + n);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("Number of bands must be > 0");
        }
        this.dataType = n;
        this.width = n2;
        this.height = n3;
        this.numBands = n4;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public abstract int getNumDataElements();

    public final int getDataType() {
        return this.dataType;
    }

    public int getTransferType() {
        return this.dataType;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            nArray2[n3] = this.getSample(n, n2, n3, dataBuffer);
            ++n3;
        }
        return nArray2;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = this.getTransferType();
        int n6 = this.getNumDataElements();
        int n7 = 0;
        Object object2 = null;
        switch (n5) {
            case 0: {
                byte[] byArray = object == null ? new byte[n6 * n3 * n4] : (byte[])object;
                int n8 = n2;
                while (n8 < n2 + n4) {
                    int n9 = n;
                    while (n9 < n + n3) {
                        object2 = this.getDataElements(n9, n8, object2, dataBuffer);
                        byte[] byArray2 = (byte[])object2;
                        int n10 = 0;
                        while (n10 < n6) {
                            byArray[n7++] = byArray2[n10];
                            ++n10;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n6 * n3 * n4] : (short[])object;
                int n11 = n2;
                while (n11 < n2 + n4) {
                    int n12 = n;
                    while (n12 < n + n3) {
                        object2 = this.getDataElements(n12, n11, object2, dataBuffer);
                        short[] sArray2 = (short[])object2;
                        int n13 = 0;
                        while (n13 < n6) {
                            sArray[n7++] = sArray2[n13];
                            ++n13;
                        }
                        ++n12;
                    }
                    ++n11;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n6 * n3 * n4] : (int[])object;
                int n14 = n2;
                while (n14 < n2 + n4) {
                    int n15 = n;
                    while (n15 < n + n3) {
                        object2 = this.getDataElements(n15, n14, object2, dataBuffer);
                        int[] nArray2 = (int[])object2;
                        int n16 = 0;
                        while (n16 < n6) {
                            nArray[n7++] = nArray2[n16];
                            ++n16;
                        }
                        ++n15;
                    }
                    ++n14;
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n6 * n3 * n4] : (float[])object;
                int n17 = n2;
                while (n17 < n2 + n4) {
                    int n18 = n;
                    while (n18 < n + n3) {
                        object2 = this.getDataElements(n18, n17, object2, dataBuffer);
                        float[] fArray2 = (float[])object2;
                        int n19 = 0;
                        while (n19 < n6) {
                            fArray[n7++] = fArray2[n19];
                            ++n19;
                        }
                        ++n18;
                    }
                    ++n17;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n6 * n3 * n4] : (double[])object;
                int n20 = n2;
                while (n20 < n2 + n4) {
                    int n21 = n;
                    while (n21 < n + n3) {
                        object2 = this.getDataElements(n21, n20, object2, dataBuffer);
                        double[] dArray2 = (double[])object2;
                        int n22 = 0;
                        while (n22 < n6) {
                            dArray[n7++] = dArray2[n22];
                            ++n22;
                        }
                        ++n21;
                    }
                    ++n20;
                }
                object = dArray;
            }
        }
        return object;
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = 0;
        Object var8_8 = null;
        int n6 = this.getTransferType();
        int n7 = this.getNumDataElements();
        switch (n6) {
            case 0: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n7];
                int n8 = n2;
                while (n8 < n2 + n4) {
                    int n9 = n;
                    while (n9 < n + n3) {
                        int n10 = 0;
                        while (n10 < n7) {
                            byArray2[n10] = byArray[n5++];
                            ++n10;
                        }
                        this.setDataElements(n9, n8, byArray2, dataBuffer);
                        ++n9;
                    }
                    ++n8;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n7];
                int n11 = n2;
                while (n11 < n2 + n4) {
                    int n12 = n;
                    while (n12 < n + n3) {
                        int n13 = 0;
                        while (n13 < n7) {
                            sArray2[n13] = sArray[n5++];
                            ++n13;
                        }
                        this.setDataElements(n12, n11, sArray2, dataBuffer);
                        ++n12;
                    }
                    ++n11;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int[] nArray2 = new int[n7];
                int n14 = n2;
                while (n14 < n2 + n4) {
                    int n15 = n;
                    while (n15 < n + n3) {
                        int n16 = 0;
                        while (n16 < n7) {
                            nArray2[n16] = nArray[n5++];
                            ++n16;
                        }
                        this.setDataElements(n15, n14, nArray2, dataBuffer);
                        ++n15;
                    }
                    ++n14;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n7];
                int n17 = n2;
                while (n17 < n2 + n4) {
                    int n18 = n;
                    while (n18 < n + n3) {
                        int n19 = 0;
                        while (n19 < n7) {
                            fArray2[n19] = fArray[n5++];
                            ++n19;
                        }
                        this.setDataElements(n18, n17, fArray2, dataBuffer);
                        ++n18;
                    }
                    ++n17;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n7];
                int n20 = n2;
                while (n20 < n2 + n4) {
                    int n21 = n;
                    while (n21 < n + n3) {
                        int n22 = 0;
                        while (n22 < n7) {
                            dArray2[n22] = dArray[n5++];
                            ++n22;
                        }
                        this.setDataElements(n21, n20, dArray2, dataBuffer);
                        ++n21;
                    }
                    ++n20;
                }
                break;
            }
        }
    }

    public float[] getPixel(int n, int n2, float[] fArray, DataBuffer dataBuffer) {
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            fArray2[n3] = this.getSampleFloat(n, n2, n3, dataBuffer);
            ++n3;
        }
        return fArray2;
    }

    public double[] getPixel(int n, int n2, double[] dArray, DataBuffer dataBuffer) {
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            dArray2[n3] = this.getSampleDouble(n, n2, n3, dataBuffer);
            ++n3;
        }
        return dArray2;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands * n3 * n4];
        int n6 = n2;
        while (n6 < n4 + n2) {
            int n7 = n;
            while (n7 < n3 + n) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    nArray2[n5++] = this.getSample(n7, n6, n8, dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return nArray2;
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray, DataBuffer dataBuffer) {
        int n5 = 0;
        float[] fArray2 = fArray != null ? fArray : new float[this.numBands * n3 * n4];
        int n6 = n2;
        while (n6 < n4 + n2) {
            int n7 = n;
            while (n7 < n3 + n) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    fArray2[n5++] = this.getSampleFloat(n7, n6, n8, dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return fArray2;
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[this.numBands * n3 * n4];
        int n6 = n2;
        while (n6 < n4 + n2) {
            int n7 = n;
            while (n7 < n3 + n) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    dArray2[n5++] = this.getSampleDouble(n7, n6, n8, dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return dArray2;
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        float f = this.getSample(n, n2, n3, dataBuffer);
        return f;
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        double d = this.getSample(n, n2, n3, dataBuffer);
        return d;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n7 = n2;
        while (n7 < n4 + n2) {
            int n8 = n;
            while (n8 < n3 + n) {
                nArray2[n6++] = this.getSample(n8, n7, n5, dataBuffer);
                ++n8;
            }
            ++n7;
        }
        return nArray2;
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        float[] fArray2 = fArray != null ? fArray : new float[n3 * n4];
        int n7 = n2;
        while (n7 < n4 + n2) {
            int n8 = n;
            while (n8 < n3 + n) {
                fArray2[n6++] = this.getSampleFloat(n8, n7, n5, dataBuffer);
                ++n8;
            }
            ++n7;
        }
        return fArray2;
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        double[] dArray2 = dArray != null ? dArray : new double[n3 * n4];
        int n7 = n2;
        while (n7 < n2 + n4) {
            int n8 = n;
            while (n8 < n + n3) {
                dArray2[n6++] = this.getSampleDouble(n8, n7, n5, dataBuffer);
                ++n8;
            }
            ++n7;
        }
        return dArray2;
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = 0;
        while (n3 < this.numBands) {
            this.setSample(n, n2, n3, nArray[n3], dataBuffer);
            ++n3;
        }
    }

    public void setPixel(int n, int n2, float[] fArray, DataBuffer dataBuffer) {
        int n3 = 0;
        while (n3 < this.numBands) {
            this.setSample(n, n2, n3, fArray[n3], dataBuffer);
            ++n3;
        }
    }

    public void setPixel(int n, int n2, double[] dArray, DataBuffer dataBuffer) {
        int n3 = 0;
        while (n3 < this.numBands) {
            this.setSample(n, n2, n3, dArray[n3], dataBuffer);
            ++n3;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    this.setSample(n7, n6, n8, nArray[n5++], dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    this.setSample(n7, n6, n8, fArray[n5++], dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n4) {
            int n7 = n;
            while (n7 < n + n3) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    this.setSample(n7, n6, n8, dArray[n5++], dataBuffer);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        int n4 = (int)f;
        this.setSample(n, n2, n3, n4, dataBuffer);
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        int n4 = (int)d;
        this.setSample(n, n2, n3, n4, dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n2;
        while (n7 < n2 + n4) {
            int n8 = n;
            while (n8 < n + n3) {
                this.setSample(n8, n7, n5, nArray[n6++], dataBuffer);
                ++n8;
            }
            ++n7;
        }
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n2;
        while (n7 < n2 + n4) {
            int n8 = n;
            while (n8 < n + n3) {
                this.setSample(n8, n7, n5, fArray[n6++], dataBuffer);
                ++n8;
            }
            ++n7;
        }
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = 0;
        int n7 = n2;
        while (n7 < n2 + n4) {
            int n8 = n;
            while (n8 < n + n3) {
                this.setSample(n8, n7, n5, dArray[n6++], dataBuffer);
                ++n8;
            }
            ++n7;
        }
    }

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public abstract DataBuffer createDataBuffer();

    public abstract int[] getSampleSize();

    public abstract int getSampleSize(int var1);

    static {
        NativeLibLoader.loadLibraries();
        SampleModel.initIDs();
    }
}

