/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.TimerQueue;

public class JApplet
extends Applet
implements Accessible,
RootPaneContainer {
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JApplet() throws HeadlessException {
        TimerQueue timerQueue = TimerQueue.sharedInstance();
        if (timerQueue != null) {
            TimerQueue timerQueue2 = timerQueue;
            synchronized (timerQueue2) {
                if (!timerQueue.running) {
                    timerQueue.start();
                }
            }
        }
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setLocale(JComponent.getDefaultLocale());
        this.setLayout(new BorderLayout());
        this.setRootPane(this.createRootPane());
        this.setRootPaneCheckingEnabled(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy());
        this.enableEvents(8L);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.setRootPaneCheckingEnabled(bl);
                throw throwable;
            }
        }
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    protected String paramString() {
        String string = this.rootPane != null ? this.rootPane.toString() : "";
        String string2 = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",rootPane=" + string + ",rootPaneCheckingEnabled=" + string2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJApplet();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJApplet
    extends Applet.AccessibleApplet {
        protected AccessibleJApplet() {
        }
    }
}

