/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = new MenuSelectionManager();
    private Vector selection = new Vector();
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public static MenuSelectionManager defaultManager() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedPath(MenuElement[] menuElementArray) {
        Object object;
        int n = 0;
        if (menuElementArray == null) {
            menuElementArray = new MenuElement[]{};
        }
        if (menuElementArray.length > 0) {
            if (menuElementArray[menuElementArray.length - 1] instanceof JMenuItem) {
                object = (JComponent)((Object)menuElementArray[menuElementArray.length - 1]);
                ((JComponent)object).scrollRectToVisible(new Rectangle(0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight()));
            } else if (menuElementArray.length > 1 && menuElementArray[menuElementArray.length - 1] instanceof JPopupMenu && menuElementArray[menuElementArray.length - 2] instanceof JMenuItem) {
                object = (JComponent)((Object)menuElementArray[menuElementArray.length - 2]);
                ((JComponent)object).scrollRectToVisible(new Rectangle(0, 0, ((JComponent)object).getWidth(), ((JComponent)object).getHeight()));
            }
        }
        object = this;
        synchronized (object) {
            int n2 = this.selection.size();
            int n3 = 0;
            int n4 = menuElementArray.length;
            while (n3 < n4) {
                if (n3 >= n2 || (MenuElement)this.selection.elementAt(n3) != menuElementArray[n3]) break;
                ++n;
                ++n3;
            }
            n3 = n2 - 1;
            while (n3 >= n) {
                MenuElement menuElement = (MenuElement)this.selection.elementAt(n3);
                this.selection.removeElementAt(n3);
                menuElement.menuSelectionChanged(false);
                --n3;
            }
            n3 = n;
            n4 = menuElementArray.length;
            while (n3 < n4) {
                if (menuElementArray[n3] != null) {
                    this.selection.addElement(menuElementArray[n3]);
                    menuElementArray[n3].menuSelectionChanged(true);
                }
                ++n3;
            }
        }
        this.fireStateChanged();
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] menuElementArray = new MenuElement[this.selection.size()];
        int n = 0;
        int n2 = this.selection.size();
        while (n < n2) {
            menuElementArray[n] = (MenuElement)this.selection.elementAt(n);
            ++n;
        }
        return menuElementArray;
    }

    public void clearSelectedPath() {
        if (this.selection.size() > 0) {
            this.setSelectedPath(null);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MenuSelectionManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MenuSelectionManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = MenuSelectionManager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? MenuSelectionManager.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            return;
        }
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getModifiers();
        if ((n == 504 || n == 505) && (n2 & 0x1C) != 0) {
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        int n3 = point.x;
        int n4 = point.y;
        Vector vector = (Vector)this.selection.clone();
        int n5 = vector.size();
        boolean bl = false;
        int n6 = n5 - 1;
        while (n6 >= 0 && !bl) {
            Container container;
            MenuElement menuElement = (MenuElement)vector.elementAt(n6);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            JViewport jViewport = null;
            Container container2 = ((Component)((Object)menuElement)).getParent();
            if (container2 != null && container2 instanceof JPanel && (container = container2.getParent()) != null && container instanceof JViewport) {
                jViewport = (JViewport)container;
            }
            MenuElement[] menuElementArray2 = null;
            int n7 = 0;
            int n8 = menuElementArray.length;
            while (n7 < n8 && !bl) {
                Component component2;
                if (menuElementArray[n7] != null && (component2 = menuElementArray[n7].getComponent()).isShowing() && (jViewport == null || jViewport.getViewRect().intersects(component2.getBounds()))) {
                    int n9;
                    int n10;
                    if (component2 instanceof JComponent) {
                        n10 = ((JComponent)component2).getWidth();
                        n9 = ((JComponent)component2).getHeight();
                    } else {
                        Rectangle rectangle = component2.getBounds();
                        n10 = rectangle.width;
                        n9 = rectangle.height;
                    }
                    point.x = n3;
                    point.y = n4;
                    SwingUtilities.convertPointFromScreen(point, component2);
                    if (point.x >= 0 && point.x < n10 && point.y >= 0 && point.y < n9) {
                        Serializable serializable;
                        if (menuElementArray2 == null) {
                            menuElementArray2 = new MenuElement[n6 + 2];
                            int n11 = 0;
                            while (n11 <= n6) {
                                menuElementArray2[n11] = (MenuElement)vector.elementAt(n11);
                                ++n11;
                            }
                        }
                        menuElementArray2[n6 + 1] = menuElementArray[n7];
                        MenuElement[] menuElementArray3 = this.getSelectedPath();
                        if (menuElementArray3[menuElementArray3.length - 1] != menuElementArray2[n6 + 1] && (menuElementArray3.length < 2 || menuElementArray3[menuElementArray3.length - 2] != menuElementArray2[n6 + 1])) {
                            serializable = menuElementArray3[menuElementArray3.length - 1].getComponent();
                            MouseEvent mouseEvent2 = new MouseEvent((Component)serializable, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            menuElementArray3[menuElementArray3.length - 1].processMouseEvent(mouseEvent2, menuElementArray2, this);
                            MouseEvent mouseEvent3 = new MouseEvent(component2, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            menuElementArray[n7].processMouseEvent(mouseEvent3, menuElementArray2, this);
                        }
                        serializable = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        menuElementArray[n7].processMouseEvent((MouseEvent)serializable, menuElementArray2, this);
                        bl = true;
                        mouseEvent.consume();
                    }
                }
                ++n7;
            }
            --n6;
        }
    }

    private void printMenuElementArray(MenuElement[] menuElementArray) {
        this.printMenuElementArray(menuElementArray, false);
    }

    private void printMenuElementArray(MenuElement[] menuElementArray, boolean bl) {
        System.out.println("Path is(");
        int n = 0;
        int n2 = menuElementArray.length;
        while (n < n2) {
            int n3 = 0;
            while (n3 <= n) {
                System.out.print("  ");
                ++n3;
            }
            MenuElement menuElement = menuElementArray[n];
            if (menuElement instanceof JMenuItem) {
                System.out.println(((JMenuItem)menuElement).getText() + ", ");
            } else if (menuElement instanceof JMenuBar) {
                System.out.println("JMenuBar, ");
            } else if (menuElement instanceof JPopupMenu) {
                System.out.println("JPopupMenu, ");
            } else if (menuElement == null) {
                System.out.println("NULL , ");
            } else {
                System.out.println("" + menuElement + ", ");
            }
            ++n;
        }
        System.out.println(")");
        if (bl) {
            Thread.dumpStack();
        }
    }

    public Component componentForPoint(Component component, Point point) {
        Point point2 = point;
        SwingUtilities.convertPointToScreen(point2, component);
        int n = point2.x;
        int n2 = point2.y;
        Vector vector = (Vector)this.selection.clone();
        int n3 = vector.size();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n4);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            int n5 = 0;
            int n6 = menuElementArray.length;
            while (n5 < n6) {
                Component component2;
                if (menuElementArray[n5] != null && (component2 = menuElementArray[n5].getComponent()).isShowing()) {
                    int n7;
                    int n8;
                    if (component2 instanceof JComponent) {
                        n8 = ((JComponent)component2).getWidth();
                        n7 = ((JComponent)component2).getHeight();
                    } else {
                        Rectangle rectangle = component2.getBounds();
                        n8 = rectangle.width;
                        n7 = rectangle.height;
                    }
                    point2.x = n;
                    point2.y = n2;
                    SwingUtilities.convertPointFromScreen(point2, component2);
                    if (point2.x >= 0 && point2.x < n8 && point2.y >= 0 && point2.y < n7) {
                        return component2;
                    }
                }
                ++n5;
            }
            --n4;
        }
        return null;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        Vector vector = (Vector)this.selection.clone();
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            MenuElement menuElement = (MenuElement)vector.elementAt(n2);
            MenuElement[] menuElementArray = menuElement.getSubElements();
            MenuElement[] menuElementArray2 = null;
            int n3 = 0;
            int n4 = menuElementArray.length;
            while (n3 < n4) {
                Component component;
                if (menuElementArray[n3] != null && (component = menuElementArray[n3].getComponent()).isShowing()) {
                    if (menuElementArray2 == null) {
                        menuElementArray2 = new MenuElement[n2 + 2];
                        int n5 = 0;
                        while (n5 <= n2) {
                            menuElementArray2[n5] = (MenuElement)vector.elementAt(n5);
                            ++n5;
                        }
                    }
                    menuElementArray2[n2 + 1] = menuElementArray[n3];
                    menuElementArray[n3].processKeyEvent(keyEvent, menuElementArray2, this);
                    if (keyEvent.isConsumed()) {
                        return;
                    }
                }
                ++n3;
            }
            --n2;
        }
    }

    public boolean isComponentPartOfCurrentMenu(Component component) {
        if (this.selection.size() > 0) {
            MenuElement menuElement = (MenuElement)this.selection.elementAt(0);
            return this.isComponentPartOfCurrentMenu(menuElement, component);
        }
        return false;
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement menuElement, Component component) {
        if (menuElement == null) {
            return false;
        }
        if (menuElement.getComponent() == component) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n = 0;
        int n2 = menuElementArray.length;
        while (n < n2) {
            if (this.isComponentPartOfCurrentMenu(menuElementArray[n], component)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

