/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.Popup;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class PopupFactory {
    private static final Object SharedInstanceKey = new StringBuffer("PopupFactory.SharedInstanceKey");
    private static final int MAX_CACHE_SIZE = 5;
    static final int LIGHT_WEIGHT_POPUP = 0;
    static final int MEDIUM_WEIGHT_POPUP = 1;
    static final int HEAVY_WEIGHT_POPUP = 2;
    private int popupType = 0;
    static /* synthetic */ Class class$javax$swing$PopupFactory$HeavyWeightPopup;
    static /* synthetic */ Class class$javax$swing$PopupFactory$LightWeightPopup;
    static /* synthetic */ Class class$javax$swing$PopupFactory$MediumWeightPopup;

    public static void setSharedInstance(PopupFactory popupFactory) {
        if (popupFactory == null) {
            throw new IllegalArgumentException("PopupFactory can not be null");
        }
        SwingUtilities.appContextPut(SharedInstanceKey, popupFactory);
    }

    public static PopupFactory getSharedInstance() {
        PopupFactory popupFactory = (PopupFactory)SwingUtilities.appContextGet(SharedInstanceKey);
        if (popupFactory == null) {
            popupFactory = new PopupFactory();
            PopupFactory.setSharedInstance(popupFactory);
        }
        return popupFactory;
    }

    void setPopupType(int n) {
        this.popupType = n;
    }

    int getPopupType() {
        return this.popupType;
    }

    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        if (component2 == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        int n3 = this.getPopupType(component, component2, n, n2);
        Popup popup = this.getPopup(component, component2, n, n2, n3);
        if (popup == null) {
            popup = this.getPopup(component, component2, n, n2, 2);
        }
        return popup;
    }

    private int getPopupType(Component component, Component component2, int n, int n2) {
        int n3 = this.getPopupType();
        if (component == null || this.invokerInHeavyWeightPopup(component)) {
            n3 = 2;
        } else if (n3 == 0 && !(component2 instanceof JToolTip) && !(component2 instanceof JPopupMenu)) {
            n3 = 1;
        }
        return n3;
    }

    private Popup getPopup(Component component, Component component2, int n, int n2, int n3) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.getHeadlessPopup(component, component2, n, n2);
        }
        switch (n3) {
            case 0: {
                return this.getLightWeightPopup(component, component2, n, n2);
            }
            case 1: {
                return this.getMediumWeightPopup(component, component2, n, n2);
            }
            case 2: {
                return this.getHeavyWeightPopup(component, component2, n, n2);
            }
        }
        return null;
    }

    private Popup getHeadlessPopup(Component component, Component component2, int n, int n2) {
        return HeadlessPopup.getHeadlessPopup(component, component2, n, n2);
    }

    private Popup getLightWeightPopup(Component component, Component component2, int n, int n2) {
        return LightWeightPopup.getLightWeightPopup(component, component2, n, n2);
    }

    private Popup getMediumWeightPopup(Component component, Component component2, int n, int n2) {
        return MediumWeightPopup.getMediumWeightPopup(component, component2, n, n2);
    }

    private Popup getHeavyWeightPopup(Component component, Component component2, int n, int n2) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.getMediumWeightPopup(component, component2, n, n2);
        }
        return HeavyWeightPopup.getHeavyWeightPopup(component, component2, n, n2);
    }

    private boolean invokerInHeavyWeightPopup(Component component) {
        if (component != null) {
            Container container = component.getParent();
            while (container != null) {
                if (container instanceof Popup.HeavyWeightWindow) {
                    return true;
                }
                container = container.getParent();
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MediumWeightPopup
    extends ContainerPopup {
        private static final Object mediumWeightPopupCacheKey = new StringBuffer("PopupFactory.mediumPopupCache");
        private JRootPane rootPane;

        private MediumWeightPopup() {
        }

        static Popup getMediumWeightPopup(Component component, Component component2, int n, int n2) {
            MediumWeightPopup mediumWeightPopup = MediumWeightPopup.getRecycledMediumWeightPopup();
            if (mediumWeightPopup == null) {
                mediumWeightPopup = new MediumWeightPopup();
            }
            mediumWeightPopup.reset(component, component2, n, n2);
            if (!mediumWeightPopup.fitsOnScreen() || mediumWeightPopup.overlappedByOwnedWindow()) {
                mediumWeightPopup.hide();
                return null;
            }
            return mediumWeightPopup;
        }

        private static List getMediumWeightPopupCache(AppContext appContext) {
            ArrayList arrayList = (ArrayList)appContext.get(mediumWeightPopupCacheKey);
            if (arrayList == null) {
                arrayList = new ArrayList();
                appContext.put(mediumWeightPopupCacheKey, arrayList);
            }
            return arrayList;
        }

        private static List getMediumWeightPopupCache() {
            return MediumWeightPopup.getMediumWeightPopupCache(AppContext.getAppContext());
        }

        private static List getMediumWeightPopupCache(Popup popup) {
            return MediumWeightPopup.getMediumWeightPopupCache(SunToolkit.targetToAppContext(popup.getComponent()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleMediumWeightPopup(MediumWeightPopup mediumWeightPopup) {
            Class clazz = class$javax$swing$PopupFactory$MediumWeightPopup == null ? (class$javax$swing$PopupFactory$MediumWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$MediumWeightPopup")) : class$javax$swing$PopupFactory$MediumWeightPopup;
            synchronized (clazz) {
                List list = MediumWeightPopup.getMediumWeightPopupCache(mediumWeightPopup);
                if (list.size() < 5) {
                    list.add(mediumWeightPopup);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MediumWeightPopup getRecycledMediumWeightPopup() {
            Class clazz = class$javax$swing$PopupFactory$MediumWeightPopup == null ? (class$javax$swing$PopupFactory$MediumWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$MediumWeightPopup")) : class$javax$swing$PopupFactory$MediumWeightPopup;
            synchronized (clazz) {
                List list = MediumWeightPopup.getMediumWeightPopupCache();
                int n = list.size();
                if (n > 0) {
                    MediumWeightPopup mediumWeightPopup = (MediumWeightPopup)list.get(0);
                    list.remove(0);
                    return mediumWeightPopup;
                }
                return null;
            }
        }

        public void hide() {
            super.hide();
            this.rootPane.getContentPane().removeAll();
            MediumWeightPopup.recycleMediumWeightPopup(this);
        }

        public void show() {
            Component component = this.getComponent();
            Container container = null;
            if (this.owner != null) {
                container = this.owner.getParent();
            }
            while (!(container instanceof Window) && !(container instanceof Applet) && container != null) {
                container = container.getParent();
            }
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getLayeredPane();
                Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
                component.setVisible(false);
                component.setLocation(point.x, point.y);
                ((JLayeredPane)container).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
                component.setLocation(point.x, point.y);
                component.setVisible(false);
                container.add(component);
            }
            component.setVisible(true);
        }

        Component createComponent(Component component) {
            Panel panel = new Panel(new BorderLayout());
            this.rootPane = new JRootPane();
            panel.add((Component)this.rootPane, "Center");
            return panel;
        }

        void reset(Component component, Component component2, int n, int n2) {
            super.reset(component, component2, n, n2);
            Component component3 = this.getComponent();
            component3.setLocation(n, n2);
            this.rootPane.getContentPane().add(component2, "Center");
            component2.invalidate();
            component3.validate();
            this.pack();
        }
    }

    private static class LightWeightPopup
    extends ContainerPopup {
        private static final Object lightWeightPopupCacheKey = new StringBuffer("PopupFactory.lightPopupCache");

        private LightWeightPopup() {
        }

        static Popup getLightWeightPopup(Component component, Component component2, int n, int n2) {
            LightWeightPopup lightWeightPopup = LightWeightPopup.getRecycledLightWeightPopup();
            if (lightWeightPopup == null) {
                lightWeightPopup = new LightWeightPopup();
            }
            lightWeightPopup.reset(component, component2, n, n2);
            if (!lightWeightPopup.fitsOnScreen() || lightWeightPopup.overlappedByOwnedWindow()) {
                lightWeightPopup.hide();
                return null;
            }
            return lightWeightPopup;
        }

        private static List getLightWeightPopupCache(AppContext appContext) {
            ArrayList arrayList = (ArrayList)appContext.get(lightWeightPopupCacheKey);
            if (arrayList == null) {
                arrayList = new ArrayList();
                appContext.put(lightWeightPopupCacheKey, arrayList);
            }
            return arrayList;
        }

        private static List getLightWeightPopupCache() {
            return LightWeightPopup.getLightWeightPopupCache(AppContext.getAppContext());
        }

        private static List getLightWeightPopupCache(Popup popup) {
            return LightWeightPopup.getLightWeightPopupCache(SunToolkit.targetToAppContext(popup.getComponent()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleLightWeightPopup(LightWeightPopup lightWeightPopup) {
            Class clazz = class$javax$swing$PopupFactory$LightWeightPopup == null ? (class$javax$swing$PopupFactory$LightWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$LightWeightPopup")) : class$javax$swing$PopupFactory$LightWeightPopup;
            synchronized (clazz) {
                List list = LightWeightPopup.getLightWeightPopupCache(lightWeightPopup);
                if (list.size() < 5) {
                    list.add(lightWeightPopup);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static LightWeightPopup getRecycledLightWeightPopup() {
            Class clazz = class$javax$swing$PopupFactory$LightWeightPopup == null ? (class$javax$swing$PopupFactory$LightWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$LightWeightPopup")) : class$javax$swing$PopupFactory$LightWeightPopup;
            synchronized (clazz) {
                List list = LightWeightPopup.getLightWeightPopupCache();
                int n = list.size();
                if (n > 0) {
                    LightWeightPopup lightWeightPopup = (LightWeightPopup)list.get(0);
                    list.remove(0);
                    return lightWeightPopup;
                }
                return null;
            }
        }

        public void hide() {
            super.hide();
            Container container = (Container)this.getComponent();
            container.removeAll();
            LightWeightPopup.recycleLightWeightPopup(this);
        }

        public void show() {
            Container container = null;
            if (this.owner != null) {
                container = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
            }
            Container container2 = container;
            while (container2 != null) {
                if (container2 instanceof JRootPane) {
                    if (!(container2.getParent() instanceof JInternalFrame)) {
                        container = ((JRootPane)container2).getLayeredPane();
                    }
                } else {
                    if (container2 instanceof Window) {
                        if (container != null) break;
                        container = container2;
                        break;
                    }
                    if (container2 instanceof JApplet) break;
                }
                container2 = container2.getParent();
            }
            Point point = SwingUtilities.convertScreenLocationToParent(container, this.x, this.y);
            Component component = this.getComponent();
            component.setLocation(point.x, point.y);
            if (container instanceof JLayeredPane) {
                ((JLayeredPane)container).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                container.add(component);
            }
        }

        Component createComponent(Component component) {
            JPanel jPanel = new JPanel(new BorderLayout(), true);
            jPanel.setOpaque(true);
            return jPanel;
        }

        void reset(Component component, Component component2, int n, int n2) {
            super.reset(component, component2, n, n2);
            JComponent jComponent = (JComponent)this.getComponent();
            jComponent.setLocation(n, n2);
            jComponent.add(component2, "Center");
            component2.invalidate();
            this.pack();
        }
    }

    private static class HeadlessPopup
    extends ContainerPopup {
        private HeadlessPopup() {
        }

        static Popup getHeadlessPopup(Component component, Component component2, int n, int n2) {
            HeadlessPopup headlessPopup = new HeadlessPopup();
            headlessPopup.reset(component, component2, n, n2);
            return headlessPopup;
        }

        Component createComponent(Component component) {
            return new Panel(new BorderLayout());
        }

        public void show() {
        }

        public void hide() {
        }
    }

    private static class ContainerPopup
    extends Popup {
        Component owner;
        int x;
        int y;

        private ContainerPopup() {
        }

        public void hide() {
            Container container;
            Component component = this.getComponent();
            if (component != null && (container = component.getParent()) != null) {
                Rectangle rectangle = component.getBounds();
                container.remove(component);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.owner = null;
        }

        public void pack() {
            Component component = this.getComponent();
            if (component != null) {
                component.setSize(component.getPreferredSize());
            }
        }

        void reset(Component component, Component component2, int n, int n2) {
            if (component instanceof JFrame || component instanceof JDialog || component instanceof JWindow) {
                component = ((RootPaneContainer)((Object)component)).getLayeredPane();
            }
            super.reset(component, component2, n, n2);
            this.x = n;
            this.y = n2;
            this.owner = component;
        }

        boolean overlappedByOwnedWindow() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                Window window = SwingUtilities.getWindowAncestor(this.owner);
                if (window == null) {
                    return false;
                }
                Window[] windowArray = window.getOwnedWindows();
                if (windowArray != null) {
                    Rectangle rectangle = component.getBounds();
                    int n = 0;
                    while (n < windowArray.length) {
                        if (rectangle.intersects(windowArray[n].getBounds()) && windowArray[n].isVisible()) {
                            return true;
                        }
                        ++n;
                    }
                }
            }
            return false;
        }

        boolean fitsOnScreen() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                int n = component.getWidth();
                int n2 = component.getHeight();
                Container container = this.owner.getParent();
                while (container != null) {
                    if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                        Rectangle rectangle = container.getBounds();
                        Insets insets = container.getInsets();
                        rectangle.x += insets.left;
                        rectangle.y += insets.top;
                        rectangle.width -= insets.left + insets.right;
                        rectangle.height -= insets.top + insets.bottom;
                        return SwingUtilities.isRectangleContainingRectangle(rectangle, new Rectangle(this.x, this.y, n, n2));
                    }
                    if (container instanceof JApplet) {
                        Rectangle rectangle = container.getBounds();
                        Point point = container.getLocationOnScreen();
                        rectangle.x = point.x;
                        rectangle.y = point.y;
                        return SwingUtilities.isRectangleContainingRectangle(rectangle, new Rectangle(this.x, this.y, n, n2));
                    }
                    if (container instanceof Window || container instanceof Applet) break;
                    container = container.getParent();
                }
            }
            return false;
        }
    }

    private static class HeavyWeightPopup
    extends Popup {
        private static final Object heavyWeightPopupCacheKey = new StringBuffer("PopupFactory.heavyWeightPopupCache");
        static WindowAdapter l = null;

        private HeavyWeightPopup() {
        }

        static Popup getHeavyWeightPopup(Component component, Component component2, int n, int n2) {
            Container container;
            Window window = component != null ? SwingUtilities.getWindowAncestor(component) : null;
            HeavyWeightPopup heavyWeightPopup = null;
            if (window != null) {
                heavyWeightPopup = HeavyWeightPopup.getRecycledHeavyWeightPopup(window);
            }
            boolean bl = false;
            if (component2 != null && component2.isFocusable() && component2 instanceof JPopupMenu) {
                container = (JPopupMenu)component2;
                Component[] componentArray = container.getComponents();
                int n3 = 0;
                while (n3 < componentArray.length) {
                    if (!(componentArray[n3] instanceof MenuElement) && !(componentArray[n3] instanceof JSeparator)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (heavyWeightPopup == null || ((JWindow)heavyWeightPopup.getComponent()).getFocusableWindowState() != bl) {
                if (heavyWeightPopup != null) {
                    heavyWeightPopup._dispose();
                }
                heavyWeightPopup = new HeavyWeightPopup();
            }
            heavyWeightPopup.reset(component, component2, n, n2);
            if (bl) {
                container = (JWindow)heavyWeightPopup.getComponent();
                ((Window)container).setFocusableWindowState(true);
                container.setName("###focusableSwingPopup###");
            }
            return heavyWeightPopup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static HeavyWeightPopup getRecycledHeavyWeightPopup(Window window) {
            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache();
                if (!map.containsKey(window)) {
                    return null;
                }
                List list = (List)map.get(window);
                int n = list.size();
                if (n > 0) {
                    HeavyWeightPopup heavyWeightPopup = (HeavyWeightPopup)list.get(0);
                    list.remove(0);
                    return heavyWeightPopup;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Map getHeavyWeightPopupCache(AppContext appContext) {
            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                HashMap hashMap = (HashMap)appContext.get(heavyWeightPopupCacheKey);
                if (hashMap == null) {
                    hashMap = new HashMap(2);
                    appContext.put(heavyWeightPopupCacheKey, hashMap);
                }
                return hashMap;
            }
        }

        private static Map getHeavyWeightPopupCache() {
            return HeavyWeightPopup.getHeavyWeightPopupCache(AppContext.getAppContext());
        }

        private static Map getHeavyWeightPopupCache(Popup popup) {
            return HeavyWeightPopup.getHeavyWeightPopupCache(SunToolkit.targetToAppContext(popup.getComponent()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void recycleHeavyWeightPopup(HeavyWeightPopup heavyWeightPopup) {
            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
            synchronized (clazz) {
                List<HeavyWeightPopup> list;
                Window window = SwingUtilities.getWindowAncestor(heavyWeightPopup.getComponent());
                Map map = HeavyWeightPopup.getHeavyWeightPopupCache(heavyWeightPopup);
                if (window instanceof Popup.DefaultFrame || !window.isVisible()) {
                    heavyWeightPopup._dispose();
                    return;
                }
                if (map.containsKey(window)) {
                    list = (List)map.get(window);
                } else {
                    list = new ArrayList();
                    map.put(window, list);
                    Window window2 = window;
                    window2.addWindowListener(new WindowAdapter(heavyWeightPopup, window2){
                        private final /* synthetic */ HeavyWeightPopup val$popup;
                        private final /* synthetic */ Window val$w;
                        {
                            this.val$popup = heavyWeightPopup;
                            this.val$w = window;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void windowClosed(WindowEvent windowEvent) {
                            List list;
                            Class clazz = class$javax$swing$PopupFactory$HeavyWeightPopup == null ? (class$javax$swing$PopupFactory$HeavyWeightPopup = PopupFactory.class$("javax.swing.PopupFactory$HeavyWeightPopup")) : class$javax$swing$PopupFactory$HeavyWeightPopup;
                            synchronized (clazz) {
                                Map map = HeavyWeightPopup.access$000(this.val$popup);
                                list = (List)map.remove(this.val$w);
                            }
                            if (list != null) {
                                int n = list.size() - 1;
                                while (n >= 0) {
                                    ((HeavyWeightPopup)list.get(n))._dispose();
                                    --n;
                                }
                            }
                        }
                    });
                }
                if (list.size() < 5) {
                    list.add(heavyWeightPopup);
                } else {
                    heavyWeightPopup._dispose();
                }
            }
        }

        public void show() {
            super.show();
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (window != null) {
                l = new WindowAdapter(this, window){
                    private final /* synthetic */ Window val$window;
                    private final /* synthetic */ HeavyWeightPopup this$0;
                    {
                        this.this$0 = heavyWeightPopup;
                        this.val$window = window;
                    }

                    public void windowIconified(WindowEvent windowEvent) {
                        this.this$0._dispose();
                        this.val$window.removeWindowListener(HeavyWeightPopup.l);
                    }
                };
                window.addWindowListener(l);
            }
        }

        public void hide() {
            super.hide();
            HeavyWeightPopup.recycleHeavyWeightPopup(this);
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (window != null) {
                window.removeWindowListener(l);
            }
        }

        void dispose() {
        }

        void _dispose() {
            super.dispose();
        }

        static /* synthetic */ Map access$000(Popup popup) {
            return HeavyWeightPopup.getHeavyWeightPopupCache(popup);
        }
    }
}

