/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.VolatileImage;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;
import sun.security.action.GetPropertyAction;

public class RepaintManager {
    private Map volatileMap = new HashMap(1);
    Hashtable dirtyComponents = new Hashtable();
    Hashtable tmpDirtyComponents = new Hashtable();
    Vector invalidComponents;
    boolean doubleBufferingEnabled = true;
    private Dimension doubleBufferMaxSize;
    DoubleBufferInfo standardDoubleBuffer;
    private static final Object repaintManagerKey = class$javax$swing$RepaintManager == null ? (class$javax$swing$RepaintManager = RepaintManager.class$("javax.swing.RepaintManager")) : class$javax$swing$RepaintManager;
    static boolean volatileImageBufferEnabled = true;
    static final int VOLATILE_LOOP_MAX = 2;
    Rectangle tmp = new Rectangle();
    static /* synthetic */ Class class$javax$swing$RepaintManager;

    public static RepaintManager currentManager(Component component) {
        RepaintManager repaintManager = (RepaintManager)SwingUtilities.appContextGet(repaintManagerKey);
        if (repaintManager == null) {
            repaintManager = new RepaintManager();
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (repaintManager != null) {
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        } else {
            SwingUtilities.appContextRemove(repaintManagerKey);
        }
    }

    public RepaintManager() {
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                boolean bl = Boolean.getBoolean("awt.nativeDoubleBuffering");
                RepaintManager.this.doubleBufferingEnabled = !bl;
            }
        });
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Component component = null;
        Container container = jComponent;
        while (container != null) {
            if (container instanceof CellRendererPane || container.getPeer() == null) {
                return;
            }
            if (container instanceof JComponent && container.isValidateRoot()) {
                component = container;
                break;
            }
            container = container.getParent();
        }
        if (component == null) {
            return;
        }
        Component component2 = null;
        Component component3 = component;
        while (component3 != null) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (component3 instanceof Window || component3 instanceof Applet) {
                component2 = component3;
                break;
            }
            component3 = component3.getParent();
        }
        if (component2 == null) {
            return;
        }
        if (this.invalidComponents == null) {
            this.invalidComponents = new Vector();
        } else {
            int n = this.invalidComponents.size();
            int n2 = 0;
            while (n2 < n) {
                if (component == (Component)this.invalidComponents.elementAt(n2)) {
                    return;
                }
                ++n2;
            }
        }
        this.invalidComponents.addElement(component);
        SystemEventQueueUtilities.queueComponentWorkRequest(component2);
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        int n;
        if (this.invalidComponents != null && (n = this.invalidComponents.indexOf(jComponent)) != -1) {
            this.invalidComponents.removeElementAt(n);
        }
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0 || jComponent == null) {
            return;
        }
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle != null) {
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            return;
        }
        JComponent jComponent2 = null;
        Container container = jComponent;
        while (container != null) {
            if (!container.isVisible() || container.getPeer() == null) {
                return;
            }
            if (container instanceof Window || container instanceof Applet) {
                if (container instanceof Frame && (((Frame)container).getExtendedState() & 1) == 1) {
                    return;
                }
                jComponent2 = container;
                break;
            }
            container = container.getParent();
        }
        if (jComponent2 == null) {
            return;
        }
        this.dirtyComponents.put(jComponent, new Rectangle(n, n2, n3, n4));
        SystemEventQueueUtilities.queueComponentWorkRequest(jComponent2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = null;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(rectangle);
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            this.dirtyComponents.remove(jComponent);
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        return rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInvalidComponents() {
        Vector vector;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.invalidComponents == null) {
                return;
            }
            vector = this.invalidComponents;
            this.invalidComponents = null;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Component)vector.elementAt(n2)).validate();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyRegions() {
        JComponent jComponent;
        Cloneable cloneable;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            cloneable = this.tmpDirtyComponents;
            this.tmpDirtyComponents = this.dirtyComponents;
            this.dirtyComponents = cloneable;
            this.dirtyComponents.clear();
        }
        int n = this.tmpDirtyComponents.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector vector = new Vector(n);
        Enumeration enumeration = this.tmpDirtyComponents.keys();
        while (enumeration.hasMoreElements()) {
            jComponent = (JComponent)enumeration.nextElement();
            this.collectDirtyComponents(this.tmpDirtyComponents, jComponent, vector);
        }
        n = vector.size();
        int n6 = 0;
        while (n6 < n) {
            jComponent = (JComponent)vector.elementAt(n6);
            cloneable = (Rectangle)this.tmpDirtyComponents.get(jComponent);
            n4 = jComponent.getHeight();
            n5 = jComponent.getWidth();
            SwingUtilities.computeIntersection(n2, n3, n5, n4, (Rectangle)cloneable);
            jComponent.paintImmediately(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            ++n6;
        }
        this.tmpDirtyComponents.clear();
    }

    void collectDirtyComponents(Hashtable hashtable, JComponent jComponent, Vector vector) {
        Container container;
        JComponent jComponent2;
        Container container2 = jComponent2 = jComponent;
        Rectangle rectangle = jComponent._bounds;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.tmp.setBounds((Rectangle)hashtable.get(jComponent));
        SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, this.tmp);
        if (this.tmp.isEmpty()) {
            return;
        }
        while ((container = container2.getParent()) != null && container instanceof JComponent) {
            container2 = container;
            n2 += rectangle.x;
            n4 += rectangle.y;
            this.tmp.setLocation(this.tmp.x + rectangle.x, this.tmp.y + rectangle.y);
            rectangle = container2._bounds;
            this.tmp = SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, this.tmp);
            if (this.tmp.isEmpty()) {
                return;
            }
            if (hashtable.get(container2) == null) continue;
            jComponent2 = container2;
            n = n2;
            n3 = n4;
        }
        if (jComponent != jComponent2) {
            this.tmp.setLocation(this.tmp.x + n - n2, this.tmp.y + n3 - n4);
            Rectangle rectangle2 = (Rectangle)hashtable.get(jComponent2);
            SwingUtilities.computeUnion(this.tmp.x, this.tmp.y, this.tmp.width, this.tmp.height, rectangle2);
        }
        if (!vector.contains(jComponent2)) {
            vector.addElement(jComponent2);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dirtyComponents != null) {
            stringBuffer.append("" + this.dirtyComponents);
        }
        return stringBuffer.toString();
    }

    public Image getOffscreenBuffer(Component component, int n, int n2) {
        return this._getOffscreenBuffer(component, n, n2);
    }

    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        int n3;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Dimension dimension = this.getDoubleBufferMaximumSize();
        int n4 = n < 1 ? 1 : (n3 = n > dimension.width ? dimension.width : n);
        int n5 = n2 < 1 ? 1 : (n2 > dimension.height ? dimension.height : n2);
        VolatileImage volatileImage = (VolatileImage)this.volatileMap.get(graphicsConfiguration);
        if (volatileImage == null || volatileImage.getWidth() < n3 || volatileImage.getHeight() < n5) {
            if (volatileImage != null) {
                volatileImage.flush();
            }
            volatileImage = graphicsConfiguration.createCompatibleVolatileImage(n3, n5);
            this.volatileMap.put(graphicsConfiguration, volatileImage);
        }
        return volatileImage;
    }

    private Image _getOffscreenBuffer(Component component, int n, int n2) {
        int n3;
        int n4;
        Dimension dimension = this.getDoubleBufferMaximumSize();
        DoubleBufferInfo doubleBufferInfo = null;
        if (this.standardDoubleBuffer == null) {
            this.standardDoubleBuffer = new DoubleBufferInfo();
        }
        doubleBufferInfo = this.standardDoubleBuffer;
        int n5 = n < 1 ? 1 : (n4 = n > dimension.width ? dimension.width : n);
        int n6 = n2 < 1 ? 1 : (n3 = n2 > dimension.height ? dimension.height : n2);
        if (doubleBufferInfo.needsReset || doubleBufferInfo.image != null && (doubleBufferInfo.size.width < n4 || doubleBufferInfo.size.height < n3)) {
            doubleBufferInfo.needsReset = false;
            if (doubleBufferInfo.image != null) {
                doubleBufferInfo.image.flush();
                doubleBufferInfo.image = null;
            }
            n4 = Math.max(doubleBufferInfo.size.width, n4);
            n3 = Math.max(doubleBufferInfo.size.height, n3);
        }
        Image image = doubleBufferInfo.image;
        if (doubleBufferInfo.image == null) {
            image = component.createImage(n4, n3);
            doubleBufferInfo.size = new Dimension(n4, n3);
            if (component instanceof JComponent) {
                ((JComponent)component).setCreatedDoubleBuffer(true);
                doubleBufferInfo.image = image;
            }
        }
        return image;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaxSize = dimension;
        if (this.standardDoubleBuffer != null && this.standardDoubleBuffer.image != null && (this.standardDoubleBuffer.image.getWidth(null) > dimension.width || this.standardDoubleBuffer.image.getHeight(null) > dimension.height)) {
            this.standardDoubleBuffer.image = null;
        }
        Iterator iterator = this.volatileMap.keySet().iterator();
        while (iterator.hasNext()) {
            GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)iterator.next();
            VolatileImage volatileImage = (VolatileImage)this.volatileMap.get(graphicsConfiguration);
            if (volatileImage.getWidth() <= dimension.width && volatileImage.getHeight() <= dimension.height) continue;
            volatileImage.flush();
            iterator.remove();
        }
    }

    public Dimension getDoubleBufferMaximumSize() {
        block2: {
            if (this.doubleBufferMaxSize != null) break block2;
            try {
                this.doubleBufferMaxSize = Toolkit.getDefaultToolkit().getScreenSize();
            }
            catch (HeadlessException headlessException) {
                this.doubleBufferMaxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        }
        return this.doubleBufferMaxSize;
    }

    public void setDoubleBufferingEnabled(boolean bl) {
        this.doubleBufferingEnabled = bl;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    void resetDoubleBuffer() {
        if (this.standardDoubleBuffer != null) {
            this.standardDoubleBuffer.needsReset = true;
        }
    }

    void resetVolatileDoubleBuffer(GraphicsConfiguration graphicsConfiguration) {
        Image image = (Image)this.volatileMap.remove(graphicsConfiguration);
        if (image != null) {
            image.flush();
        }
    }

    boolean useVolatileDoubleBuffer() {
        return volatileImageBufferEnabled;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("swing.volatileImageBufferEnabled"));
        volatileImageBufferEnabled = string == null || string.equals("true");
    }

    private class DoubleBufferInfo {
        public Image image;
        public Dimension size;
        public boolean needsReset = false;

        private DoubleBufferInfo() {
        }
    }
}

