/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicMenuBarUI
extends MenuBarUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        this.menuBar.setOpaque(true);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu = this.menuBar.getMenu(n);
            if (jMenu != null) {
                jMenu.getModel().addChangeListener(this.changeListener);
            }
            ++n;
        }
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
    }

    InputMap getInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.menuBar, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("MenuBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("MenuBar.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("takeFocus", new TakeFocus());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    protected void uninstallDefaults() {
        if (this.menuBar != null) {
            LookAndFeel.uninstallBorder(this.menuBar);
        }
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            JMenu jMenu = this.menuBar.getMenu(n);
            if (jMenu != null) {
                jMenu.getModel().removeChangeListener(this.changeListener);
            }
            ++n;
        }
        this.containerListener = null;
        this.changeListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    private static class TakeFocus
    extends AbstractAction {
        TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenu jMenu;
            Object object;
            MenuElement[] menuElementArray = (MenuElement[])actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            if (menuElementArray2.length > 0 && menuElementArray2[0] instanceof JMenuBar) {
                object = null;
                Container container = menuElementArray.getParent().getParent();
                while (container != null) {
                    object = this.findMenuBar(container);
                    if (object != null) break;
                    container = container.getParent();
                }
                if (object != null) {
                    menuElementArray = object;
                }
            }
            if ((jMenu = menuElementArray.getMenu(0)) != null) {
                object = new MenuElement[]{menuElementArray, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath((MenuElement[])object);
            }
        }

        private JMenuBar findMenuBar(Component component) {
            JMenuBar jMenuBar = null;
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JMenuBar) {
                    jMenuBar = (JMenuBar)componentArray[n];
                    break;
                }
                ++n;
            }
            return jMenuBar;
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().addChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().removeChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation") && BasicMenuBarUI.this.menuBar.getLayout() instanceof UIResource) {
                BasicMenuBarUI.this.menuBar.setLayout(new DefaultMenuLayout(BasicMenuBarUI.this.menuBar, 2));
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = 0;
            int n2 = BasicMenuBarUI.this.menuBar.getMenuCount();
            while (n < n2) {
                JMenu jMenu = BasicMenuBarUI.this.menuBar.getMenu(n);
                if (jMenu != null && jMenu.isSelected()) {
                    BasicMenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(n);
                    break;
                }
                ++n;
            }
        }
    }
}

