/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.JTextComponent;

public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static String newline;
    private int[] mnemonics;
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOptionPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.optionPane = (JOptionPane)jComponent;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
        this.optionPane.setOpaque(true);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.optionPane);
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container container = this.createSeparator();
        if (container != null) {
            this.optionPane.add(container);
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.optionPane, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    InputMap getInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("OptionPane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.optionPane, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("OptionPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("OptionPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("close", new CloseAction());
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        return actionMapUIResource;
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if ((JOptionPane)jComponent == this.optionPane) {
            Dimension dimension = this.getMinimumOptionPaneSize();
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager != null) {
                Dimension dimension2 = layoutManager.preferredLayoutSize(jComponent);
                if (dimension != null) {
                    return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
                }
                return dimension2;
            }
            return dimension;
        }
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(){};
        JPanel jPanel3 = new JPanel(){};
        jPanel3.setLayout(new BorderLayout());
        if (this.getIcon() != null) {
            serializable = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(15, 1);
                }
            };
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).anchor = 21;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        this.addIcon(jPanel);
        return jPanel;
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            if (object instanceof JScrollPane || object instanceof JPanel) {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
            } else {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.addMessageComponents(container, gridBagConstraints, objectArray[n2], n, false);
                ++n2;
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            this.configureMessageLabel(jLabel);
            this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
        } else {
            String string = object.toString();
            int n3 = string.length();
            if (n3 <= 0) {
                return;
            }
            int n4 = -1;
            int n5 = 0;
            n4 = string.indexOf(newline);
            if (n4 >= 0) {
                n5 = newline.length();
            } else {
                n4 = string.indexOf("\r\n");
                if (n4 >= 0) {
                    n5 = 2;
                } else {
                    n4 = string.indexOf(10);
                    if (n4 >= 0) {
                        n5 = 1;
                    }
                }
            }
            if (n4 >= 0) {
                if (n4 == 0) {
                    this.addMessageComponents(container, gridBagConstraints, new Component(){

                        public Dimension getPreferredSize() {
                            Font font = this.getFont();
                            if (font != null) {
                                return new Dimension(1, font.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    }, n, true);
                } else {
                    this.addMessageComponents(container, gridBagConstraints, string.substring(0, n4), n, false);
                }
                this.addMessageComponents(container, gridBagConstraints, string.substring(n4 + n5), n, false);
            } else if (n3 > n) {
                Box box = Box.createVerticalBox();
                this.burstStringInto(box, string, n);
                this.addMessageComponents(container, gridBagConstraints, box, n, true);
            } else {
                JLabel jLabel = new JLabel(string, 10);
                this.configureMessageLabel(jLabel);
                this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
            }
        }
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent jComponent;
                JComponent jComponent2;
                Object object = this.optionPane.getMessage();
                Object[] objectArray = this.optionPane.getSelectionValues();
                Object object2 = this.optionPane.getInitialSelectionValue();
                if (objectArray != null) {
                    if (objectArray.length < 20) {
                        jComponent2 = new JComboBox();
                        int n = 0;
                        int n2 = objectArray.length;
                        while (n < n2) {
                            ((JComboBox)jComponent2).addItem(objectArray[n]);
                            ++n;
                        }
                        if (object2 != null) {
                            ((JComboBox)jComponent2).setSelectedItem(object2);
                        }
                        this.inputComponent = jComponent2;
                        jComponent = jComponent2;
                    } else {
                        jComponent2 = new JList(objectArray);
                        JScrollPane jScrollPane = new JScrollPane(jComponent2);
                        ((JList)jComponent2).setVisibleRowCount(10);
                        ((JList)jComponent2).setSelectionMode(0);
                        if (object2 != null) {
                            ((JList)jComponent2).setSelectedValue(object2, true);
                        }
                        jComponent2.addMouseListener(new ListSelectionListener());
                        jComponent = jScrollPane;
                        this.inputComponent = jComponent2;
                    }
                } else {
                    jComponent2 = new MultiplexingTextField(20);
                    ((MultiplexingTextField)jComponent2).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (object2 != null) {
                        String string = object2.toString();
                        ((JTextComponent)jComponent2).setText(string);
                        ((JTextComponent)jComponent2).setSelectionStart(0);
                        ((JTextComponent)jComponent2).setSelectionEnd(string.length());
                    }
                    ((JTextField)jComponent2).addActionListener(new TextFieldActionListener());
                    jComponent = this.inputComponent = jComponent2;
                }
                jComponent2 = object == null ? new Object[]{jComponent} : new Object[]{object, jComponent};
                return jComponent2;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            AccessibleContext accessibleContext;
            Icon icon2;
            JLabel jLabel = new JLabel(icon);
            if (jLabel != null && (icon2 = jLabel.getIcon()) instanceof Accessible && (accessibleContext = ((Accessible)((Object)icon2)).getAccessibleContext()) != null) {
                AccessibleContext accessibleContext2 = jLabel.getAccessibleContext();
                String string = null;
                String string2 = null;
                string = accessibleContext.getAccessibleName();
                if (string != null) {
                    accessibleContext2.setAccessibleName(string);
                }
                if ((string2 = accessibleContext.getAccessibleDescription()) != null) {
                    accessibleContext2.setAccessibleDescription(string2);
                }
            }
            jLabel.setVerticalAlignment(1);
            container.add((Component)jLabel, "Before");
        }
    }

    protected Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = this.getIconForType(this.optionPane.getMessageType());
        }
        return icon;
    }

    protected Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    protected void burstStringInto(Container container, String string, int n) {
        int n2 = string.length();
        if (n2 <= 0) {
            return;
        }
        if (n2 > n) {
            int n3 = string.lastIndexOf(32, n);
            if (n3 <= 0) {
                n3 = string.indexOf(32, n);
            }
            if (n3 > 0 && n3 < n2) {
                this.burstStringInto(container, string.substring(0, n3), n);
                this.burstStringInto(container, string.substring(n3 + 1), n);
                return;
            }
        }
        JLabel jLabel = new JLabel(string, 2);
        this.configureMessageLabel(jLabel);
        container.add(jLabel);
    }

    protected Container createSeparator() {
        return null;
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder"));
        jPanel.setLayout(new ButtonAreaLayout(true, 6));
        this.addButtonComponents(jPanel, this.getButtons(), this.getInitialValueIndex());
        this.mnemonics = null;
        return jPanel;
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            Object object;
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            int[] nArray = this.mnemonics;
            if (nArray != null && nArray.length != objectArray.length) {
                nArray = null;
            }
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            int n4 = 0;
            while (n4 < n2) {
                JButton jButton;
                Component component;
                object = objectArray[n4];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString());
                    jButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(jButton);
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(n4);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                    if (nArray != null) {
                        jButton.setMnemonic(nArray[n4]);
                    }
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[n4] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (n4 == n) {
                    this.initialFocusComponent = component;
                    if (this.initialFocusComponent instanceof JButton) {
                        jButton = (JButton)this.initialFocusComponent;
                        jButton.addAncestorListener(new AncestorListener(){

                            public void ancestorAdded(AncestorEvent ancestorEvent) {
                                JButton jButton = (JButton)ancestorEvent.getComponent();
                                JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                                if (jRootPane != null) {
                                    jRootPane.setDefaultButton(jButton);
                                }
                            }

                            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                            }

                            public void ancestorMoved(AncestorEvent ancestorEvent) {
                            }
                        });
                    }
                }
                ++n4;
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllWidths(bl && bl2);
            if (bl && bl2) {
                int n5 = n2 <= 2 ? 8 : 4;
                int n6 = 0;
                while (n6 < n2) {
                    object = jButtonArray[n6];
                    ((AbstractButton)object).setMargin(new Insets(2, n5, 2, n5));
                    ++n6;
                }
            }
        }
    }

    protected ActionListener createButtonActionListener(int n) {
        return new ButtonActionListener(n);
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                if (n == 0) {
                    objectArray2 = new String[]{UIManager.get("OptionPane.yesButtonText", locale), UIManager.get("OptionPane.noButtonText", locale)};
                    this.mnemonics = new int[2];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.yesButtonMnemonic", locale);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.noButtonMnemonic", locale);
                } else if (n == 1) {
                    objectArray2 = new String[]{UIManager.get("OptionPane.yesButtonText", locale), UIManager.get("OptionPane.noButtonText", locale), UIManager.get("OptionPane.cancelButtonText", locale)};
                    this.mnemonics = new int[3];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.yesButtonMnemonic", locale);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.noButtonMnemonic", locale);
                    this.mnemonics[2] = this.getMnemonic("OptionPane.cancelButtonMnemonic", locale);
                } else if (n == 2) {
                    objectArray2 = new String[]{UIManager.get("OptionPane.okButtonText", locale), UIManager.get("OptionPane.cancelButtonText", locale)};
                    this.mnemonics = new int[2];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.okButtonMnemonic", locale);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.cancelButtonMnemonic", locale);
                } else {
                    objectArray2 = new String[]{UIManager.get("OptionPane.okButtonText", locale)};
                    this.mnemonics = new int[1];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.okButtonMnemonic", locale);
                }
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    private int getMnemonic(String string, Locale locale) {
        int n;
        block4: {
            String string2 = (String)UIManager.get(string, locale);
            if (string2 == null) {
                return 0;
            }
            n = 0;
            if (string2.length() == 1 && ((n = (int)Character.toUpperCase(string2.charAt(0))) < 65 || n > 90)) {
                n = 0;
            }
            if (n != 0) break block4;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                return 0;
            }
            if (object != null) {
                int n = objectArray.length - 1;
                while (n >= 0) {
                    if (objectArray[n].equals(object)) {
                        return n;
                    }
                    --n;
                }
            }
        }
        return -1;
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane jRootPane;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (jRootPane = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                jRootPane.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    private void fireAudioAction(String string) {
        Action action;
        ActionMap actionMap = this.optionPane.getActionMap();
        if (actionMap != null && (action = actionMap.get(string)) != null) {
            BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
            basicLookAndFeel.playSound(action);
        }
    }

    private void configureMessageLabel(JLabel jLabel) {
        jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        Font font = UIManager.getFont("OptionPane.messageFont");
        if (font != null) {
            jLabel.setFont(font);
        }
    }

    private void configureButton(JButton jButton) {
        Font font = UIManager.getFont("OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                newline = System.getProperty("line.separator");
                if (newline == null) {
                    newline = "\n";
                }
                return null;
            }
        });
    }

    private static class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane jOptionPane = (JOptionPane)actionEvent.getSource();
            jOptionPane.setValue(new Integer(-1));
        }
    }

    private static class MultiplexingTextField
    extends JTextField {
        private KeyStroke[] strokes;

        MultiplexingTextField(int n) {
            super(n);
        }

        void setKeyStrokes(KeyStroke[] keyStrokeArray) {
            this.strokes = keyStrokeArray;
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            if (bl2 && n != 2) {
                int n2 = this.strokes.length - 1;
                while (n2 >= 0) {
                    if (this.strokes[n2].equals(keyStroke)) {
                        return false;
                    }
                    --n2;
                }
            }
            return bl2;
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicOptionPaneUI.this.optionPane.setInputValue(((JTextField)actionEvent.getSource()).getText());
        }
    }

    private class ListSelectionListener
    extends MouseAdapter {
        private ListSelectionListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                BasicOptionPaneUI.this.optionPane.setInputValue(jList.getModel().getElementAt(n));
            }
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int n) {
            this.buttonIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicOptionPaneUI.this.optionPane != null) {
                int n = BasicOptionPaneUI.this.optionPane.getOptionType();
                Object[] objectArray = BasicOptionPaneUI.this.optionPane.getOptions();
                if (BasicOptionPaneUI.this.inputComponent != null && (objectArray != null || n == -1 || (n == 0 || n == 1 || n == 2) && this.buttonIndex == 0)) {
                    BasicOptionPaneUI.this.resetInputValue();
                }
                if (objectArray == null) {
                    if (n == 2 && this.buttonIndex == 1) {
                        BasicOptionPaneUI.this.optionPane.setValue(new Integer(2));
                    } else {
                        BasicOptionPaneUI.this.optionPane.setValue(new Integer(this.buttonIndex));
                    }
                } else {
                    BasicOptionPaneUI.this.optionPane.setValue(objectArray[this.buttonIndex]);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicOptionPaneUI.this.optionPane) {
                Object object;
                if ("ancestor" == propertyChangeEvent.getPropertyName()) {
                    object = (JOptionPane)propertyChangeEvent.getSource();
                    boolean bl = propertyChangeEvent.getOldValue() == null;
                    switch (((JOptionPane)object).getMessageType()) {
                        case -1: {
                            if (!bl) break;
                            BasicOptionPaneUI.this.fireAudioAction("OptionPane.informationSound");
                            break;
                        }
                        case 3: {
                            if (!bl) break;
                            BasicOptionPaneUI.this.fireAudioAction("OptionPane.questionSound");
                            break;
                        }
                        case 1: {
                            if (!bl) break;
                            BasicOptionPaneUI.this.fireAudioAction("OptionPane.informationSound");
                            break;
                        }
                        case 2: {
                            if (!bl) break;
                            BasicOptionPaneUI.this.fireAudioAction("OptionPane.warningSound");
                            break;
                        }
                        case 0: {
                            if (!bl) break;
                            BasicOptionPaneUI.this.fireAudioAction("OptionPane.errorSound");
                            break;
                        }
                        default: {
                            System.err.println("Undefined JOptionPane type: " + ((JOptionPane)object).getMessageType());
                        }
                    }
                }
                if (((String)(object = propertyChangeEvent.getPropertyName())).equals("options") || ((String)object).equals("initialValue") || ((String)object).equals("icon") || ((String)object).equals("messageType") || ((String)object).equals("optionType") || ((String)object).equals("message") || ((String)object).equals("selectionValues") || ((String)object).equals("initialSelectionValue") || ((String)object).equals("wantsInput")) {
                    BasicOptionPaneUI.this.uninstallComponents();
                    BasicOptionPaneUI.this.installComponents();
                    BasicOptionPaneUI.this.optionPane.validate();
                } else if (((String)object).equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JOptionPane jOptionPane = (JOptionPane)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jOptionPane.applyComponentOrientation(componentOrientation);
                    }
                }
            }
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllWidths;
        protected int padding;
        protected boolean centersChildren;

        public ButtonAreaLayout(boolean bl, int n) {
            this.syncAllWidths = bl;
            this.padding = n;
            this.centersChildren = true;
        }

        public void setSyncAllWidths(boolean bl) {
            this.syncAllWidths = bl;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            block18: {
                Component[] componentArray = container.getComponents();
                if (componentArray == null || componentArray.length <= 0) break block18;
                int n = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n];
                Insets insets = container.getInsets();
                int n2 = insets.top;
                boolean bl = container.getComponentOrientation().isLeftToRight();
                if (this.syncAllWidths) {
                    int n3;
                    int n4;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n) {
                        dimensionArray[n6] = componentArray[n6].getPreferredSize();
                        n5 = Math.max(n5, dimensionArray[n6].width);
                        ++n6;
                    }
                    if (this.getCentersChildren()) {
                        n4 = (container.getSize().width - insets.left - insets.right - (n5 * n + (n - 1) * this.padding)) / 2;
                        n3 = this.padding + n5;
                    } else if (n > 1) {
                        n4 = insets.left;
                        n3 = (container.getSize().width - insets.left - insets.right - n5 * n) / (n - 1) + n5;
                    } else {
                        n4 = insets.left + (container.getSize().width - insets.left - insets.right - n5) / 2;
                        n3 = 0;
                    }
                    if (!bl) {
                        n4 = container.getSize().width - insets.right - (n4 - insets.left) - n5;
                        n3 = -n3;
                    }
                    n6 = 0;
                    while (n6 < n) {
                        componentArray[n6].setBounds(n4, n2, n5, dimensionArray[n6].height);
                        n4 += n3;
                        ++n6;
                    }
                } else {
                    int n7;
                    int n8;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n) {
                        dimensionArray[n10] = componentArray[n10].getPreferredSize();
                        n9 += dimensionArray[n10].width;
                        ++n10;
                    }
                    n9 += (n - 1) * this.padding;
                    boolean bl2 = this.getCentersChildren();
                    if (bl2) {
                        n8 = insets.left + (container.getSize().width - insets.left - insets.right - n9) / 2;
                        n7 = this.padding;
                    } else if (n > 1) {
                        n7 = (container.getSize().width - insets.left - insets.right - n9) / (n - 1);
                        n8 = insets.left;
                    } else {
                        n8 = insets.left + (container.getSize().width - insets.left - insets.right - n9) / 2;
                        n7 = 0;
                    }
                    if (bl) {
                        n10 = 0;
                        while (n10 < n) {
                            componentArray[n10].setBounds(n8, n2, dimensionArray[n10].width, dimensionArray[n10].height);
                            n8 += n7 + dimensionArray[n10].width;
                            ++n10;
                        }
                    } else {
                        n8 = container.getSize().width - insets.right - (n8 - insets.left);
                        n10 = 0;
                        while (n10 < n) {
                            componentArray[n10].setBounds(n8 -= n7 + dimensionArray[n10].width, n2, dimensionArray[n10].width, dimensionArray[n10].height);
                            ++n10;
                        }
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = insets.top + insets.bottom;
                int n4 = insets.left + insets.right;
                if (this.syncAllWidths) {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n) {
                        Dimension dimension = componentArray[n6].getPreferredSize();
                        n2 = Math.max(n2, dimension.height);
                        n5 = Math.max(n5, dimension.width);
                        ++n6;
                    }
                    return new Dimension(n4 + n5 * n + (n - 1) * this.padding, n3 + n2);
                }
                int n7 = 0;
                int n8 = 0;
                while (n8 < n) {
                    Dimension dimension = componentArray[n8].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n7 += dimension.width;
                    ++n8;
                }
                return new Dimension(n4 + (n7 += (n - 1) * this.padding), n3 + n2);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

