/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.InternationalFormatter;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private static final FocusListener focusListener = new FocusHandler();
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private static final Dimension zeroSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSpinnerUI();
    }

    private void maybeAdd(Component component, String string) {
        if (component != null) {
            this.spinner.add(component, string);
        }
    }

    public void installUI(JComponent jComponent) {
        this.spinner = (JSpinner)jComponent;
        this.installDefaults();
        this.installListeners();
        this.maybeAdd(this.createNextButton(), "Next");
        this.maybeAdd(this.createPreviousButton(), "Previous");
        this.maybeAdd(this.createEditor(), "Editor");
        this.updateEnabledState();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        jComponent.removeAll();
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(propertyChangeListener);
        this.spinner.addFocusListener(focusListener);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(propertyChangeListener);
        this.removeEditorBorderListener(this.spinner.getEditor());
    }

    protected void installDefaults() {
        this.spinner.setLayout(this.createLayout());
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Component createPreviousButton() {
        return this.createArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        return this.createArrowButton(1, nextButtonHandler);
    }

    private Component createArrowButton(int n, ArrowButtonHandler arrowButtonHandler) {
        BasicArrowButton basicArrowButton = new BasicArrowButton(n);
        basicArrowButton.addActionListener(arrowButtonHandler);
        basicArrowButton.addMouseListener(arrowButtonHandler);
        Border border = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (border instanceof UIResource) {
            basicArrowButton.setBorder(new CompoundBorder(border, null));
        } else {
            basicArrowButton.setBorder(border);
        }
        return basicArrowButton;
    }

    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        this.maybeRemoveEditorBorder(jComponent);
        this.installEditorBorderListener(jComponent);
        return jComponent;
    }

    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        this.maybeRemoveEditorBorder(jComponent2);
        this.installEditorBorderListener(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private void maybeRemoveEditorBorder(JComponent jComponent) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
                jComponent = (JComponent)jComponent.getComponent(0);
            }
            if (jComponent != null && jComponent.getBorder() instanceof UIResource) {
                jComponent.setBorder(null);
            }
        }
    }

    private void installEditorBorderListener(JComponent jComponent) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
                jComponent = (JComponent)jComponent.getComponent(0);
            }
            if (jComponent != null && (jComponent.getBorder() == null || jComponent.getBorder() instanceof UIResource)) {
                jComponent.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private void removeEditorBorderListener(JComponent jComponent) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (jComponent instanceof JPanel && jComponent.getComponentCount() > 0) {
                jComponent = (JComponent)jComponent.getComponent(0);
            }
            if (jComponent != null) {
                jComponent.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container container, boolean bl) {
        int n = container.getComponentCount() - 1;
        while (n >= 0) {
            Component component = container.getComponent(n);
            component.setEnabled(bl);
            if (component instanceof Container) {
                this.updateEnabledState((Container)component, bl);
            }
            --n;
        }
    }

    private void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.spinner, this.getActionMap());
    }

    private InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Spinner.ancestorInputMap");
        }
        return null;
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("Spinner.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Spinner.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("increment", nextButtonHandler);
        actionMapUIResource.put("decrement", previousButtonHandler);
        return actionMapUIResource;
    }

    private static class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JSpinner jSpinner = (JSpinner)focusEvent.getSource();
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jSpinner.getEditor();
            defaultEditor.getTextField().requestFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JSpinner jSpinner;
            SpinnerUI spinnerUI;
            JComponent jComponent;
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getSource() instanceof JSpinner) {
                JSpinner jSpinner2 = (JSpinner)propertyChangeEvent.getSource();
                SpinnerUI spinnerUI2 = jSpinner2.getUI();
                if (spinnerUI2 instanceof BasicSpinnerUI) {
                    BasicSpinnerUI basicSpinnerUI = (BasicSpinnerUI)spinnerUI2;
                    if ("editor".equals(string)) {
                        JComponent jComponent2 = (JComponent)propertyChangeEvent.getOldValue();
                        JComponent jComponent3 = (JComponent)propertyChangeEvent.getNewValue();
                        basicSpinnerUI.replaceEditor(jComponent2, jComponent3);
                        basicSpinnerUI.updateEnabledState();
                    } else if ("enabled".equals(string)) {
                        basicSpinnerUI.updateEnabledState();
                    }
                }
            } else if (propertyChangeEvent.getSource() instanceof JComponent && (jComponent = (JComponent)propertyChangeEvent.getSource()).getParent() instanceof JPanel && jComponent.getParent().getParent() instanceof JSpinner && "border".equals(string) && (spinnerUI = (jSpinner = (JSpinner)jComponent.getParent().getParent()).getUI()) instanceof BasicSpinnerUI) {
                BasicSpinnerUI basicSpinnerUI = (BasicSpinnerUI)spinnerUI;
                basicSpinnerUI.maybeRemoveEditorBorder(jComponent);
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                component = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? zeroSize : component.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4 = container.getWidth();
            int n5 = container.getHeight();
            Insets insets = container.getInsets();
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n6 = Math.max(dimension.width, dimension2.width);
            int n7 = n5 - (insets.top + insets.bottom);
            Insets insets2 = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (insets2 == null) {
                insets2 = insets;
            }
            if (container.getComponentOrientation().isLeftToRight()) {
                n3 = insets.left;
                n2 = n4 - insets.left - n6 - insets2.right;
                n = n4 - n6 - insets2.right;
            } else {
                n = insets2.left;
                n3 = n + n6;
                n2 = n4 - insets2.left - n6 - insets.right;
            }
            int n8 = insets2.top;
            int n9 = n5 / 2 + n5 % 2 - n8;
            int n10 = insets2.top + n9;
            int n11 = n5 - n10 - insets2.bottom;
            this.setBounds(this.editor, n3, insets.top, n2, n7);
            this.setBounds(this.nextButton, n, n8, n6, n9);
            this.setBounds(this.previousButton, n, n10, n6, n11);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener,
    UIResource {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String string, boolean bl) {
            super(string);
            this.isNext = bl;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            while (object instanceof Component && !(object instanceof JSpinner)) {
                object = ((Component)object).getParent();
            }
            return object instanceof JSpinner ? (JSpinner)object : null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block6: {
                JSpinner jSpinner = this.spinner;
                if (!(actionEvent.getSource() instanceof Timer)) {
                    jSpinner = this.eventToSpinner(actionEvent);
                }
                if (jSpinner == null) break block6;
                try {
                    Object object;
                    int n = this.getCalendarField(jSpinner);
                    jSpinner.commitEdit();
                    if (n != -1) {
                        ((SpinnerDateModel)jSpinner.getModel()).setCalendarField(n);
                    }
                    Object object2 = object = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                    if (object != null) {
                        jSpinner.setValue(object);
                        this.select(jSpinner);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                }
            }
        }

        private void select(JSpinner jSpinner) {
            block4: {
                SpinnerDateModel spinnerDateModel;
                DateFormat.Field field;
                Object object;
                JComponent jComponent = jSpinner.getEditor();
                if (!(jComponent instanceof JSpinner.DateEditor)) break block4;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                SimpleDateFormat simpleDateFormat = dateEditor.getFormat();
                if (simpleDateFormat != null && (object = jSpinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((spinnerDateModel = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator attributedCharacterIterator = ((Format)simpleDateFormat).formatToCharacterIterator(object);
                        if (!this.select(jFormattedTextField, attributedCharacterIterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(jFormattedTextField, attributedCharacterIterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }

        private boolean select(JFormattedTextField jFormattedTextField, AttributedCharacterIterator attributedCharacterIterator, DateFormat.Field field) {
            int n = jFormattedTextField.getDocument().getLength();
            attributedCharacterIterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> map;
                if ((map = attributedCharacterIterator.getAttributes()) == null || !map.containsKey(field)) continue;
                int n2 = attributedCharacterIterator.getRunStart(field);
                int n3 = attributedCharacterIterator.getRunLimit(field);
                if (n2 != -1 && n3 != -1 && n2 <= n && n3 <= n) {
                    jFormattedTextField.select(n2, n3);
                }
                return true;
            } while (attributedCharacterIterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner jSpinner) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)jComponent;
                JFormattedTextField jFormattedTextField = dateEditor.getTextField();
                int n = jFormattedTextField.getSelectionStart();
                JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
                if (abstractFormatter instanceof InternationalFormatter) {
                    Format.Field[] fieldArray = ((InternationalFormatter)abstractFormatter).getFields(n);
                    int n2 = 0;
                    while (n2 < fieldArray.length) {
                        int n3;
                        if (fieldArray[n2] instanceof DateFormat.Field && (n3 = fieldArray[n2] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fieldArray[n2]).getCalendarField()) != -1) {
                            return n3;
                        }
                        ++n2;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(mouseEvent);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void focusSpinnerIfNecessary() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (component == null || !SwingUtilities.isDescendingFrom(component, this.spinner))) {
                FocusTraversalPolicy focusTraversalPolicy;
                Component component2;
                Container container = this.spinner;
                if (!container.isFocusCycleRoot()) {
                    container = container.getFocusCycleRootAncestor();
                }
                if (container != null && (component2 = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, this.spinner)) != null && SwingUtilities.isDescendingFrom(component2, this.spinner)) {
                    component2.requestFocus();
                }
            }
        }
    }
}

