/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    int majorAxis;
    int majorSpan;
    int minorSpan;
    boolean majorReqValid;
    boolean minorReqValid;
    SizeRequirements majorRequest;
    SizeRequirements minorRequest;
    boolean majorAllocValid;
    int[] majorOffsets;
    int[] majorSpans;
    boolean minorAllocValid;
    int[] minorOffsets;
    int[] minorSpans;
    Rectangle tempRect = new Rectangle();

    public BoxView(Element element, int n) {
        super(element);
        this.majorAxis = n;
        this.majorOffsets = new int[0];
        this.majorSpans = new int[0];
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorOffsets = new int[0];
        this.minorSpans = new int[0];
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    public int getAxis() {
        return this.majorAxis;
    }

    public void setAxis(int n) {
        boolean bl = n != this.majorAxis;
        this.majorAxis = n;
        if (bl) {
            this.preferenceChanged(null, true, true);
        }
    }

    public void layoutChanged(int n) {
        if (n == this.majorAxis) {
            this.majorAllocValid = false;
        } else {
            this.minorAllocValid = false;
        }
    }

    protected boolean isLayoutValid(int n) {
        if (n == this.majorAxis) {
            return this.majorAllocValid;
        }
        return this.minorAllocValid;
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        int n3 = viewArray != null ? viewArray.length : 0;
        this.majorOffsets = this.updateLayoutArray(this.majorOffsets, n, n3);
        this.majorSpans = this.updateLayoutArray(this.majorSpans, n, n3);
        this.majorReqValid = false;
        this.majorAllocValid = false;
        this.minorOffsets = this.updateLayoutArray(this.minorOffsets, n, n3);
        this.minorSpans = this.updateLayoutArray(this.minorSpans, n, n3);
        this.minorReqValid = false;
        this.minorAllocValid = false;
    }

    int[] updateLayoutArray(int[] nArray, int n, int n2) {
        int n3 = this.getViewCount();
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        System.arraycopy(nArray, n, nArray2, n + n2, n3 - n2 - n);
        return nArray2;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        boolean bl = this.isLayoutValid(this.majorAxis);
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (bl && !this.isLayoutValid(this.majorAxis)) {
            Container container = this.getContainer();
            if (shape != null && container != null) {
                int n = documentEvent.getOffset();
                int n2 = this.getViewIndexAtPosition(n);
                Rectangle rectangle = this.getInsideAllocation(shape);
                if (this.majorAxis == 0) {
                    rectangle.x += this.majorOffsets[n2];
                    rectangle.width -= this.majorOffsets[n2];
                } else {
                    rectangle.y += this.minorOffsets[n2];
                    rectangle.height -= this.minorOffsets[n2];
                }
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = this.majorAxis == 0 ? bl : bl2;
        boolean bl5 = bl3 = this.majorAxis == 0 ? bl2 : bl;
        if (bl4) {
            this.majorReqValid = false;
            this.majorAllocValid = false;
        }
        if (bl3) {
            this.minorReqValid = false;
            this.minorAllocValid = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public int getResizeWeight(int n) {
        this.checkRequests(n);
        if (n == this.majorAxis ? this.majorRequest.preferred != this.majorRequest.minimum || this.majorRequest.preferred != this.majorRequest.maximum : this.minorRequest.preferred != this.minorRequest.minimum || this.minorRequest.preferred != this.minorRequest.maximum) {
            return 1;
        }
        return 0;
    }

    void setSpanOnAxis(int n, float f) {
        if (n == this.majorAxis) {
            if (this.majorSpan != (int)f) {
                this.majorAllocValid = false;
            }
            if (!this.majorAllocValid) {
                this.majorSpan = (int)f;
                this.checkRequests(this.majorAxis);
                this.layoutMajorAxis(this.majorSpan, n, this.majorOffsets, this.majorSpans);
                this.majorAllocValid = true;
                this.updateChildSizes();
            }
        } else {
            if ((int)f != this.minorSpan) {
                this.minorAllocValid = false;
            }
            if (!this.minorAllocValid) {
                this.minorSpan = (int)f;
                this.checkRequests(n);
                this.layoutMinorAxis(this.minorSpan, n, this.minorOffsets, this.minorSpans);
                this.minorAllocValid = true;
                this.updateChildSizes();
            }
        }
    }

    void updateChildSizes() {
        int n = this.getViewCount();
        if (this.majorAxis == 0) {
            int n2 = 0;
            while (n2 < n) {
                View view = this.getView(n2);
                view.setSize(this.majorSpans[n2], this.minorSpans[n2]);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                View view = this.getView(n3);
                view.setSize(this.minorSpans[n3], this.majorSpans[n3]);
                ++n3;
            }
        }
    }

    float getSpanOnAxis(int n) {
        if (n == this.majorAxis) {
            return this.majorSpan;
        }
        return this.minorSpan;
    }

    public void setSize(float f, float f2) {
        this.layout((int)(f - (float)this.getLeftInset() - (float)this.getRightInset()), (int)(f2 - (float)this.getTopInset() - (float)this.getBottomInset()));
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = this.getViewCount();
        int n2 = rectangle.x + this.getLeftInset();
        int n3 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n4 = 0;
        while (n4 < n) {
            this.tempRect.x = n2 + this.getOffset(0, n4);
            this.tempRect.y = n3 + this.getOffset(1, n4);
            this.tempRect.width = this.getSpan(0, n4);
            this.tempRect.height = this.getSpan(1, n4);
            if (this.tempRect.intersects(rectangle2)) {
                this.paintChild(graphics, this.tempRect, n4);
            }
            ++n4;
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        if (shape != null) {
            Shape shape2 = super.getChildAllocation(n, shape);
            if (shape2 != null && !this.isAllocationValid()) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (rectangle.width == 0 && rectangle.height == 0) {
                    return null;
                }
            }
            return shape2;
        }
        return null;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape, bias);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.viewToModel(f, f2, shape, biasArray);
    }

    public float getAlignment(int n) {
        this.checkRequests(n);
        if (n == this.majorAxis) {
            return this.majorRequest.alignment;
        }
        return this.minorRequest.alignment;
    }

    public float getPreferredSpan(int n) {
        float f;
        this.checkRequests(n);
        float f2 = f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n == this.majorAxis) {
            return (float)this.majorRequest.preferred + f;
        }
        return (float)this.minorRequest.preferred + f;
    }

    public float getMinimumSpan(int n) {
        float f;
        this.checkRequests(n);
        float f2 = f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n == this.majorAxis) {
            return (float)this.majorRequest.minimum + f;
        }
        return (float)this.minorRequest.minimum + f;
    }

    public float getMaximumSpan(int n) {
        float f;
        this.checkRequests(n);
        float f2 = f = n == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        if (n == this.majorAxis) {
            return (float)this.majorRequest.maximum + f;
        }
        return (float)this.minorRequest.maximum + f;
    }

    protected boolean isAllocationValid() {
        return this.majorAllocValid && this.minorAllocValid;
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        if (this.majorAxis == 0) {
            return n < rectangle.x;
        }
        return n2 < rectangle.y;
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        if (this.majorAxis == 0) {
            return n > rectangle.width + rectangle.x;
        }
        return n2 > rectangle.height + rectangle.y;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        if (this.majorAxis == 0) {
            if (n < rectangle.x + this.majorOffsets[0]) {
                this.childAllocation(0, rectangle);
                return this.getView(0);
            }
            int n4 = 0;
            while (n4 < n3) {
                if (n < rectangle.x + this.majorOffsets[n4]) {
                    this.childAllocation(n4 - 1, rectangle);
                    return this.getView(n4 - 1);
                }
                ++n4;
            }
            this.childAllocation(n3 - 1, rectangle);
            return this.getView(n3 - 1);
        }
        if (n2 < rectangle.y + this.majorOffsets[0]) {
            this.childAllocation(0, rectangle);
            return this.getView(0);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (n2 < rectangle.y + this.majorOffsets[n5]) {
                this.childAllocation(n5 - 1, rectangle);
                return this.getView(n5 - 1);
            }
            ++n5;
        }
        this.childAllocation(n3 - 1, rectangle);
        return this.getView(n3 - 1);
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        rectangle.x += this.getOffset(0, n);
        rectangle.y += this.getOffset(1, n);
        rectangle.width = this.getSpan(0, n);
        rectangle.height = this.getSpan(1, n);
    }

    protected void layout(int n, int n2) {
        this.setSpanOnAxis(0, n);
        this.setSpanOnAxis(1, n2);
    }

    public int getWidth() {
        int n = this.majorAxis == 0 ? this.majorSpan : this.minorSpan;
        return n += this.getLeftInset() - this.getRightInset();
    }

    public int getHeight() {
        int n = this.majorAxis == 1 ? this.majorSpan : this.minorSpan;
        return n += this.getTopInset() - this.getBottomInset();
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            nArray2[n4] = (int)view.getPreferredSpan(n2);
            l3 += (long)nArray2[n4];
            l = (long)((float)l + view.getMinimumSpan(n2));
            l2 = (long)((float)l2 + view.getMaximumSpan(n2));
            ++n4;
        }
        long l4 = (long)n - l3;
        float f = 0.0f;
        if (l4 != 0L) {
            float f2;
            float f3 = f2 = l4 > 0L ? (float)(l2 - l3) : (float)(l3 - l);
            if (f2 == 0.0f) {
                f = 0.0f;
            } else {
                f = (float)l4 / f2;
                f = Math.min(f, 1.0f);
                f = Math.max(f, -1.0f);
            }
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            View view = this.getView(n6);
            nArray[n6] = n5;
            int n7 = f > 0.0f ? (int)view.getMaximumSpan(n2) - nArray2[n6] : nArray2[n6] - (int)view.getMinimumSpan(n2);
            float f4 = f * (float)n7;
            f4 = f4 < 0.0f ? (f4 -= 0.5f) : (f4 += 0.5f);
            int n8 = (int)f4;
            int n9 = n6;
            nArray2[n9] = nArray2[n9] + n8;
            n5 = (int)Math.min((long)n5 + (long)nArray2[n6], Integer.MAX_VALUE);
            ++n6;
        }
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            int n5 = (int)view.getMinimumSpan(n2);
            int n6 = (int)view.getMaximumSpan(n2);
            if (n6 < n) {
                float f = view.getAlignment(n2);
                nArray[n4] = (int)((float)(n - n6) * f);
                nArray2[n4] = n6;
            } else {
                nArray[n4] = 0;
                nArray2[n4] = Math.max(n5, n);
            }
            ++n4;
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            f += view.getMinimumSpan(n);
            f2 += view.getPreferredSpan(n);
            f3 += view.getMaximumSpan(n);
            ++n3;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        sizeRequirements.minimum = (int)f;
        sizeRequirements.preferred = (int)f2;
        sizeRequirements.maximum = (int)f3;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        int n2 = 0;
        long l = 0L;
        int n3 = Integer.MAX_VALUE;
        int n4 = this.getViewCount();
        int n5 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            n2 = Math.max((int)view.getMinimumSpan(n), n2);
            l = Math.max((long)((int)view.getPreferredSpan(n)), l);
            n3 = Math.max((int)view.getMaximumSpan(n), n3);
            ++n5;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
            sizeRequirements.alignment = 0.5f;
        }
        sizeRequirements.preferred = (int)l;
        sizeRequirements.minimum = n2;
        sizeRequirements.maximum = n3;
        return sizeRequirements;
    }

    void checkRequests(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        if (n == this.majorAxis) {
            if (!this.majorReqValid) {
                this.majorRequest = this.calculateMajorAxisRequirements(n, this.majorRequest);
                this.majorReqValid = true;
            }
        } else if (!this.minorReqValid) {
            this.minorRequest = this.calculateMinorAxisRequirements(n, this.minorRequest);
            this.minorReqValid = true;
        }
    }

    protected void baselineLayout(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = (int)((float)n * this.getAlignment(n2));
        int n4 = n - n3;
        int n5 = this.getViewCount();
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            View view = this.getView(n6);
            float f = view.getAlignment(n2);
            if (view.getResizeWeight(n2) > 0) {
                int n8 = (int)view.getMinimumSpan(n2);
                int n9 = (int)view.getMaximumSpan(n2);
                if (f == 0.0f) {
                    n7 = Math.max(Math.min(n9, n4), n8);
                } else if (f == 1.0f) {
                    n7 = Math.max(Math.min(n9, n3), n8);
                } else {
                    int n10 = (int)Math.min((float)n3 / f, (float)n4 / (1.0f - f));
                    n7 = Math.max(Math.min(n9, n10), n8);
                }
            } else {
                n7 = (int)view.getPreferredSpan(n2);
            }
            nArray[n6] = n3 - (int)((float)n7 * f);
            nArray2[n6] = n7;
            ++n6;
        }
    }

    protected SizeRequirements baselineRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = new SizeRequirements();
        SizeRequirements sizeRequirements3 = new SizeRequirements();
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            float f = view.getAlignment(n);
            int n4 = (int)view.getPreferredSpan(n);
            int n5 = (int)(f * (float)n4);
            int n6 = n4 - n5;
            sizeRequirements2.preferred = Math.max(n5, sizeRequirements2.preferred);
            sizeRequirements3.preferred = Math.max(n6, sizeRequirements3.preferred);
            if (view.getResizeWeight(n) > 0) {
                n4 = (int)view.getMinimumSpan(n);
                n5 = (int)(f * (float)n4);
                n6 = n4 - n5;
                sizeRequirements2.minimum = Math.max(n5, sizeRequirements2.minimum);
                sizeRequirements3.minimum = Math.max(n6, sizeRequirements3.minimum);
                n4 = (int)view.getMaximumSpan(n);
                n5 = (int)(f * (float)n4);
                n6 = n4 - n5;
                sizeRequirements2.maximum = Math.max(n5, sizeRequirements2.maximum);
                sizeRequirements3.maximum = Math.max(n6, sizeRequirements3.maximum);
            } else {
                sizeRequirements2.minimum = Math.max(n5, sizeRequirements2.minimum);
                sizeRequirements3.minimum = Math.max(n6, sizeRequirements3.minimum);
                sizeRequirements2.maximum = Math.max(n5, sizeRequirements2.maximum);
                sizeRequirements3.maximum = Math.max(n6, sizeRequirements3.maximum);
            }
            ++n3;
        }
        sizeRequirements.preferred = (int)Math.min((long)sizeRequirements2.preferred + (long)sizeRequirements3.preferred, Integer.MAX_VALUE);
        if (sizeRequirements.preferred > 0) {
            sizeRequirements.alignment = (float)sizeRequirements2.preferred / (float)sizeRequirements.preferred;
        }
        if (sizeRequirements.alignment == 0.0f) {
            sizeRequirements.minimum = sizeRequirements3.minimum;
            sizeRequirements.maximum = sizeRequirements3.maximum;
        } else if (sizeRequirements.alignment == 1.0f) {
            sizeRequirements.minimum = sizeRequirements2.minimum;
            sizeRequirements.maximum = sizeRequirements2.maximum;
        } else {
            sizeRequirements.minimum = Math.max((int)((float)sizeRequirements2.minimum / sizeRequirements.alignment), (int)((float)sizeRequirements3.minimum / (1.0f - sizeRequirements.alignment)));
            sizeRequirements.maximum = Math.min((int)((float)sizeRequirements2.maximum / sizeRequirements.alignment), (int)((float)sizeRequirements3.maximum / (1.0f - sizeRequirements.alignment)));
        }
        return sizeRequirements;
    }

    protected int getOffset(int n, int n2) {
        int[] nArray = n == this.majorAxis ? this.majorOffsets : this.minorOffsets;
        return nArray[n2];
    }

    protected int getSpan(int n, int n2) {
        int[] nArray = n == this.majorAxis ? this.majorSpans : this.minorSpans;
        return nArray[n2];
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        View view;
        int n2;
        int n3;
        if (this.majorAxis == 1 && (n3 = this.getViewIndexAtPosition(n2 = bias == Position.Bias.Backward ? Math.max(0, n - 1) : n)) != -1 && (view = this.getView(n3)) != null && view instanceof CompositeView) {
            return ((CompositeView)view).flipEastAndWestAtEnds(n, bias);
        }
        return false;
    }
}

