/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class SimpleAttributeSet
implements MutableAttributeSet,
Serializable,
Cloneable {
    public static final AttributeSet EMPTY = new EmptyAttributeSet();
    private transient Hashtable table = new Hashtable(3);
    private static Enumeration emptyEnumeration;

    public SimpleAttributeSet() {
    }

    public SimpleAttributeSet(AttributeSet attributeSet) {
        this.addAttributes(attributeSet);
    }

    private SimpleAttributeSet(Hashtable hashtable) {
        this.table = hashtable;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int getAttributeCount() {
        return this.table.size();
    }

    public boolean isDefined(Object object) {
        return this.table.containsKey(object);
    }

    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public Enumeration getAttributeNames() {
        return this.table.keys();
    }

    public Object getAttribute(Object object) {
        AttributeSet attributeSet;
        Object object2 = this.table.get(object);
        if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
            object2 = attributeSet.getAttribute(object);
        }
        return object2;
    }

    public boolean containsAttribute(Object object, Object object2) {
        return object2.equals(this.getAttribute(object));
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        boolean bl = true;
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (bl && enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            bl = attributeSet.getAttribute(e).equals(this.getAttribute(e));
        }
        return bl;
    }

    public void addAttribute(Object object, Object object2) {
        this.table.put(object, object2);
    }

    public void addAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.addAttribute(e, attributeSet.getAttribute(e));
        }
    }

    public void removeAttribute(Object object) {
        this.table.remove(object);
    }

    public void removeAttributes(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeAttribute(enumeration.nextElement());
        }
    }

    public void removeAttributes(AttributeSet attributeSet) {
        if (attributeSet == this) {
            this.table.clear();
        } else {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Object object = attributeSet.getAttribute(e);
                if (!object.equals(this.getAttribute(e))) continue;
                this.removeAttribute(e);
            }
        }
    }

    public AttributeSet getResolveParent() {
        return (AttributeSet)this.table.get(StyleConstants.ResolveAttribute);
    }

    public void setResolveParent(AttributeSet attributeSet) {
        this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
    }

    public Object clone() {
        SimpleAttributeSet simpleAttributeSet;
        try {
            simpleAttributeSet = (SimpleAttributeSet)super.clone();
            simpleAttributeSet.table = (Hashtable)this.table.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            simpleAttributeSet = null;
        }
        return simpleAttributeSet;
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AttributeSet) {
            AttributeSet attributeSet = (AttributeSet)object;
            return this.isEqual(attributeSet);
        }
        return false;
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = this.getAttribute(e);
            string = object instanceof AttributeSet ? string + e + "=**AttributeSet** " : string + e + "=" + object + " ";
        }
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        StyleContext.writeAttributeSet(objectOutputStream, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.table = new Hashtable(3);
        StyleContext.readAttributeSet(objectInputStream, this);
    }

    private static Enumeration getEmptyEnumeration() {
        if (emptyEnumeration == null) {
            emptyEnumeration = new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException("No more elements");
                }
            };
        }
        return emptyEnumeration;
    }

    static class EmptyAttributeSet
    implements AttributeSet,
    Serializable {
        EmptyAttributeSet() {
        }

        public int getAttributeCount() {
            return 0;
        }

        public boolean isDefined(Object object) {
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return attributeSet.getAttributeCount() == 0;
        }

        public AttributeSet copyAttributes() {
            return this;
        }

        public Object getAttribute(Object object) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return SimpleAttributeSet.getEmptyEnumeration();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return false;
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return attributeSet.getAttributeCount() == 0;
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof AttributeSet && ((AttributeSet)object).getAttributeCount() == 0;
        }

        public int hashCode() {
            return 0;
        }
    }
}

