/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int GoodBreakWeight = 1000;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    static final Position.Bias[] sharedBiasReturn = new Position.Bias[1];
    private View parent;
    private Element elem;

    public View(Element element) {
        this.elem = element;
    }

    public View getParent() {
        return this.parent;
    }

    public boolean isVisible() {
        return true;
    }

    public abstract float getPreferredSpan(int var1);

    public float getMinimumSpan(int n) {
        int n2 = this.getResizeWeight(n);
        if (n2 == 0) {
            return this.getPreferredSpan(n);
        }
        return 0.0f;
    }

    public float getMaximumSpan(int n) {
        int n2 = this.getResizeWeight(n);
        if (n2 == 0) {
            return this.getPreferredSpan(n);
        }
        return 2.1474836E9f;
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        View view2 = this.getParent();
        if (view2 != null) {
            view2.preferenceChanged(this, bl, bl2);
        }
    }

    public float getAlignment(int n) {
        return 0.5f;
    }

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View view) {
        if (view == null) {
            int n = 0;
            while (n < this.getViewCount()) {
                if (this.getView(n).getParent() == this) {
                    this.getView(n).setParent(null);
                }
                ++n;
            }
        }
        this.parent = view;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int n) {
        return null;
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), null);
    }

    public void remove(int n) {
        this.replace(n, 1, null);
    }

    public void insert(int n, View view) {
        View[] viewArray = new View[]{view};
        this.replace(n, 0, viewArray);
    }

    public void append(View view) {
        View[] viewArray = new View[]{view};
        this.replace(this.getViewCount(), 0, viewArray);
    }

    public void replace(int n, int n2, View[] viewArray) {
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return -1;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return null;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        biasArray[0] = Position.Bias.Forward;
        switch (n2) {
            case 1: 
            case 5: {
                Rectangle rectangle;
                if (n == -1) {
                    n = n2 == 1 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent jTextComponent = (JTextComponent)this.getContainer();
                Caret caret = jTextComponent != null ? jTextComponent.getCaret() : null;
                Point point = caret != null ? caret.getMagicCaretPosition() : null;
                int n3 = point == null ? ((rectangle = jTextComponent.modelToView(n)) == null ? 0 : rectangle.x) : point.x;
                if (n2 == 1) {
                    n = Utilities.getPositionAbove(jTextComponent, n, n3);
                    break;
                }
                n = Utilities.getPositionBelow(jTextComponent, n, n3);
                break;
            }
            case 7: {
                if (n == -1) {
                    n = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                n = Math.max(0, n - 1);
                break;
            }
            case 3: {
                if (n == -1) {
                    n = this.getStartOffset();
                    break;
                }
                n = Math.min(n + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n2, shape, bias2);
        }
        rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        return rectangle2;
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.getViewCount() > 0) {
            Element element = this.getElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange != null && !this.updateChildren(elementChange, documentEvent, viewFactory)) {
                elementChange = null;
            }
            this.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
            this.updateLayout(elementChange, documentEvent, shape);
        }
    }

    public Document getDocument() {
        return this.elem.getDocument();
    }

    public int getStartOffset() {
        return this.elem.getStartOffset();
    }

    public int getEndOffset() {
        return this.elem.getEndOffset();
    }

    public Element getElement() {
        return this.elem;
    }

    public Graphics getGraphics() {
        Container container = this.getContainer();
        return container.getGraphics();
    }

    public AttributeSet getAttributes() {
        return this.elem.getAttributes();
    }

    public View breakView(int n, int n2, float f, float f2) {
        return this;
    }

    public View createFragment(int n, int n2) {
        return this;
    }

    public int getBreakWeight(int n, float f, float f2) {
        if (f2 > this.getPreferredSpan(n)) {
            return 1000;
        }
        return 0;
    }

    public int getResizeWeight(int n) {
        return 0;
    }

    public void setSize(float f, float f2) {
    }

    public Container getContainer() {
        View view = this.getParent();
        return view != null ? view.getContainer() : null;
    }

    public ViewFactory getViewFactory() {
        View view = this.getParent();
        return view != null ? view.getViewFactory() : null;
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        int n = this.getViewIndex(f, f2, shape);
        if (n >= 0) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = (shape = this.getChildAllocation(n, shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (rectangle.contains(f, f2)) {
                return this.getView(n).getToolTipText(f, f2, shape);
            }
        }
        return null;
    }

    public int getViewIndex(float f, float f2, Shape shape) {
        int n = this.getViewCount() - 1;
        while (n >= 0) {
            Shape shape2 = this.getChildAllocation(n, shape);
            if (shape2 != null) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape.getBounds();
                if (rectangle.contains(f, f2)) {
                    return n;
                }
            }
            --n;
        }
        return -1;
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        int n;
        Element[] elementArray = elementChange.getChildrenRemoved();
        Element[] elementArray2 = elementChange.getChildrenAdded();
        View[] viewArray = null;
        if (elementArray2 != null) {
            viewArray = new View[elementArray2.length];
            n = 0;
            while (n < elementArray2.length) {
                viewArray[n] = viewFactory.create(elementArray2[n]);
                ++n;
            }
        }
        n = 0;
        int n2 = elementChange.getIndex();
        if (elementArray != null) {
            n = elementArray.length;
        }
        this.replace(n2, n, viewArray);
        return true;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        int n;
        View view;
        Element element = this.getElement();
        int n2 = documentEvent.getOffset();
        int n3 = this.getViewIndex(n2, Position.Bias.Forward);
        if (n3 == -1 && documentEvent.getType() == DocumentEvent.EventType.REMOVE && n2 >= this.getEndOffset()) {
            n3 = this.getViewCount() - 1;
        }
        int n4 = n3;
        View view2 = view = n3 >= 0 ? this.getView(n3) : null;
        if (view != null && view.getStartOffset() == n2 && n2 > 0) {
            n3 = Math.max(n3 - 1, 0);
        }
        if (documentEvent.getType() != DocumentEvent.EventType.REMOVE && (n4 = this.getViewIndex(n2 + documentEvent.getLength(), Position.Bias.Forward)) < 0) {
            n4 = this.getViewCount() - 1;
        }
        int n5 = n = n4 + 1;
        Element[] elementArray2 = elementArray = elementChange != null ? elementChange.getChildrenAdded() : null;
        if (elementArray != null && elementArray.length > 0) {
            n = elementChange.getIndex();
            n5 = n + elementArray.length - 1;
        }
        int n6 = n3 = Math.max(n3, 0);
        while (n6 <= n4) {
            if ((n6 < n || n6 > n5) && (view = this.getView(n6)) != null) {
                Shape shape2 = this.getChildAllocation(n6, shape);
                this.forwardUpdateToView(view, documentEvent, shape2, viewFactory);
            }
            ++n6;
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        DocumentEvent.EventType eventType = documentEvent.getType();
        if (eventType == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(documentEvent, shape, viewFactory);
        } else if (eventType == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(documentEvent, shape, viewFactory);
        } else {
            view.changedUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
        if (elementChange != null && shape != null) {
            this.preferenceChanged(null, true, true);
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        return this.modelToView(n, shape, Position.Bias.Forward);
    }

    public int viewToModel(float f, float f2, Shape shape) {
        View.sharedBiasReturn[0] = Position.Bias.Forward;
        return this.viewToModel(f, f2, shape, sharedBiasReturn);
    }
}

