/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import sun.awt.ConstrainableGraphics;
import sun.awt.DebugHelper;
import sun.awt.Graphics2Delegate;

public abstract class SunGraphicsCallback {
    public static final int HEAVYWEIGHTS = 1;
    public static final int LIGHTWEIGHTS = 2;
    public static final int TWO_PASSES = 4;
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$SunGraphicsCallback == null ? (class$sun$awt$SunGraphicsCallback = SunGraphicsCallback.class$("sun.awt.SunGraphicsCallback")) : class$sun$awt$SunGraphicsCallback);
    static /* synthetic */ Class class$sun$awt$SunGraphicsCallback;

    public abstract void run(Component var1, Graphics var2);

    protected void constrainGraphics(Graphics graphics, Rectangle rectangle) {
        if (graphics instanceof ConstrainableGraphics) {
            ((ConstrainableGraphics)((Object)graphics)).constrain(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics.translate(rectangle.x, rectangle.y);
        }
        graphics.clipRect(0, 0, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runOneComponent(Component component, Rectangle rectangle, Graphics graphics, Shape shape, int n) {
        if (component == null || component.getPeer() == null || !component.isVisible()) {
            return;
        }
        boolean bl = component.isLightweight();
        if (bl && (n & 2) == 0 || !bl && (n & 1) == 0) {
            return;
        }
        if (rectangle == null) {
            rectangle = component.getBounds();
        }
        if (shape == null || shape.intersects(rectangle)) {
            Graphics graphics2 = graphics.create();
            try {
                this.constrainGraphics(graphics2, rectangle);
                graphics2.setFont(component.getFont());
                graphics2.setColor(component.getForeground());
                if (graphics2 instanceof Graphics2D) {
                    ((Graphics2D)graphics2).setBackground(component.getBackground());
                } else if (graphics2 instanceof Graphics2Delegate) {
                    ((Graphics2Delegate)((Object)graphics2)).setBackground(component.getBackground());
                }
                this.run(component, graphics2);
                Object var9_8 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    public final void runComponents(Component[] componentArray, Graphics graphics, int n) {
        int n2 = componentArray.length;
        Shape shape = graphics.getClip();
        if ((n & 4) != 0) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                this.runOneComponent(componentArray[n3], null, graphics, shape, 2);
                --n3;
            }
            int n4 = n2 - 1;
            while (n4 >= 0) {
                this.runOneComponent(componentArray[n4], null, graphics, shape, 1);
                --n4;
            }
        } else {
            int n5 = n2 - 1;
            while (n5 >= 0) {
                this.runOneComponent(componentArray[n5], null, graphics, shape, n);
                --n5;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class PrintHeavyweightComponentsCallback
    extends SunGraphicsCallback {
        private static PrintHeavyweightComponentsCallback instance = new PrintHeavyweightComponentsCallback();

        private PrintHeavyweightComponentsCallback() {
        }

        public void run(Component component, Graphics graphics) {
            if (!component.isLightweight()) {
                component.printAll(graphics);
            } else if (component instanceof Container) {
                this.runComponents(((Container)component).getComponents(), graphics, 3);
            }
        }

        public static PrintHeavyweightComponentsCallback getInstance() {
            return instance;
        }
    }

    public static final class PaintHeavyweightComponentsCallback
    extends SunGraphicsCallback {
        private static PaintHeavyweightComponentsCallback instance = new PaintHeavyweightComponentsCallback();

        private PaintHeavyweightComponentsCallback() {
        }

        public void run(Component component, Graphics graphics) {
            if (!component.isLightweight()) {
                component.paintAll(graphics);
            } else if (component instanceof Container) {
                this.runComponents(((Container)component).getComponents(), graphics, 3);
            }
        }

        public static PaintHeavyweightComponentsCallback getInstance() {
            return instance;
        }
    }
}

