/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;

public final class FontResolver {
    private Font[] allFonts;
    private static final float DEFAULT_SIZE = 12.0f;
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
        this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        this.allFonts = (Font[])this.allFonts.clone();
        int n = 0;
        while (n < this.allFonts.length) {
            this.allFonts[n] = this.allFonts[n].deriveFont(12.0f);
            ++n;
        }
    }

    private int getIndexFor(char c) {
        int n = 0;
        while (n < this.allFonts.length) {
            if (this.allFonts[n].canDisplay(c)) {
                return n + 1;
            }
            ++n;
        }
        return 1;
    }

    public int getFontIndex(char c) {
        int n;
        int n2 = c >> 9;
        int[] nArray = this.blocks[n2];
        if (nArray == null) {
            nArray = new int[128];
            this.blocks[n2] = nArray;
        }
        if (nArray[n = c & 0x7F] == 0) {
            nArray[n] = this.getIndexFor(c);
        }
        return nArray[n];
    }

    public Font getFont(int n, Map map) {
        Font font = this.allFonts[n - 1];
        return font.deriveFont(map);
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }
}

