/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.im.spi.InputMethodDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import sun.awt.InputMethodSupport;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.awt.im.InputMethodMenu;
import sun.misc.Service;

class ExecutableInputMethodManager
extends InputMethodManager
implements Runnable {
    private InputContext currentInputContext;
    private String triggerMenuString;
    private InputMethodMenu selectionMenu;
    private static String selectInputMethodMenuTitle;
    private InputMethodLocator hostAdapterLocator;
    private int javaInputMethodCount;
    private Vector javaInputMethodLocatorList;
    private Component requestComponent;
    private Component invokerComponent;
    private InputContext requestInputContext;
    private static final String preferredIMNode = "/sun/awt/im/preferredInputMethod";
    private static final String descriptorKey = "descriptor";
    private Hashtable preferredLocatorCache = new Hashtable();
    private Preferences userRoot;
    static /* synthetic */ Class class$java$awt$im$spi$InputMethodDescriptor;

    ExecutableInputMethodManager() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            InputMethodDescriptor inputMethodDescriptor;
            if (toolkit instanceof InputMethodSupport && (inputMethodDescriptor = ((InputMethodSupport)((Object)toolkit)).getInputMethodAdapterDescriptor()) != null) {
                this.hostAdapterLocator = new InputMethodLocator(inputMethodDescriptor, null, null);
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.javaInputMethodLocatorList = new Vector();
        this.initializeInputMethodLocatorList();
    }

    synchronized void initialize() {
        this.triggerMenuString = selectInputMethodMenuTitle = Toolkit.getProperty("AWT.InputMethodSelectionMenu", "Select Input Method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.hasMultipleInputMethods()) {
            try {
                ExecutableInputMethodManager executableInputMethodManager = this;
                synchronized (executableInputMethodManager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (true) {
            this.waitForChangeRequest();
            this.initializeInputMethodLocatorList();
            InputMethodMenu.showInputMethodMenu(this.requestComponent, this.invokerComponent);
        }
    }

    void setInputContext(InputContext inputContext) {
        if (this.currentInputContext == null || inputContext != null) {
            // empty if block
        }
        this.currentInputContext = inputContext;
    }

    public synchronized void notifyChangeRequest(Component component) {
        if (!(component instanceof Frame || component instanceof Dialog || component instanceof JApplet)) {
            return;
        }
        if (this.requestComponent != null) {
            return;
        }
        this.requestComponent = component;
        if (component instanceof JDialog && !(component.getParent() instanceof JFrame)) {
            this.invokerComponent = component;
        }
        if (this.invokerComponent == null) {
            this.invokerComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.invokerComponent != null && !this.invokerComponent.isShowing()) {
                this.invokerComponent = component;
            }
        }
        if (this.invokerComponent == null) {
            this.invokerComponent = component;
        }
        this.notify();
    }

    public synchronized void notifyChangeRequestByHotKey(Component component) {
        this.invokerComponent = component;
        while (!(component instanceof Frame || component instanceof Dialog || component instanceof JApplet)) {
            if (component == null) {
                return;
            }
            component = component.getParent();
        }
        this.notifyChangeRequest(component);
    }

    public String getTriggerMenuString() {
        return this.triggerMenuString;
    }

    boolean hasMultipleInputMethods() {
        return this.hostAdapterLocator != null && this.javaInputMethodCount > 0 || this.javaInputMethodCount > 1;
    }

    private synchronized void waitForChangeRequest() {
        try {
            while (this.requestComponent == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeInputMethodLocatorList() {
        Vector vector = this.javaInputMethodLocatorList;
        synchronized (vector) {
            this.javaInputMethodLocatorList.clear();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator iterator = Service.installedProviders((Class)(class$java$awt$im$spi$InputMethodDescriptor == null ? (class$java$awt$im$spi$InputMethodDescriptor = ExecutableInputMethodManager.class$("java.awt.im.spi.InputMethodDescriptor")) : class$java$awt$im$spi$InputMethodDescriptor));
                        while (iterator.hasNext()) {
                            InputMethodDescriptor inputMethodDescriptor = (InputMethodDescriptor)iterator.next();
                            ClassLoader classLoader = inputMethodDescriptor.getClass().getClassLoader();
                            ExecutableInputMethodManager.this.javaInputMethodLocatorList.add(new InputMethodLocator(inputMethodDescriptor, classLoader, null));
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            this.javaInputMethodCount = this.javaInputMethodLocatorList.size();
        }
        if (this.hasMultipleInputMethods()) {
            if (this.userRoot == null) {
                this.userRoot = this.getUserRoot();
            }
        } else {
            this.triggerMenuString = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showInputMethodMenu() {
        Object object;
        if (!this.hasMultipleInputMethods()) {
            this.requestComponent = null;
            this.invokerComponent = null;
            return;
        }
        this.selectionMenu = InputMethodMenu.getMenu(selectInputMethodMenuTitle);
        if (this.invokerComponent instanceof JRootPane && this.selectionMenu.isVisible()) {
            ExecutableInputMethodManager executableInputMethodManager = this;
            synchronized (executableInputMethodManager) {
                this.requestComponent = null;
                this.invokerComponent = null;
            }
            return;
        }
        this.selectionMenu.removeAll();
        String string = this.getCurrentSelection();
        if (this.hostAdapterLocator != null) {
            this.selectionMenu.addOneInputMethodToMenu(this.hostAdapterLocator, string);
            this.selectionMenu.addSeparator();
        }
        int n = 0;
        while (n < this.javaInputMethodLocatorList.size()) {
            object = (InputMethodLocator)this.javaInputMethodLocatorList.get(n);
            this.selectionMenu.addOneInputMethodToMenu((InputMethodLocator)object, string);
            ++n;
        }
        object = this;
        synchronized (object) {
            this.selectionMenu.addToComponent(this.requestComponent);
            this.requestInputContext = this.currentInputContext;
            Point point = this.requestComponent.getLocationOnScreen();
            Point point2 = this.invokerComponent.getLocationOnScreen();
            int n2 = 60;
            int n3 = 80;
            if (this.requestComponent.getSize().width < n2 * 2) {
                n2 = this.requestComponent.getSize().width / 2;
            }
            if (this.requestComponent.getSize().height < n3 * 2) {
                n3 = this.requestComponent.getSize().height / 2;
            }
            this.selectionMenu.show(this.invokerComponent, point.x + n2 - point2.x, point.y + n3 - point2.y);
            this.requestComponent = null;
            this.invokerComponent = null;
        }
    }

    private String getCurrentSelection() {
        InputMethodLocator inputMethodLocator;
        InputContext inputContext = this.currentInputContext;
        if (inputContext != null && (inputMethodLocator = inputContext.getInputMethodLocator()) != null) {
            return inputMethodLocator.getActionCommandString();
        }
        return null;
    }

    void changeInputMethod(String string) {
        String string2;
        Object object;
        Object object2 = null;
        String string3 = string;
        String string4 = null;
        int n = string.indexOf(10);
        if (n != -1) {
            string4 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        if (this.hostAdapterLocator.getActionCommandString().equals(string3)) {
            object2 = this.hostAdapterLocator;
        } else {
            int n2 = 0;
            while (n2 < this.javaInputMethodLocatorList.size()) {
                object = (InputMethodLocator)this.javaInputMethodLocatorList.get(n2);
                string2 = ((InputMethodLocator)object).getActionCommandString();
                if (string2.equals(string3)) {
                    object2 = object;
                    break;
                }
                ++n2;
            }
        }
        if (object2 != null && string4 != null) {
            String string5 = "";
            object = "";
            string2 = "";
            int n3 = string4.indexOf(95);
            if (n3 == -1) {
                string5 = string4;
            } else {
                string5 = string4.substring(0, n3);
                int n4 = n3 + 1;
                if ((n3 = string4.indexOf(95, n4)) == -1) {
                    object = string4.substring(n4);
                } else {
                    object = string4.substring(n4, n3);
                    string2 = string4.substring(n3 + 1);
                }
            }
            Locale locale = new Locale(string5, (String)object, string2);
            object2 = ((InputMethodLocator)object2).deriveLocator(locale);
        }
        if (object2 == null) {
            return;
        }
        if (this.requestInputContext != null) {
            this.requestInputContext.changeInputMethod((InputMethodLocator)object2);
            this.requestInputContext = null;
            this.putPreferredInputMethod((InputMethodLocator)object2);
        }
    }

    InputMethodLocator findInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator = this.getPreferredInputMethod(locale);
        if (inputMethodLocator != null) {
            return inputMethodLocator;
        }
        if (this.hostAdapterLocator != null && this.hostAdapterLocator.isLocaleAvailable(locale)) {
            return this.hostAdapterLocator.deriveLocator(locale);
        }
        this.initializeInputMethodLocatorList();
        int n = 0;
        while (n < this.javaInputMethodLocatorList.size()) {
            InputMethodLocator inputMethodLocator2 = (InputMethodLocator)this.javaInputMethodLocatorList.get(n);
            if (inputMethodLocator2.isLocaleAvailable(locale)) {
                return inputMethodLocator2.deriveLocator(locale);
            }
            ++n;
        }
        return null;
    }

    Locale getDefaultKeyboardLocale() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof InputMethodSupport) {
            return ((InputMethodSupport)((Object)toolkit)).getDefaultKeyboardLocale();
        }
        return Locale.getDefault();
    }

    private synchronized InputMethodLocator getPreferredInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator = null;
        if (!this.hasMultipleInputMethods()) {
            return null;
        }
        inputMethodLocator = (InputMethodLocator)this.preferredLocatorCache.get(locale.toString().intern());
        if (inputMethodLocator != null) {
            return inputMethodLocator;
        }
        String string = this.findPreferredInputMethodNode(locale);
        String string2 = this.readPreferredInputMethod(string);
        if (string2 != null) {
            if (this.hostAdapterLocator != null && this.hostAdapterLocator.getDescriptor().getClass().getName().equals(string2)) {
                Locale locale2 = this.getAdvertisedLocale(this.hostAdapterLocator, locale);
                if (locale2 != null) {
                    inputMethodLocator = this.hostAdapterLocator.deriveLocator(locale2);
                    this.preferredLocatorCache.put(locale.toString().intern(), inputMethodLocator);
                }
                return inputMethodLocator;
            }
            int n = 0;
            while (n < this.javaInputMethodLocatorList.size()) {
                InputMethodLocator inputMethodLocator2 = (InputMethodLocator)this.javaInputMethodLocatorList.get(n);
                InputMethodDescriptor inputMethodDescriptor = inputMethodLocator2.getDescriptor();
                if (inputMethodDescriptor.getClass().getName().equals(string2)) {
                    Locale locale3 = this.getAdvertisedLocale(inputMethodLocator2, locale);
                    if (locale3 != null) {
                        inputMethodLocator = inputMethodLocator2.deriveLocator(locale3);
                        this.preferredLocatorCache.put(locale.toString().intern(), inputMethodLocator);
                    }
                    return inputMethodLocator;
                }
                ++n;
            }
            this.writePreferredInputMethod(string, null);
        }
        return null;
    }

    private String findPreferredInputMethodNode(Locale locale) {
        if (this.userRoot == null) {
            return null;
        }
        String string = "/sun/awt/im/preferredInputMethod/" + this.createLocalePath(locale);
        while (!string.equals(preferredIMNode)) {
            try {
                if (this.userRoot.nodeExists(string) && this.readPreferredInputMethod(string) != null) {
                    return string;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            string = string.substring(0, string.lastIndexOf(47));
        }
        return null;
    }

    private String readPreferredInputMethod(String string) {
        if (this.userRoot == null || string == null) {
            return null;
        }
        return this.userRoot.node(string).get(descriptorKey, null);
    }

    private synchronized void putPreferredInputMethod(InputMethodLocator inputMethodLocator) {
        Object object;
        InputMethodDescriptor inputMethodDescriptor = inputMethodLocator.getDescriptor();
        Locale locale = inputMethodLocator.getLocale();
        if (locale == null) {
            try {
                object = inputMethodDescriptor.getAvailableLocales();
                if (((Locale[])object).length != 1) {
                    return;
                }
                locale = object[0];
            }
            catch (AWTException aWTException) {
                return;
            }
        }
        if (locale.equals(Locale.JAPAN)) {
            locale = Locale.JAPANESE;
        }
        if (locale.equals(Locale.KOREA)) {
            locale = Locale.KOREAN;
        }
        if (locale.equals(new Locale("th", "TH"))) {
            locale = new Locale("th");
        }
        object = "/sun/awt/im/preferredInputMethod/" + this.createLocalePath(locale);
        this.writePreferredInputMethod((String)object, inputMethodDescriptor.getClass().getName());
        this.preferredLocatorCache.put(locale.toString().intern(), inputMethodLocator.deriveLocator(locale));
    }

    private String createLocalePath(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        String string4 = null;
        string4 = !string3.equals("") ? "_" + string + "/_" + string2 + "/_" + string3 : (!string2.equals("") ? "_" + string + "/_" + string2 : "_" + string);
        return string4;
    }

    private void writePreferredInputMethod(String string, String string2) {
        if (this.userRoot != null) {
            Preferences preferences = this.userRoot.node(string);
            if (string2 != null) {
                preferences.put(descriptorKey, string2);
            } else {
                preferences.remove(descriptorKey);
            }
        }
    }

    private Preferences getUserRoot() {
        return (Preferences)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Preferences.userRoot();
            }
        });
    }

    private Locale getAdvertisedLocale(InputMethodLocator inputMethodLocator, Locale locale) {
        Locale locale2 = null;
        if (inputMethodLocator.isLocaleAvailable(locale)) {
            locale2 = locale;
        } else if (locale.getLanguage().equals("ja")) {
            if (inputMethodLocator.isLocaleAvailable(Locale.JAPAN)) {
                locale2 = Locale.JAPAN;
            } else if (inputMethodLocator.isLocaleAvailable(Locale.JAPANESE)) {
                locale2 = Locale.JAPANESE;
            }
        } else if (locale.getLanguage().equals("ko")) {
            if (inputMethodLocator.isLocaleAvailable(Locale.KOREA)) {
                locale2 = Locale.KOREA;
            } else if (inputMethodLocator.isLocaleAvailable(Locale.KOREAN)) {
                locale2 = Locale.KOREAN;
            }
        } else if (locale.getLanguage().equals("th")) {
            if (inputMethodLocator.isLocaleAvailable(new Locale("th", "TH"))) {
                locale2 = new Locale("th", "TH");
            } else if (inputMethodLocator.isLocaleAvailable(new Locale("th"))) {
                locale2 = new Locale("th");
            }
        }
        return locale2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

