/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteComponentRaster;

public class ByteInterleavedRaster
extends ByteComponentRaster {
    boolean inOrder;
    int dbOffset;
    int dbOffsetPacked;
    boolean packed = false;
    int[] bitMasks;
    int[] bitOffsets;
    private int maxX = this.minX + this.width;
    private int maxY = this.minY + this.height;

    public ByteInterleavedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    private boolean isInterleaved(ComponentSampleModel componentSampleModel) {
        int n;
        int n2 = this.sampleModel.getNumBands();
        if (n2 == 1) {
            return true;
        }
        int[] nArray = componentSampleModel.getBankIndices();
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] != 0) {
                return false;
            }
            ++n3;
        }
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n4 = n = nArray2[0];
        int n5 = 1;
        while (n5 < n2) {
            int n6 = nArray2[n5];
            if (n6 < n) {
                n = n6;
            }
            if (n6 > n4) {
                n4 = n6;
            }
            ++n5;
        }
        return n4 - n < componentSampleModel.getPixelStride();
    }

    public ByteInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteInterleavedRaster byteInterleavedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteInterleavedRaster);
        SampleModel sampleModel2;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteInterleavedRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        int n = rectangle.x - point.x;
        int n2 = rectangle.y - point.y;
        if (sampleModel instanceof PixelInterleavedSampleModel || sampleModel instanceof ComponentSampleModel && this.isInterleaved((ComponentSampleModel)sampleModel)) {
            sampleModel2 = (ComponentSampleModel)sampleModel;
            this.scanlineStride = ((ComponentSampleModel)sampleModel2).getScanlineStride();
            this.pixelStride = ((ComponentSampleModel)sampleModel2).getPixelStride();
            this.dataOffsets = ((ComponentSampleModel)sampleModel2).getBandOffsets();
            int n3 = 0;
            while (n3 < this.getNumDataElements()) {
                int n4 = n3++;
                this.dataOffsets[n4] = this.dataOffsets[n4] + (n * this.pixelStride + n2 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            sampleModel2 = (SinglePixelPackedSampleModel)sampleModel;
            this.packed = true;
            this.bitMasks = ((SinglePixelPackedSampleModel)sampleModel2).getBitMasks();
            this.bitOffsets = ((SinglePixelPackedSampleModel)sampleModel2).getBitOffsets();
            this.scanlineStride = ((SinglePixelPackedSampleModel)sampleModel2).getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = dataBufferByte.getOffset();
            this.dataOffsets[0] = this.dataOffsets[0] + (n * this.pixelStride + n2 * this.scanlineStride);
        } else {
            throw new RasterFormatException("ByteInterleavedRasters must have PixelInterleavedSampleModel, SinglePixelPackedSampleModel or interleaved ComponentSampleModel.  Sample model is " + sampleModel);
        }
        this.bandOffset = this.dataOffsets[0];
        this.dbOffsetPacked = dataBuffer.getOffset() - this.sampleModelTranslateY * this.scanlineStride - this.sampleModelTranslateX * this.pixelStride;
        this.dbOffset = this.dbOffsetPacked - (n * this.pixelStride + n2 * this.scanlineStride);
        this.inOrder = false;
        if (this.numDataElements == this.pixelStride) {
            this.inOrder = true;
            int n5 = 1;
            while (n5 < this.numDataElements) {
                if (this.dataOffsets[n5] - this.dataOffsets[0] != n5) {
                    this.inOrder = false;
                    break;
                }
                ++n5;
            }
        }
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n4 = 0;
        while (n4 < this.numDataElements) {
            byArray[n4] = this.data[this.dataOffsets[n4] + n3];
            ++n4;
        }
        return byArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.getByteData(n, n2, n3, n4, (byte[])object);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[n3 * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(this.data, n6, byArray, 0, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n6, byArray, n7, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n7++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * n3 * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.inOrder) {
            n5 += this.dataOffsets[0];
            int n7 = n3 * this.pixelStride;
            if (this.scanlineStride == n7) {
                System.arraycopy(this.data, n5, byArray, n6, n7 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n5, byArray, n6, n7);
                    n6 += n7;
                    ++n8;
                    n5 += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            n5 += this.dataOffsets[0];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n5;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n6++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            n5 += this.dataOffsets[0];
            int n12 = this.dataOffsets[1] - this.dataOffsets[0];
            int n13 = 0;
            while (n13 < n4) {
                int n14 = n5;
                int n15 = 0;
                while (n15 < n3) {
                    byArray[n6++] = this.data[n14];
                    byArray[n6++] = this.data[n14 + n12];
                    ++n15;
                    n14 += this.pixelStride;
                }
                ++n13;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            n5 += this.dataOffsets[0];
            int n16 = this.dataOffsets[1] - this.dataOffsets[0];
            int n17 = this.dataOffsets[2] - this.dataOffsets[0];
            int n18 = 0;
            while (n18 < n4) {
                int n19 = n5;
                int n20 = 0;
                while (n20 < n3) {
                    byArray[n6++] = this.data[n19];
                    byArray[n6++] = this.data[n19 + n16];
                    byArray[n6++] = this.data[n19 + n17];
                    ++n20;
                    n19 += this.pixelStride;
                }
                ++n18;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            n5 += this.dataOffsets[0];
            int n21 = this.dataOffsets[1] - this.dataOffsets[0];
            int n22 = this.dataOffsets[2] - this.dataOffsets[0];
            int n23 = this.dataOffsets[3] - this.dataOffsets[0];
            int n24 = 0;
            while (n24 < n4) {
                int n25 = n5;
                int n26 = 0;
                while (n26 < n3) {
                    byArray[n6++] = this.data[n25];
                    byArray[n6++] = this.data[n25 + n21];
                    byArray[n6++] = this.data[n25 + n22];
                    byArray[n6++] = this.data[n25 + n23];
                    ++n26;
                    n25 += this.pixelStride;
                }
                ++n24;
                n5 += this.scanlineStride;
            }
        } else {
            int n27 = 0;
            while (n27 < n4) {
                int n28 = n5;
                int n29 = 0;
                while (n29 < n3) {
                    int n30 = 0;
                    while (n30 < this.numDataElements) {
                        byArray[n6++] = this.data[this.dataOffsets[n30] + n28];
                        ++n30;
                    }
                    ++n29;
                    n28 += this.pixelStride;
                }
                ++n27;
                n5 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n4 = 0;
        while (n4 < this.numDataElements) {
            this.data[this.dataOffsets[n4] + n3] = byArray[n4];
            ++n4;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = raster.getWidth();
        int n8 = raster.getHeight();
        if (n5 < this.minX || n6 < this.minY || n5 + n7 > this.maxX || n6 + n8 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n5, n6, n3, n4, n7, n8, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, int n5, int n6, Raster raster) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        Object object = null;
        if (raster instanceof ByteInterleavedRaster) {
            ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)raster;
            byte[] byArray = byteInterleavedRaster.getDataStorage();
            if (this.inOrder && byteInterleavedRaster.inOrder && this.pixelStride == byteInterleavedRaster.pixelStride) {
                int n9 = byteInterleavedRaster.getDataOffset(0);
                int n10 = byteInterleavedRaster.getScanlineStride();
                int n11 = byteInterleavedRaster.getPixelStride();
                int n12 = n9 + (n4 - n8) * n10 + (n3 - n7) * n11;
                int n13 = this.dataOffsets[0] + (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
                int n14 = n5 * this.pixelStride;
                int n15 = 0;
                while (n15 < n6) {
                    System.arraycopy(byArray, n12, this.data, n13, n14);
                    n12 += n10;
                    n13 += this.scanlineStride;
                    ++n15;
                }
                this.notifyChanged();
                return;
            }
        }
        int n16 = 0;
        while (n16 < n6) {
            object = raster.getDataElements(n7, n8 + n16, n5, 1, object);
            this.setDataElements(n, n2 + n16, n5, 1, object);
            ++n16;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.putByteData(n, n2, n3, n4, (byte[])object);
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(byArray, 0, this.data, n6, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(byArray, n7, this.data, n6, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = byArray[n7++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.inOrder) {
            n5 += this.dataOffsets[0];
            int n7 = n3 * this.pixelStride;
            if (n7 == this.scanlineStride) {
                System.arraycopy(byArray, 0, this.data, n5, n7 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(byArray, n6, this.data, n5, n7);
                    n6 += n7;
                    ++n8;
                    n5 += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            n5 += this.dataOffsets[0];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n5;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = byArray[n6++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            n5 += this.dataOffsets[0];
            int n12 = this.dataOffsets[1] - this.dataOffsets[0];
            int n13 = 0;
            while (n13 < n4) {
                int n14 = n5;
                int n15 = 0;
                while (n15 < n3) {
                    this.data[n14] = byArray[n6++];
                    this.data[n14 + n12] = byArray[n6++];
                    ++n15;
                    n14 += this.pixelStride;
                }
                ++n13;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            n5 += this.dataOffsets[0];
            int n16 = this.dataOffsets[1] - this.dataOffsets[0];
            int n17 = this.dataOffsets[2] - this.dataOffsets[0];
            int n18 = 0;
            while (n18 < n4) {
                int n19 = n5;
                int n20 = 0;
                while (n20 < n3) {
                    this.data[n19] = byArray[n6++];
                    this.data[n19 + n16] = byArray[n6++];
                    this.data[n19 + n17] = byArray[n6++];
                    ++n20;
                    n19 += this.pixelStride;
                }
                ++n18;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            n5 += this.dataOffsets[0];
            int n21 = this.dataOffsets[1] - this.dataOffsets[0];
            int n22 = this.dataOffsets[2] - this.dataOffsets[0];
            int n23 = this.dataOffsets[3] - this.dataOffsets[0];
            int n24 = 0;
            while (n24 < n4) {
                int n25 = n5;
                int n26 = 0;
                while (n26 < n3) {
                    this.data[n25] = byArray[n6++];
                    this.data[n25 + n21] = byArray[n6++];
                    this.data[n25 + n22] = byArray[n6++];
                    this.data[n25 + n23] = byArray[n6++];
                    ++n26;
                    n25 += this.pixelStride;
                }
                ++n24;
                n5 += this.scanlineStride;
            }
        } else {
            int n27 = 0;
            while (n27 < n4) {
                int n28 = n5;
                int n29 = 0;
                while (n29 < n3) {
                    int n30 = 0;
                    while (n30 < this.numDataElements) {
                        this.data[this.dataOffsets[n30] + n28] = byArray[n6++];
                        ++n30;
                    }
                    ++n29;
                    n28 += this.pixelStride;
                }
                ++n27;
                n5 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public int getSample(int n, int n2, int n3) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int n4 = n2 * this.scanlineStride + n + this.dbOffsetPacked;
            byte by = this.data[n4];
            return (by & this.bitMasks[n3]) >>> this.bitOffsets[n3];
        }
        int n5 = n2 * this.scanlineStride + n * this.pixelStride + this.dbOffset;
        return this.data[n5 + this.dataOffsets[n3]] & 0xFF;
    }

    public void setSample(int n, int n2, int n3, int n4) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int n5 = n2 * this.scanlineStride + n + this.dbOffsetPacked;
            int n6 = this.bitMasks[n3];
            byte by = this.data[n5];
            by = (byte)(by & ~n6);
            this.data[n5] = by = (byte)(by | n4 << this.bitOffsets[n3] & n6);
        } else {
            int n7 = n2 * this.scanlineStride + n * this.pixelStride + this.dbOffset;
            this.data[n7 + this.dataOffsets[n3]] = (byte)n4;
        }
        this.notifyChanged();
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n * this.pixelStride;
        int n7 = 0;
        if (this.packed) {
            n6 += this.dbOffsetPacked;
            int n8 = this.bitMasks[n5];
            int n9 = this.bitOffsets[n5];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n6;
                int n12 = 0;
                while (n12 < n3) {
                    byte by = this.data[n11++];
                    nArray2[n7++] = (by & n8) >>> n9;
                    ++n12;
                }
                n6 += this.scanlineStride;
                ++n10;
            }
        } else {
            n6 += this.dbOffset + this.dataOffsets[n5];
            int n13 = 0;
            while (n13 < n4) {
                int n14 = n6;
                int n15 = 0;
                while (n15 < n3) {
                    nArray2[n7++] = this.data[n14] & 0xFF;
                    n14 += this.pixelStride;
                    ++n15;
                }
                n6 += this.scanlineStride;
                ++n13;
            }
        }
        return nArray2;
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n2 * this.scanlineStride + n * this.pixelStride;
        int n7 = 0;
        if (this.packed) {
            n6 += this.dbOffsetPacked;
            int n8 = this.bitMasks[n5];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    byte by = this.data[n10];
                    by = (byte)(by & ~n8);
                    int n12 = nArray[n7++];
                    by = (byte)(by | n12 << this.bitOffsets[n5] & n8);
                    this.data[n10++] = by;
                    ++n11;
                }
                n6 += this.scanlineStride;
                ++n9;
            }
        } else {
            n6 += this.dbOffset + this.dataOffsets[n5];
            int n13 = 0;
            while (n13 < n4) {
                int n14 = n6;
                int n15 = 0;
                while (n15 < n3) {
                    this.data[n14] = (byte)nArray[n7++];
                    n14 += this.pixelStride;
                    ++n15;
                }
                n6 += this.scanlineStride;
                ++n13;
            }
        }
        this.notifyChanged();
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        int n6 = 0;
        if (this.packed) {
            n5 += this.dbOffsetPacked;
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    byte by = this.data[n5 + n8];
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        nArray2[n6++] = (by & this.bitMasks[n9]) >>> this.bitOffsets[n9];
                        ++n9;
                    }
                    ++n8;
                }
                n5 += this.scanlineStride;
                ++n7;
            }
        } else {
            n5 += this.dbOffset;
            int n10 = this.dataOffsets[0];
            if (this.numBands == 1) {
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n5 + n10;
                    int n13 = 0;
                    while (n13 < n3) {
                        nArray2[n6++] = this.data[n12] & 0xFF;
                        n12 += this.pixelStride;
                        ++n13;
                    }
                    n5 += this.scanlineStride;
                    ++n11;
                }
            } else if (this.numBands == 2) {
                int n14 = this.dataOffsets[1] - n10;
                int n15 = 0;
                while (n15 < n4) {
                    int n16 = n5 + n10;
                    int n17 = 0;
                    while (n17 < n3) {
                        nArray2[n6++] = this.data[n16] & 0xFF;
                        nArray2[n6++] = this.data[n16 + n14] & 0xFF;
                        n16 += this.pixelStride;
                        ++n17;
                    }
                    n5 += this.scanlineStride;
                    ++n15;
                }
            } else if (this.numBands == 3) {
                int n18 = this.dataOffsets[1] - n10;
                int n19 = this.dataOffsets[2] - n10;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = n5 + n10;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray2[n6++] = this.data[n21] & 0xFF;
                        nArray2[n6++] = this.data[n21 + n18] & 0xFF;
                        nArray2[n6++] = this.data[n21 + n19] & 0xFF;
                        n21 += this.pixelStride;
                        ++n22;
                    }
                    n5 += this.scanlineStride;
                    ++n20;
                }
            } else if (this.numBands == 4) {
                int n23 = this.dataOffsets[1] - n10;
                int n24 = this.dataOffsets[2] - n10;
                int n25 = this.dataOffsets[3] - n10;
                int n26 = 0;
                while (n26 < n4) {
                    int n27 = n5 + n10;
                    int n28 = 0;
                    while (n28 < n3) {
                        nArray2[n6++] = this.data[n27] & 0xFF;
                        nArray2[n6++] = this.data[n27 + n23] & 0xFF;
                        nArray2[n6++] = this.data[n27 + n24] & 0xFF;
                        nArray2[n6++] = this.data[n27 + n25] & 0xFF;
                        n27 += this.pixelStride;
                        ++n28;
                    }
                    n5 += this.scanlineStride;
                    ++n26;
                }
            } else {
                int n29 = 0;
                while (n29 < n4) {
                    int n30 = n5;
                    int n31 = 0;
                    while (n31 < n3) {
                        int n32 = 0;
                        while (n32 < this.numBands) {
                            nArray2[n6++] = this.data[n30 + this.dataOffsets[n32]] & 0xFF;
                            ++n32;
                        }
                        n30 += this.pixelStride;
                        ++n31;
                    }
                    n5 += this.scanlineStride;
                    ++n29;
                }
            }
        }
        return nArray2;
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        int n6 = 0;
        if (this.packed) {
            n5 += this.dbOffsetPacked;
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < this.numBands) {
                        int n11 = nArray[n6++];
                        n9 |= n11 << this.bitOffsets[n10] & this.bitMasks[n10];
                        ++n10;
                    }
                    this.data[n5 + n8] = (byte)n9;
                    ++n8;
                }
                n5 += this.scanlineStride;
                ++n7;
            }
        } else {
            n5 += this.dbOffset;
            int n12 = this.dataOffsets[0];
            if (this.numBands == 1) {
                int n13 = 0;
                while (n13 < n4) {
                    int n14 = n5 + n12;
                    int n15 = 0;
                    while (n15 < n3) {
                        this.data[n14] = (byte)nArray[n6++];
                        n14 += this.pixelStride;
                        ++n15;
                    }
                    n5 += this.scanlineStride;
                    ++n13;
                }
            } else if (this.numBands == 2) {
                int n16 = this.dataOffsets[1] - n12;
                int n17 = 0;
                while (n17 < n4) {
                    int n18 = n5 + n12;
                    int n19 = 0;
                    while (n19 < n3) {
                        this.data[n18] = (byte)nArray[n6++];
                        this.data[n18 + n16] = (byte)nArray[n6++];
                        n18 += this.pixelStride;
                        ++n19;
                    }
                    n5 += this.scanlineStride;
                    ++n17;
                }
            } else if (this.numBands == 3) {
                int n20 = this.dataOffsets[1] - n12;
                int n21 = this.dataOffsets[2] - n12;
                int n22 = 0;
                while (n22 < n4) {
                    int n23 = n5 + n12;
                    int n24 = 0;
                    while (n24 < n3) {
                        this.data[n23] = (byte)nArray[n6++];
                        this.data[n23 + n20] = (byte)nArray[n6++];
                        this.data[n23 + n21] = (byte)nArray[n6++];
                        n23 += this.pixelStride;
                        ++n24;
                    }
                    n5 += this.scanlineStride;
                    ++n22;
                }
            } else if (this.numBands == 4) {
                int n25 = this.dataOffsets[1] - n12;
                int n26 = this.dataOffsets[2] - n12;
                int n27 = this.dataOffsets[3] - n12;
                int n28 = 0;
                while (n28 < n4) {
                    int n29 = n5 + n12;
                    int n30 = 0;
                    while (n30 < n3) {
                        this.data[n29] = (byte)nArray[n6++];
                        this.data[n29 + n25] = (byte)nArray[n6++];
                        this.data[n29 + n26] = (byte)nArray[n6++];
                        this.data[n29 + n27] = (byte)nArray[n6++];
                        n29 += this.pixelStride;
                        ++n30;
                    }
                    n5 += this.scanlineStride;
                    ++n28;
                }
            } else {
                int n31 = 0;
                while (n31 < n4) {
                    int n32 = n5;
                    int n33 = 0;
                    while (n33 < n3) {
                        int n34 = 0;
                        while (n34 < this.numBands) {
                            this.data[n32 + this.dataOffsets[n34]] = (byte)nArray[n6++];
                            ++n34;
                        }
                        n32 += this.pixelStride;
                        ++n33;
                    }
                    n5 += this.scanlineStride;
                    ++n31;
                }
            }
        }
        this.notifyChanged();
    }

    public void setRect(int n, int n2, Raster raster) {
        int n3;
        if (!(raster instanceof ByteInterleavedRaster)) {
            super.setRect(n, n2, raster);
            return;
        }
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n + n6;
        int n9 = n2 + n7;
        if (n8 < this.minX) {
            n3 = this.minX - n8;
            n4 -= n3;
            n6 += n3;
            n8 = this.minX;
        }
        if (n9 < this.minY) {
            n3 = this.minY - n9;
            n5 -= n3;
            n7 += n3;
            n9 = this.minY;
        }
        if (n8 + n4 > this.maxX) {
            n4 = this.maxX - n8;
        }
        if (n9 + n5 > this.maxY) {
            n5 = this.maxY - n9;
        }
        this.setDataElements(n8, n9, n6, n7, n4, n5, raster);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        this.notifyStolen();
        return new ByteInterleavedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ByteInterleavedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numDataElements) {
            int n3 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[n2];
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        if (this.data.length < n) {
            throw new RasterFormatException("Data array too small (should be " + n + " )");
        }
    }

    public String toString() {
        return new String("ByteInterleavedRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }
}

