/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.TextLine;

public class MTextAreaPeer
extends MComponentPeer
implements TextAreaPeer {
    static final int MARGIN = 2;
    static final int BORDER = 1;
    static final int SCROLLBAR = 16;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int topLine = 0;
    int numLines = 0;
    int textLength = 0;
    Vector lines;
    int selStart = 0;
    int selEnd = 0;
    int movedRight = 0;
    transient boolean hscrollbar;
    transient boolean vscrollbar;

    native void create(MComponentPeer var1);

    void initialize() {
        TextArea textArea = (TextArea)this.target;
        String string = textArea.getText();
        if (string != null) {
            this.setText(string);
        }
        int n = textArea.getSelectionStart();
        int n2 = textArea.getSelectionEnd();
        if (n2 > n) {
            this.select(n, n2);
        }
        super.pSetScrollbarBackground(MComponentPeer.getParent_NoClientCode(this.target).getBackground());
        if (!this.target.isBackgroundSet()) {
            this.setTargetBackground(SystemColor.text);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setEditable(textArea.isEditable());
        super.initialize();
    }

    public MTextAreaPeer(TextArea textArea) {
        super(textArea);
    }

    public void setEditable(boolean bl) {
        this.pSetEditable(bl);
        this.setBackground(this.target.getBackground());
    }

    public void setBackground(Color color) {
        this.setTextBackground(color);
    }

    public void setForeground(Color color) {
        this.pSetInnerForeground(color);
    }

    native int getExtraWidth();

    native int getExtraHeight();

    public native void setTextBackground(Color var1);

    public native void pSetEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native String getText();

    public native void insert(String var1, int var2);

    public native void replaceRange(String var1, int var2, int var3);

    public native void setFont(Font var1);

    public native void setCaretPosition(int var1);

    public native int getCaretPosition();

    public native void pSetCursor(Cursor var1);

    native void pShow2();

    native void pMakeCursorVisible();

    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.getMinimumSize(n, n2);
    }

    public Dimension getMinimumSize(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int n3 = fontMetrics.charWidth('0');
        int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        return new Dimension(n2 * n3 + this.getExtraWidth(), n * n4 + this.getExtraHeight());
    }

    public boolean isFocusable() {
        return true;
    }

    public void pasteFromClipboard() {
        block2: {
            Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) break block2;
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                string = string == null ? "" : string;
                this.replaceRange(string, this.getSelectionStart(), this.getSelectionEnd());
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        int n;
        TextArea textArea = (TextArea)this.target;
        Dimension dimension = textArea.size();
        Color color = textArea.getBackground();
        Color color2 = textArea.getForeground();
        FontMetrics fontMetrics = this.getFontMetrics(textArea.getFont());
        int n2 = 0;
        String string = textArea.getText();
        this.textLength = string.length();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n3 = 0;
        this.lines = new Vector();
        int n4 = ((TextArea)this.target).getScrollbarVisibility();
        this.vscrollbar = n4 == 0 || n4 == 1;
        this.hscrollbar = n4 == 0 || n4 == 2;
        boolean bl = !this.hscrollbar;
        int n5 = dimension.width - (this.vscrollbar ? 16 : 0);
        int n6 = dimension.height - (this.hscrollbar ? 16 : 0);
        try {
            String string2;
            this.numLines = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                n = fontMetrics.stringWidth(string2);
                if (n > n5 && bl) {
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = string2.length();
                    do {
                        int n10 = 0;
                        n8 = n7 + 1;
                        while (n8 < n9) {
                            char c = string2.charAt(n8);
                            int n11 = fontMetrics.charWidth(c);
                            if (n10 + n11 + 10 > n5) break;
                            n10 += n11;
                            ++n8;
                        }
                        String string3 = string2.substring(n7, n8);
                        TextLine textLine = new TextLine();
                        textLine.text = string3;
                        textLine.pos = n3 + n7;
                        this.lines.addElement(textLine);
                        n7 = n8;
                        n2 = Math.max(n2, n);
                        ++this.numLines;
                    } while (n8 != n9);
                    n3 += string2.length() + 1;
                    continue;
                }
                TextLine textLine = new TextLine();
                textLine.text = string2;
                textLine.pos = n3;
                this.lines.addElement(textLine);
                n3 += string2.length() + 1;
                n2 = Math.max(n2, n);
                ++this.numLines;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
        int n12 = 0;
        int n13 = 0;
        int n14 = this.linesInWindow(true);
        int n15 = Math.max(this.numLines - n14, 0);
        int n16 = 0;
        int n17 = n5 - 4;
        int n18 = Math.max(n2 - n17, 0);
        int n19 = 0;
        graphics.setColor(color);
        graphics.fillRect(1, 1, n5, n6);
        if (this.vscrollbar) {
            n = dimension.height - (this.hscrollbar ? 16 : 0);
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n - 1);
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics2, color, 14, n, n12, n15, n16, n14, false);
                Object var32_38 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var32_39 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        if (this.hscrollbar) {
            n = dimension.width - (this.vscrollbar ? 16 : 0);
            graphics.fillRect(1, dimension.height - 16 - 3, n - 1, 13);
            Graphics graphics3 = graphics.create();
            try {
                graphics3.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics3, color, 14, n, n13, n18, n19, n17, true);
                Object var34_41 = null;
                graphics3.dispose();
            }
            catch (Throwable throwable) {
                Object var34_42 = null;
                graphics3.dispose();
                throw throwable;
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n5 - 1, n6 - 1, false);
        if (string != null) {
            n = this.linesInWindow(true);
            n6 = dimension.height - 20;
            int n20 = Math.min(this.numLines - 1, this.topLine + n - 1);
            this.paintLines(graphics, color, color2, this.topLine, n20);
        }
        this.target.print(graphics);
    }

    int linesInWindow(boolean bl) {
        Dimension dimension = this.target.size();
        int n = dimension.height - (4 + (bl ? 16 : 0));
        return n / this.fontHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintLines(Graphics graphics, Color color, Color color2, int n, int n2) {
        Dimension dimension = this.target.size();
        int n3 = dimension.width - (2 + (this.vscrollbar ? 16 : 0));
        int n4 = dimension.height - (2 + (this.hscrollbar ? 16 : 0));
        int n5 = this.linesInWindow(true) + this.topLine;
        n = Math.max(this.topLine, n);
        n2 = Math.min(n2, n5 - 1);
        Graphics graphics2 = graphics.create();
        try {
            graphics2.clipRect(3, 3, n3 - 4, n4 - 4);
            graphics2.setFont(this.target.getFont());
            int n6 = n;
            while (n6 <= n2) {
                this.paintLine(graphics2, color, color2, n6);
                ++n6;
            }
            Object var13_12 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    void paintLine(Graphics graphics, Color color, Color color2, int n) {
        Dimension dimension = this.target.size();
        int n2 = this.linesInWindow(true);
        if (n < this.topLine || n >= n2 + this.topLine) {
            return;
        }
        int n3 = dimension.width - (2 + (this.hscrollbar ? 16 : 0));
        int n4 = 2 + this.fontLeading + (n - this.topLine) * this.fontHeight;
        String string = ((TextLine)this.lines.elementAt((int)n)).text;
        int n5 = string.length();
        if (n > this.numLines - 1) {
            graphics.setColor(color);
            graphics.fillRect(1, n4 - this.fontLeading, n3, this.fontHeight);
            return;
        }
        int n6 = 0;
        int n7 = n < this.numLines - 1 ? n5 : this.textLength;
        int n8 = this.pos2x(this.selStart) - this.movedRight;
        int n9 = this.pos2x(this.selEnd) - this.movedRight;
        Color color3 = color.brighter();
        if (this.selStart < n6 && this.selEnd > n7) {
            graphics.setColor(color3);
            graphics.fillRect(1, n4 - this.fontLeading, n3, this.fontHeight);
        } else {
            graphics.setColor(color);
            graphics.fillRect(1, n4 - this.fontLeading, n3, this.fontHeight);
            if (this.selStart >= n6 && this.selStart <= n7) {
                graphics.setColor(color3);
                if (this.selEnd > n7) {
                    graphics.fillRect(n8, n4 - this.fontLeading, n3 + 1 - n8, this.fontHeight);
                } else if (this.selStart != this.selEnd) {
                    graphics.fillRect(n8, n4 - this.fontLeading, n9 - n8, this.fontHeight);
                }
            } else if (this.selEnd >= n6 && this.selEnd <= n7) {
                graphics.setColor(color3);
                graphics.fillRect(1, n4 - this.fontLeading, n9 - 1, this.fontHeight);
            }
        }
        graphics.setColor(color2);
        graphics.drawString(string, 2 - this.movedRight, n4 + this.fontAscent);
    }

    int pos2x(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int[] nArray = fontMetrics.getWidths();
        TextLine textLine = (TextLine)this.lines.elementAt(0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.lines.size() - 1) {
            TextLine textLine2 = (TextLine)this.lines.elementAt(n3 + 1);
            if (n >= textLine.pos && n < textLine2.pos) {
                n2 = n3;
                break;
            }
            textLine = textLine2;
            ++n3;
        }
        int n4 = 2;
        int n5 = 0;
        while (n5 < n - textLine.pos - 1) {
            n4 += nArray[textLine.text.charAt(n5)];
            ++n5;
        }
        return n4;
    }

    public void insertText(String string, int n) {
        this.insert(string, n);
    }

    public void replaceText(String string, int n, int n2) {
        this.replaceRange(string, n, n2);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize(int n, int n2) {
        return this.getPreferredSize(n, n2);
    }

    public Dimension minimumSize(int n, int n2) {
        return this.getMinimumSize(n, n2);
    }

    public void valueChanged() {
        this.postEvent(new TextEvent(this.target, 900));
    }

    void pShow() {
        this.pShow2();
        this.notifyTextComponentChange(true);
    }

    void pHide() {
        this.notifyTextComponentChange(false);
        super.pHide();
    }

    void pDispose() {
        this.notifyTextComponentChange(false);
        super.pDispose();
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            this.nativeHandleMouseWheel(mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    native void nativeHandleMouseWheel(int var1, int var2, int var3);

    public int getIndexAtPoint(int n, int n2) {
        return -1;
    }

    public Rectangle getCharacterBounds(int n) {
        return null;
    }

    public long filterEvents(long l) {
        return 0L;
    }
}

