/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.util.Arrays;
import java.util.Comparator;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.GeneralRenderer;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.SurfaceType;

public final class GraphicsPrimitiveMgr {
    private static final boolean debugTrace = false;
    private static GraphicsPrimitive[] primitives;
    private static GraphicsPrimitive[] generalPrimitives;
    private static boolean needssort;
    private static Comparator primSorter;
    private static Comparator primFinder;
    static /* synthetic */ Class class$sun$java2d$loops$GraphicsPrimitive;
    static /* synthetic */ Class class$sun$java2d$loops$SurfaceType;
    static /* synthetic */ Class class$sun$java2d$loops$CompositeType;
    static /* synthetic */ Class class$sun$java2d$SunGraphics2D;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$sun$java2d$loops$XORComposite;
    static /* synthetic */ Class class$java$awt$AlphaComposite;

    private static native void initIDs(Class var0, Class var1, Class var2, Class var3, Class var4, Class var5, Class var6);

    private static native void registerNativeLoops();

    private GraphicsPrimitiveMgr() {
    }

    public static synchronized void register(GraphicsPrimitive[] graphicsPrimitiveArray) {
        GraphicsPrimitive[] graphicsPrimitiveArray2 = primitives;
        int n = 0;
        int n2 = graphicsPrimitiveArray.length;
        if (graphicsPrimitiveArray2 != null) {
            n = graphicsPrimitiveArray2.length;
        }
        GraphicsPrimitive[] graphicsPrimitiveArray3 = new GraphicsPrimitive[n + n2];
        if (graphicsPrimitiveArray2 != null) {
            System.arraycopy(graphicsPrimitiveArray2, 0, graphicsPrimitiveArray3, 0, n);
        }
        System.arraycopy(graphicsPrimitiveArray, 0, graphicsPrimitiveArray3, n, n2);
        needssort = true;
        primitives = graphicsPrimitiveArray3;
    }

    public static synchronized void registerGeneral(GraphicsPrimitive graphicsPrimitive) {
        if (generalPrimitives == null) {
            generalPrimitives = new GraphicsPrimitive[]{graphicsPrimitive};
            return;
        }
        int n = generalPrimitives.length;
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[n + 1];
        System.arraycopy(generalPrimitives, 0, graphicsPrimitiveArray, 0, n);
        graphicsPrimitiveArray[n] = graphicsPrimitive;
        generalPrimitives = graphicsPrimitiveArray;
    }

    public static synchronized GraphicsPrimitive locate(int n, SurfaceType surfaceType) {
        return GraphicsPrimitiveMgr.locate(n, SurfaceType.OpaqueColor, CompositeType.Src, surfaceType);
    }

    public static synchronized GraphicsPrimitive locate(int n, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locatePrim(n, surfaceType, compositeType, surfaceType2);
        if (graphicsPrimitive == null && (graphicsPrimitive = GraphicsPrimitiveMgr.locateGeneral(n)) != null && (graphicsPrimitive = graphicsPrimitive.makePrimitive(surfaceType, compositeType, surfaceType2)) != null && GraphicsPrimitive.traceflags != 0) {
            graphicsPrimitive = graphicsPrimitive.traceWrap();
        }
        return graphicsPrimitive;
    }

    public static synchronized GraphicsPrimitive locatePrim(int n, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        PrimitiveSpec primitiveSpec = new PrimitiveSpec();
        SurfaceType surfaceType3 = surfaceType2;
        while (surfaceType3 != null) {
            SurfaceType surfaceType4 = surfaceType;
            while (surfaceType4 != null) {
                CompositeType compositeType2 = compositeType;
                while (compositeType2 != null) {
                    primitiveSpec.uniqueID = GraphicsPrimitive.makeUniqueID(n, surfaceType4, compositeType2, surfaceType3);
                    GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(primitiveSpec);
                    if (graphicsPrimitive != null) {
                        return graphicsPrimitive;
                    }
                    compositeType2 = compositeType2.getSuperType();
                }
                surfaceType4 = surfaceType4.getSuperType();
            }
            surfaceType3 = surfaceType3.getSuperType();
        }
        return null;
    }

    private static GraphicsPrimitive locateGeneral(int n) {
        if (generalPrimitives == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < generalPrimitives.length) {
            GraphicsPrimitive graphicsPrimitive = generalPrimitives[n2];
            if (graphicsPrimitive.getPrimTypeID() == n) {
                return graphicsPrimitive;
            }
            ++n2;
        }
        return null;
    }

    private static GraphicsPrimitive locate(PrimitiveSpec primitiveSpec) {
        GraphicsPrimitive[] graphicsPrimitiveArray;
        if (needssort) {
            if (GraphicsPrimitive.traceflags != 0) {
                int n = 0;
                while (n < primitives.length) {
                    GraphicsPrimitiveMgr.primitives[n] = primitives[n].traceWrap();
                    ++n;
                }
            }
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        if ((graphicsPrimitiveArray = primitives) == null) {
            return null;
        }
        int n = Arrays.binarySearch(graphicsPrimitiveArray, primitiveSpec, primFinder);
        if (n >= 0) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[n];
            if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                graphicsPrimitiveArray[n] = graphicsPrimitive = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
            }
            return graphicsPrimitive;
        }
        return null;
    }

    private static void writeLog(String string) {
    }

    public static void testPrimitiveInstantiation() {
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(false);
    }

    public static void testPrimitiveInstantiation(boolean bl) {
        int n = 0;
        int n2 = 0;
        GraphicsPrimitive[] graphicsPrimitiveArray = primitives;
        int n3 = 0;
        while (n3 < graphicsPrimitiveArray.length) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[n3];
            if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                GraphicsPrimitive graphicsPrimitive2 = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
                if (!graphicsPrimitive2.getSignature().equals(graphicsPrimitive.getSignature()) || graphicsPrimitive2.getUniqueID() != graphicsPrimitive.getUniqueID()) {
                    System.out.println("r.getSignature == " + graphicsPrimitive2.getSignature());
                    System.out.println("r.getUniqueID == " + graphicsPrimitive2.getUniqueID());
                    System.out.println("p.getSignature == " + graphicsPrimitive.getSignature());
                    System.out.println("p.getUniqueID == " + graphicsPrimitive.getUniqueID());
                    throw new RuntimeException("Primitive " + graphicsPrimitive + " returns wrong signature for " + graphicsPrimitive2.getClass());
                }
                ++n2;
                graphicsPrimitive = graphicsPrimitive2;
                if (bl) {
                    System.out.println(graphicsPrimitive);
                }
            } else {
                if (bl) {
                    System.out.println(graphicsPrimitive + " (not proxied).");
                }
                ++n;
            }
            ++n3;
        }
        System.out.println(n + " graphics primitives were not proxied.");
        System.out.println(n2 + " proxied graphics primitives resolved correctly.");
        System.out.println(n + n2 + " total graphics primitives");
    }

    public static void main(String[] stringArray) {
        if (needssort) {
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(stringArray.length > 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        needssort = true;
        GraphicsPrimitiveMgr.initIDs(class$sun$java2d$loops$GraphicsPrimitive == null ? (class$sun$java2d$loops$GraphicsPrimitive = GraphicsPrimitiveMgr.class$("sun.java2d.loops.GraphicsPrimitive")) : class$sun$java2d$loops$GraphicsPrimitive, class$sun$java2d$loops$SurfaceType == null ? (class$sun$java2d$loops$SurfaceType = GraphicsPrimitiveMgr.class$("sun.java2d.loops.SurfaceType")) : class$sun$java2d$loops$SurfaceType, class$sun$java2d$loops$CompositeType == null ? (class$sun$java2d$loops$CompositeType = GraphicsPrimitiveMgr.class$("sun.java2d.loops.CompositeType")) : class$sun$java2d$loops$CompositeType, class$sun$java2d$SunGraphics2D == null ? (class$sun$java2d$SunGraphics2D = GraphicsPrimitiveMgr.class$("sun.java2d.SunGraphics2D")) : class$sun$java2d$SunGraphics2D, class$java$awt$Color == null ? (class$java$awt$Color = GraphicsPrimitiveMgr.class$("java.awt.Color")) : class$java$awt$Color, class$sun$java2d$loops$XORComposite == null ? (class$sun$java2d$loops$XORComposite = GraphicsPrimitiveMgr.class$("sun.java2d.loops.XORComposite")) : class$sun$java2d$loops$XORComposite, class$java$awt$AlphaComposite == null ? (class$java$awt$AlphaComposite = GraphicsPrimitiveMgr.class$("java.awt.AlphaComposite")) : class$java$awt$AlphaComposite);
        CustomComponent.register();
        GeneralRenderer.register();
        GraphicsPrimitiveMgr.registerNativeLoops();
        primSorter = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((GraphicsPrimitive)object).getUniqueID();
                return n2 == (n = ((GraphicsPrimitive)object2).getUniqueID()) ? 0 : (n2 < n ? -1 : 1);
            }
        };
        primFinder = new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((GraphicsPrimitive)object).getUniqueID();
                return n2 == (n = ((PrimitiveSpec)object2).uniqueID) ? 0 : (n2 < n ? -1 : 1);
            }
        };
    }

    private static class PrimitiveSpec {
        public int uniqueID;

        private PrimitiveSpec() {
        }
    }
}

