/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;

public final class RenderCache {
    public Entry[] entries;

    public RenderCache(int n) {
        this.entries = new Entry[n];
    }

    public Object get(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        int n;
        int n2 = n = this.entries.length - 1;
        while (n2 >= 0) {
            Entry entry = this.entries[n2];
            if (entry == null) break;
            if (entry.matches(surfaceType, compositeType, surfaceType2)) {
                if (n2 < n - 4) {
                    System.arraycopy(this.entries, n2 + 1, this.entries, n2, n - n2);
                    this.entries[n] = entry;
                }
                return entry.getValue();
            }
            --n2;
        }
        return null;
    }

    public void put(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2, Object object) {
        Entry entry = new Entry(surfaceType, compositeType, surfaceType2, object);
        int n = this.entries.length;
        System.arraycopy(this.entries, 1, this.entries, 0, n - 1);
        this.entries[n - 1] = entry;
    }

    final class Entry {
        private SurfaceType src;
        private CompositeType comp;
        private SurfaceType dst;
        private Object value;

        public Entry(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2, Object object) {
            this.src = surfaceType;
            this.comp = compositeType;
            this.dst = surfaceType2;
            this.value = object;
        }

        public boolean matches(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            return this.src == surfaceType && this.comp == compositeType && this.dst == surfaceType2;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

