/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;
import sun.dc.pr.Rasterizer;

public class DuctusRenderer {
    public static final float PenUnits = 0.01f;
    public static final int MinPenUnits = 100;
    public static final int MinPenUnitsAA = 20;
    public static final float MinPenSizeAA = 0.19999999f;
    static final int[] RasterizerCaps = new int[]{30, 10, 20};
    static final int[] RasterizerCorners = new int[]{50, 10, 40};
    private static Rasterizer theRasterizer;
    private static byte[] theTile;

    public static synchronized Rasterizer getRasterizer() {
        Rasterizer rasterizer = theRasterizer;
        if (rasterizer == null) {
            rasterizer = new Rasterizer();
        } else {
            theRasterizer = null;
        }
        return rasterizer;
    }

    public static synchronized void dropRasterizer(Rasterizer rasterizer) {
        rasterizer.reset();
        theRasterizer = rasterizer;
    }

    public static synchronized byte[] getAlphaTile() {
        byte[] byArray = theTile;
        if (byArray == null) {
            int n = Rasterizer.TILE_SIZE;
            byArray = new byte[n * n];
        } else {
            theTile = null;
        }
        return byArray;
    }

    public static synchronized void dropAlphaTile(byte[] byArray) {
        theTile = byArray;
    }

    public static synchronized void getAlpha(Rasterizer rasterizer, byte[] byArray, int n, int n2, int n3) throws PRException {
        try {
            rasterizer.writeAlpha(byArray, n, n2, n3);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static PathConsumer createStroker(PathConsumer pathConsumer, BasicStroke basicStroke, boolean bl, AffineTransform affineTransform) {
        Object[] objectArray;
        PathStroker pathStroker = new PathStroker(pathConsumer);
        pathConsumer = pathStroker;
        float[] fArray = null;
        if (!bl) {
            pathStroker.setPenDiameter(basicStroke.getLineWidth());
            if (affineTransform != null) {
                fArray = new float[4];
                objectArray = new double[6];
                affineTransform.getMatrix((double[])objectArray);
                int n = 0;
                while (n < 4) {
                    fArray[n] = (float)objectArray[n];
                    ++n;
                }
            }
            pathStroker.setPenT4(fArray);
            pathStroker.setPenFitting(0.01f, 100);
        }
        pathStroker.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
        pathStroker.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
        objectArray = basicStroke.getDashArray();
        if (objectArray != null) {
            PathDasher pathDasher = new PathDasher(pathStroker);
            pathDasher.setDash((float[])objectArray, basicStroke.getDashPhase());
            pathDasher.setDashT4(fArray);
            pathConsumer = pathDasher;
        }
        return pathConsumer;
    }

    public static void feedConsumer(PathIterator pathIterator, PathConsumer pathConsumer, boolean bl, float f) throws PathException {
        pathConsumer.beginPath();
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray = new float[6];
        float f4 = 0.5f - f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl2) {
                bl2 = false;
                if (n != 0) {
                    pathConsumer.beginSubpath(f2, f3);
                }
            }
            if (bl) {
                int n2;
                switch (n) {
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                if (n2 >= 0) {
                    float f7 = fArray[n2];
                    float f8 = fArray[n2 + 1];
                    float f9 = (float)Math.floor(f7 + f4) + f;
                    float f10 = (float)Math.floor(f8 + f4) + f;
                    fArray[n2] = f9;
                    fArray[n2 + 1] = f10;
                    f9 -= f7;
                    f10 -= f8;
                    switch (n) {
                        case 3: {
                            fArray[0] = fArray[0] + f5;
                            fArray[1] = fArray[1] + f6;
                            fArray[2] = fArray[2] + f9;
                            fArray[3] = fArray[3] + f10;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f9 + f5) / 2.0f;
                            fArray[1] = fArray[1] + (f10 + f6) / 2.0f;
                            break;
                        }
                    }
                    f5 = f9;
                    f6 = f10;
                }
            }
            switch (n) {
                case 0: {
                    f2 = fArray[0];
                    f3 = fArray[1];
                    pathConsumer.beginSubpath(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pathConsumer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    pathConsumer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pathConsumer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pathConsumer.closedSubpath();
                    bl2 = true;
                }
            }
            pathIterator.next();
        }
        pathConsumer.endPath();
    }

    public static Rasterizer createShapeRasterizer(PathIterator pathIterator, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, float f) {
        Rasterizer rasterizer = DuctusRenderer.getRasterizer();
        if (basicStroke != null) {
            Object[] objectArray;
            float[] fArray = null;
            rasterizer.setUsage(3);
            if (bl) {
                rasterizer.setPenDiameter(0.19999999f);
            } else {
                rasterizer.setPenDiameter(basicStroke.getLineWidth());
                if (affineTransform != null) {
                    fArray = new float[4];
                    objectArray = new double[6];
                    affineTransform.getMatrix((double[])objectArray);
                    int n = 0;
                    while (n < 4) {
                        fArray[n] = (float)objectArray[n];
                        ++n;
                    }
                    rasterizer.setPenT4(fArray);
                }
                rasterizer.setPenFitting(0.01f, 20);
            }
            rasterizer.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
            rasterizer.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
            objectArray = basicStroke.getDashArray();
            if (objectArray != null) {
                rasterizer.setDash((float[])objectArray, basicStroke.getDashPhase());
                rasterizer.setDashT4(fArray);
            }
        } else {
            rasterizer.setUsage(pathIterator.getWindingRule() == 0 ? 1 : 2);
        }
        rasterizer.beginPath();
        boolean bl3 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray = new float[6];
        float f4 = 0.5f - f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl3) {
                bl3 = false;
                if (n != 0) {
                    rasterizer.beginSubpath(f2, f3);
                }
            }
            if (bl2) {
                int n2;
                switch (n) {
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                if (n2 >= 0) {
                    float f7 = fArray[n2];
                    float f8 = fArray[n2 + 1];
                    float f9 = (float)Math.floor(f7 + f4) + f;
                    float f10 = (float)Math.floor(f8 + f4) + f;
                    fArray[n2] = f9;
                    fArray[n2 + 1] = f10;
                    f9 -= f7;
                    f10 -= f8;
                    switch (n) {
                        case 3: {
                            fArray[0] = fArray[0] + f5;
                            fArray[1] = fArray[1] + f6;
                            fArray[2] = fArray[2] + f9;
                            fArray[3] = fArray[3] + f10;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f9 + f5) / 2.0f;
                            fArray[1] = fArray[1] + (f10 + f6) / 2.0f;
                            break;
                        }
                    }
                    f5 = f9;
                    f6 = f10;
                }
            }
            switch (n) {
                case 0: {
                    f2 = fArray[0];
                    f3 = fArray[1];
                    rasterizer.beginSubpath(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    rasterizer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    rasterizer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    rasterizer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    rasterizer.closedSubpath();
                    bl3 = true;
                }
            }
            pathIterator.next();
        }
        try {
            rasterizer.endPath();
        }
        catch (PRException pRException) {
            pRException.printStackTrace();
        }
        return rasterizer;
    }
}

