/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.print.StreamPrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Sides;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.io.CharToByteConverter;
import sun.print.PSPathGraphics;
import sun.print.PSStreamPrintService;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.security.action.GetPropertyAction;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits;
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /imageSrc {currentfile /ASCII85Decode filter /RunLengthDecode filter  imStr readstring pop } def";
    private static final String COPIES = "/#copies exch def";
    private static final String PAGE_SAVE = "/pgSave save def";
    private static final String PAGE_RESTORE = "pgSave restore";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String SetFontName = "SF";
    private static final String DrawStringName = "DS";
    private static final String EVEN_ODD_FILL_STR = "eofill";
    private static final String WINDING_FILL_STR = "fill";
    private static final String EVEN_ODD_CLIP_STR = "eoclip";
    private static final String WINDING_CLIP_STR = "clip";
    private static final String MOVETO_STR = " moveto";
    private static final String LINETO_STR = " lineto";
    private static final String CURVETO_STR = " curveto";
    private static final String GRESTORE_STR = "grestore";
    private static final String GSAVE_STR = "gsave";
    private static final String NEWPATH_STR = "newpath";
    private static final String CLOSEPATH_STR = "closepath";
    private static final String SETRGBCOLOR_STR = " setrgbcolor";
    private static final String SETGRAY_STR = " setgray";
    private static final String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static boolean forcePDL;
    private static boolean forceRaster;
    static boolean shapeTextProp;
    private int mDestType;
    private String mDestination = "lp";
    private boolean mNoJobSheet = false;
    private String mOptions;
    private Font mLastFont;
    private Color mLastColor;
    private Shape mLastClip;
    private AffineTransform mLastTransform;
    private EPSPrinter epsPrinter = null;
    FontMetrics mCurMetrics;
    PrintStream mPSStream;
    private CharToByteConverter[] converter;
    private String[] convname;
    private int convcount = 0;
    private boolean eurosupport = false;
    File spoolFile;
    private String mFillOpStr = "fill";
    private String mClipOpStr = "clip";
    ArrayList mGStateStack = new ArrayList();
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;
    private static Properties mFontProps;
    private static Font oldfont;
    private static int oldcharset;
    private static int oldpsfont;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$Chromaticity;
    static /* synthetic */ Class class$javax$print$attribute$standard$Destination;

    private static Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = SunToolkit.getStartupLocale().getLanguage();
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties." + string2);
                if (!(file.canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2)).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties")).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead())) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private void initConverters(Properties properties) {
        String string;
        if (properties == null) {
            return;
        }
        int n = 0;
        while (n < 120) {
            string = properties.getProperty("charset." + n, null);
            if (string == null) break;
            ++n;
        }
        this.convcount = 0;
        if (n > 0) {
            this.converter = new CharToByteConverter[n];
            this.convname = new String[n];
            int n2 = 0;
            while (n2 < n) {
                string = properties.getProperty("charset." + n2, "");
                CharToByteConverter charToByteConverter = this.getConverter(string);
                if (charToByteConverter != null) {
                    this.converter[this.convcount] = charToByteConverter;
                    this.convname[this.convcount] = string;
                    ++this.convcount;
                }
                ++n2;
            }
        }
        if (properties.getProperty("euro_support", "").equals("1")) {
            this.eurosupport = true;
        }
    }

    private CharToByteConverter getConverter(String string) {
        CharToByteConverter charToByteConverter;
        Class<?> clazz;
        try {
            clazz = Class.forName("sun.io.CharToByte" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            charToByteConverter = (CharToByteConverter)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return charToByteConverter;
    }

    public PSPrinterJob() {
        this.initConverters(mFontProps);
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(new Copies(this.getCopies()));
        this.attributes.add(new JobName(this.getJobName(), null));
        boolean bl = this.printDialog(this.attributes);
        if (bl) {
            Destination destination;
            Chromaticity chromaticity;
            Copies copies;
            JobName jobName = (JobName)this.attributes.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = PSPrinterJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)this.attributes.get(class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = PSPrinterJob.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((chromaticity = (Chromaticity)this.attributes.get(class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = PSPrinterJob.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) != null) {
                this.setChrom(chromaticity);
            }
            if ((destination = (Destination)this.attributes.get(class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = PSPrinterJob.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    this.mDestination = "out.ps";
                }
            } else {
                this.mDestType = 0;
                this.mDestination = this.getPrintService().getName();
            }
        }
        return bl;
    }

    protected void startDoc() throws PrinterException {
        if (this.epsPrinter == null) {
            OutputStream outputStream;
            Object object;
            if (this.getPrintService() instanceof PSStreamPrintService) {
                object = (StreamPrintService)this.getPrintService();
                this.mDestType = 2;
                if (((StreamPrintService)object).isDisposed()) {
                    throw new PrinterException("service is disposed");
                }
                outputStream = ((StreamPrintService)object).getOutputStream();
                if (outputStream == null) {
                    throw new PrinterException("Null output stream");
                }
            } else {
                this.mNoJobSheet = this.noJobSheet;
                if (this.destinationAttr != null) {
                    this.mDestType = 1;
                    this.mDestination = this.destinationAttr;
                }
                if (this.mDestType == 1) {
                    try {
                        this.spoolFile = new File(this.mDestination);
                        outputStream = new FileOutputStream(this.spoolFile);
                    }
                    catch (IOException iOException) {
                        throw new PrinterIOException(iOException);
                    }
                } else {
                    object = new PrinterOpener();
                    AccessController.doPrivileged(object);
                    if (((PrinterOpener)object).pex != null) {
                        throw ((PrinterOpener)object).pex;
                    }
                    outputStream = ((PrinterOpener)object).result;
                }
            }
            this.mPSStream = new PrintStream(new BufferedOutputStream(outputStream));
            this.mPSStream.println(ADOBE_PS_STR);
        }
        this.mPSStream.println("%%BeginProlog");
        this.mPSStream.println(READIMAGEPROC);
        this.mPSStream.println("/BD {bind def} bind def");
        this.mPSStream.println("/D {def} BD");
        this.mPSStream.println("/Cp1252 {Cp1252Encoding recode} D");
        this.mPSStream.println("/ISOF   {Cp1252} D");
        this.mPSStream.println("/recode {");
        this.mPSStream.println("  /encode exch def");
        this.mPSStream.println("  dup /fname exch def findfont");
        this.mPSStream.println("  dup maxlength dict /nf exch def");
        this.mPSStream.println("  {  1 index /FID ne 2 index /Encoding ne and");
        this.mPSStream.println("     {nf 3 1 roll put} {pop pop} ifelse");
        this.mPSStream.println("  } forall");
        this.mPSStream.println("  nf /Encoding encode put fname nf definefont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("/Cp1252Encoding [");
        this.mPSStream.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.mPSStream.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.mPSStream.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.mPSStream.println("/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef");
        this.mPSStream.println("/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quotesingle");
        this.mPSStream.println("/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash");
        this.mPSStream.println("/zero/one/two/three/four/five/six/seven");
        this.mPSStream.println("/eight/nine/colon/semicolon/less/equal/greater/question");
        this.mPSStream.println("/at/A/B/C/D/E/F/G");
        this.mPSStream.println("/H/I/J/K/L/M/N/O");
        this.mPSStream.println("/P/Q/R/S/T/U/V/W");
        this.mPSStream.println("/X/Y/Z/bracketleft/backslash/bracketright/asciicircum/underscore");
        this.mPSStream.println("/grave/a/b/c/d/e/f/g");
        this.mPSStream.println("/h/i/j/k/l/m/n/o");
        this.mPSStream.println("/p/q/r/s/t/u/v/w");
        this.mPSStream.println("/x/y/z/braceleft/bar/braceright/asciitilde/.notdef");
        this.mPSStream.println("/euro/.notdef/quotesinglbase/florin/quotedblbase/ellipsis/dagger/daggerdbl");
        this.mPSStream.println("/circumflex/perthousand/Scaron/guilsinglleft/OE/.notdef/Zcaron/.notdef");
        this.mPSStream.println("/.notdef/quoteleft/quoteright/quotedblleft/quotedblright/bullet/endash/emdash");
        this.mPSStream.println("/tilde/trademark/scaron/guilsinglright/oe/.notdef/zcaron/Ydieresis");
        this.mPSStream.println("/space/exclamdown/cent/sterling/currency/yen/brokenbar/section");
        this.mPSStream.println("/dieresis/copyright/ordfeminine/guillemotleft/logicalnot/hyphen/registered/macron");
        this.mPSStream.println("/degree/plusminus/twosuperior/threesuperior/acute/mu/paragraph/periodcentered");
        this.mPSStream.println("/cedilla/onesuperior/ordmasculine/guillemotright/onequarter/onehalf/threequarters/questiondown");
        this.mPSStream.println("/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla");
        this.mPSStream.println("/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex/Idieresis");
        this.mPSStream.println("/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/multiply");
        this.mPSStream.println("/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/germandbls");
        this.mPSStream.println("/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla");
        this.mPSStream.println("/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis");
        this.mPSStream.println("/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/divide");
        this.mPSStream.println("/oslash/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/ydieresis");
        this.mPSStream.println("] def");
        this.mPSStream.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.mPSStream.println("/DS {");
        this.mPSStream.println("  moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("  1 index length 1 sub NZ div 0");
        this.mPSStream.println("  3 2 roll ashow newpath} BD");
        this.mPSStream.println("/DS {");
        this.mPSStream.println("  moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("  1 index length 1 sub NZ div 0");
        this.mPSStream.println("  3 2 roll ashow newpath} BD");
        this.mPSStream.println("/F [");
        int n = Integer.parseInt(mFontProps.getProperty("font.num", "9"));
        int n2 = 0;
        while (n2 < n) {
            this.mPSStream.println("    /" + mFontProps.getProperty("font." + String.valueOf(n2), "Courier Cp1252"));
            ++n2;
        }
        this.mPSStream.println("] D");
        this.mPSStream.println("/SF {");
        this.mPSStream.println("  F exch get exch scalefont setfont");
        this.mPSStream.println("  TS dup length 2 lt {pop 0}{stringwidth pop} ifelse");
        this.mPSStream.println("  dup 0 eq {pop 1}{10 mul div} ifelse");
        this.mPSStream.println("  20 mul round 20 div");
        this.mPSStream.println("  currentfont exch [1 0 0 -1 0 0] dup 3 -1 roll 0 exch put makefont setfont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("%%EndProlog");
        this.mPSStream.println("%%BeginSetup");
        if (this.epsPrinter == null) {
            this.mPSStream.println("<< " + (this.isCollated() ? "/Collate true " : "") + "/NumCopies " + this.getCopiesInt() + " >> setpagedevice ");
            if (this.sidesAttr != Sides.ONE_SIDED) {
                this.mPSStream.print("<< ");
                if (this.sidesAttr == Sides.TWO_SIDED_LONG_EDGE) {
                    this.mPSStream.print(" /Duplex true ");
                } else if (this.sidesAttr == Sides.TWO_SIDED_SHORT_EDGE) {
                    this.mPSStream.print(" /Duplex true /Tumble true ");
                }
                this.mPSStream.println(">> setpagedevice ");
            }
        }
        this.mPSStream.println("%%EndSetup");
    }

    protected void abortDoc() {
        if (this.mPSStream != null && this.mDestType != 2) {
            this.mPSStream.close();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (PSPrinterJob.this.spoolFile != null && PSPrinterJob.this.spoolFile.exists()) {
                    PSPrinterJob.this.spoolFile.delete();
                }
                return null;
            }
        });
    }

    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.flush();
            if (this.mDestType != 2) {
                this.mPSStream.close();
            }
        }
        if (this.mDestType == 0) {
            if (this.getPrintService() != null) {
                this.mDestination = this.getPrintService().getName();
            }
            PrinterSpooler printerSpooler = new PrinterSpooler();
            AccessController.doPrivileged(printerSpooler);
            if (printerSpooler.pex != null) {
                throw printerSpooler.pex;
            }
        }
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        double d = pageFormat.getPaper().getHeight();
        int n2 = n + 1;
        this.mGStateStack = new ArrayList();
        this.mGStateStack.add(new GState());
        this.mPSStream.println(PAGE_COMMENT + n2 + " " + n2);
        this.mPSStream.println(PAGE_SAVE);
        this.mPSStream.println(d + COORD_PREP);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        this.mPSStream.println(PAGE_RESTORE);
        this.mPSStream.println(SHOWPAGE);
    }

    protected void drawImageBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2) {
        this.setTransform(new AffineTransform());
        this.prepDrawing(null);
        int n3 = (int)f7;
        int n4 = (int)f8;
        this.mPSStream.println(IMAGE_SAVE);
        int n5 = 3 * n3;
        while (n5 > 65535) {
            n5 /= 2;
        }
        this.mPSStream.println(n5 + IMAGE_STR);
        this.mPSStream.println("[" + f3 + " 0 " + "0 " + f4 + " " + f + " " + f2 + "]concat");
        this.mPSStream.println(n3 + " " + n4 + " " + 8 + "[" + n3 + " 0 " + "0 " + n4 + " 0 " + 0 + "]" + "/imageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n3 * 3];
        try {
            n6 = (int)f6 * n;
            int n7 = 0;
            while (n7 < n4) {
                n6 += (int)f5;
                n6 = this.getChrom() == Chromaticity.MONOCHROME ? PSPrinterJob.swapBGRtoRGBMono(byArray, n6, byArray2) : PSPrinterJob.swapBGRtoRGB(byArray, n6, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
                ++n7;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        this.mPSStream.println(IMAGE_SAVE);
        int n5 = 3 * n3;
        while (n5 > 65535) {
            n5 /= 2;
        }
        this.mPSStream.println(n5 + IMAGE_STR);
        this.mPSStream.println("[" + n3 + " 0 " + "0 " + n4 + " " + n + " " + n2 + "]concat");
        this.mPSStream.println(n3 + " " + n4 + " " + 8 + "[" + n3 + " 0 " + "0 " + -n4 + " 0 " + n4 + "]" + "/imageSrc load false 3 colorimage");
        int n6 = 0;
        byte[] byArray2 = new byte[n3 * 3];
        try {
            int n7 = 0;
            while (n7 < n4) {
                n6 = this.getChrom() == Chromaticity.MONOCHROME ? PSPrinterJob.swapBGRtoRGBMono(byArray, n6, byArray2) : PSPrinterJob.swapBGRtoRGB(byArray, n6, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
                ++n7;
            }
        }
        catch (IOException iOException) {
            throw new PrinterIOException(iOException);
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        PSPathGraphics pSPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            pSPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl = !peekGraphics.getAWTDrawingOnly();
            pSPathGraphics = new PSPathGraphics(graphics2D, printerJob, printable, pageFormat, n, bl);
        }
        return pSPathGraphics;
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    protected void setClip(Shape shape) {
        this.mLastClip = shape;
    }

    protected void setTransform(AffineTransform affineTransform) {
        this.mLastTransform = affineTransform;
    }

    protected boolean setFont(Font font) {
        this.mLastFont = font;
        return true;
    }

    private int getPSFontIndex(Font font, int n, int n2) {
        int n3;
        block4: {
            n3 = n2;
            if (font != null && font == oldfont && n == oldcharset) {
                return oldpsfont;
            }
            String string = PlatformFont.styleStr(font.getStyle());
            String string2 = font.getName().toLowerCase(Locale.ENGLISH);
            String string3 = mFontProps.getProperty(string2 = string2.replace(' ', '_'), "");
            String string4 = mFontProps.getProperty(string3 + "." + this.convname[n] + "." + string, null);
            if (string4 == null && n != 0) {
                string4 = mFontProps.getProperty("monospaced." + this.convname[n] + ".plain", null);
            }
            if (string4 == null) break block4;
            try {
                n3 = Integer.parseInt(mFontProps.getProperty(string4));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n3;
    }

    private boolean GetCharsetArray(char[] cArray, byte[] byArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] < ' ') {
                return false;
            }
            if (!this.eurosupport && cArray[n2] == '\u20ac') {
                return false;
            }
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.convcount) {
                if (this.converter[n3].canConvert(cArray[n2])) {
                    byArray[n2] = (byte)n3;
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean textOut(Graphics graphics, String string, float f, float f2) {
        if (string.length() <= 0) {
            return false;
        }
        boolean bl = true;
        int n = string.length();
        if (mFontProps == null) {
            this.prepDrawing(graphics);
            bl = false;
        } else {
            this.prepDrawing(null);
            char[] cArray = string.toCharArray();
            if (this.getPSFontIndex(this.mLastFont, 0, -1) < 0) {
                return false;
            }
            byte[] byArray = new byte[n];
            if (!this.GetCharsetArray(cArray, byArray)) {
                return false;
            }
            AffineTransform affineTransform = this.mLastFont.getTransform();
            affineTransform.scale(10.0, 10.0);
            Font font = this.mLastFont.deriveFont(affineTransform);
            FontMetrics fontMetrics = SunToolkit.getDefaultToolkit().getFontMetrics(font);
            byte by = byArray[0];
            int n2 = 0;
            int n3 = 0;
            while (n3 <= n) {
                if (n3 == n || byArray[n3] != by) {
                    int n4 = this.getPSFontIndex(this.mLastFont, by, 0);
                    String string2 = string.substring(n2, n3);
                    int n5 = fontMetrics.charsWidth(cArray, n2, n3);
                    byte[] byArray2 = new byte[4 * n3 - n2];
                    this.converter[by].setSubstitutionMode(true);
                    int n6 = 0;
                    try {
                        n6 = this.converter[by].convert(cArray, n2, n3, byArray2, 0, byArray2.length);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.converter[by].setSubstitutionMode(false);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('(');
                    int n7 = 0;
                    while (n7 < n6) {
                        char c = (char)(byArray2[n7] & 0xFF);
                        if (c < ' ' || c > '\u007f') {
                            stringBuffer.append('\\');
                            stringBuffer.append((char)(48 + (c / 64 & 7)));
                            stringBuffer.append((char)(48 + (c / 8 & 7)));
                            stringBuffer.append((char)(48 + (c & 7)));
                        } else {
                            if (c == '(' || c == ')' || c == '\\') {
                                stringBuffer.append('\\');
                            }
                            stringBuffer.append(c);
                        }
                        ++n7;
                    }
                    stringBuffer.append(')');
                    this.mPSStream.println("/TS " + stringBuffer.toString() + " D");
                    this.getGState().emitPSFont(n4, this.mLastFont.getSize(), n5);
                    float f3 = (float)n5 / 10.0f;
                    this.mPSStream.println("TS " + f3 + " " + f + " " + f2 + " DS");
                    f += f3;
                    n2 = n3;
                }
                ++n3;
            }
        }
        return bl;
    }

    private static String escapeParens(String string) {
        if (string.indexOf(40) == -1 && string.indexOf(41) == -1) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(40, n2)) != -1) {
            ++n;
            ++n2;
        }
        n2 = 0;
        while ((n2 = string.indexOf(41, n2)) != -1) {
            ++n;
            ++n2;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + n];
        n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '(' || cArray[n3] == ')') {
                cArray2[n2++] = 92;
            }
            cArray2[n2++] = cArray[n3];
            ++n3;
        }
        return new String(cArray2);
    }

    protected void setFillMode(int n) {
        switch (n) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected int getFillMode() {
        if (this.mFillOpStr == EVEN_ODD_FILL_STR) {
            return 1;
        }
        return 2;
    }

    protected void setColor(Color color) {
        this.mLastColor = color;
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    protected void beginPath() {
        this.prepDrawing(null);
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    private float fract3(float f) {
        return (float)Math.round(f * 1000.0f) / 1000.0f;
    }

    protected void moveTo(float f, float f2) {
        this.mPSStream.println(this.fract3(f) + " " + this.fract3(f2) + MOVETO_STR);
        this.mStartPathX = f;
        this.mStartPathY = f2;
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void lineTo(float f, float f2) {
        this.mPSStream.println(this.fract3(f) + " " + this.fract3(f2) + LINETO_STR);
        this.mPenX = f;
        this.mPenY = f2;
    }

    protected void bezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mPSStream.println(this.fract3(f) + " " + this.fract3(f2) + " " + this.fract3(f3) + " " + this.fract3(f4) + " " + this.fract3(f5) + " " + this.fract3(f6) + CURVETO_STR);
        this.mPenX = f5;
        this.mPenY = f6;
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    protected double getXRes() {
        return 300.0;
    }

    protected double getYRes() {
        return 300.0;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return paper.getImageableWidth();
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return paper.getImageableHeight();
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return paper.getWidth();
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return paper.getHeight();
    }

    protected int getNoncollatedCopies() {
        return 1;
    }

    protected int getCollatedCopies() {
        return 1;
    }

    private String[] printExecCmd(String string, String string2, boolean bl, String string3, int n, String string4) {
        String[] stringArray;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 16;
        int n7 = 0;
        int n8 = 2;
        int n9 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n7 |= n2;
            ++n8;
        }
        if (string2 != null && !string2.equals("")) {
            n7 |= n3;
            ++n8;
        }
        if (string3 != null && !string3.equals("")) {
            n7 |= n4;
            ++n8;
        }
        if (n > 1) {
            n7 |= n5;
            ++n8;
        }
        if (bl) {
            n7 |= n6;
            ++n8;
        }
        if (System.getProperty("os.name").equals("Linux") || System.getProperty("os.name").equals("AIX")) {
            stringArray = new String[n8];
            stringArray[n9++] = "/usr/bin/lpr";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = new String("-P" + string);
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = new String("-J" + string3);
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = new String("-#" + new Integer(n).toString());
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = new String("-h");
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = new String(string2);
            }
        } else {
            stringArray = new String[++n8];
            stringArray[n9++] = System.getProperty("os.name").equals("z/OS") ? "/bin/lp" : "/usr/bin/lp";
            stringArray[n9++] = "-c";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = new String("-d" + string);
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = new String("-t" + string3);
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = new String("-n" + new Integer(n).toString());
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = new String("-o nobanner");
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = new String("-o" + string2);
            }
        }
        stringArray[n9++] = string4;
        return stringArray;
    }

    private static int swapBGRtoRGB(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n < byArray.length - 2 && n2 < byArray2.length - 2) {
            byArray2[n2++] = byArray[n + 2];
            byArray2[n2++] = byArray[n + 1];
            byArray2[n2++] = byArray[n + 0];
            n += 3;
        }
        return n;
    }

    private static int swapBGRtoRGBMono(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n < byArray.length - 2 && n2 < byArray2.length - 2) {
            byte by = (byte)((double)(byArray[n + 0] & 0xFF) * 0.11 + (double)(byArray[n + 1] & 0xFF) * 0.59 + (double)(byArray[n + 2] & 0xFF) * 0.3);
            byArray2[n2++] = by;
            byArray2[n2++] = by;
            byArray2[n2++] = by;
            n += 3;
        }
        return n;
    }

    private String makeCharsetName(String string, char[] cArray) {
        if (string.equals("Cp1252") || string.equals("ISO8859_1")) {
            return "latin1";
        }
        if (string.equals("UTF8")) {
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] > '\u00ff') {
                    return string.toLowerCase();
                }
                ++n;
            }
            return "latin1";
        }
        if (string.startsWith("ISO8859")) {
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] > '\u007f') {
                    return string.toLowerCase();
                }
                ++n;
            }
            return "latin1";
        }
        return string.toLowerCase();
    }

    private void prepDrawing(Graphics graphics) {
        while (!(this.isOuterGState() || this.getGState().canSetClip(this.mLastClip) && this.getGState().mTransform.equals(this.mLastTransform))) {
            this.grestore();
        }
        this.getGState().emitPSColor(this.mLastColor);
        if (this.isOuterGState()) {
            this.gsave();
            this.getGState().emitTransform(this.mLastTransform);
            this.getGState().emitPSClip(this.mLastClip);
        }
        if (graphics != null) {
            this.getGState().emitPSFont(graphics, this.mLastFont);
        }
    }

    private GState getGState() {
        int n = this.mGStateStack.size();
        return (GState)this.mGStateStack.get(n - 1);
    }

    private void gsave() {
        GState gState = this.getGState();
        this.mGStateStack.add(new GState(gState));
        this.mPSStream.println(GSAVE_STR);
    }

    private void grestore() {
        int n = this.mGStateStack.size();
        this.mGStateStack.remove(n - 1);
        this.mPSStream.println(GRESTORE_STR);
    }

    private boolean isOuterGState() {
        return this.mGStateStack.size() == 1;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] rlEncode(byte[] var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = new byte[var1_1.length * 2 + 2];
        while (var2_2 < var1_1.length) {
            if (var5_5 == 0) {
                var4_4 = var2_2++;
                var5_5 = 1;
            }
            while (var5_5 < 128 && var2_2 < var1_1.length && var1_1[var2_2] == var1_1[var4_4]) {
                ++var5_5;
                ++var2_2;
            }
            if (var5_5 <= 1) ** GOTO lbl21
            var6_6[var3_3++] = (byte)(257 - var5_5);
            var6_6[var3_3++] = var1_1[var4_4];
            var5_5 = 0;
            continue;
lbl-1000:
            // 1 sources

            {
                ++var5_5;
                ++var2_2;
lbl21:
                // 2 sources

                ** while (var5_5 < 128 && var2_2 < var1_1.length && var1_1[var2_2] != var1_1[var2_2 - 1])
            }
lbl22:
            // 1 sources

            var6_6[var3_3++] = (byte)(var5_5 - 1);
            var7_7 = var4_4;
            while (var7_7 < var4_4 + var5_5) {
                var6_6[var3_3++] = var1_1[var7_7];
                ++var7_7;
            }
            var5_5 = 0;
        }
        var6_6[var3_3++] = -128;
        var7_8 = new byte[var3_3];
        System.arraycopy(var6_6, 0, var7_8, 0, var3_3);
        return var7_8;
    }

    private byte[] ascii85Encode(byte[] byArray) {
        long l;
        long l2;
        byte[] byArray2 = new byte[(byArray.length + 4) * 5 / 4 + 2];
        long l3 = 85L;
        long l4 = l3 * l3;
        long l5 = l3 * l4;
        long l6 = l3 * l5;
        int n = 33;
        int n2 = 0;
        int n3 = 0;
        while (n2 + 3 < byArray.length) {
            if ((l2 = ((long)(byArray[n2++] & 0xFF) << 24) + ((long)(byArray[n2++] & 0xFF) << 16) + ((long)(byArray[n2++] & 0xFF) << 8) + (long)(byArray[n2++] & 0xFF)) == 0L) {
                byArray2[n3++] = 122;
                continue;
            }
            l = l2;
            byArray2[n3++] = (byte)(l / l6 + (long)n);
            byArray2[n3++] = (byte)((l %= l6) / l5 + (long)n);
            byArray2[n3++] = (byte)((l %= l5) / l4 + (long)n);
            byArray2[n3++] = (byte)((l %= l4) / l3 + (long)n);
            byArray2[n3++] = (byte)((l %= l3) + (long)n);
        }
        if (n2 < byArray.length) {
            int n4 = byArray.length - n2;
            l2 = 0L;
            while (n2 < byArray.length) {
                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
            }
            int n5 = 4 - n4;
            while (n5-- > 0) {
                l2 <<= 8;
            }
            byte[] byArray3 = new byte[5];
            l = l2;
            byArray3[0] = (byte)(l / l6 + (long)n);
            byArray3[1] = (byte)((l %= l6) / l5 + (long)n);
            byArray3[2] = (byte)((l %= l5) / l4 + (long)n);
            byArray3[3] = (byte)((l %= l4) / l3 + (long)n);
            byArray3[4] = (byte)((l %= l3) + (long)n);
            int n6 = 0;
            while (n6 < n4 + 1) {
                byArray2[n3++] = byArray3[n6];
                ++n6;
            }
        }
        byArray2[n3++] = 126;
        byArray2[n3++] = 62;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray4, 0, n3);
        return byArray4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        mFontProps = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                mFontProps = PSPrinterJob.initProps();
                return null;
            }
        });
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        String string2 = AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        if (string2 != null) {
            if (string2.equalsIgnoreCase(FORCE_PDL)) {
                forcePDL = true;
            } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                forceRaster = true;
            }
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction(SHAPE_TEXT_PROP))) != null) {
            shapeTextProp = true;
        }
        oldfont = null;
        oldcharset = 0;
        oldpsfont = 0;
    }

    public static class EPSPrinter
    implements Pageable {
        private PageFormat pf;
        private PSPrinterJob job;
        private int llx;
        private int lly;
        private int urx;
        private int ury;
        private Printable printable;
        private PrintStream stream;
        private String epsTitle;

        public EPSPrinter(Printable printable, String string, PrintStream printStream, int n, int n2, int n3, int n4) {
            this.printable = printable;
            this.epsTitle = string;
            this.stream = printStream;
            this.llx = n;
            this.lly = n2;
            this.urx = this.llx + n3;
            this.ury = this.lly + n4;
            Paper paper = new Paper();
            paper.setSize(n3, n4);
            paper.setImageableArea(0.0, 0.0, n3, n4);
            this.pf = new PageFormat();
            this.pf.setPaper(paper);
        }

        public void print() throws PrinterException {
            this.stream.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.stream.println("%%BoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
            this.stream.println("%%Title: " + this.epsTitle);
            this.stream.println("%%Creator: Java Printing");
            this.stream.println("%%CreationDate: " + new Date());
            this.stream.println("%%EndComments");
            this.job = new PSPrinterJob();
            this.job.epsPrinter = this;
            this.job.mPSStream = this.stream;
            this.job.mDestType = 2;
            this.job.startDoc();
            try {
                try {
                    this.job.printPage(this, 0);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof PrinterException) {
                        throw (PrinterException)throwable;
                    }
                    throw new PrinterException(throwable.toString());
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.job.endDoc();
                throw throwable;
            }
            this.job.endDoc();
            this.stream.flush();
        }

        public int getNumberOfPages() {
            return 1;
        }

        public PageFormat getPageFormat(int n) {
            if (n > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.pf;
        }

        public Printable getPrintable(int n) {
            if (n > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.printable;
        }
    }

    public static class PluginPrinter
    implements Printable {
        private EPSPrinter epsPrinter;
        private Component applet;
        private PrintStream stream;
        private String epsTitle;
        private int bx;
        private int by;
        private int bw;
        private int bh;
        private int width;
        private int height;

        public PluginPrinter(Component component, PrintStream printStream, int n, int n2, int n3, int n4) {
            this.applet = component;
            this.epsTitle = "Java Plugin Applet";
            this.stream = printStream;
            this.bx = n;
            this.by = n2;
            this.bw = n3;
            this.bh = n4;
            this.width = component.size().width;
            this.height = component.size().height;
            this.epsPrinter = new EPSPrinter(this, this.epsTitle, printStream, 0, 0, this.width, this.height);
        }

        public void printPluginPSHeader() {
            this.stream.println("BeginEPSF");
            this.stream.println("%%BeginDocument: JavaPluginApplet");
            this.stream.println("clippath pathbbox");
            this.stream.println("/ury exch def /urx exch def");
            this.stream.println("/lly exch def /llx exch def");
            this.stream.println("/imHgt ury lly sub def");
            this.stream.println("/ypos ury " + (this.by + this.bh) + " imHgt cvi mod sub def");
            this.stream.println("llx ypos translate");
            float f = (float)this.bw / (float)this.width;
            float f2 = (float)this.bh / (float)this.height;
            this.stream.println(f + " " + f2 + " scale");
        }

        public void printPluginApplet() {
            try {
                this.epsPrinter.print();
            }
            catch (PrinterException printerException) {}
        }

        public void printPluginPSTrailer() {
            this.stream.println("EndEPSF");
            this.stream.println("%%EndDocument: JavaPluginApplet");
            this.stream.flush();
        }

        public void printAll() {
            this.printPluginPSHeader();
            this.printPluginApplet();
            this.printPluginPSTrailer();
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n > 0) {
                return 1;
            }
            this.applet.printAll(graphics);
            return 0;
        }
    }

    private class GState {
        Color mColor;
        Shape mClip;
        Font mFont;
        AffineTransform mTransform;

        GState() {
            this.mColor = Color.black;
            this.mClip = null;
            this.mFont = null;
            this.mTransform = new AffineTransform();
        }

        GState(GState gState) {
            this.mColor = gState.mColor;
            this.mClip = gState.mClip;
            this.mFont = gState.mFont;
            this.mTransform = gState.mTransform;
        }

        boolean canSetClip(Shape shape) {
            return this.mClip == null || this.mClip.equals(shape);
        }

        void emitPSClip(Shape shape) {
            if (!(shape == null || this.mClip != null && this.mClip.equals(shape))) {
                this.convertToPSPath(shape.getPathIterator(new AffineTransform()));
                PSPrinterJob.this.selectClipPath();
                this.mClip = shape;
            }
        }

        void emitTransform(AffineTransform affineTransform) {
            if (affineTransform != null && !affineTransform.equals(this.mTransform)) {
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                PSPrinterJob.this.mPSStream.println("[" + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + "] concat");
                this.mTransform = affineTransform;
            }
        }

        void emitPSColor(Color color) {
            if (color != null && !color.equals(this.mColor)) {
                float[] fArray = color.getColorComponents(null);
                if (PSPrinterJob.this.getChrom() == Chromaticity.MONOCHROME) {
                    PSPrinterJob.this.mPSStream.println((double)fArray[0] * 0.3 + (double)fArray[1] * 0.59 + (double)fArray[2] * 0.11 + PSPrinterJob.SETGRAY_STR);
                } else if (fArray[0] == fArray[1] && fArray[1] == fArray[2]) {
                    PSPrinterJob.this.mPSStream.println(fArray[0] + PSPrinterJob.SETGRAY_STR);
                } else {
                    PSPrinterJob.this.mPSStream.println(fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + PSPrinterJob.SETRGBCOLOR_STR);
                }
                this.mColor = color;
            }
        }

        void emitPSFont(Graphics graphics, Font font) {
            if (this.mFont == null && font != null || !this.mFont.equals(font)) {
                PSPrinterJob.this.mCurMetrics = graphics.getFontMetrics();
                Rectangle2D rectangle2D = PSPrinterJob.this.mCurMetrics.getStringBounds(PSPrinterJob.testString, graphics);
                float f = (float)rectangle2D.getWidth();
                int n = font.getStyle();
                n = font.getFamily().toLowerCase().startsWith("helvetica") || font.getFamily().toLowerCase().startsWith("sansserif") ? 0 : (font.getFamily().toLowerCase().startsWith("dialog") ? 0 : (font.getFamily().toLowerCase().startsWith("times") || font.getFamily().toLowerCase().startsWith("serif") ? 4 : 8));
                if (font.isBold()) {
                    ++n;
                }
                if (font.isItalic()) {
                    n += 2;
                }
                PSPrinterJob.this.mPSStream.println("% Font[" + font.getFamily() + ", " + font.getStyle() + ", " + font.getSize2D() + "]");
                PSPrinterJob.this.getGState().emitPSFont(n, font.getSize2D(), f);
            }
            this.mFont = font;
        }

        void emitPSFont(int n, float f, float f2) {
            PSPrinterJob.this.mPSStream.println(f2 + " " + f + " " + n + " " + PSPrinterJob.SetFontName);
        }

        private void convertToPSPath(PathIterator pathIterator) {
            float[] fArray = new float[6];
            int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
            PSPrinterJob.this.setFillMode(n);
            PSPrinterJob.this.beginPath();
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(fArray);
                switch (n2) {
                    case 0: {
                        PSPrinterJob.this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        PSPrinterJob.this.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        float f = PSPrinterJob.this.getPenX();
                        float f2 = PSPrinterJob.this.getPenY();
                        float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                        float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                        float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                        float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                        PSPrinterJob.this.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        PSPrinterJob.this.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        PSPrinterJob.this.closeSubpath();
                    }
                }
                pathIterator.next();
            }
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrinterException pex;

        private PrinterSpooler() {
        }

        public Object run() {
            try {
                if (PSPrinterJob.this.spoolFile == null || !PSPrinterJob.this.spoolFile.exists()) {
                    this.pex = new PrinterException("No spool file");
                    return null;
                }
                String string = PSPrinterJob.this.spoolFile.getAbsolutePath();
                String[] stringArray = PSPrinterJob.this.printExecCmd(PSPrinterJob.this.mDestination, PSPrinterJob.this.mOptions, PSPrinterJob.this.mNoJobSheet, PSPrinterJob.this.getJobNameInt(), 1, string);
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                PSPrinterJob.this.spoolFile.delete();
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
            }
            catch (InterruptedException interruptedException) {
                this.pex = new PrinterException(interruptedException.toString());
            }
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrinterException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                PSPrinterJob.this.spoolFile = File.createTempFile("javaprint", ".ps", null);
                PSPrinterJob.this.spoolFile.deleteOnExit();
                this.result = new FileOutputStream(PSPrinterJob.this.spoolFile);
                return this.result;
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
                return null;
            }
        }
    }
}

