/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.File;
import java.net.URI;
import java.security.AccessController;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeUpdater;
import sun.print.ServiceNotifier;
import sun.print.SunPrinterJobService;
import sun.print.UnixPrintJob;
import sun.print.UnixPrintServiceLookup;
import sun.security.action.GetPropertyAction;

public class UnixPrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    private static String encoding = "ISO8859_1";
    private static DocFlavor textByteFlavor;
    private static final DocFlavor[] supportedDocFlavors;
    String[] lpcStatusCom = new String[]{"", "| grep -E '^[ 0-9a-zA-Z]*@' | awk '{print $2, $3}'"};
    String[] lpcQueueCom = new String[]{"", "| grep -E '^[ 0-9a-zA-Z]*@' | awk '{print $4}'"};
    private static final Class[] serviceAttrCats;
    private static final Class[] otherAttrCats;
    private static int MAXCOPIES;
    private static final MediaSizeName[] mediaSizes;
    private String printer;
    private PrinterName name;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterName;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterIsAcceptingJobs;
    static /* synthetic */ Class class$javax$print$attribute$standard$QueuedJobCount;
    static /* synthetic */ Class class$javax$print$attribute$standard$Chromaticity;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$Destination;
    static /* synthetic */ Class class$javax$print$attribute$standard$Fidelity;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobSheets;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;
    static /* synthetic */ Class class$javax$print$attribute$standard$PageRanges;
    static /* synthetic */ Class class$javax$print$attribute$standard$RequestingUserName;
    static /* synthetic */ Class class$javax$print$attribute$standard$SheetCollate;
    static /* synthetic */ Class class$javax$print$attribute$standard$Sides;
    static /* synthetic */ Class class$javax$print$attribute$PrintServiceAttribute;
    static /* synthetic */ Class class$javax$print$attribute$Attribute;
    static /* synthetic */ Class class$javax$print$attribute$standard$CopiesSupported;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaSize;
    static /* synthetic */ Class class$sun$print$PSPrinterJob;

    UnixPrintService(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = string;
    }

    public String getName() {
        return this.printer;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsSysV() {
        String string = "/usr/bin/lpstat -a " + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray != null && stringArray.length > 0 && stringArray[0].startsWith(this.printer + " accepting requests")) {
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsZOS() {
        String string = "/usr/lpp/Printsrv/bin/lpstat -a " + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray != null && stringArray.length > 0 && stringArray[0].startsWith(this.printer + " accepting requests")) {
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsAIX() {
        String string = "/usr/bin/lpstat -a" + this.printer + " |/usr/bin/expand|/usr/bin/tail +3|/usr/bin/cut -c15-23";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray != null && stringArray.length > 0 && stringArray[0].startsWith("READY")) {
            return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobsBSD() {
        String string;
        String[] stringArray;
        if (UnixPrintServiceLookup.cmdIndex == -1) {
            UnixPrintServiceLookup.cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(string = "/usr/sbin/lpc status " + this.printer + this.lpcStatusCom[UnixPrintServiceLookup.cmdIndex])) != null && stringArray.length > 0) {
            if (UnixPrintServiceLookup.cmdIndex == 1) {
                if (stringArray[0].startsWith("enabled enabled")) {
                    return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
                }
            } else if (stringArray.length > 2) {
                int n = 1;
                while (n < stringArray.length - 1) {
                    if (stringArray[n].trim().startsWith("queuing is enabled") && stringArray[n + 1].trim().startsWith("printing is enabled")) {
                        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
                    }
                    ++n;
                }
            }
        }
        return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getPrinterIsAcceptingJobsSysV();
        }
        if (UnixPrintServiceLookup.isBSD()) {
            return this.getPrinterIsAcceptingJobsBSD();
        }
        if (UnixPrintServiceLookup.isZOS()) {
            return this.getPrinterIsAcceptingJobsZOS();
        }
        if (UnixPrintServiceLookup.isAIX()) {
            return this.getPrinterIsAcceptingJobsAIX();
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private QueuedJobCount getQueuedJobCountSysV() {
        String string = "/usr/bin/lpstat -R " + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        int n = stringArray == null ? 0 : stringArray.length;
        return new QueuedJobCount(n);
    }

    private QueuedJobCount getQueuedJobCountZOS() {
        String string = "/usr/lpp/Printsrv/bin/lpstat -R " + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        int n = stringArray == null ? 0 : stringArray.length;
        return new QueuedJobCount(n);
    }

    private QueuedJobCount getQueuedJobCountAIX() {
        String string = "/usr/bin/lpstat -R" + this.printer;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        int n = stringArray == null ? 0 : stringArray.length;
        return new QueuedJobCount(n);
    }

    private QueuedJobCount getQueuedJobCountBSD() {
        if (UnixPrintServiceLookup.cmdIndex == -1) {
            UnixPrintServiceLookup.cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        int n = 0;
        String string = "/usr/sbin/lpc status " + this.printer + this.lpcQueueCom[UnixPrintServiceLookup.cmdIndex];
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray != null && stringArray.length > 0) {
            String string2 = "";
            if (UnixPrintServiceLookup.cmdIndex == 1) {
                string2 = stringArray[0];
            } else if (stringArray.length > 3) {
                string2 = stringArray[3].trim();
                if (string2.startsWith("no")) {
                    return new QueuedJobCount(0);
                }
                string2 = string2.substring(0, string2.indexOf(32));
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new QueuedJobCount(n);
    }

    private QueuedJobCount getQueuedJobCount() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getQueuedJobCountSysV();
        }
        if (UnixPrintServiceLookup.isBSD()) {
            return this.getQueuedJobCountBSD();
        }
        if (UnixPrintServiceLookup.isZOS()) {
            return this.getQueuedJobCountZOS();
        }
        if (UnixPrintServiceLookup.isAIX()) {
            return this.getQueuedJobCountAIX();
        }
        return new QueuedJobCount(0);
    }

    private PrintServiceAttributeSet getSysVServiceAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getQueuedJobCountSysV());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobsSysV());
        return hashPrintServiceAttributeSet;
    }

    private PrintServiceAttributeSet getZOSServiceAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getQueuedJobCountZOS());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobsZOS());
        return hashPrintServiceAttributeSet;
    }

    private PrintServiceAttributeSet getAIXServiceAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getQueuedJobCountAIX());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobsAIX());
        return hashPrintServiceAttributeSet;
    }

    private PrintServiceAttributeSet getBSDServiceAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getQueuedJobCountBSD());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobsBSD());
        return hashPrintServiceAttributeSet;
    }

    private boolean isSupportedCopies(Copies copies) {
        int n = copies.getValue();
        return n > 0 && n < MAXCOPIES;
    }

    private boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        int n = 0;
        while (n < mediaSizes.length) {
            if (mediaSizeName.equals(mediaSizes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new UnixPrintJob(this);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        if (UnixPrintServiceLookup.isSysV()) {
            return this.getSysVServiceAttributes();
        }
        if (UnixPrintServiceLookup.isZOS()) {
            return this.getZOSServiceAttributes();
        }
        if (UnixPrintServiceLookup.isAIX()) {
            return this.getAIXServiceAttributes();
        }
        return this.getBSDServiceAttributes();
    }

    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet printServiceAttributeSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = printServiceAttributeSet;
            return AttributeSetUtilities.unmodifiableView(printServiceAttributeSet);
        }
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        int n = 0;
        while (n < attributeArray.length) {
            Attribute attribute = attributeArray[n];
            if (!this.lastSet.containsValue(attribute)) {
                hashPrintServiceAttributeSet.add(attribute);
            }
            ++n;
        }
        this.lastSet = printServiceAttributeSet;
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        UnixPrintService unixPrintService = this;
        synchronized (unixPrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!(class$javax$print$attribute$PrintServiceAttribute == null ? (class$javax$print$attribute$PrintServiceAttribute = UnixPrintService.class$("javax.print.attribute.PrintServiceAttribute")) : class$javax$print$attribute$PrintServiceAttribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (clazz == (class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = UnixPrintService.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName)) {
            return this.getPrinterName();
        }
        if (clazz == (class$javax$print$attribute$standard$QueuedJobCount == null ? (class$javax$print$attribute$standard$QueuedJobCount = UnixPrintService.class$("javax.print.attribute.standard.QueuedJobCount")) : class$javax$print$attribute$standard$QueuedJobCount)) {
            return this.getQueuedJobCount();
        }
        if (clazz == (class$javax$print$attribute$standard$PrinterIsAcceptingJobs == null ? (class$javax$print$attribute$standard$PrinterIsAcceptingJobs = UnixPrintService.class$("javax.print.attribute.standard.PrinterIsAcceptingJobs")) : class$javax$print$attribute$standard$PrinterIsAcceptingJobs)) {
            return this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        hashPrintServiceAttributeSet.add(this.getPrinterName());
        hashPrintServiceAttributeSet.add(this.getPrinterIsAcceptingJobs());
        hashPrintServiceAttributeSet.add(this.getQueuedJobCount());
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    public DocFlavor[] getSupportedDocFlavors() {
        int n = supportedDocFlavors.length;
        DocFlavor[] docFlavorArray = new DocFlavor[n];
        System.arraycopy(supportedDocFlavors, 0, docFlavorArray, 0, n);
        return docFlavorArray;
    }

    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        int n = 0;
        while (n < supportedDocFlavors.length) {
            if (docFlavor.equals(supportedDocFlavors[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Class[] getSupportedAttributeCategories() {
        int n = otherAttrCats.length;
        Class[] classArray = new Class[n];
        System.arraycopy(otherAttrCats, 0, classArray, 0, otherAttrCats.length);
        return classArray;
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = UnixPrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        int n = 0;
        while (n < otherAttrCats.length) {
            if (clazz == otherAttrCats[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getDefaultAttributeValue(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = UnixPrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = UnixPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) {
            return new Copies(1);
        }
        if (clazz == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = UnixPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            return Chromaticity.COLOR;
        }
        if (clazz == (class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = UnixPrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) {
            return new Destination(new File("out.ps").toURI());
        }
        if (clazz == (class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = UnixPrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity)) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz == (class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = UnixPrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName)) {
            return new JobName("Java Printing", null);
        }
        if (clazz == (class$javax$print$attribute$standard$JobSheets == null ? (class$javax$print$attribute$standard$JobSheets = UnixPrintService.class$("javax.print.attribute.standard.JobSheets")) : class$javax$print$attribute$standard$JobSheets)) {
            return JobSheets.STANDARD;
        }
        if (clazz == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = UnixPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                return MediaSizeName.NA_LETTER;
            }
            return MediaSizeName.ISO_A4;
        }
        if (clazz == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = UnixPrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
            float f;
            float f2;
            String string = Locale.getDefault().getCountry();
            if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
                f2 = MediaSize.NA.LETTER.getX(25400) - 2.0f;
                f = MediaSize.NA.LETTER.getY(25400) - 2.0f;
            } else {
                f2 = MediaSize.ISO.A4.getX(25400) - 2.0f;
                f = MediaSize.ISO.A4.getY(25400) - 2.0f;
            }
            return new MediaPrintableArea(0.25f, 0.25f, f2, f, 25400);
        }
        if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = UnixPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) {
            return OrientationRequested.PORTRAIT;
        }
        if (clazz == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = UnixPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == (class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = UnixPrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName)) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = UnixPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            return SheetCollate.UNCOLLATED;
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = UnixPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
            return Sides.ONE_SIDED;
        }
        return null;
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!(class$javax$print$attribute$Attribute == null ? (class$javax$print$attribute$Attribute = UnixPrintService.class$("javax.print.attribute.Attribute")) : class$javax$print$attribute$Attribute).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = UnixPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = UnixPrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) {
            return new Destination(new File("out.ps").toURI());
        }
        if (clazz == (class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = UnixPrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName)) {
            return new JobName("Java Printing", null);
        }
        if (clazz == (class$javax$print$attribute$standard$JobSheets == null ? (class$javax$print$attribute$standard$JobSheets = UnixPrintService.class$("javax.print.attribute.standard.JobSheets")) : class$javax$print$attribute$standard$JobSheets)) {
            JobSheets[] jobSheetsArray = new JobSheets[]{JobSheets.NONE, JobSheets.STANDARD};
            return jobSheetsArray;
        }
        if (clazz == (class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = UnixPrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName)) {
            String string = "";
            try {
                string = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string, null);
        }
        if (clazz == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = UnixPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                OrientationRequested[] orientationRequestedArray = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return orientationRequestedArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = UnixPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies) || clazz == (class$javax$print$attribute$standard$CopiesSupported == null ? (class$javax$print$attribute$standard$CopiesSupported = UnixPrintService.class$("javax.print.attribute.standard.CopiesSupported")) : class$javax$print$attribute$standard$CopiesSupported)) {
            return new CopiesSupported(1, MAXCOPIES);
        }
        if (clazz == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = UnixPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) {
            Media[] mediaArray = new Media[mediaSizes.length];
            System.arraycopy(mediaSizes, 0, mediaArray, 0, mediaSizes.length);
            return mediaArray;
        }
        if (clazz == (class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = UnixPrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity)) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        if (clazz == (class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = UnixPrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) {
            Object object;
            if (attributeSet == null) {
                return null;
            }
            MediaSize mediaSize = (MediaSize)attributeSet.get(class$javax$print$attribute$standard$MediaSize == null ? (class$javax$print$attribute$standard$MediaSize = UnixPrintService.class$("javax.print.attribute.standard.MediaSize")) : class$javax$print$attribute$standard$MediaSize);
            if (mediaSize == null && (object = (Media)attributeSet.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = UnixPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) != null && object instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)object;
                mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
            }
            if (mediaSize == null) {
                return null;
            }
            object = new MediaPrintableArea[]{new MediaPrintableArea(0.25f, 0.25f, mediaSize.getX(25400), mediaSize.getY(25400), 25400)};
            return object;
        }
        if (clazz == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = UnixPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return pageRangesArray;
            }
            return null;
        }
        if (clazz == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = UnixPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED};
                return sheetCollateArray;
            }
            SheetCollate[] sheetCollateArray = new SheetCollate[]{SheetCollate.UNCOLLATED};
            return sheetCollateArray;
        }
        if (clazz == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = UnixPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] sidesArray = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return sidesArray;
            }
            return null;
        }
        return null;
    }

    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        Class clazz;
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz = attribute.getCategory())) {
            return false;
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = UnixPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity)) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                return attribute == Chromaticity.COLOR || attribute == Chromaticity.MONOCHROME;
            }
            return false;
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = UnixPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = UnixPrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) {
            URI uRI = ((Destination)attribute).getURI();
            return "file".equals(uRI.getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == (class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = UnixPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media) && attribute instanceof MediaSizeName) {
            return this.isSupportedMedia((MediaSizeName)attribute);
        }
        return !(attribute.getCategory() == (class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = UnixPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested) ? attribute == OrientationRequested.REVERSE_PORTRAIT || docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) && !docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) && !docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) && !docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) && !docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) && !docFlavor.equals(DocFlavor.URL.GIF) && !docFlavor.equals(DocFlavor.URL.JPEG) && !docFlavor.equals(DocFlavor.URL.PNG) : (attribute.getCategory() == (class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = UnixPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges) ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : (attribute.getCategory() == (class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = UnixPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate) ? docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) : attribute.getCategory() == (class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = UnixPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides) && docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE))));
    }

    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        int n = 0;
        while (n < attributeArray.length) {
            try {
                Attribute attribute = attributeArray[n];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                } else if (!this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) {
                    hashAttributeSet.add(attribute);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n;
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public String toString() {
        return "Unix Printer : " + this.getName();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof UnixPrintService && ((UnixPrintService)object).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    public boolean usesClass(Class clazz) {
        return clazz == (class$sun$print$PSPrinterJob == null ? (class$sun$print$PSPrinterJob = UnixPrintService.class$("sun.print.PSPrinterJob")) : class$sun$print$PSPrinterJob);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        supportedDocFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.POSTSCRIPT, DocFlavor.INPUT_STREAM.POSTSCRIPT, DocFlavor.URL.POSTSCRIPT, DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.CHAR_ARRAY.TEXT_PLAIN, DocFlavor.READER.TEXT_PLAIN, DocFlavor.STRING.TEXT_PLAIN, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_HOST, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_US_ASCII, DocFlavor.URL.TEXT_PLAIN_HOST, DocFlavor.URL.TEXT_PLAIN_UTF_8, DocFlavor.URL.TEXT_PLAIN_UTF_16, DocFlavor.URL.TEXT_PLAIN_UTF_16BE, DocFlavor.URL.TEXT_PLAIN_UTF_16LE, DocFlavor.URL.TEXT_PLAIN_US_ASCII, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
        encoding = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        serviceAttrCats = new Class[]{class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = UnixPrintService.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName, class$javax$print$attribute$standard$PrinterIsAcceptingJobs == null ? (class$javax$print$attribute$standard$PrinterIsAcceptingJobs = UnixPrintService.class$("javax.print.attribute.standard.PrinterIsAcceptingJobs")) : class$javax$print$attribute$standard$PrinterIsAcceptingJobs, class$javax$print$attribute$standard$QueuedJobCount == null ? (class$javax$print$attribute$standard$QueuedJobCount = UnixPrintService.class$("javax.print.attribute.standard.QueuedJobCount")) : class$javax$print$attribute$standard$QueuedJobCount};
        otherAttrCats = new Class[]{class$javax$print$attribute$standard$Chromaticity == null ? (class$javax$print$attribute$standard$Chromaticity = UnixPrintService.class$("javax.print.attribute.standard.Chromaticity")) : class$javax$print$attribute$standard$Chromaticity, class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = UnixPrintService.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies, class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = UnixPrintService.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination, class$javax$print$attribute$standard$Fidelity == null ? (class$javax$print$attribute$standard$Fidelity = UnixPrintService.class$("javax.print.attribute.standard.Fidelity")) : class$javax$print$attribute$standard$Fidelity, class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = UnixPrintService.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName, class$javax$print$attribute$standard$JobSheets == null ? (class$javax$print$attribute$standard$JobSheets = UnixPrintService.class$("javax.print.attribute.standard.JobSheets")) : class$javax$print$attribute$standard$JobSheets, class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = UnixPrintService.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media, class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = UnixPrintService.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea, class$javax$print$attribute$standard$OrientationRequested == null ? (class$javax$print$attribute$standard$OrientationRequested = UnixPrintService.class$("javax.print.attribute.standard.OrientationRequested")) : class$javax$print$attribute$standard$OrientationRequested, class$javax$print$attribute$standard$PageRanges == null ? (class$javax$print$attribute$standard$PageRanges = UnixPrintService.class$("javax.print.attribute.standard.PageRanges")) : class$javax$print$attribute$standard$PageRanges, class$javax$print$attribute$standard$RequestingUserName == null ? (class$javax$print$attribute$standard$RequestingUserName = UnixPrintService.class$("javax.print.attribute.standard.RequestingUserName")) : class$javax$print$attribute$standard$RequestingUserName, class$javax$print$attribute$standard$SheetCollate == null ? (class$javax$print$attribute$standard$SheetCollate = UnixPrintService.class$("javax.print.attribute.standard.SheetCollate")) : class$javax$print$attribute$standard$SheetCollate, class$javax$print$attribute$standard$Sides == null ? (class$javax$print$attribute$standard$Sides = UnixPrintService.class$("javax.print.attribute.standard.Sides")) : class$javax$print$attribute$standard$Sides};
        MAXCOPIES = 1000;
        mediaSizes = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5};
    }
}

