/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFileHeader;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public final class TraceFile
extends RandomAccessFile {
    private boolean bigendian = true;
    protected TraceFileHeader traceFileHeader;
    private String filespec;

    public TraceFile(String string, String string2) throws Exception {
        super(string, string2);
        this.filespec = string;
        this.traceFileHeader = new TraceFileHeader(this);
    }

    protected final int readI() throws IOException {
        int n = this.readInt();
        return this.bigendian ? n : Util.convertEndian(n);
    }

    protected final long readL() throws IOException {
        long l = this.readLong();
        long l2 = l >>> 56 | l << 56 | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L;
        return this.bigendian ? l : l2;
    }

    protected final BigInteger readBigInteger(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray);
        if (!this.bigendian) {
            TraceFile.reverseByteOrder(byArray);
        }
        return new BigInteger(1, byArray);
    }

    private static final void reverseByteOrder(byte[] byArray) {
        int n = 0;
        while (n < byArray.length / 2) {
            byte by = byArray[n];
            byArray[n] = byArray[byArray.length - 1 - n];
            byArray[byArray.length - 1 - n] = by;
            ++n;
        }
    }

    protected final long readULong() throws IOException {
        long l = this.readLong();
        long l2 = l >>> 56 | l << 56 | l >> 40 & 0xFF00L | l >> 24 & 0xFF0000L | l >> 8 & 0xFF000000L | l << 8 & 0xFF00000000L | l << 24 & 0xFF0000000000L | l << 40 & 0xFF000000000000L;
        return this.bigendian ? l : l2;
    }

    protected final String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 0) break;
            ++n2;
        }
        return new String(byArray, 0, n2, "8859_1");
    }

    protected final void setBigEndian(boolean bl) {
        this.bigendian = bl;
    }

    public final String toString() {
        return this.filespec;
    }
}

