/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.linux;

import com.ibm.jvm.linux.PSLine;
import com.ibm.jvm.linux.ProcMaps;
import com.ibm.jvm.linux.ProcStat;
import com.ibm.jvm.linux.ProcStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class procdata {
    String[] pids;
    Hashtable status;
    Hashtable stat;
    ProcMaps maps;
    String outFile = ".procdata";
    boolean outFileOK = true;
    BufferedWriter outWriter;

    public procdata(String string) {
        String string2;
        Enumeration enumeration;
        PSLine pSLine;
        String string3 = "procdata looking at process " + string;
        String string4 = "=====================================================================================";
        this.console("");
        this.console(string3);
        this.console(string4.substring(0, string3.length()));
        this.console("");
        this.outFile = string + this.outFile;
        this.console("Creating file: " + this.outFile);
        this.console("");
        try {
            this.outWriter = new BufferedWriter(new FileWriter(this.outFile, false));
        }
        catch (IOException iOException) {
            this.console("IOEception whilst opening " + this.outFile + " - will output to console instead");
            this.outFileOK = false;
        }
        this.output("");
        this.output(string3);
        this.output(string4.substring(0, string3.length()));
        this.output("");
        this.status = new Hashtable();
        this.stat = new Hashtable();
        Vector vector = this.issueCommand("ps -emfH --cols 500");
        if (vector.size() == 0 && (vector = this.issueCommand("ps -efH --cols 500")).size() == 0) {
            this.console("");
            this.console("ps command failed - this debug tool only works on Linux");
            System.exit(-1);
        }
        Vector vector2 = new Vector();
        this.output((String)vector.elementAt(0));
        boolean bl = false;
        String string5 = "";
        int n = 1;
        while (n < vector.size()) {
            pSLine = new PSLine((String)vector.elementAt(n));
            if (!bl) {
                if (pSLine.getPID().equals(string)) {
                    bl = true;
                    vector2.addElement(pSLine);
                    string5 = pSLine.getCMD();
                }
            } else {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    string2 = ((PSLine)enumeration.nextElement()).getPID();
                    if (!pSLine.getPPID().equals(string2)) continue;
                    vector2.addElement(pSLine);
                }
            }
            ++n;
        }
        this.pids = new String[vector2.size()];
        n = -1;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            pSLine = (PSLine)enumeration.nextElement();
            string2 = pSLine.getPID();
            String string6 = pSLine.getLine();
            this.pids[++n] = string2;
            this.output(string6);
        }
        this.output("");
        this.maps = new ProcMaps(string);
        this.output(this.maps.getData());
        this.output("");
        this.console("Reading /proc/pid/stat and /proc/pid/status");
        n = 0;
        while (n < this.pids.length) {
            this.status.put(this.pids[n], new ProcStatus(this.pids[n]));
            this.output(((ProcStatus)this.status.get(this.pids[n])).getData());
            this.stat.put(this.pids[n], new ProcStat(this.pids[n]));
            ++n;
        }
        this.summary();
        this.console("Complete - output stored in: " + this.outFile);
    }

    private Vector issueCommand(String string) {
        Vector vector;
        block7: {
            vector = new Vector();
            try {
                this.console("issueCommand() " + string);
                Process process = Runtime.getRuntime().exec(string);
                process.waitFor();
                try {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        string2 = string2.trim();
                        vector.addElement(string2);
                    }
                }
                catch (Exception exception) {
                    this.console("issueCommand() inputstream failed, exception = " + exception);
                    System.exit(-1);
                }
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string3 = bufferedReader.readLine();
                    if (string3 == null) break block7;
                    this.console("issueCommand() stderr returned:\n" + string3);
                }
                catch (Exception exception) {
                    this.console("issueCommand stderr failed, exception = " + exception);
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                this.console("issueCommand() failed, exception = " + exception);
                System.exit(-1);
            }
        }
        return vector;
    }

    private void summary() {
        this.console("Creating summary");
        this.output("  pid" + this.summaryField("PPid", false, false, 0, 6) + this.summaryField("State", false, false, 0, 14) + this.summaryField("SigPnd", false, false, 0, 18) + this.summaryField("SigBlk", false, false, 0, 18) + this.summaryField("SigIgn", false, false, 0, 18) + this.summaryField("startstack", false, false, 0, 12) + this.summaryField("kstkesp", false, false, 0, 12) + this.summaryField("kstkeip", false, false, 0, 12));
        int n = 0;
        while (n < this.pids.length) {
            ProcStatus procStatus = (ProcStatus)this.status.get(this.pids[n]);
            ProcStat procStat = (ProcStat)this.stat.get(this.pids[n]);
            String string = procStatus.get("SigPnd");
            String string2 = procStatus.get("SigBlk");
            String string3 = procStatus.get("SigIgn");
            String string4 = "";
            String string5 = "";
            if (!string.equals("0000000000000000")) {
                string4 = string4 + " Pnd:" + this.decodeSigmask(string);
                string = "*" + string;
                this.console("==> " + this.pids[n] + " Pnd " + string);
            }
            if (!string2.equals("0000000000000000")) {
                string4 = string4 + " Blk:" + this.decodeSigmask(string2);
                if (string2.equals("fffffffefffbfeef")) {
                    string5 = "Pthread_manager";
                } else if (string2.equals("0000000000000200")) {
                    string5 = "in pthread wait (eg condvar wait)";
                } else if (string2.equals("0000000080000000")) {
                    string5 = "in interruptible I/O";
                } else if (string2.equals("0000000080000200")) {
                    string5 = "normal running";
                } else if (string2.equals("fffffffffe41f207")) {
                    string5 = "suspended thread";
                } else if (string2.equals("fffffffffe41fa07")) {
                    string5 = "GCing thread";
                } else {
                    string2 = "*" + string2;
                    this.console("==> " + this.pids[n] + " Blk " + string2);
                }
            }
            this.output(this.summaryField(this.pids[n], false, false, 0, 6) + this.summaryField(procStatus.get("PPid"), false, false, 0, 6) + this.summaryField(procStatus.get("State"), false, false, 0, 14) + this.summaryField(string, false, false, 0, 18) + this.summaryField(string2, false, false, 0, 18) + this.summaryField(string3, false, false, 0, 18) + this.summaryField(procStat.get("startstack"), true, true, 8, 12) + this.summaryField(procStat.get("kstkesp"), true, true, 8, 12) + this.summaryField(procStat.get("kstkeip"), true, true, 8, 12) + string4 + " " + string5);
            ++n;
        }
    }

    private String summaryField(String string, boolean bl, boolean bl2, int n, int n2) {
        String string2;
        if (bl) {
            Long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            string2 = Long.toHexString(l);
        } else {
            string2 = string;
        }
        if (n != 0) {
            string2 = "000000000000000000000000000" + string2;
            string2 = string2.substring(string2.length() - n);
        }
        if (bl2) {
            string2 = "0x" + string2;
        }
        string2 = "                                      " + string2;
        string2 = string2.substring(string2.length() - n2);
        return string2;
    }

    private long getlongFromHexString(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        long l = 1L;
        long l2 = 0L;
        int n = cArray.length;
        while (n > 0) {
            char c = cArray[n - 1];
            switch (c) {
                case '0': {
                    break;
                }
                case '1': {
                    l2 += 1L * l;
                    break;
                }
                case '2': {
                    l2 += 2L * l;
                    break;
                }
                case '3': {
                    l2 += 3L * l;
                    break;
                }
                case '4': {
                    l2 += 4L * l;
                    break;
                }
                case '5': {
                    l2 += 5L * l;
                    break;
                }
                case '6': {
                    l2 += 6L * l;
                    break;
                }
                case '7': {
                    l2 += 7L * l;
                    break;
                }
                case '8': {
                    l2 += 8L * l;
                    break;
                }
                case '9': {
                    l2 += 9L * l;
                    break;
                }
                case 'A': {
                    l2 += 10L * l;
                    break;
                }
                case 'B': {
                    l2 += 11L * l;
                    break;
                }
                case 'C': {
                    l2 += 12L * l;
                    break;
                }
                case 'D': {
                    l2 += 13L * l;
                    break;
                }
                case 'E': {
                    l2 += 14L * l;
                    break;
                }
                case 'F': {
                    l2 += 15L * l;
                    break;
                }
                default: {
                    return 0L;
                }
            }
            l *= 16L;
            --n;
        }
        return l2;
    }

    private int checksum(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char[] cArray = string.substring(n2, n2 + 1).toUpperCase().toCharArray();
            switch (cArray[0]) {
                case '1': {
                    ++n;
                    break;
                }
                case '2': {
                    n += 2;
                    break;
                }
                case '3': {
                    n += 3;
                    break;
                }
                case '4': {
                    n += 4;
                    break;
                }
                case '5': {
                    n += 5;
                    break;
                }
                case '6': {
                    n += 6;
                    break;
                }
                case '7': {
                    n += 7;
                    break;
                }
                case '8': {
                    n += 8;
                    break;
                }
                case '9': {
                    n += 9;
                    break;
                }
                case 'A': {
                    n += 10;
                    break;
                }
                case 'B': {
                    n += 11;
                    break;
                }
                case 'C': {
                    n += 12;
                    break;
                }
                case 'D': {
                    n += 13;
                    break;
                }
                case 'E': {
                    n += 14;
                    break;
                }
                case 'F': {
                    n += 15;
                }
            }
            ++n2;
        }
        return n;
    }

    private String decodeSigmask(String string) {
        String string2;
        boolean bl;
        if (this.checksum(string) <= 112) {
            bl = true;
            string2 = "+";
        } else {
            bl = false;
            string2 = "-";
        }
        String[] stringArray = new String[]{"UNUSED", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "BUS", "FPE", "KILL", "USR1", "SEGV", "USR2", "PIPE", "ALRM", "TERM", "STKFLT", "CHLD", "CONT", "STOP", "TSTP", "TTIN", "TTOU", "URG", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "IO", "PWR", "UNUSED", "Sig32", "Sig33", "Sig34", "Sig35", "Sig36", "Sig37", "Sig38", "Sig39", "Sig40", "Sig41", "Sig42", "Sig43", "Sig44", "Sig45", "Sig46", "Sig47", "Sig48", "Sig49", "Sig50", "Sig51", "Sig52", "Sig53", "Sig54", "Sig55", "Sig56", "Sig57", "Sig58", "Sig59", "Sig60", "Sig61", "Sig62", "Sig63", "Sig64"};
        String string3 = "";
        long l = this.getlongFromHexString(string);
        boolean bl2 = false;
        long l2 = 1L;
        int n = 1;
        while (n < 65) {
            if ((l & l2) == l2) {
                if (bl) {
                    string3 = string3 + " +" + stringArray[n];
                }
            } else if (!bl) {
                string3 = string3 + " -" + stringArray[n];
            }
            l2 *= 2L;
            ++n;
        }
        return string3 + " ";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("format is procdata pid");
            System.exit(-1);
        }
        procdata procdata2 = new procdata(stringArray[0]);
    }

    private void output(String string) {
        if (this.outFileOK) {
            try {
                this.outWriter.write(string + "\n");
                this.outWriter.flush();
            }
            catch (IOException iOException) {
                this.console("output to " + this.outFile + " received IOException");
            }
        } else {
            System.out.println(string);
        }
    }

    private void console(String string) {
        System.err.println(string);
    }
}

