/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.oldformat;

import com.ibm.jvm.oldformat.ExternalTraceBuffer;
import com.ibm.jvm.oldformat.MultiTraceFile;
import com.ibm.jvm.oldformat.SingleTraceFile;
import com.ibm.jvm.oldformat.SpannedTraceEntry;
import com.ibm.jvm.oldformat.TraceBuffer;
import com.ibm.jvm.oldformat.TraceBufferHeader;
import com.ibm.jvm.oldformat.TraceEntryList;
import com.ibm.jvm.oldformat.TraceFileHeader;
import com.ibm.jvm.oldformat.TraceFormat;
import com.ibm.jvm.oldformat.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class TraceFile {
    protected static BigInteger first = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    protected static BigInteger last = BigInteger.ZERO;
    protected static BigInteger lastWritePlatform = BigInteger.ZERO;
    protected static BigInteger lastWriteSystem = BigInteger.ZERO;
    protected static BigInteger timeConversion = BigInteger.ZERO;
    protected static final String active = "Active Threads :\n";
    protected static final String start = "Trace Start Time :\n";
    protected static final String finish = "Trace End Time :\n";
    protected static Hashtable names = new Hashtable();
    protected Hashtable spanners = new Hashtable();
    protected TraceEntryList entryList = new TraceEntryList();
    protected TraceFileHeader header;
    private Vector bufVector = null;

    public static final TraceFile getFile(String string) throws Exception {
        int n = string.indexOf("#");
        try {
            if (n == -1) {
                return new SingleTraceFile(string);
            }
            return new MultiTraceFile(string, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Trace file not found");
            System.exit(-3);
            return null;
        }
    }

    protected final void parse() {
        try {
            this.bufVector = this.readData();
        }
        catch (Exception exception) {
            System.out.println("TraceFile.parse() " + exception);
        }
    }

    protected final byte[] readFile(File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            if (file.length() > 0L) {
                fileInputStream.read(byArray);
                Util.determineEndian(byArray);
                Util.determineEncoding(byArray[0]);
            } else {
                System.out.println("Trace file is empty");
                System.exit(-3);
            }
            return byArray;
        }
        throw new FileNotFoundException();
    }

    protected final TraceEntryList getEntryList() {
        this.processData(this.bufVector);
        return this.entryList;
    }

    protected final Vector readTraceBuffers(TraceFileHeader traceFileHeader, byte[] byArray) {
        Vector vector = new Vector(100);
        int n = (int)traceFileHeader.getBufferSize();
        int n2 = (byArray.length - traceFileHeader.getLength()) / n;
        int n3 = byArray.length;
        Util.Debug.println("there are " + Integer.toString(n2) + " in this file:");
        int n4 = 0;
        while (n4 < n2) {
            Util.Debug.println("Processing buffer at offset " + ((long)n4 * traceFileHeader.getBufferSize() + (long)traceFileHeader.getLength()));
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, n3 -= n, byArray2, 0, n);
            vector.addElement(TraceBuffer.newBuffer(byArray2));
            ((TraceBuffer)vector.get((int)(vector.size() - 1))).hack = n3;
            ++n4;
        }
        return vector;
    }

    protected final TraceFileHeader createHeader(byte[] byArray) {
        int n = (int)Util.constructUnsignedInt(byArray, 4);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return new TraceFileHeader(byArray2);
    }

    protected int findNewest(Object[] objectArray) {
        int n = 0;
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (n2 < objectArray.length) {
            BigInteger bigInteger2 = ((TraceBuffer)objectArray[n2]).getLatestTimeStamp();
            if (bigInteger2.compareTo(bigInteger) == 1) {
                bigInteger = bigInteger2;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    protected final void readEntriesFromBuffers(Object[] objectArray, int n) {
        try {
            Util.Debug.println("num buffers " + objectArray.length);
            TraceBuffer traceBuffer = null;
            TraceEntryList traceEntryList = null;
            int n2 = 0;
            while (n2 < objectArray.length) {
                traceBuffer = (TraceBuffer)objectArray[n];
                Util.Debug.println("Processing buffer " + n + " for thread " + traceBuffer.getHeader().getThreadName());
                String string = Long.toString(traceBuffer.getHeader().getThreadID(), 16);
                SpannedTraceEntry spannedTraceEntry = (SpannedTraceEntry)this.spanners.get(string);
                TraceEntryList traceEntryList2 = traceEntryList = spannedTraceEntry == null ? traceBuffer.readEntries(traceBuffer.getOffsetToFirstEntry()) : ((ExternalTraceBuffer)traceBuffer).readEntries(spannedTraceEntry);
                if (traceEntryList.getFirst() instanceof SpannedTraceEntry) {
                    spannedTraceEntry = (SpannedTraceEntry)traceEntryList.removeFirst();
                    this.spanners.put(string, spannedTraceEntry);
                } else {
                    this.spanners.remove(string);
                }
                this.entryList.addAll(traceEntryList);
                n = (n + 1) % objectArray.length;
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void doSummary(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        bufferedWriter.write("                Trace Summary");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        this.header.summarize(bufferedWriter);
        bufferedWriter.write(active, 0, active.length());
        this.computeSummary(this.bufVector);
        Enumeration enumeration = names.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (String)names.get(object2);
            String string = "        " + (String)object2 + "  ";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.write((String)object, 0, ((String)object).length());
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        if (names.size() == 0) {
            bufferedWriter.write("Trace file contains no trace data");
            System.out.println("Trace file contains no trace data");
            bufferedWriter.close();
            System.exit(-3);
        }
        if ((double)TraceFormat.verMod >= 1.1) {
            object2 = lastWritePlatform.subtract(TraceFormat.startPlatform);
            object = lastWriteSystem.subtract(TraceFormat.startSystem);
            timeConversion = ((BigInteger)object2).divide((BigInteger)object);
            bufferedWriter.write("JVM started      : " + Util.getFormattedTime(TraceFormat.startPlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Last buffer write: " + Util.getFormattedTime(lastWritePlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        object2 = "First tracepoint:  " + Util.getFormattedTime(first);
        object = "Last tracepoint :  " + Util.getFormattedTime(last);
        bufferedWriter.write((String)object2, 0, ((String)object2).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write((String)object, 0, ((String)object).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    protected void computeSummary(Vector vector) throws IOException {
        Object[] objectArray = vector.toArray();
        int n = 0;
        while (n < objectArray.length) {
            TraceBufferHeader traceBufferHeader = ((TraceBuffer)objectArray[n]).getHeader();
            String string = Long.toString(traceBufferHeader.getThreadID(), 16);
            String string2 = traceBufferHeader.getThreadName();
            BigInteger bigInteger = traceBufferHeader.getWrapTime();
            BigInteger bigInteger2 = traceBufferHeader.getLastTimeStamp();
            if ((double)TraceFormat.verMod >= 1.1) {
                BigInteger bigInteger3 = traceBufferHeader.getWritePlatform();
                BigInteger bigInteger4 = traceBufferHeader.getWriteSystem();
                if (bigInteger3.compareTo(lastWritePlatform) > 0) {
                    lastWritePlatform = bigInteger3;
                    lastWriteSystem = bigInteger4;
                }
            }
            if (names.get(string) == null) {
                names.put(string, string2);
            }
            if (bigInteger.compareTo(first) < 0) {
                first = bigInteger;
            }
            if (bigInteger2.compareTo(last) > 0) {
                last = bigInteger2;
            }
            ++n;
        }
    }

    protected abstract Vector readData();

    protected abstract void processData(Vector var1);
}

