/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class DBCS_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final String[] data;
    private final int convertType;
    private final char[] singleMap;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    DBCS_Encoder(Charset charset, short[] sArray, String[] stringArray, char[] cArray, byte by, byte[] byArray) {
        super(charset, 2.0f, 4.0f);
        this.index = sArray;
        this.data = stringArray;
        this.singleMap = by == 2 ? new char[0] : (char[])(cArray != null && cArray.length % 3 == 0 ? cArray : null);
        this.convertType = by;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        char c2 = this.convSingle(c);
        if (c2 != '\uffff') {
            return true;
        }
        int n = this.index[c >> 8] << 8;
        c2 = this.data[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
        return this.convertType != 1 && (c2 != '\u0000' || c == '\u0000');
    }

    private final char convSingle(char c) {
        if (this.singleMap == null) {
            return c < '\u0080' ? c : (char)'\uffff';
        }
        int n = this.singleMap.length;
        int n2 = 0;
        while (n2 < n) {
            if (c <= this.singleMap[n2 + 1] && c >= this.singleMap[n2]) {
                return (char)(this.singleMap[n2 + 2] + c - this.singleMap[n2]);
            }
            n2 += 3;
        }
        return '\uffff';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            char c2 = this.convSingle(c);
            int n5 = 1;
            if (c2 == '\uffff') {
                c2 = this.getValue(c);
                if (c2 >= '\u0100') {
                    n5 = 2;
                } else {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
            }
            if (n4 - n3 < n5) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if (n5 > 1) {
                byArray[n3++] = (byte)(c2 >> 8);
            }
            byArray[n3++] = (byte)c2;
            ++n;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block11: {
            CoderResult coderResult2;
            block16: {
                CoderResult coderResult3;
                block15: {
                    CoderResult coderResult4;
                    block14: {
                        CoderResult coderResult5;
                        block13: {
                            CoderResult coderResult6;
                            n = charBuffer.position();
                            try {
                                while (true) {
                                    char c;
                                    int n2;
                                    block18: {
                                        block17: {
                                            if (!charBuffer.hasRemaining()) {
                                                coderResult = CoderResult.UNDERFLOW;
                                                break block11;
                                            }
                                            char c2 = charBuffer.get();
                                            if (Surrogate.is(c2)) {
                                                if (this.sgp.parse(c2, charBuffer) < 0) {
                                                    coderResult6 = this.sgp.error();
                                                    Object var10_12 = null;
                                                    break;
                                                }
                                                coderResult5 = this.sgp.unmappableResult();
                                                break block13;
                                            }
                                            n2 = 1;
                                            c = this.convSingle(c2);
                                            if (this.convertType == 1) break block17;
                                            if (c != '\uffff') break block18;
                                            c = this.getValue(c2);
                                            if (c >= '\u0100') {
                                                n2 = 2;
                                                break block18;
                                            } else {
                                                coderResult4 = CoderResult.unmappableForLength(1);
                                                break block14;
                                            }
                                        }
                                        if (c == '\uffff') {
                                            coderResult3 = CoderResult.unmappableForLength(1);
                                            break block15;
                                        }
                                    }
                                    if (byteBuffer.remaining() < n2) {
                                        coderResult2 = CoderResult.OVERFLOW;
                                        break block16;
                                    }
                                    if (n2 > 1) {
                                        byteBuffer.put((byte)(c >> 8));
                                    }
                                    byteBuffer.put((byte)c);
                                    ++n;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var10_18 = null;
                                charBuffer.position(n);
                                throw throwable;
                            }
                            charBuffer.position(n);
                            return coderResult6;
                        }
                        Object var10_13 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var10_14 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var10_15 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var10_16 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var10_17 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected char getValue(char c) {
        int n = this.index[c >> 8] << 8;
        return this.data[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType != 1 && charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

