/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class DirectDecoder
extends IBMCharsetDecoder {
    private final int maxCode;

    protected DirectDecoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.maxCode = n;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = (char)(byArray[n] & 0xFF);
            if (c > this.maxCode) {
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
            ++n;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block6: {
            CoderResult coderResult2;
            block8: {
                CoderResult coderResult3;
                n = byteBuffer.position();
                try {
                    while (true) {
                        if (!byteBuffer.hasRemaining()) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block6;
                        }
                        char c = (char)(byteBuffer.get() & 0xFF);
                        if (c > this.maxCode) {
                            coderResult3 = CoderResult.unmappableForLength(1);
                            Object var8_7 = null;
                            break;
                        }
                        if (!charBuffer.hasRemaining()) {
                            coderResult2 = CoderResult.OVERFLOW;
                            break block8;
                        }
                        ++n;
                        charBuffer.put(c);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    byteBuffer.position(n);
                    throw throwable;
                }
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var8_8 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var8_9 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !IBMCharsetDecoder.UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

