/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public class ISCII91
extends Converter {
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';

    public ISCII91() {
        super("ISCII91", "ISCII91");
    }

    protected int mapClass(String string) {
        return 6;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private class Encoder
    extends CharsetEncoder {
        private static final byte NO_CHAR = -1;
        private final byte[] directMapTable;
        private final Surrogate.Parser sgp;

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            this.directMapTable = ISCII91.this.c2b.getByteData();
            this.sgp = new Surrogate.Parser();
        }

        public boolean canEncode(char c) {
            return c >= '\u0900' && c <= '\u097f' || c == '\u200d' || c == '\u200c' || c >= '\u0000' && c <= '\u007f';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block16: {
                CoderResult coderResult2;
                block21: {
                    CoderResult coderResult3;
                    block20: {
                        CoderResult coderResult4;
                        block19: {
                            CoderResult coderResult5;
                            block18: {
                                CoderResult coderResult6;
                                n = charBuffer.position();
                                try {
                                    while (true) {
                                        if (!charBuffer.hasRemaining()) {
                                            coderResult = CoderResult.UNDERFLOW;
                                            break block16;
                                        }
                                        int n2 = Integer.MIN_VALUE;
                                        char c = charBuffer.get();
                                        if (c >= '\u0000' && c <= '\u007f') {
                                            if (byteBuffer.remaining() < 1) {
                                                coderResult6 = CoderResult.OVERFLOW;
                                                Object var9_11 = null;
                                                break;
                                            } else {
                                                byteBuffer.put((byte)c);
                                                continue;
                                            }
                                        }
                                        if (c == '\u200c') {
                                            c = '\u094d';
                                        } else if (c == '\u200d') {
                                            c = '\u093c';
                                        }
                                        if (c >= '\u0900' && c <= '\u097f') {
                                            n2 = (c - 2304) * 2;
                                        }
                                        if (c >= '\ud800' && c < '\udbff') {
                                            if (this.sgp.parse(c, charBuffer) < 0) {
                                                coderResult5 = this.sgp.error();
                                                break block18;
                                            }
                                            coderResult4 = this.sgp.unmappableResult();
                                            break block19;
                                        }
                                        if (n2 == Integer.MIN_VALUE || this.directMapTable[n2] == -1) {
                                            coderResult3 = CoderResult.unmappableForLength(1);
                                            break block20;
                                        }
                                        byteBuffer.put(this.directMapTable[n2++]);
                                        if (this.directMapTable[n2] != -1) {
                                            if (byteBuffer.remaining() < 1) {
                                                coderResult2 = CoderResult.OVERFLOW;
                                                break block21;
                                            }
                                            byteBuffer.put(this.directMapTable[n2]);
                                        }
                                        ++n;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var9_17 = null;
                                    charBuffer.position(n);
                                    throw throwable;
                                }
                                charBuffer.position(n);
                                return coderResult6;
                            }
                            Object var9_12 = null;
                            charBuffer.position(n);
                            return coderResult5;
                        }
                        Object var9_13 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var9_14 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var9_15 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var9_16 = null;
            charBuffer.position(n);
            return coderResult;
        }
    }

    private class Decoder
    extends CharsetDecoder {
        private final char[] directMapTable;
        private static final char ZWNJ_CHAR = '\u200c';
        private static final char ZWJ_CHAR = '\u200d';
        private static final char INVALID_CHAR = '\uffff';
        private char contextChar;
        private boolean needFlushing;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
            this.directMapTable = ISCII91.this.b2c.getCharData();
            this.contextChar = (char)65535;
            this.needFlushing = false;
        }

        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.needFlushing) {
                if (charBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.contextChar);
            }
            this.contextChar = (char)65535;
            this.needFlushing = false;
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            block39: {
                CoderResult coderResult2;
                block45: {
                    CoderResult coderResult3;
                    block44: {
                        CoderResult coderResult4;
                        block43: {
                            CoderResult coderResult5;
                            block42: {
                                CoderResult coderResult6;
                                block41: {
                                    CoderResult coderResult7;
                                    n = byteBuffer.position();
                                    try {
                                        block19: while (true) {
                                            if (!byteBuffer.hasRemaining()) {
                                                coderResult = CoderResult.UNDERFLOW;
                                                break block39;
                                            }
                                            int n2 = byteBuffer.get();
                                            n2 = n2 < 0 ? n2 + 255 : n2;
                                            char c = this.directMapTable[n2];
                                            if (this.contextChar == '\ufffd') {
                                                if (charBuffer.remaining() < 1) {
                                                    coderResult7 = CoderResult.OVERFLOW;
                                                    Object var9_12 = null;
                                                    break;
                                                } else {
                                                    charBuffer.put('\ufffd');
                                                    this.contextChar = (char)65535;
                                                    this.needFlushing = false;
                                                    continue;
                                                }
                                            }
                                            block1 : switch (c) {
                                                case '\u0901': 
                                                case '\u0907': 
                                                case '\u0908': 
                                                case '\u090b': 
                                                case '\u093f': 
                                                case '\u0940': 
                                                case '\u0943': 
                                                case '\u0964': {
                                                    if (this.needFlushing) {
                                                        if (charBuffer.remaining() < 1) {
                                                            coderResult6 = CoderResult.OVERFLOW;
                                                            break block41;
                                                        } else {
                                                            charBuffer.put(this.contextChar);
                                                            this.contextChar = c;
                                                            continue block19;
                                                        }
                                                    }
                                                    this.contextChar = c;
                                                    this.needFlushing = true;
                                                    continue block19;
                                                }
                                                case '\u093c': {
                                                    switch (this.contextChar) {
                                                        case '\u0901': {
                                                            charBuffer.put('\u0950');
                                                            break block1;
                                                        }
                                                        case '\u0907': {
                                                            charBuffer.put('\u090c');
                                                            break block1;
                                                        }
                                                        case '\u0908': {
                                                            charBuffer.put('\u0961');
                                                            break block1;
                                                        }
                                                        case '\u090b': {
                                                            charBuffer.put('\u0960');
                                                            break block1;
                                                        }
                                                        case '\u093f': {
                                                            charBuffer.put('\u0962');
                                                            break block1;
                                                        }
                                                        case '\u0940': {
                                                            charBuffer.put('\u0963');
                                                            break block1;
                                                        }
                                                        case '\u0943': {
                                                            charBuffer.put('\u0944');
                                                            break block1;
                                                        }
                                                        case '\u0964': {
                                                            charBuffer.put('\u093d');
                                                            break block1;
                                                        }
                                                        case '\u094d': {
                                                            if (this.needFlushing) {
                                                                charBuffer.put(this.contextChar);
                                                                this.contextChar = c;
                                                                continue block19;
                                                            }
                                                            charBuffer.put('\u200d');
                                                            break block1;
                                                        }
                                                    }
                                                    if (this.needFlushing) {
                                                        charBuffer.put(this.contextChar);
                                                        this.contextChar = c;
                                                        continue block19;
                                                    }
                                                    charBuffer.put('\u093c');
                                                    break;
                                                }
                                                case '\u094d': {
                                                    if (this.needFlushing) {
                                                        if (charBuffer.remaining() < 1) {
                                                            coderResult5 = CoderResult.OVERFLOW;
                                                            break block42;
                                                        } else {
                                                            charBuffer.put(this.contextChar);
                                                            this.contextChar = c;
                                                            continue block19;
                                                        }
                                                    }
                                                    if (this.contextChar == '\u094d') {
                                                        charBuffer.put('\u200c');
                                                        break;
                                                    }
                                                    charBuffer.put('\u094d');
                                                    break;
                                                }
                                                case '\uffff': {
                                                    if (this.needFlushing) {
                                                        if (charBuffer.remaining() < 1) {
                                                            coderResult4 = CoderResult.OVERFLOW;
                                                            break block43;
                                                        } else {
                                                            charBuffer.put(this.contextChar);
                                                            this.contextChar = c;
                                                            continue block19;
                                                        }
                                                    }
                                                    coderResult3 = CoderResult.unmappableForLength(1);
                                                    break block44;
                                                }
                                                default: {
                                                    if (this.needFlushing) {
                                                        if (charBuffer.remaining() < 1) {
                                                            coderResult2 = CoderResult.OVERFLOW;
                                                            break block45;
                                                        } else {
                                                            charBuffer.put(this.contextChar);
                                                            this.contextChar = c;
                                                            continue block19;
                                                        }
                                                    }
                                                    charBuffer.put(c);
                                                }
                                            }
                                            this.contextChar = c;
                                            this.needFlushing = false;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_19 = null;
                                        byteBuffer.position(n);
                                        throw throwable;
                                    }
                                    byteBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var9_13 = null;
                                byteBuffer.position(n);
                                return coderResult6;
                            }
                            Object var9_14 = null;
                            byteBuffer.position(n);
                            return coderResult5;
                        }
                        Object var9_15 = null;
                        byteBuffer.position(n);
                        return coderResult4;
                    }
                    Object var9_16 = null;
                    byteBuffer.position(n);
                    return coderResult3;
                }
                Object var9_17 = null;
                byteBuffer.position(n);
                return coderResult2;
            }
            Object var9_18 = null;
            byteBuffer.position(n);
            return coderResult;
        }
    }
}

