/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

class SBCS_Decoder
extends IBMCharsetDecoder {
    private final char[] byteToCharTable;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static boolean bidiConfigDone = false;
    private static String bidiInit;

    protected SBCS_Decoder(Charset charset, char[] cArray) {
        super(charset, 1.0f, 1.0f);
        this.byteToCharTable = cArray;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : (String)AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected SBCS_Decoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        if (string.length() >= 256) {
            this.byteToCharTable = string.toCharArray();
        } else {
            this.byteToCharTable = new char[256];
            int n = 0;
            while (n < 256) {
                this.byteToCharTable[n] = n < string.length() ? (int)string.charAt(n) : 65533;
                ++n;
            }
        }
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : (String)AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = this.byteToCharTable[byArray[n] + 128];
            if (c == '\ufffd') {
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
            ++n;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block6: {
            CoderResult coderResult2;
            block8: {
                CoderResult coderResult3;
                n = byteBuffer.position();
                try {
                    while (true) {
                        if (!byteBuffer.hasRemaining()) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block6;
                        }
                        char c = this.byteToCharTable[byteBuffer.get() + 128];
                        if (c == '\ufffd') {
                            coderResult3 = CoderResult.unmappableForLength(1);
                            Object var8_7 = null;
                            break;
                        }
                        if (!charBuffer.hasRemaining()) {
                            coderResult2 = CoderResult.OVERFLOW;
                            break block8;
                        }
                        ++n;
                        charBuffer.put(c);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    byteBuffer.position(n);
                    throw throwable;
                }
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var8_8 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var8_9 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        BidiConvert bidiConvert;
        int n;
        int n2;
        char[] cArray;
        CoderResult coderResult;
        boolean bl;
        int n3 = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !IBMCharsetDecoder.UseBuffer) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            int n4 = charBuffer.position();
            cArray = charBuffer.array();
            n2 = charBuffer.arrayOffset() + n3;
            n = charBuffer.arrayOffset() + n4;
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            int n5 = charBuffer.position();
            n2 = 0;
            n = n5 - n3;
            cArray = new char[n];
            charBuffer.position(n3);
            charBuffer.get(cArray);
            charBuffer.position(n5);
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n2, n, this.bidiParms, this.toString())) {
            cArray = bidiConvert.toUnicode(cArray, n2, n, this.bidiParms, this.toString());
            if (bl) {
                System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n3, cArray.length);
            } else {
                charBuffer.position(n3);
                charBuffer.put(cArray);
            }
        }
        return coderResult;
    }
}

