/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class SBCS_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final char[] data;
    private final byte[] byteMap;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    protected SBCS_Encoder(Charset charset, short[] sArray, char[] cArray, byte[] byArray, int n, byte[] byArray2) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.data = cArray;
        this.byteMap = byArray;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.shift = n;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : (String)AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected SBCS_Encoder(Charset charset, short[] sArray, String string, int n, int n2, int n3) {
        this(charset, sArray, string.toCharArray(), null, n3, null);
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : (String)AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    public boolean canEncode(char c) {
        char c2 = this.data[this.index[c >> this.shift] + (c & this.mask2)];
        return c2 != '\u0000' || c == '\u0000';
    }

    /*
     * Unable to fully structure code
     */
    private CoderResult encodeArrayLoop(CharBuffer var1_1, ByteBuffer var2_2) {
        block8: {
            var3_3 = var1_1.array();
            var4_4 = var1_1.arrayOffset() + var1_1.position();
            var5_5 = var1_1.arrayOffset() + var1_1.limit();
            var6_6 = var2_2.array();
            var7_7 = var2_2.arrayOffset() + var2_2.position();
            var8_8 = var2_2.arrayOffset() + var2_2.limit();
            var10_9 = CoderResult.UNDERFLOW;
            if (this.byteMap == null) ** GOTO lbl38
            while (var4_4 < var5_5) {
                var9_10 = var3_3[var4_4];
                if (Surrogate.is(var9_10)) {
                    var10_9 = this.sgp.parse(var9_10, var3_3, var4_4, var5_5) < 0 ? this.sgp.error() : this.sgp.unmappableResult();
                    break block8;
                }
                var11_12 = this.byteMap[var9_10];
                if (var11_12 == 0 && var9_10 != '\u0000') {
                    var10_9 = CoderResult.unmappableForLength(1);
                    break block8;
                }
                if (var8_8 - var7_7 < 1) {
                    var10_9 = CoderResult.OVERFLOW;
                    break block8;
                }
                var6_6[var7_7++] = var11_12;
                ++var4_4;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                var9_11 = var3_3[var4_4];
                if (Surrogate.is(var9_11)) {
                    var10_9 = this.sgp.parse(var9_11, var3_3, var4_4, var5_5) < 0 ? this.sgp.error() : this.sgp.unmappableResult();
                    break;
                }
                var11_13 = (byte)this.data[this.index[var9_11 >> this.shift] + (var9_11 & this.mask2)];
                if (var11_13 == 0 && var9_11 != '\u0000') {
                    var10_9 = CoderResult.unmappableForLength(1);
                    break;
                }
                if (var8_8 - var7_7 < 1) {
                    var10_9 = CoderResult.OVERFLOW;
                    break;
                }
                var6_6[var7_7++] = var11_13;
                ++var4_4;
lbl38:
                // 2 sources

                ** while (var4_4 < var5_5)
            }
        }
        var1_1.position(var4_4 - var1_1.arrayOffset());
        var2_2.position(var7_7 - var2_2.arrayOffset());
        return var10_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block8: {
            CoderResult coderResult2;
            block12: {
                CoderResult coderResult3;
                block11: {
                    CoderResult coderResult4;
                    block10: {
                        CoderResult coderResult5;
                        n = charBuffer.position();
                        try {
                            while (true) {
                                byte by;
                                if (!charBuffer.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block8;
                                }
                                char c = charBuffer.get();
                                if (Surrogate.is(c)) {
                                    if (this.sgp.parse(c, charBuffer) < 0) {
                                        coderResult5 = this.sgp.error();
                                        Object var9_8 = null;
                                        break;
                                    }
                                    coderResult4 = this.sgp.unmappableResult();
                                    break block10;
                                }
                                byte by2 = by = this.byteMap != null ? this.byteMap[c] : (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                                if (by == 0 && c != '\u0000') {
                                    coderResult3 = CoderResult.unmappableForLength(1);
                                    break block11;
                                }
                                if (!byteBuffer.hasRemaining()) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block12;
                                }
                                ++n;
                                byteBuffer.put(by);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            charBuffer.position(n);
                            throw throwable;
                        }
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var9_9 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var9_10 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var9_11 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var9_12 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, IBMCharsetEncoder.UseBuffer, this.bidiParms, this.toString())) {
            int n;
            int n2;
            int n3;
            int n4 = charBuffer.remaining();
            if (n4 > byteBuffer.remaining()) {
                n4 = byteBuffer.remaining();
            }
            if (charBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
                char[] cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + charBuffer.position();
                n2 = n3 + n4;
                char c = cArray[n3];
                byte by = this.byteMap != null ? this.byteMap[c] : (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                boolean bl = by == 0 && c != '\u0000';
                n = n3 + 1;
                while (n < n2) {
                    c = cArray[n];
                    by = this.byteMap != null ? this.byteMap[c] : (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                    if ((by == 0 && c != '\u0000') != bl) break;
                    ++n;
                }
                n4 = n - n3;
            } else {
                int n5 = charBuffer.position();
                n2 = n4;
                n = charBuffer.get();
                byte by = this.byteMap != null ? this.byteMap[n] : (byte)this.data[this.index[n >> this.shift] + (n & this.mask2)];
                boolean bl = by == 0 && n != 0;
                n3 = 1;
                while (n3 < n2) {
                    n = charBuffer.get();
                    by = this.byteMap != null ? this.byteMap[n] : (byte)this.data[this.index[n >> this.shift] + (n & this.mask2)];
                    if ((by == 0 && n != 0) != bl) break;
                    ++n3;
                }
                charBuffer.position(n5);
                n4 = n3;
            }
            int n6 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n4);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, IBMCharsetEncoder.UseBuffer, this.bidiParms, this.toString());
            charBuffer.limit(n6);
            n2 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n2 = charBuffer.position() + charBuffer2.position() - n2;
            charBuffer.position(n2);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

