/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ExpiringCache {
    private long millisUntilExpiration;
    private Map map;
    private int queryCount;
    private int queryOverflow = 300;

    ExpiringCache() {
        this(30000L);
    }

    ExpiringCache(long l) {
        this.millisUntilExpiration = l;
        this.map = new HashMap();
    }

    synchronized String get(String string) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(string)) != null) {
            return entry.val();
        }
        return null;
    }

    synchronized void put(String string, String string2) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(string)) != null) {
            entry.setTimestamp(System.currentTimeMillis());
            entry.setVal(string2);
        } else {
            this.map.put(string, new Entry(System.currentTimeMillis(), string2));
        }
    }

    synchronized void clear() {
        this.map.clear();
    }

    private Entry entryFor(String string) {
        long l;
        Entry entry = (Entry)this.map.get(string);
        if (entry != null && ((l = System.currentTimeMillis() - entry.timestamp()) < 0L || l >= this.millisUntilExpiration)) {
            this.map.remove(string);
            entry = null;
        }
        return entry;
    }

    private void cleanup() {
        Set set = this.map.keySet();
        String[] stringArray = new String[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringArray[n++] = string;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.entryFor(stringArray[n2]);
            ++n2;
        }
        this.queryCount = 0;
    }

    static class Entry {
        private long timestamp;
        private String val;

        Entry(long l, String string) {
            this.timestamp = l;
            this.val = string;
        }

        long timestamp() {
            return this.timestamp;
        }

        void setTimestamp(long l) {
            this.timestamp = l;
        }

        String val() {
            return this.val;
        }

        void setVal(String string) {
            this.val = string;
        }
    }
}

