/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineNumberInputStream
extends FilterInputStream {
    int pushBack = -1;
    int lineNumber;
    int markLineNumber;
    int markPushBack = -1;

    public LineNumberInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = this.pushBack;
        if (n != -1) {
            this.pushBack = -1;
        } else {
            n = this.in.read();
        }
        switch (n) {
            case 13: {
                this.pushBack = this.in.read();
                if (this.pushBack == 10) {
                    this.pushBack = -1;
                }
            }
            case 10: {
                ++this.lineNumber;
                return 10;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        try {
            while (n4 < n2) {
                n3 = this.read();
                if (n3 != -1) {
                    if (byArray != null) {
                        byArray[n + n4] = (byte)n3;
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return n4;
    }

    public long skip(long l) throws IOException {
        int n = 2048;
        long l2 = l;
        if (l <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        while (l2 > 0L) {
            int n2 = this.read(byArray, 0, (int)Math.min((long)n, l2));
            if (n2 < 0) break;
            l2 -= (long)n2;
        }
        return l - l2;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int available() throws IOException {
        return this.pushBack == -1 ? super.available() / 2 : super.available() / 2 + 1;
    }

    public void mark(int n) {
        this.markLineNumber = this.lineNumber;
        this.markPushBack = this.pushBack;
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this.lineNumber = this.markLineNumber;
        this.pushBack = this.markPushBack;
        this.in.reset();
    }
}

