/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineNumber = 0;
    private int markedLineNumber;
    private boolean skipLF;
    private boolean markedSkipLF;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public LineNumberReader(Reader reader) {
        super(reader);
    }

    public LineNumberReader(Reader reader, int n) {
        super(reader, n);
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = super.read();
            if (this.skipLF) {
                if (n == 10) {
                    n = super.read();
                }
                this.skipLF = false;
            }
            switch (n) {
                case 13: {
                    this.skipLF = true;
                }
                case 10: {
                    ++this.lineNumber;
                    return 10;
                }
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3 = super.read(cArray, n, n2);
            int n4 = n;
            while (n4 < n + n3) {
                block11: {
                    char c;
                    block10: {
                        c = cArray[n4];
                        if (!this.skipLF) break block10;
                        this.skipLF = false;
                        if (c == '\n') break block11;
                    }
                    switch (c) {
                        case '\r': {
                            this.skipLF = true;
                        }
                        case '\n': {
                            ++this.lineNumber;
                        }
                    }
                }
                ++n4;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String string = super.readLine(this.skipLF);
            this.skipLF = false;
            if (string != null) {
                ++this.lineNumber;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        int n = (int)Math.min(l, 8192L);
        Object object = this.lock;
        synchronized (object) {
            if (this.skipBuffer == null || this.skipBuffer.length < n) {
                this.skipBuffer = new char[n];
            }
            long l2 = l;
            while (l2 > 0L) {
                int n2 = this.read(this.skipBuffer, 0, (int)Math.min(l2, (long)n));
                if (n2 == -1) break;
                l2 -= (long)n2;
            }
            return l - l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(n);
            this.markedLineNumber = this.lineNumber;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.lineNumber = this.markedLineNumber;
            this.skipLF = this.markedSkipLF;
        }
    }
}

