/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class UnixFileSystem
extends FileSystem {
    private final char slash;
    private final char colon;
    private final String javaHome;
    private ExpiringCache cache = new ExpiringCache();
    private ExpiringCache javaHomePrefixCache = new ExpiringCache();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$io$UnixFileSystem;

    public UnixFileSystem() {
        this.slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
        this.colon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);
        this.javaHome = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
    }

    public char getSeparator() {
        return this.slash;
    }

    public char getPathSeparator() {
        return this.colon;
    }

    private String normalize(String string, int n, int n2) {
        if (n == 0) {
            return string;
        }
        int n3 = n;
        while (n3 > 0 && string.charAt(n3 - 1) == '/') {
            --n3;
        }
        if (n3 == 0) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n2 > 0) {
            stringBuffer.append(string.substring(0, n2));
        }
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            char c = string.charAt(n5);
            if (n4 != 47 || c != '/') {
                stringBuffer.append(c);
                n4 = c;
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    public String normalize(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (n2 == 47 && c == '/') {
                return this.normalize(string, n, n3 - 1);
            }
            n2 = c;
            ++n3;
        }
        if (n2 == 47) {
            return this.normalize(string, n, n - 1);
        }
        return string;
    }

    public int prefixLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.charAt(0) == '/' ? 1 : 0;
    }

    public String resolve(String string, String string2) {
        if (string2.equals("")) {
            return string;
        }
        if (string2.charAt(0) == '/') {
            if (string.equals("/")) {
                return string2;
            }
            return string + string2;
        }
        if (string.equals("/")) {
            return string + string2;
        }
        return string + '/' + string2;
    }

    public String getDefaultParent() {
        return "/";
    }

    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public boolean isAbsolute(File file) {
        return file.getPrefixLength() != 0;
    }

    public String resolve(File file) {
        if (this.isAbsolute(file)) {
            return file.getPath();
        }
        return this.resolve(System.getProperty("user.dir"), file.getPath());
    }

    public String canonicalize(String string) throws IOException {
        if (!FileSystem.useCanonCaches) {
            return this.canonicalize0(string);
        }
        String string2 = this.cache.get(string);
        if (string2 == null) {
            Object object;
            String string3 = null;
            String string4 = null;
            if (FileSystem.useCanonPrefixCache && (string3 = UnixFileSystem.parentOrNull(string)) != null && (string4 = this.javaHomePrefixCache.get(string3)) != null) {
                object = string.substring(1 + string3.length());
                string2 = string4 + this.slash + (String)object;
                this.cache.put(string3 + this.slash + (String)object, string2);
            }
            if (string2 == null) {
                string2 = this.canonicalize0(string);
                this.cache.put(string, string2);
                if (FileSystem.useCanonPrefixCache && string3 != null && string3.startsWith(this.javaHome) && (string4 = UnixFileSystem.parentOrNull(string2)) != null && string4.startsWith(this.javaHome) && ((File)(object = new File(string2))).exists() && !((File)object).isDirectory()) {
                    this.javaHomePrefixCache.put(string3, string4);
                }
            }
        }
        if (!$assertionsDisabled && !this.canonicalize0(string).equals(string2)) {
            throw new AssertionError();
        }
        return string2;
    }

    private native String canonicalize0(String var1) throws IOException;

    static String parentOrNull(String string) {
        int n;
        if (string == null) {
            return null;
        }
        char c = File.separatorChar;
        int n2 = n = string.length() - 1;
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            char c2 = string.charAt(n2);
            if (c2 == '.') {
                if (++n3 >= 2) {
                    return null;
                }
            } else {
                if (c2 == c) {
                    if (n3 == 1 && n4 == 0) {
                        return null;
                    }
                    if (n2 == 0 || n2 >= n - 1 || string.charAt(n2 - 1) == c) {
                        return null;
                    }
                    return string.substring(0, n2);
                }
                ++n4;
                n3 = 0;
            }
            --n2;
        }
        return null;
    }

    public native int getBooleanAttributes0(File var1);

    public int getBooleanAttributes(File file) {
        int n = this.getBooleanAttributes0(file);
        String string = file.getName();
        boolean bl = string.length() > 0 && string.charAt(0) == '.';
        return n | (bl ? 8 : 0);
    }

    public native boolean checkAccess(File var1, boolean var2);

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public native boolean createFileExclusively(String var1) throws IOException;

    public boolean delete(File file) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.delete0(file);
    }

    private native boolean delete0(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public native String[] list(File var1);

    public native boolean createDirectory(File var1);

    public boolean rename(File file, File file2) {
        this.cache.clear();
        this.javaHomePrefixCache.clear();
        return this.rename0(file, file2);
    }

    private native boolean rename0(File var1, File var2);

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean setReadOnly(File var1);

    public File[] listRoots() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead("/");
            }
            return new File[]{new File("/")};
        }
        catch (SecurityException securityException) {
            return new File[0];
        }
    }

    public int compare(File file, File file2) {
        return file.getPath().compareTo(file2.getPath());
    }

    public int hashCode(File file) {
        return file.getPath().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$io$UnixFileSystem == null ? (class$java$io$UnixFileSystem = UnixFileSystem.class$("java.io.UnixFileSystem")) : class$java$io$UnixFileSystem).desiredAssertionStatus();
        UnixFileSystem.initIDs();
    }
}

