/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;
import java.io.PrintStream;
import sun.misc.VM;

public class ThreadGroup {
    ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;
    static /* synthetic */ Class class$java$lang$ThreadGroup;
    static /* synthetic */ Class class$java$lang$Thread;

    private ThreadGroup() {
        this.name = "system";
        this.maxPriority = 10;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        threadGroup.checkAccess();
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (n < 1) {
                this.maxPriority = 1;
            } else if (n < this.maxPriority) {
                this.maxPriority = n;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].setMaxPriority(n);
            ++n3;
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n2 = this.nthreads;
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            n2 += threadGroupArray[n3].activeCount();
            ++n3;
        }
        return n2;
    }

    public int enumerate(Thread[] threadArray) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Thread[] threadArray, int n, boolean bl) {
        int n2;
        int n3 = 0;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n2 = this.nthreads;
            if (n2 > threadArray.length - n) {
                n2 = threadArray.length - n;
            }
            int n4 = 0;
            while (n4 < n2) {
                if (this.threads[n4].isAlive()) {
                    threadArray[n++] = this.threads[n4];
                }
                ++n4;
            }
            if (bl) {
                n3 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray = new ThreadGroup[n3];
                    System.arraycopy(this.groups, 0, threadGroupArray, 0, n3);
                } else {
                    threadGroupArray = null;
                }
            }
        }
        if (bl) {
            n2 = 0;
            while (n2 < n3) {
                n = threadGroupArray[n2].enumerate(threadArray, n, true);
                ++n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < n) {
            n2 += threadGroupArray[n3].activeGroupCount();
            ++n3;
        }
        return n2;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(ThreadGroup[] threadGroupArray, int n, boolean bl) {
        int n2;
        int n3 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n2 = this.ngroups;
            if (n2 > threadGroupArray.length - n) {
                n2 = threadGroupArray.length - n;
            }
            if (n2 > 0) {
                System.arraycopy(this.groups, 0, threadGroupArray, n, n2);
                n += n2;
            }
            if (bl) {
                n3 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray2 = new ThreadGroup[n3];
                    System.arraycopy(this.groups, 0, threadGroupArray2, 0, n3);
                } else {
                    threadGroupArray2 = null;
                }
            }
        }
        if (bl) {
            n2 = 0;
            while (n2 < n3) {
                n = threadGroupArray2[n2].enumerate(threadGroupArray, n, true);
                ++n2;
            }
        }
        return n;
    }

    public final void stop() {
        if (this.stopOrSuspend(false)) {
            Thread.currentThread().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            n2 = 0;
            while (n2 < this.nthreads) {
                this.threads[n2].interrupt();
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        n2 = 0;
        while (n2 < n) {
            threadGroupArray[n2].interrupt();
            ++n2;
        }
    }

    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrSuspend(boolean bl) {
        int n;
        int n2;
        boolean bl2 = false;
        Thread thread = Thread.currentThread();
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            n2 = 0;
            while (n2 < this.nthreads) {
                if (this.threads[n2] == thread) {
                    bl2 = true;
                } else if (bl) {
                    this.threads[n2].suspend();
                } else {
                    this.threads[n2].stop();
                }
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            }
        }
        n2 = 0;
        while (n2 < n) {
            bl2 = threadGroupArray[n2].stopOrSuspend(bl) || bl2;
            ++n2;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            n2 = 0;
            while (n2 < this.nthreads) {
                this.threads[n2].resume();
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        n2 = 0;
        while (n2 < n) {
            threadGroupArray[n2].resume();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            threadGroupArray[n2].destroy();
            ++n2;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void add(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.groups == null) {
                this.groups = (ThreadGroup[])ExtendedSystem.newArray(class$java$lang$ThreadGroup == null ? (class$java$lang$ThreadGroup = ThreadGroup.class$("java.lang.ThreadGroup")) : class$java$lang$ThreadGroup, 4, this);
            } else if (this.ngroups == this.groups.length) {
                this.groups = (ThreadGroup[])ExtendedSystem.resizeArray(this.ngroups * 2, this.groups, 0, this.ngroups);
            }
            this.groups[this.ngroups] = threadGroup;
            ++this.ngroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                return;
            }
            int n = 0;
            while (n < this.ngroups) {
                if (this.groups[n] == threadGroup) {
                    --this.ngroups;
                    System.arraycopy(this.groups, n + 1, this.groups, n, this.ngroups - n);
                    this.groups[this.ngroups] = null;
                    break;
                }
                ++n;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = (Thread[])ExtendedSystem.newArray(class$java$lang$Thread == null ? (class$java$lang$Thread = ThreadGroup.class$("java.lang.Thread")) : class$java$lang$Thread, 4, this);
            } else if (this.nthreads == this.threads.length) {
                this.threads = (Thread[])ExtendedSystem.resizeArray(this.nthreads * 2, this.threads, 0, this.nthreads);
            }
            this.threads[this.nthreads] = thread;
            ++this.nthreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return;
            }
            int n = 0;
            while (n < this.nthreads) {
                if (this.threads[n] == thread) {
                    System.arraycopy(this.threads, n + 1, this.threads, n, --this.nthreads - n);
                    this.threads[this.nthreads] = null;
                    break;
                }
                ++n;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(PrintStream printStream, int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            n3 = 0;
            while (n3 < n) {
                printStream.print(" ");
                ++n3;
            }
            printStream.println(this);
            n += 4;
            int n4 = 0;
            while (n4 < this.nthreads) {
                int n5 = 0;
                while (n5 < n) {
                    printStream.print(" ");
                    ++n5;
                }
                printStream.println(this.threads[n4]);
                ++n4;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].list(printStream, n);
            ++n3;
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else if (!(throwable instanceof ThreadDeath)) {
            throwable.printStackTrace(System.err);
        }
    }

    public boolean allowThreadSuspension(boolean bl) {
        this.vmAllowSuspension = bl;
        if (!bl) {
            VM.unsuspendSomeThreads();
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.maxPriority + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

